/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text.syntax;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnpad.JNPad;
import jnpad.config.Config;
import jnpad.text.syntax.CScheme;
import jnpad.util.Utilities;

public class CPPScheme
extends CScheme {
    static Color exceptionColor;
    static Color operatorColor_;
    Font exceptionFont;
    Font operatorFont_;
    private static final Logger LOGGER;
    private static final long serialVersionUID = 8959231363486824139L;

    static {
        LOGGER = Logger.getLogger(CPPScheme.class.getName());
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config("C++ Scheme - init.");
        }
        BufferedReader in = null;
        try {
            try {
                String line;
                String dir = String.valueOf(JNPad.PROPS_DIR) + Utilities.DIR_SEPARATOR + "schemes";
                String file = String.valueOf(dir) + Utilities.DIR_SEPARATOR + "cpp.words";
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                while ((line = in.readLine()) != null && !line.equals(":KEYWORDS")) {
                }
                while ((line = in.readLine()) != null && !line.equals(":MODIFIERS")) {
                    CPPScheme.read(line, CScheme.WordType.KEYWORD);
                }
                while ((line = in.readLine()) != null && !line.equals(":EXCEPTIONS")) {
                    CPPScheme.read(line, CScheme.WordType.MODIFIER);
                }
                while ((line = in.readLine()) != null && !line.equals(":DATA_TYPES")) {
                    CPPScheme.read(line, CScheme.WordType.EXCEPTION);
                }
                while ((line = in.readLine()) != null && !line.equals(":OPERATORS")) {
                    CPPScheme.read(line, CScheme.WordType.DATA_TYPE);
                }
                while ((line = in.readLine()) != null) {
                    CPPScheme.read(line, CScheme.WordType.OPERATOR);
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex2) {
                    LOGGER.log(Level.WARNING, ex2.getMessage(), ex2);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    public CPPScheme(boolean mini) {
        super(mini);
        this.doUpdateColors();
        this.doUpdateFonts();
    }

    private void doUpdateColors() {
        exceptionColor = Config.SYNTAX_KEYWORD3_COLOR.getValue();
        operatorColor_ = Config.SYNTAX_KEYWORD7_COLOR.getValue();
    }

    private void doUpdateFonts() {
        this.exceptionFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD3_STYLE.getValue());
        this.operatorFont_ = this.textFont.deriveFont(Config.SYNTAX_KEYWORD7_STYLE.getValue());
    }

    @Override
    public void setTextFont(Font f) {
        super.setTextFont(f);
        this.doUpdateFonts();
    }

    @Override
    public void configure(int cfg) {
        super.configure(cfg);
        if ((cfg & 1) != 0) {
            this.doUpdateColors();
        }
        if ((cfg & 2) != 0) {
            this.doUpdateFonts();
        }
    }

    @Override
    public Color getWordColor(CScheme.WordType type) {
        if (type == null) {
            return this.textColor;
        }
        switch (type) {
            case OPERATOR: {
                return classify ? operatorColor_ : keywordColor;
            }
            case EXCEPTION: {
                return classify ? exceptionColor : keywordColor;
            }
        }
        return super.getWordColor(type);
    }

    @Override
    public Font getWordFont(CScheme.WordType type) {
        if (type == null) {
            return this.textFont;
        }
        switch (type) {
            case OPERATOR: {
                return classify ? this.operatorFont_ : this.keywordFont;
            }
            case EXCEPTION: {
                return classify ? this.exceptionFont : this.keywordFont;
            }
        }
        return super.getWordFont(type);
    }

    @Override
    public String getContentType() {
        return "text/cpp";
    }
}

