/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text.highlighter;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import jnpad.config.Config;
import jnpad.text.highlighter.IHighlightPainter;

public class BracketHighlightPainter
implements IHighlightPainter {
    private Color _color;

    public BracketHighlightPainter() {
        this.configure(1);
    }

    @Override
    public void configure(int cfg) {
        if ((cfg & 1) != 0) {
            this.setColor(Config.BRACKET_HIGHLIGHTER_COLOR.getValue());
        }
    }

    public void setColor(Color color) {
        if (color != null) {
            this._color = color;
        }
    }

    public Color getColor() {
        return this._color;
    }

    @Override
    public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
        Rectangle r;
        if (c.getSelectionStart() != c.getSelectionEnd()) {
            return;
        }
        if (offs0 == offs1) {
            return;
        }
        Document doc = c.getDocument();
        FontMetrics fm = g.getFontMetrics();
        Segment segment = new Segment();
        try {
            r = c.modelToView(offs0);
            doc.getText(offs0, 1, segment);
            r.width = fm.charWidth(segment.array[segment.offset]);
        }
        catch (BadLocationException aoException) {
            return;
        }
        g.setColor(this.getColor());
        g.fillRect(r.x, r.y, r.width, r.height);
    }
}

