/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import jnpad.GUIUtilities;
import jnpad.config.Config;
import jnpad.config.Controlable;
import jnpad.text.DocumentRange;
import jnpad.text.EditPane;
import jnpad.text.JNPadTextArea;
import jnpad.text.TextBundle;

public class MarkStrip
extends JComponent
implements Controlable {
    private Color occurrenceMarkerColor = (Color)Config.MARKER_OCCURRENCE_COLOR.getDefault();
    private Color occurrenceMarkerBorderColor = (Color)Config.MARKER_OCCURRENCE_COLOR.getDefault();
    private Color bookmarkMarkerColor = (Color)Config.MARKER_BOOKMARK_COLOR.getDefault();
    private Color bookmarkMarkerBorderColor = (Color)Config.MARKER_BOOKMARK_BORDER_COLOR.getDefault();
    private Color searchMarkerColor = (Color)Config.MARKER_SEARCH_COLOR.getDefault();
    private Color searchMarkerBorderColor = (Color)Config.MARKER_SEARCH_BORDER_COLOR.getDefault();
    private Color caretMarkerColor = (Color)Config.MARKER_CARET_COLOR.getDefault();
    private int caretLineY = -1;
    private int lastLineY = -1;
    private boolean showOccurrences = true;
    private boolean showBookmarks = true;
    private boolean showSearched = true;
    private boolean followCaret = true;
    private Rectangle visibleRect = new Rectangle();
    private static final int PREFERRED_WIDTH = Config.MARKER_PREFERRED_WIDTH.getValue();
    private EditPane editPane;
    private JNPadTextArea textArea;
    private static final long serialVersionUID = 5411365801461770494L;

    public MarkStrip(EditPane editPane) {
        this.editPane = editPane;
        this.textArea = editPane.getTextArea();
        this.configure(7);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int line = MarkStrip.this.yToLine(e.getY());
                if (line > -1) {
                    try {
                        int offs = MarkStrip.this.textArea.getLineStartOffset(line);
                        MarkStrip.this.textArea.setCaretPosition(offs);
                    }
                    catch (BadLocationException ex) {
                        UIManager.getLookAndFeel().provideErrorFeedback(MarkStrip.this.textArea);
                    }
                }
            }
        });
        this.setLayout(null);
    }

    void caretUpdate() {
        if (this.getFollowCaret()) {
            int line = this.textArea.getCaretLineNumber();
            float percent = (float)line / (float)this.textArea.getLineCount();
            this.textArea.computeVisibleRect(this.visibleRect);
            this.caretLineY = (int)((float)this.visibleRect.height * percent);
            if (this.caretLineY != this.lastLineY) {
                this.repaint(0, this.lastLineY, this.getWidth(), 2);
                this.repaint(0, this.caretLineY, this.getWidth(), 2);
                this.lastLineY = this.caretLineY;
            }
        }
    }

    @Override
    public void configure(int cfg) {
        if ((cfg & 1) != 0) {
            this.setBookmarkMarkerColor(Config.MARKER_BOOKMARK_COLOR.getValue());
            this.setBookmarkMarkerBorderColor(Config.MARKER_BOOKMARK_BORDER_COLOR.getValue());
            this.setOccurrenceMarkerColor(Config.MARKER_OCCURRENCE_COLOR.getValue());
            this.setOccurrenceMarkerBorderColor(Config.MARKER_OCCURRENCE_BORDER_COLOR.getValue());
            this.setSearchMarkerColor(Config.MARKER_SEARCH_COLOR.getValue());
            this.setSearchMarkerBorderColor(Config.MARKER_SEARCH_BORDER_COLOR.getValue());
            this.setCaretMarkerColor(Config.MARKER_CARET_COLOR.getValue());
        }
    }

    @Override
    public void updateControls() {
        this.updateControls(8191);
    }

    @Override
    public void updateControls(int ctrls) {
        if ((ctrls & 4) != 0 && (this.getShowOccurrences() && this.editPane.hasOccurrences() || this.getShowBookmarks() && this.editPane.hasBookmarks())) {
            this.refreshMarkers();
        }
        if ((ctrls & 0x20) != 0 && this.getShowOccurrences()) {
            this.refreshMarkers();
        }
        if ((ctrls & 0x40) != 0 && this.getShowBookmarks()) {
            this.refreshMarkers();
        }
        if ((ctrls & 0x80) != 0 && this.getShowSearched()) {
            this.refreshMarkers();
        }
    }

    @Override
    public void doLayout() {
        int i = 0;
        while (i < this.getComponentCount()) {
            Marker m = (Marker)this.getComponent(i);
            m.updateLocation();
            ++i;
        }
        this.caretUpdate();
    }

    public boolean getFollowCaret() {
        return this.followCaret;
    }

    public void setFollowCaret(boolean follow) {
        if (this.followCaret != follow) {
            if (this.followCaret) {
                this.repaint(0, this.caretLineY, this.getWidth(), 2);
            }
            this.caretLineY = -1;
            this.lastLineY = -1;
            this.followCaret = follow;
            this.caretUpdate();
        }
    }

    public Color getCaretMarkerColor() {
        return this.caretMarkerColor;
    }

    public void setCaretMarkerColor(Color color) {
        if (color != null) {
            this.caretMarkerColor = color;
        }
    }

    public Color getBookmarkMarkerColor() {
        return this.bookmarkMarkerColor;
    }

    public void setBookmarkMarkerColor(Color color) {
        if (color != null) {
            this.bookmarkMarkerColor = color;
        }
    }

    public Color getBookmarkMarkerBorderColor() {
        return this.bookmarkMarkerBorderColor;
    }

    public void setBookmarkMarkerBorderColor(Color color) {
        if (color != null) {
            this.bookmarkMarkerBorderColor = color;
        }
    }

    public Color getOccurrenceMarkerColor() {
        return this.occurrenceMarkerColor;
    }

    public void setOccurrenceMarkerColor(Color color) {
        if (color != null) {
            this.occurrenceMarkerColor = color;
        }
    }

    public Color getOccurrenceMarkerBorderColor() {
        return this.occurrenceMarkerBorderColor;
    }

    public void setOccurrenceMarkerBorderColor(Color color) {
        if (color != null) {
            this.occurrenceMarkerBorderColor = color;
        }
    }

    public Color getSearchMarkerColor() {
        return this.searchMarkerColor;
    }

    public void setSearchMarkerColor(Color color) {
        if (color != null) {
            this.searchMarkerColor = color;
        }
    }

    public Color getSearchMarkerBorderColor() {
        return this.searchMarkerBorderColor;
    }

    public void setSearchMarkerBorderColor(Color color) {
        if (color != null) {
            this.searchMarkerBorderColor = color;
        }
    }

    public boolean getShowOccurrences() {
        return this.showOccurrences;
    }

    public void setShowOccurrences(boolean b) {
        if (b != this.showOccurrences) {
            this.showOccurrences = b;
            if (this.isDisplayable()) {
                this.refreshMarkers();
            }
        }
    }

    public boolean getShowBookmarks() {
        return this.showBookmarks;
    }

    public void setShowBookmarks(boolean b) {
        if (b != this.showBookmarks) {
            this.showBookmarks = b;
            if (this.isDisplayable()) {
                this.refreshMarkers();
            }
        }
    }

    public boolean getShowSearched() {
        return this.showSearched;
    }

    public void setShowSearched(boolean b) {
        if (b != this.showSearched) {
            this.showSearched = b;
            if (this.isDisplayable()) {
                this.refreshMarkers();
            }
        }
    }

    private void refreshMarkers() {
        Marker m;
        Integer key;
        AbstractNotice notice;
        int line;
        DocumentRange range;
        int n;
        int n2;
        DocumentRange[] documentRangeArray;
        DocumentRange[] ranges;
        this.removeAll();
        HashMap<Integer, Marker> markerMap = new HashMap<Integer, Marker>();
        if (this.getShowOccurrences() && this.editPane.hasOccurrences()) {
            documentRangeArray = ranges = this.editPane.getOccurrences();
            n2 = ranges.length;
            n = 0;
            while (n < n2) {
                block21: {
                    range = documentRangeArray[n];
                    try {
                        line = this.textArea.getLineOfOffset(range.getStartOffset());
                    }
                    catch (BadLocationException ble) {
                        break block21;
                    }
                    notice = new OccurrenceNotice(range, this.getOccurrenceMarkerColor(), this.getOccurrenceMarkerBorderColor());
                    key = line;
                    m = (Marker)markerMap.get(key);
                    if (m == null) {
                        m = new Marker(notice);
                        markerMap.put(key, m);
                        this.add(m);
                    } else if (!m.containsNotice(notice)) {
                        m.addNotice(notice);
                    }
                }
                ++n;
            }
        }
        if (this.getShowBookmarks() && this.editPane.hasBookmarks()) {
            documentRangeArray = ranges = this.editPane.getBookmarks();
            n2 = ranges.length;
            n = 0;
            while (n < n2) {
                block22: {
                    range = documentRangeArray[n];
                    try {
                        line = this.textArea.getLineOfOffset(range.getStartOffset());
                    }
                    catch (BadLocationException ble) {
                        break block22;
                    }
                    notice = new BookmarkNotice(range, this.getBookmarkMarkerColor(), this.getBookmarkMarkerBorderColor());
                    key = line;
                    m = (Marker)markerMap.get(key);
                    if (m == null) {
                        m = new Marker(notice);
                        markerMap.put(key, m);
                        this.add(m);
                    } else if (!m.containsNotice(notice)) {
                        m.addNotice(notice);
                    }
                }
                ++n;
            }
        }
        if (this.getShowSearched() && this.editPane.hasSearched()) {
            DocumentRange range2 = this.editPane.getSearched();
            if (range2 == null) {
                return;
            }
            int line2 = 0;
            try {
                line2 = this.textArea.getLineOfOffset(range2.getStartOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            SearchNotice notice2 = new SearchNotice(range2, this.getSearchMarkerColor(), this.getSearchMarkerBorderColor());
            Integer key2 = line2;
            Marker m2 = (Marker)markerMap.get(key2);
            if (m2 == null) {
                m2 = new Marker(notice2);
                markerMap.put(key2, m2);
                this.add(m2);
            } else if (!m2.containsNotice(notice2)) {
                m2.addNotice(notice2);
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.caretLineY > -1) {
            g.setColor(this.getCaretMarkerColor());
            g.fillRect(0, this.caretLineY, this.getWidth(), 2);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int height = this.textArea.getPreferredScrollableViewportSize().height;
        return new Dimension(PREFERRED_WIDTH, height);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String text = null;
        int line = this.yToLine(e.getY());
        if (line > -1) {
            text = TextBundle.getString("MarkStrip.line", new Object[0]);
            text = MessageFormat.format(text, line + 1);
        }
        return text;
    }

    private int lineToY(int line) {
        int h = this.textArea.getVisibleRect().height;
        float lineCount = this.textArea.getLineCount();
        return (int)((float)line / lineCount * (float)h) - 2;
    }

    private int yToLine(int y) {
        int line = -1;
        int h = this.textArea.getVisibleRect().height;
        if (y < h) {
            float at = (float)y / (float)h;
            line = (int)((float)this.textArea.getLineCount() * at);
        }
        return line;
    }

    private abstract class AbstractNotice
    implements Notice {
        DocumentRange range;
        Color color;
        Color borderColor;

        AbstractNotice(DocumentRange range, Color color, Color borderColor) {
            this.range = range;
            this.color = color;
            this.borderColor = borderColor;
        }

        @Override
        public boolean containsPosition(int pos) {
            return pos >= this.range.getStartOffset() && pos < this.range.getEndOffset();
        }

        public int hashCode() {
            return this.range.hashCode();
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        @Override
        public Color getBorderColor() {
            return this.borderColor;
        }

        @Override
        public int getLength() {
            return this.range.getEndOffset() - this.range.getStartOffset();
        }

        @Override
        public int getLine() {
            try {
                return MarkStrip.this.textArea.getLineOfOffset(this.range.getStartOffset());
            }
            catch (BadLocationException ble) {
                return 0;
            }
        }

        @Override
        public int getOffset() {
            return this.range.getStartOffset();
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public DocumentRange getRange() {
            return this.range;
        }
    }

    private class BookmarkNotice
    extends AbstractNotice {
        BookmarkNotice(DocumentRange range, Color color, Color borderColor) {
            super(range, color, borderColor);
        }

        @Override
        public int compareTo(Notice other) {
            if (other == null || !(other instanceof BookmarkNotice)) {
                return 1;
            }
            return this.range.compareTo(((BookmarkNotice)other).range);
        }

        public boolean equals(Object o) {
            return o instanceof BookmarkNotice && this.compareTo((Notice)o) == 0;
        }

        @Override
        public String getMessage() {
            String text = null;
            try {
                String word = MarkStrip.this.textArea.getText(this.range.getStartOffset(), this.getLength());
                text = TextBundle.getString("MarkStrip.bookmark", new Object[0]);
                text = MessageFormat.format(text, word);
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(MarkStrip.this.textArea);
            }
            return text;
        }

        @Override
        public int getLevel() {
            return 0;
        }
    }

    private class Marker
    extends JComponent {
        private List<Notice> notices = new ArrayList<Notice>(1);
        private MouseListener mouseHandler = new MouseHandler();
        private static final long serialVersionUID = -7849793495614737486L;

        public Marker(Notice notice) {
            this.addNotice(notice);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setSize(this.getPreferredSize());
            ToolTipManager.sharedInstance().registerComponent(this);
            this.addMouseListener(this.mouseHandler);
        }

        void addNotice(Notice notice) {
            this.notices.add(notice);
        }

        Color[] getColors() {
            Color[] c = new Color[2];
            int lowestLevel = Integer.MAX_VALUE;
            for (Notice notice : this.notices) {
                if (notice.getLevel() >= lowestLevel) continue;
                lowestLevel = notice.getLevel();
                c[0] = notice.getColor();
                c[1] = notice.getBorderColor();
            }
            return c;
        }

        @Override
        public Dimension getPreferredSize() {
            int w = PREFERRED_WIDTH - 4;
            return new Dimension(w, 5);
        }

        @Override
        public String getToolTipText() {
            String text;
            if (this.notices.size() == 1) {
                text = this.notices.get(0).getMessage();
            } else {
                StringBuilder sb = new StringBuilder("<html>");
                sb.append(TextBundle.getString("MarkStrip.multipleMarkers", new Object[0]));
                sb.append("<br>");
                for (Notice pn : this.notices) {
                    sb.append("&nbsp;&nbsp;&nbsp;- ");
                    sb.append(pn.getMessage());
                    sb.append("<br>");
                }
                text = sb.toString();
            }
            return text;
        }

        @Override
        protected void paintComponent(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            Color[] colors = this.getColors();
            g.setColor(colors[0] != null ? colors[0] : Color.LIGHT_GRAY);
            g.fillRect(0, 0, w, h);
            if (colors[1] != null) {
                GUIUtilities.drawBorder(g, colors[1], 0, 0, w, h);
            }
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            this.removeMouseListener(this.mouseHandler);
        }

        void updateLocation() {
            int line = this.notices.get(0).getLine();
            int y = MarkStrip.this.lineToY(line);
            this.setLocation(2, y);
        }

        boolean containsNotice(Notice not) {
            boolean result = false;
            for (Notice notice : this.notices) {
                if (!notice.equals(not)) continue;
                result = true;
                break;
            }
            return result;
        }

        void handleMouseClicked(MouseEvent e) {
            Notice n = this.notices.get(0);
            int offs = n.getOffset();
            int len = n.getLength();
            if (offs > -1 && len > -1) {
                MarkStrip.this.textArea.setSelectionStart(offs);
                MarkStrip.this.textArea.setSelectionEnd(offs + len);
            } else {
                int line = n.getLine();
                try {
                    offs = MarkStrip.this.textArea.getLineStartOffset(line);
                    MarkStrip.this.textArea.setCaretPosition(offs);
                }
                catch (BadLocationException ble) {
                    UIManager.getLookAndFeel().provideErrorFeedback(MarkStrip.this.textArea);
                }
            }
        }

        private class MouseHandler
        extends MouseAdapter
        implements Serializable {
            private static final long serialVersionUID = 8877013585055386988L;

            private MouseHandler() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Marker.this.handleMouseClicked(e);
            }
        }
    }

    private static interface Notice
    extends Comparable<Notice> {
        public boolean containsPosition(int var1);

        public Color getColor();

        public Color getBorderColor();

        public int getLength();

        public int getLine();

        public String getMessage();

        public int getOffset();

        public String getToolTipText();

        public int getLevel();

        public DocumentRange getRange();
    }

    private class OccurrenceNotice
    extends AbstractNotice {
        OccurrenceNotice(DocumentRange range, Color color, Color borderColor) {
            super(range, color, borderColor);
        }

        @Override
        public int compareTo(Notice other) {
            if (other == null || !(other instanceof OccurrenceNotice)) {
                return 1;
            }
            return this.range.compareTo(((OccurrenceNotice)other).range);
        }

        public boolean equals(Object o) {
            return o instanceof OccurrenceNotice && this.compareTo((Notice)o) == 0;
        }

        @Override
        public String getMessage() {
            String text = null;
            try {
                String word = MarkStrip.this.textArea.getText(this.range.getStartOffset(), this.getLength());
                text = TextBundle.getString("MarkStrip.occurrence", new Object[0]);
                text = MessageFormat.format(text, word);
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(MarkStrip.this.textArea);
            }
            return text;
        }

        @Override
        public int getLevel() {
            return 2;
        }
    }

    private class SearchNotice
    extends AbstractNotice {
        SearchNotice(DocumentRange range, Color color, Color borderColor) {
            super(range, color, borderColor);
        }

        @Override
        public int compareTo(Notice other) {
            if (other == null || !(other instanceof SearchNotice)) {
                return 1;
            }
            return this.range.compareTo(((SearchNotice)other).range);
        }

        public boolean equals(Object o) {
            return o instanceof SearchNotice && this.compareTo((Notice)o) == 0;
        }

        @Override
        public String getMessage() {
            String text = null;
            try {
                String word = MarkStrip.this.textArea.getText(this.range.getStartOffset(), this.getLength());
                text = TextBundle.getString("MarkStrip.search", new Object[0]);
                text = MessageFormat.format(text, word);
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback(MarkStrip.this.textArea);
            }
            return text;
        }

        @Override
        public int getLevel() {
            return 1;
        }
    }
}

