/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import javax.swing.text.Position;

public class DocumentRange
implements Comparable<DocumentRange> {
    Position start;
    Position end;
    boolean first;

    DocumentRange() {
    }

    public DocumentRange(Position start, Position end, boolean first) {
        this.start = start;
        this.end = end;
        this.first = first;
    }

    @Override
    public int compareTo(DocumentRange other) {
        if (other == null) {
            return 1;
        }
        int diff = this.getStartOffset() - other.getStartOffset();
        if (diff != 0) {
            return diff;
        }
        return this.getEndOffset() - other.getEndOffset();
    }

    public boolean equals(Object other) {
        return other == this || other instanceof DocumentRange && this.compareTo((DocumentRange)other) == 0;
    }

    public int hashCode() {
        return this.getStartOffset() + this.getEndOffset();
    }

    public int getEndOffset() {
        return this.end.getOffset();
    }

    public int getStartOffset() {
        return this.first ? this.start.getOffset() - 1 : this.start.getOffset();
    }

    public String toString() {
        return "[DocumentRange: " + this.start.getOffset() + "-" + this.end.getOffset() + "]";
    }
}

