/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jnpad.config.Config;
import jnpad.text.highlighter.IHighlightPainter;

public class ActiveLine
implements IHighlightPainter {
    private JTextArea textArea;
    private Color color;
    private Rectangle lastView;
    private Object highlightTag;
    private static final Logger LOGGER = Logger.getLogger(ActiveLine.class.getName());

    public ActiveLine(JTextArea textArea) {
        this.textArea = textArea;
        this.configure(1);
        Handler handler = new Handler();
        textArea.addCaretListener(handler);
        textArea.addMouseListener(handler);
        textArea.addMouseMotionListener(handler);
        this.setVisible(true);
    }

    @Override
    public void configure(int cfg) {
        if ((cfg & 1) != 0) {
            this.setColor(Config.ACTIVE_LINE_COLOR.getValue());
        }
    }

    public void setVisible(boolean b) {
        try {
            if (b) {
                this.highlightTag = this.textArea.getHighlighter().addHighlight(0, 0, this);
            } else {
                this.textArea.getHighlighter().removeHighlight(this.highlightTag);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.color = color;
        }
    }

    @Override
    public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
        try {
            Rectangle r = c.modelToView(c.getCaretPosition());
            g.setColor(this.color);
            g.fillRect(0, r.y, c.getWidth(), r.height);
            if (this.lastView == null) {
                this.lastView = r;
            }
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void resetHighlight() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ActiveLine.this.lastView == null) {
                    return;
                }
                try {
                    int offset = ActiveLine.this.textArea.getCaretPosition();
                    Rectangle currentView = ActiveLine.this.textArea.modelToView(offset);
                    if (((ActiveLine)ActiveLine.this).lastView.y != currentView.y) {
                        ActiveLine.this.textArea.repaint(0, ((ActiveLine)ActiveLine.this).lastView.y, ActiveLine.this.textArea.getWidth(), ((ActiveLine)ActiveLine.this).lastView.height);
                        ActiveLine.this.lastView = currentView;
                        ActiveLine.this.textArea.repaint(0, currentView.y, ActiveLine.this.textArea.getWidth(), currentView.height);
                    }
                }
                catch (BadLocationException ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
        });
    }

    private class Handler
    extends MouseInputAdapter
    implements CaretListener {
        private Handler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ActiveLine.this.resetHighlight();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ActiveLine.this.resetHighlight();
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            ActiveLine.this.resetHighlight();
        }
    }
}

