/*
 * Decompiled with CFR 0.152.
 */
package jnpad.config;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jnpad.config.PropChangeEvent;
import jnpad.config.PropChangeListener;

public abstract class Prop<V>
implements Serializable {
    protected final String name;
    protected final V defaultValue;
    private final List<PropChangeListener<V>> myListeners = new CopyOnWriteArrayList<PropChangeListener<V>>();
    private static final long serialVersionUID = 7741728667044277868L;

    protected Prop(String name, V def) {
        this.name = name;
        this.defaultValue = def;
    }

    public void addPropListener(PropChangeListener<V> listener) {
        this.myListeners.add(listener);
    }

    public void removePropListener(PropChangeListener<V> listener) {
        this.myListeners.add(listener);
    }

    protected void firePropChange(V oldValue, V newValue) {
        if (!this.myListeners.isEmpty()) {
            PropChangeEvent<V> event = new PropChangeEvent<V>(this, oldValue, newValue);
            for (PropChangeListener<V> listener : this.myListeners) {
                listener.propChange(event);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public V getDefault() {
        return this.defaultValue;
    }

    public void setToDefault() {
        this.setValue(this.defaultValue);
    }

    public boolean isDefault() {
        return this.getDefault().equals(this.getValue());
    }

    public abstract V getValue();

    public void setValue(V value) {
        V oldValue = this.getValue();
        this.doSetValue(value);
        this.firePropChange(oldValue, value);
    }

    protected abstract void doSetValue(V var1);

    public abstract String getDefaultString();

    public String toString() {
        return String.valueOf(this.name) + "=" + this.getDefaultString();
    }
}

