/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.event.ItemEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import jnpad.JNPadBundle;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Config;
import jnpad.ui.MnemonicHelper;
import jnpad.util.Utilities;

public final class SelectKeymapAction
extends JNPadAction {
    static final String NAME = "select-keymap";
    private static Map<String, JNPadAction> map = new HashMap<String, JNPadAction>();
    private static final long serialVersionUID = -9032300359975558889L;

    public SelectKeymapAction(JNPadFrame jNPad, File file, boolean selected, MnemonicHelper mnemonicHelper) {
        super(jNPad, NAME, JNPadActions.Group.CONFIGURE);
        char mnemonic;
        String label = Utilities.getFileBaseName(file.getPath());
        String name = "select-keymap " + label;
        this.setLabel(label);
        this.setName(name);
        if (mnemonicHelper != null && (mnemonic = mnemonicHelper.getMnemonic(label)) != '\u0000') {
            this.setMnemonic(mnemonic);
        }
        this.setDescription(ActionBundle.getString(NAME.concat(".description"), label));
        this.setSelected(selected);
        this.setStateAction(true);
        map.put(name, this);
    }

    @Override
    public void handleStateChanged(ItemEvent e) {
        if (1 == e.getStateChange()) {
            Config.USE_CUSTOM_SHORTCUTS.setValue(!((String)Config.JNPAD_KEYMAP.getDefault()).equals(this.getLabel()));
            Config.JNPAD_KEYMAP.setValue(this.getLabel());
            String msg = ActionBundle.getString("select-keymap.message", this.getLabel());
            this.jNPad.setStatus(msg, 10);
            Object[] options = new String[]{JNPadBundle.getYesOptionText(), JNPadBundle.getNoOptionText()};
            int option = JOptionPane.showOptionDialog(this.jNPad, JNPadBundle.getString("JNPad.restart", msg), JNPadBundle.getString("select-keymap.title", new Object[0]), -1, 1, null, options, options[0]);
            if (option == 1 || option == -1) {
                return;
            }
            this.jNPad.restart();
        }
    }

    static List<String> getCompletionsForPrefix(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : map.keySet()) {
            JNPadAction action = map.get(key);
            if (!key.startsWith(prefix) || !action.isEnabled()) continue;
            list.add(key);
        }
        Collections.sort(list);
        return list;
    }

    static boolean performAction(String name) {
        JNPadAction action = map.get(name);
        if (action != null && action.isEnabled()) {
            action.setSelected(!action.isSelected());
            return true;
        }
        return false;
    }
}

