/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.event.ItemEvent;
import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.text.Buffer;
import jnpad.text.IEditAction;
import jnpad.ui.MnemonicHelper;
import jnpad.util.LineSeparator;

public abstract class SelectEOLAction
extends JNPadAction
implements IEditAction {
    private LineSeparator lineSeparator;
    private static MnemonicHelper mnemonicHelper = new MnemonicHelper();
    private static final long serialVersionUID = -7911049330691224084L;

    protected SelectEOLAction(JNPadFrame jNPad, String name, LineSeparator lineSeparator, String picture) {
        super(jNPad, name, JNPadActions.Group.CONFIGURE);
        this.lineSeparator = lineSeparator;
        this.setLabel(lineSeparator.getLongName());
        char mnemonic = mnemonicHelper.getMnemonic(this.getLabel());
        if (mnemonic != '\u0000') {
            this.setMnemonic(mnemonic);
        }
        if (Config.isDefaultMode()) {
            this.setIcon(GUIUtilities.loadIcon(picture));
        }
        if (Accelerators.isUsingCompositeShortcuts()) {
            this.setKeyBinding(Accelerators.getShortcutLabel(name));
        }
        this.setDescription(ActionBundle.getString("select-eol.description", this.getLabel()));
        this.setStateAction(true);
    }

    @Override
    public void handleStateChanged(ItemEvent e) {
        Buffer buffer = this.jNPad.getActiveBuffer();
        if (buffer != null && 1 == e.getStateChange()) {
            buffer.setLineSeparator(this.lineSeparator);
            this.jNPad.setStatus(ActionBundle.getString("select-eol.message", this.lineSeparator.getName()), 10);
        }
    }
}

