/*
 * Decompiled with CFR 0.152.
 */
package jnpad;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import jnpad.ExitDialog;
import jnpad.GUIUtilities;
import jnpad.JNPadActionHelper;
import jnpad.JNPadBundle;
import jnpad.JNPadCardViewer;
import jnpad.JNPadInput;
import jnpad.JNPadKeyboardHandler;
import jnpad.JNPadMenuHelper;
import jnpad.JNPadParser;
import jnpad.JNPadStatusBar;
import jnpad.JNPadTabbedViewer;
import jnpad.JNPadToolBarHelper;
import jnpad.JNPadViewer;
import jnpad.action.ActionManager;
import jnpad.action.JNPadAction;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.config.Configurable;
import jnpad.config.Controlable;
import jnpad.config.KeyEventWorkaround;
import jnpad.search.FindDialog;
import jnpad.search.FindResultsPanel;
import jnpad.search.IncrementalSearchPanel;
import jnpad.search.ReplaceDialog;
import jnpad.search.Text;
import jnpad.text.Buffer;
import jnpad.text.BufferSet;
import jnpad.text.EditPane;
import jnpad.text.JNPadTextArea;
import jnpad.text.MockBuffer;
import jnpad.text.Viewer;
import jnpad.ui.EdgeBorder;
import jnpad.ui.JNPadFileFilter;
import jnpad.ui.JNPadSplitPane;
import jnpad.ui.icon.IconUtilities;
import jnpad.ui.status.IStatusBar;
import jnpad.ui.status.StatusDisplayable;
import jnpad.util.LineSeparator;
import jnpad.util.Platform;
import jnpad.util.Utilities;

public class JNPadFrame
extends JFrame
implements StatusDisplayable,
Controlable {
    JPanel contentPane;
    JPanel pnBackground = new JPanel();
    JSplitPane sppOutput = new JNPadSplitPane(0);
    FindResultsPanel findResultsPanel;
    IncrementalSearchPanel incrementalSearchPanel;
    JNPadStatusBar statusBar;
    JNPadViewer viewer;
    JNPadActionHelper actions;
    JNPadMenuHelper menus;
    JNPadToolBarHelper toolbars;
    private PageFormat pageFormat;
    private FindDialog findDialog;
    private ReplaceDialog replaceDialog;
    private int waitCount;
    private int index_file;
    private int sppOutputPosition = -1;
    private boolean isIncrementalSearchVisible;
    private boolean isFindResultsVisible;
    private boolean isResetEnabled = true;
    private boolean lastGrobalEditable = true;
    private Boolean lastReadOnly;
    private Boolean lastDirty;
    private boolean isFullScreen;
    private int prevX;
    private int prevY;
    private int prevWidth;
    private int prevHeight;
    private boolean prevStatusVisible;
    private boolean prevToolbarsVisible;
    private boolean prevIsMaximized;
    private JButton btFullScreen;
    private Component horizontalGlue;
    private PropertyChangeListener propertyChangeHandler = new PropertyChangeHandler();
    private List<JNPadInput> inputFiles;
    private String sessionPath;
    private JNPadKeyboardHandler keyboardHandler;
    private KeyListener keyEventInterceptor;
    private static final Logger LOGGER = Logger.getLogger(JNPadFrame.class.getName());
    private static final long serialVersionUID = 5466384895908813762L;

    public JNPadFrame(String sessionPath) {
        this(null, sessionPath);
    }

    public JNPadFrame(List<JNPadInput> inputFiles) {
        this(inputFiles, null);
    }

    public JNPadFrame(List<JNPadInput> inputFiles, String sessionPath) {
        super("jNPad");
        try {
            this.inputFiles = inputFiles;
            this.sessionPath = sessionPath;
            this.jbInit();
            this.validate();
            int x = Config.JNPAD_X.getValue();
            int y = Config.JNPAD_Y.getValue();
            if (x == (Integer)Config.JNPAD_X.getDefault() || y == (Integer)Config.JNPAD_Y.getDefault()) {
                this.setLocationRelativeTo(null);
            } else {
                this.setLocation(x, y);
            }
            this.setVisible(true);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void jbInit() throws Exception {
        try {
            this.pageFormat = PrinterJob.getPrinterJob().defaultPage();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
        this.setSize(Config.JNPAD_WIDTH.getValue(), Config.JNPAD_HEIGHT.getValue());
        ArrayList<Image> editorImages = new ArrayList<Image>(3);
        editorImages.add(GUIUtilities.getIcon("icon-jnpad16.png", false).getImage());
        editorImages.add(GUIUtilities.getIcon("icon-jnpad32.png", false).getImage());
        editorImages.add(GUIUtilities.getIcon("icon-jnpad48.png", false).getImage());
        this.setIconImages(editorImages);
        if (Accelerators.isUsingCompositeShortcuts()) {
            this.keyboardHandler = new JNPadKeyboardHandler();
        }
        this.actions = new JNPadActionHelper(this);
        this.menus = new JNPadMenuHelper(this);
        this.toolbars = new JNPadToolBarHelper(this);
        this.statusBar = new JNPadStatusBar(this);
        this.findResultsPanel = new FindResultsPanel(this);
        this.viewer = Config.TAB_TABBED.getValue() != false ? new JNPadTabbedViewer(this, this.menus.mWindow) : new JNPadCardViewer(this, this.menus.mWindow);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.toolbars.toolBar, "North");
        this.contentPane.add((Component)this.pnBackground, "Center");
        this.contentPane.add((Component)this.statusBar, "South");
        this.sppOutput.setBottomComponent(this.findResultsPanel);
        this.setJMenuBar(this.menus.getMenuBar());
        if (Config.isDefaultMode() || Config.isBasicMode()) {
            this.setToolBars();
            if (!Config.TOOLBAR_VISIBLE.getValue().booleanValue()) {
                this.setToolBarVisible(false);
            }
        }
        this.pnBackground.setLayout(new BorderLayout());
        this.pnBackground.add((Component)this.viewer, "Center");
        this.clearStatus();
        this.menus.loadRecentFiles();
        if (this.sessionPath != null) {
            JNPadParser parser = new JNPadParser(this.sessionPath);
            try {
                parser.load();
            }
            catch (Exception ex) {
                this.setStatus(StatusDisplayable.StatusType.ERROR, ex.getMessage());
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
            if (this.inputFiles == null) {
                this.inputFiles = new ArrayList<JNPadInput>();
            }
            this.inputFiles.addAll(parser.getJNPadInputList());
        }
        if (!this.loadOpenedFiles() && Utilities.isEmptyList(this.inputFiles)) {
            this.doNewFile(false);
        } else if (Utilities.isNotEmptyList(this.inputFiles)) {
            this.openFiles(this.inputFiles);
        }
        if (Config.JNPAD_MAXIMIZE.getValue().booleanValue()) {
            this.setExtendedState(6);
        }
        this.actions.registerKeyboardActions();
        if (!Config.STATUSBAR_VISIBLE.getValue().booleanValue()) {
            this.setStatusBarVisible(false);
        }
        if (Config.isDistractionFreeMode()) {
            this.setUndecorated(true);
        }
    }

    public JNPadKeyboardHandler getKeyboardHandler() {
        return this.keyboardHandler;
    }

    public final KeyListener getKeyEventInterceptor() {
        return this.keyEventInterceptor;
    }

    public void setKeyEventInterceptor(KeyListener listener) {
        this.keyEventInterceptor = listener;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (!Accelerators.isUsingCompositeShortcuts()) {
            super.processKeyEvent(e);
            return;
        }
        if (this.getFocusOwner() instanceof JComponent) {
            Object binding;
            JComponent comp = (JComponent)this.getFocusOwner();
            InputMap im = comp.getInputMap();
            ActionMap am = comp.getActionMap();
            if (im != null && am != null && comp.isEnabled() && (binding = im.get(KeyStroke.getKeyStrokeForEvent(e))) != null && am.get(binding) != null) {
                return;
            }
        }
        if (this.getFocusOwner() instanceof JTextComponent) {
            Keymap keymap;
            if (e.getID() == 401) {
                switch (e.getKeyCode()) {
                    case 8: 
                    case 9: 
                    case 10: {
                        return;
                    }
                }
            }
            if ((keymap = ((JTextComponent)this.getFocusOwner()).getKeymap()).getAction(KeyStroke.getKeyStrokeForEvent(e)) != null) {
                return;
            }
        }
        if (e.isConsumed()) {
            return;
        }
        if ((e = KeyEventWorkaround.processKeyEvent(e)) == null) {
            return;
        }
        switch (e.getID()) {
            case 400: {
                if (this.keyEventInterceptor != null) {
                    this.keyEventInterceptor.keyTyped(e);
                    break;
                }
                if (this.keyboardHandler == null) break;
                this.keyboardHandler.keyTyped(e);
                break;
            }
            case 401: {
                if (this.keyEventInterceptor != null) {
                    this.keyEventInterceptor.keyPressed(e);
                    break;
                }
                if (this.keyboardHandler == null) break;
                this.keyboardHandler.keyPressed(e);
                break;
            }
            case 402: {
                if (this.keyEventInterceptor != null) {
                    this.keyEventInterceptor.keyReleased(e);
                    break;
                }
                if (this.keyboardHandler == null) break;
                this.keyboardHandler.keyReleased(e);
                break;
            }
        }
        if (!e.isConsumed()) {
            super.processKeyEvent(e);
        }
    }

    public boolean isFullScreen() {
        return this.isFullScreen;
    }

    public void toggleFullScreen() {
        if (!this.isFullScreen) {
            this.prevX = this.getX();
            this.prevY = this.getY();
            this.prevWidth = this.getWidth();
            this.prevHeight = this.getHeight();
            this.prevStatusVisible = this.isStatusBarVisible();
            this.prevToolbarsVisible = this.isToolBarVisible();
            this.prevIsMaximized = this.getExtendedState() == 6;
            this.dispose();
            this.setUndecorated(true);
            this.clearStatus();
            if (this.btFullScreen == null) {
                this.btFullScreen = new JButton(this.actions.fullScreenAction);
                this.btFullScreen.setText(this.actions.fullScreenAction.getLabel());
                this.btFullScreen.setMargin(new Insets(0, 1, 0, 1));
                this.btFullScreen.setFocusPainted(false);
                this.horizontalGlue = Box.createHorizontalGlue();
            }
            this.menus.menuBar.add(this.horizontalGlue);
            this.menus.menuBar.add(this.btFullScreen);
            this.setBounds(0, 0, this.getToolkit().getScreenSize().width, this.getToolkit().getScreenSize().height);
            this.setVisible(true);
            this.isFullScreen = true;
        } else {
            this.setVisible(true);
            this.setBounds(this.prevX, this.prevY, this.prevWidth, this.prevHeight);
            this.dispose();
            this.setUndecorated(false);
            this.menus.menuBar.remove(this.horizontalGlue);
            this.menus.menuBar.remove(this.btFullScreen);
            if (this.prevIsMaximized) {
                this.setExtendedState(6);
            }
            this.setVisible(true);
            this.isFullScreen = false;
        }
        this.viewer.focusOnActiveBuffer();
    }

    public void reduceAsTrayIcon() {
        if (!SystemTray.isSupported()) {
            return;
        }
        this.saveAll();
        try {
            this.setVisible(false);
            int w = SystemTray.getSystemTray().getTrayIconSize().width;
            Image image = w == 16 ? GUIUtilities.getIcon("icon-jnpad16.png").getImage() : IconUtilities.createImage(new IconUtilities.LetterIcon("j", true, w, w, true));
            final TrayIcon tic = new TrayIcon(image, this.getTitle());
            SystemTray.getSystemTray().add(tic);
            tic.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JNPadFrame.this.setVisible(true);
                    SystemTray.getSystemTray().remove(tic);
                }
            });
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public void setToolBars() {
        this.toolbars.setToolBars();
    }

    public void viewToolBarsVisible(boolean b) {
        this.toolbars.viewToolBarsVisible(b);
    }

    public void setStatusBarVisible(boolean b) {
        this.statusBar.setVisible(b);
        JNPadAction.checkSelection(this.actions.statusBarVisibleAction, b);
    }

    public boolean isStatusBarVisible() {
        return this.statusBar.isVisible();
    }

    public void setToolBarVisible(boolean b) {
        this.toolbars.setToolBarVisible(b);
    }

    public boolean isToolBarVisible() {
        return this.toolbars.isToolBarVisible();
    }

    public void setFindResultsVisible(boolean b) {
        if (b != this.isFindResultsVisible()) {
            if (b) {
                if (this.sppOutputPosition < 0) {
                    this.sppOutputPosition = this.pnBackground.getHeight() * 2 / 3;
                }
                this.pnBackground.remove(this.viewer);
                this.pnBackground.add((Component)this.sppOutput, "Center");
                this.sppOutput.add((Component)this.viewer, "top");
                this.sppOutput.setDividerLocation(this.sppOutputPosition);
                this.findResultsPanel.requestFocusInWindow();
            } else {
                this.sppOutputPosition = this.sppOutput.getDividerLocation();
                this.pnBackground.remove(this.sppOutput);
                this.pnBackground.add((Component)this.viewer, "Center");
                this.viewer.focusOnActiveBuffer();
            }
            this.pnBackground.revalidate();
            JNPadAction.checkSelection(this.actions.findResultsVisibleAction, b);
            this.isFindResultsVisible = b;
        }
    }

    public boolean isFindResultsVisible() {
        return this.isFindResultsVisible;
    }

    public void addNewFound(String text, String path) {
        this.findResultsPanel.addNewFound(text, path);
    }

    public void addNewText(Text text) {
        this.findResultsPanel.addNewText(text);
    }

    public void showFoundTarget() {
        this.findResultsPanel.showFoundTarget();
    }

    public void setIncrementalSearchVisible(boolean b) {
        if (b != this.isIncrementalSearchVisible()) {
            if (b) {
                if (this.incrementalSearchPanel == null) {
                    this.incrementalSearchPanel = new IncrementalSearchPanel(this);
                }
                this.pnBackground.add((Component)this.incrementalSearchPanel, "South");
                this.statusBar.setBorder(new EdgeBorder(1));
                this.incrementalSearchPanel.requestFocusInWindow();
            } else if (this.incrementalSearchPanel != null) {
                this.pnBackground.remove(this.incrementalSearchPanel);
                this.statusBar.setBorder(null);
                this.viewer.focusOnActiveBuffer();
            }
            this.isIncrementalSearchVisible = b;
            this.pnBackground.validate();
        }
    }

    public boolean isIncrementalSearchVisible() {
        return this.isIncrementalSearchVisible;
    }

    public void showFindDialog() {
        if (this.findDialog == null) {
            this.findDialog = new FindDialog(this);
            this.actions.findNextAction.setEnabled(true);
            this.actions.findPreviousAction.setEnabled(true);
        } else {
            this.findDialog.setVisible(true);
        }
    }

    public void findNext() {
        if (this.findDialog != null) {
            this.findDialog.findNext();
        }
    }

    public void findPrevious() {
        if (this.findDialog != null) {
            this.findDialog.findPrevious();
        }
    }

    public void showReplaceDialog() {
        if (this.replaceDialog == null) {
            this.replaceDialog = new ReplaceDialog(this);
            this.actions.replaceNextAction.setEnabled(true);
        } else {
            this.replaceDialog.setVisible(true);
        }
    }

    public void replaceNext() {
        if (this.replaceDialog != null) {
            this.replaceDialog.replaceNext();
        }
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public BufferSet getActiveBufferSet() {
        try {
            return this.viewer.getActiveBufferSet();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            return null;
        }
    }

    public Buffer getActiveBuffer() {
        try {
            return this.viewer.getActiveBuffer();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            return null;
        }
    }

    public EditPane getActiveEditPane() {
        try {
            Buffer activeBuffer = this.getActiveBuffer();
            if (activeBuffer != null) {
                return activeBuffer.getSelectedEditPane();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
        return null;
    }

    public JNPadTextArea getActiveTextArea() {
        try {
            Buffer activeBuffer = this.getActiveBuffer();
            if (activeBuffer != null) {
                return activeBuffer.getSelectedTextArea();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
        return null;
    }

    public void pageLayout() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        this.pageFormat = pj.pageDialog(this.pageFormat);
        this.pageFormat = pj.validatePage(this.pageFormat);
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void showWaitCursor() {
        if (this.waitCount++ == 0) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void hideWaitCursor() {
        if (this.waitCount > 0) {
            --this.waitCount;
        }
        if (this.waitCount == 0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void reset() {
        if (!this.isResetEnabled) {
            return;
        }
        this.index_file = 0;
        this.doNewFile(false);
    }

    void handleStateChanged(Buffer buffer) {
        this.lastDirty = null;
        this.lastReadOnly = null;
        this.setStatus(buffer.getFilePath(), Config.isDistractionFreeMode() || this.isFullScreen() ? 0 : 10);
        this.updateControls(buffer);
    }

    private boolean checkInitFile() {
        if (this.viewer.getBufferCount() == 1) {
            Buffer buffer = this.viewer.getBufferAt(0);
            return buffer.isNew() && !buffer.isDirty();
        }
        return false;
    }

    private void setSaveSessionEnabled() {
        boolean b = false;
        int i = 0;
        while (!b && i < this.viewer.getBufferCount()) {
            Buffer buffer = this.viewer.getBufferAt(i);
            b = !buffer.isNew();
            ++i;
        }
        this.actions.saveSessionAction.setEnabled(b);
    }

    private void setSaveAllEnabled() {
        boolean b = false;
        int i = 0;
        while (!b && i < this.viewer.getBufferCount()) {
            Buffer buffer = this.viewer.getBufferAt(i);
            b = buffer.isDirty() && !buffer.isReadOnly();
            ++i;
        }
        this.actions.saveAllFilesAction.setEnabled(b);
    }

    private void setCloseOtherEnabled() {
        boolean b = this.viewer.getBufferCount() > 1;
        this.actions.closeOtherAction.setEnabled(b);
        this.actions.closeAllToLeftAction.setEnabled(b);
        this.actions.closeAllToRightAction.setEnabled(b);
    }

    @Override
    public void updateControls() {
        this.updateControls(8191);
    }

    @Override
    public void updateControls(int ctrls) {
        try {
            this.updateControls(this.getActiveBuffer(), ctrls);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public void updateControls(Buffer buffer) {
        this.updateControls(buffer, 8191);
    }

    public void updateControls(Buffer buffer, int ctrls) {
        this.viewer.updateControls(ctrls);
        buffer.updateControls(ctrls);
        if ((ctrls & 0x200) != 0) {
            this.updateEditableControls(buffer);
        }
        if ((ctrls & 4) != 0) {
            this.updateTextChangedControls(buffer);
        }
        if ((ctrls & 0x800) != 0) {
            this.statusBar.setEOL(buffer.getLineSeparator());
        }
        if ((ctrls & 0x1000) != 0) {
            this.statusBar.setEncoding(buffer.getEncoding());
        }
        if ((ctrls & 0x10) != 0) {
            this.statusBar.setAsOverwriteTextMode(buffer.getSelectedTextArea().isOverwriteTextMode());
        }
        if ((ctrls & 0x100) != 0) {
            this.updateViewControls(buffer);
        }
    }

    private void updateTextChangedControls(Buffer buffer) {
        boolean isReadOnly = buffer.isReadOnly();
        boolean isDirty = buffer.isDirty();
        if (this.lastDirty == null || this.lastReadOnly == null || this.lastDirty != isDirty || this.lastReadOnly != isReadOnly) {
            int i = this.viewer.indexOf(buffer);
            if (i >= 0 && i < this.viewer.getBufferCount()) {
                this.viewer.setComponentIconAt(i);
            }
            this.actions.saveFileAction.setEnabled(!isReadOnly && isDirty);
            this.setSaveAllEnabled();
            this.setSaveSessionEnabled();
            StringBuilder sb = new StringBuilder();
            sb.append("jNPad");
            sb.append(isDirty ? " - * " : " - ");
            sb.append(buffer.getFilePath());
            if (isReadOnly) {
                sb.append(" [").append(JNPadBundle.getString("JNPad.readOnly", new Object[0])).append("]");
            }
            this.setTitle(sb.toString());
            this.lastReadOnly = isReadOnly;
            this.lastDirty = isDirty;
        }
    }

    private void updateEditableControls(Buffer buffer) {
        boolean isEditable;
        boolean bl = isEditable = !buffer.isReadOnly();
        if (isEditable != this.lastGrobalEditable) {
            ActionManager.INSTANCE.setEnabledBy(isEditable, buffer.hasSelection(), buffer.canUndo(), buffer.canRedo(), buffer.isDirty());
            this.updateTextChangedControls(buffer);
            GUIUtilities.setButtonGroupEnabled(this.menus.bgEOL, isEditable);
            GUIUtilities.setButtonGroupEnabled(this.menus.bgEncoding, isEditable);
            this.lastGrobalEditable = isEditable;
            JNPadAction.setGlobalItemStateChangedEnabled(false);
            this.actions.setReadOnlyAction.setSelected(!isEditable);
            JNPadAction.setGlobalItemStateChangedEnabled(true);
            this.statusBar.setReadOnlyIndicatorEnabled(!isEditable);
        }
    }

    private void updateViewControls(Buffer buffer) {
        JNPadAction.setGlobalItemStateChangedEnabled(false);
        this.actions.lineWrapAction.setSelected(buffer.getLineWrap());
        this.actions.lineNumbersAction.setSelected(buffer.isLineNumbersVisible());
        this.actions.activeLineAction.setSelected(buffer.isActiveLineVisible());
        this.actions.rightMarginLineAction.setSelected(buffer.isRightMarginLineVisible());
        this.actions.markOccurrencesAction.setSelected(buffer.isOccurrencesHighlighterVisible());
        this.actions.markStripAction.setSelected(buffer.isMarkStripVisible());
        this.actions.setReadOnlyAction.setSelected(buffer.isReadOnly());
        JNPadAction.setGlobalItemStateChangedEnabled(true);
        this.statusBar.setReadOnlyIndicatorEnabled(buffer.isReadOnly());
        this.updateEOLControls(buffer);
        this.updateEncodingControls(buffer);
    }

    private void updateEOLControls(Buffer buffer) {
        JNPadAction.setGlobalItemStateChangedEnabled(false);
        LineSeparator lineSeparator = buffer.getLineSeparator();
        if (lineSeparator == LineSeparator.DOS) {
            GUIUtilities.setSelectedButton(this.menus.bgEOL, 0);
        } else if (lineSeparator == LineSeparator.UNIX) {
            GUIUtilities.setSelectedButton(this.menus.bgEOL, 1);
        } else if (lineSeparator == LineSeparator.MAC) {
            GUIUtilities.setSelectedButton(this.menus.bgEOL, 2);
        }
        JNPadAction.setGlobalItemStateChangedEnabled(true);
        this.statusBar.setEOL(buffer.getLineSeparator());
    }

    private void updateEncodingControls(Buffer buffer) {
        JNPadAction.setGlobalItemStateChangedEnabled(false);
        String encoding = buffer.getEncoding();
        Enumeration<AbstractButton> e = this.menus.bgEncoding.getElements();
        while (e.hasMoreElements()) {
            AbstractButton b = e.nextElement();
            if (!b.getText().equals(encoding)) continue;
            b.setSelected(true);
            break;
        }
        JNPadAction.setGlobalItemStateChangedEnabled(true);
        this.statusBar.setEncoding(buffer.getEncoding());
    }

    @Override
    public void configure(int cfg) {
        this.viewer.configure(cfg);
        this.findResultsPanel.configure(cfg);
        ((Configurable)((Object)this.actions.fileBrowserAction)).configure(cfg);
        ((Configurable)((Object)this.actions.executeActionAction)).configure(cfg);
    }

    JPopupMenu createTabbedPopupMenu() {
        return this.menus.createTabbedPopupMenu();
    }

    JPopupMenu createEncodingPopupMenu() {
        return this.menus.createEncodingPopupMenu();
    }

    public boolean newFile() {
        return this.doNewFile(true);
    }

    private boolean doNewFile(boolean status) {
        String name = JNPadBundle.getString("newFile.new", ++this.index_file).concat(".txt");
        try {
            Buffer buffer = new Buffer(this.viewer.getActiveBufferSet(), name, "");
            this.viewer.add(buffer);
            this.viewer.setActiveIndex(this.viewer.getBufferCount() - 1);
            buffer.addPropertyChangeListener(this.propertyChangeHandler);
            if (status) {
                this.setStatus(JNPadBundle.getString("newFile.open", name), 10);
            }
            this.updateControls(buffer);
            buffer.requestFocus();
            this.setCloseOtherEnabled();
            return true;
        }
        catch (Exception ex) {
            String msg = JNPadBundle.getString("newFile.error", new Object[0]);
            this.setStatus(StatusDisplayable.StatusType.ERROR, msg);
            LOGGER.log(Level.WARNING, msg, ex);
            return false;
        }
    }

    public boolean openFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setCurrentDirectory(new File(Config.CHOOSER_FILE_DIRECTORY.getValue()));
        if (fileChooser.showOpenDialog(this.rootPane) != 0) {
            return false;
        }
        File[] files = fileChooser.getSelectedFiles();
        if (files.length > 0) {
            boolean b = true;
            Config.CHOOSER_FILE_DIRECTORY.setValue(files[0].getParent());
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                b = b && this.openFile(file.getAbsolutePath());
                ++n2;
            }
            return b;
        }
        return false;
    }

    public boolean openFile(JNPadInput in) {
        return this.openFile(in.getPath(), in.getCaretPosition(), in.isReadOnly(), in.getSplitConfig(), in.isLineWrapped());
    }

    public boolean openFileAsReadOnly(String filePath) {
        return this.openFile(filePath, -1, true, "", false);
    }

    public boolean openFile(String filePath) {
        return this.openFile(filePath, -1, false, "", false);
    }

    public boolean openFile(String filePath, int caretPosition, boolean isReadOnly, boolean isLineWrapped) {
        return this.openFile(filePath, caretPosition, isReadOnly, "", isLineWrapped);
    }

    public boolean openFile(String filePath, int caretPosition, boolean isReadOnly, String splitConfig, boolean isLineWrapped) {
        String path;
        if (this.checkInitFile()) {
            this.isResetEnabled = false;
            this.doCloseFile(null, false);
            this.isResetEnabled = true;
        }
        if (filePath == null) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setFileSelectionMode(0);
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setCurrentDirectory(new File(Config.CHOOSER_FILE_DIRECTORY.getValue()));
            if (fileChooser.showOpenDialog(this.rootPane) != 0) {
                return false;
            }
            File file = fileChooser.getSelectedFile();
            path = file.getAbsolutePath();
            caretPosition = -1;
            Config.CHOOSER_FILE_DIRECTORY.setValue(file.getParent());
        } else {
            path = filePath;
        }
        String name = Utilities.getFileName(path);
        int index = this.viewer.indexOf(new MockBuffer(path));
        if (index != -1) {
            Buffer buffer = this.viewer.getBufferAt(index);
            if (buffer.isDirty()) {
                Object[] options = new String[]{JNPadBundle.getYesOptionText(), JNPadBundle.getCancelOptionText()};
                int option = JOptionPane.showOptionDialog(this, JNPadBundle.getString("openFile.warning.message", path), JNPadBundle.getString("openFile.warning.title", name), -1, 0, null, options, options[0]);
                if (option == 1 || option == -1) {
                    return false;
                }
                if (!this.closeFile(path, false)) {
                    return false;
                }
            } else {
                this.setStatus(JNPadBundle.getString("openFile.warning.message2", path), 10);
                this.updateControls(this.viewer.getBufferAt(index));
                this.viewer.setActiveIndex(index);
            }
        }
        try {
            if (this.viewer.indexOf(new MockBuffer(path)) == -1) {
                String s;
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(path));
                String encoding = GUIUtilities.detectEncoding(in);
                if (encoding == null || !Charset.isSupported(encoding)) {
                    encoding = Config.FILE_ENCODING.getValue();
                }
                byte[] buff = new byte[in.available()];
                in.read(buff, 0, buff.length);
                in.close();
                try {
                    s = new String(buff, 0, buff.length, encoding);
                }
                catch (Exception ex) {
                    LOGGER.fine("Unsupported Encoding " + encoding);
                    s = new String(buff, 0, buff.length, (String)Config.FILE_ENCODING.getDefault());
                    Config.FILE_ENCODING.setToDefault();
                }
                GUIUtilities.StringConversion conversion = GUIUtilities.getStringConversion(s, Config.REMOVE_END_SPACES.getValue());
                Buffer buffer = new Buffer(this.viewer.getActiveBufferSet(), path, conversion.getResult());
                buffer.setLineSeparator(conversion.getLineSeparator(), false);
                buffer.setReadOnly(isReadOnly);
                buffer.setEncoding(encoding, false);
                try {
                    if (caretPosition < 0) {
                        caretPosition = this.getRecentFileCursorPosition(path);
                    }
                    buffer.getSelectedTextArea().setCaretPosition(caretPosition);
                }
                catch (Exception ex) {
                    buffer.getSelectedTextArea().setCaretPosition(0);
                }
                this.viewer.add(buffer);
                this.viewer.setActiveIndex(this.viewer.getBufferCount() - 1);
                buffer.setInitialSplitConfig(splitConfig);
                buffer.getSelectedEditPane().setLineWrap(isLineWrapped);
                buffer.addPropertyChangeListener(this.propertyChangeHandler);
                this.setStatus(JNPadBundle.getString("openFile.open", path), 10);
                this.updateControls(buffer);
                buffer.requestFocus();
            }
            this.setCloseOtherEnabled();
            return true;
        }
        catch (Exception ex) {
            String msg = JNPadBundle.getString("openFile.error", path);
            this.setStatus(StatusDisplayable.StatusType.ERROR, msg);
            LOGGER.log(Level.WARNING, msg, ex);
            if (this.viewer.getBufferCount() == 0) {
                this.reset();
            }
            return false;
        }
    }

    public boolean openFiles(List<JNPadInput> inputs) {
        if (inputs.size() > 0) {
            int openedIndex = -1;
            int i = 0;
            while (i < inputs.size()) {
                JNPadInput in = inputs.get(i);
                if (in.isCurrent()) {
                    openedIndex = i;
                }
                this.openFile(in);
                ++i;
            }
            if (openedIndex >= 0 && openedIndex < this.viewer.getBufferCount()) {
                this.viewer.setActiveIndex(openedIndex);
            }
            this.updateControls();
            return true;
        }
        return false;
    }

    public boolean closeFile(String filePath, boolean confirmation) {
        return !this.checkInitFile() && this.doCloseFile(filePath, confirmation);
    }

    private boolean doCloseFile(String filePath, boolean confirmation) {
        int index;
        Buffer buffer = null;
        if (filePath == null) {
            index = this.viewer.getActiveIndex();
            buffer = this.viewer.getActiveBuffer();
        } else {
            index = this.viewer.indexOf(new MockBuffer(filePath));
            if (index != -1) {
                buffer = this.viewer.getBufferAt(index);
            }
        }
        if (buffer == null) {
            return false;
        }
        if (confirmation && buffer.isDirty()) {
            Object[] options = new String[]{JNPadBundle.getYesOptionText(), JNPadBundle.getNoOptionText(), JNPadBundle.getCancelOptionText()};
            int option = JOptionPane.showOptionDialog(this, JNPadBundle.getString("closeFile.warning.message", buffer.getFilePath()), JNPadBundle.getString("closeFile.warning.title", new Object[0]), -1, 0, null, options, options[0]);
            if (option == 2 || option == -1) {
                return false;
            }
            if (option == 0) {
                this.saveFile(filePath);
            }
        }
        buffer.removePropertyChangeListener(this.propertyChangeHandler);
        this.setStatus(JNPadBundle.getString("closeFile.close", buffer.getFilePath()), 10);
        this.menus.updateRecentFiles(buffer.getFilePath(), buffer.getCaretPosition(), buffer.isReadOnly(), buffer.isSplitted() ? buffer.getSplitConfig() : "", buffer.isLineWrapped());
        this.viewer.removeBufferAt(index);
        if (this.viewer.getBufferCount() > 0) {
            int j = index;
            if (index >= this.viewer.getBufferCount()) {
                j = this.viewer.getBufferCount() - 1;
            }
            this.viewer.setActiveIndex(j);
            this.updateControls(this.viewer.getActiveBuffer());
        }
        this.setSaveAllEnabled();
        this.setCloseOtherEnabled();
        this.viewer.focusOnActiveBuffer();
        Utilities.gc_();
        return true;
    }

    public void closeOtherFiles() {
        int i = this.viewer.getActiveIndex();
        int count = this.viewer.getBufferCount();
        int j = count - 1;
        while (j >= 0) {
            if (j != i) {
                Buffer buffer = this.viewer.getBufferAt(j);
                this.doCloseFile(buffer.getFilePath(), true);
            }
            --j;
        }
    }

    public void closeAllToRight() {
        int i = this.viewer.getActiveIndex();
        int count = this.viewer.getBufferCount();
        int j = count - 1;
        while (j > i) {
            Buffer buffer = this.viewer.getBufferAt(j);
            this.doCloseFile(buffer.getFilePath(), true);
            --j;
        }
    }

    public void closeAllToLeft() {
        int i = this.viewer.getActiveIndex();
        int j = 0;
        while (j < i) {
            Buffer buffer = this.viewer.getBufferAt(0);
            this.doCloseFile(buffer.getFilePath(), true);
            ++j;
        }
    }

    public void closeAll() {
        int count = this.viewer.getBufferCount();
        int j = count - 1;
        while (j >= 0) {
            Buffer buffer = this.viewer.getBufferAt(j);
            this.closeFile(buffer.getFilePath(), true);
            --j;
        }
    }

    public void closeFiles() {
        ExitDialog.showDialog(this, this.viewer.getActiveBufferSet(), 2);
    }

    public boolean saveFile(String filePath) {
        Buffer buffer;
        int index;
        block9: {
            try {
                if (filePath != null) {
                    index = this.viewer.indexOf(new MockBuffer(filePath));
                    buffer = this.viewer.getBufferAt(index);
                } else {
                    buffer = this.viewer.getActiveBuffer();
                    index = this.viewer.getActiveIndex();
                }
                if (buffer != null) break block9;
                return false;
            }
            catch (Exception ex) {
                String msg = JNPadBundle.getString("saveFile.error", filePath);
                this.setStatus(StatusDisplayable.StatusType.ERROR, msg);
                LOGGER.log(Level.WARNING, msg, ex);
                return false;
            }
        }
        filePath = buffer.getFilePath();
        File f = new File(filePath);
        if (!f.exists()) {
            return this.saveFileAs(buffer, index);
        }
        if (Config.SECURE_SAVE.getValue().booleanValue()) {
            String name = Utilities.getFileName(filePath);
            name = name.concat(String.valueOf('~'));
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));
                byte[] data = new byte[in.available()];
                in.read(data, 0, data.length);
                in.close();
                String dirPath = filePath.substring(0, filePath.lastIndexOf(Utilities.DIR_SEPARATOR) + 1);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dirPath.concat(name)));
                out.write(data);
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filePath));
        out.write(JNPadFrame.getData(buffer));
        out.close();
        buffer.setAsSaved();
        this.updateControls(buffer);
        this.setStatus(JNPadBundle.getString("saveFile.save", filePath), 10);
        return true;
    }

    private boolean saveFileAs(Buffer buffer, int index) {
        String path = buffer.getFilePath();
        JFileChooser fileChooser = new JFileChooser();
        File file = new File(path);
        if (file.exists()) {
            fileChooser.setSelectedFile(file);
        } else {
            fileChooser.setCurrentDirectory(new File(Config.CHOOSER_FILE_DIRECTORY.getValue()));
        }
        fileChooser.rescanCurrentDirectory();
        if (fileChooser.showSaveDialog(this.rootPane) == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            path = selectedFile.getAbsolutePath();
            String name = Utilities.getFileName(path);
            if (selectedFile.exists()) {
                Object[] options = new String[]{JNPadBundle.getYesOptionText(), JNPadBundle.getNoOptionText()};
                int option = JOptionPane.showOptionDialog(this, JNPadBundle.getString("saveFile.warning.message", path), JNPadBundle.getString("saveFile.warning.title", name), -1, 0, null, options, options[0]);
                if (option == 1 || option == -1) {
                    return false;
                }
            }
            Config.CHOOSER_FILE_DIRECTORY.setValue(selectedFile.getParent());
            try {
                if (index == -1) {
                    index = this.viewer.getActiveIndex();
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(path));
                out.write(JNPadFrame.getData(buffer));
                out.close();
                buffer.setFilePath(path);
                buffer.setAsSaved();
                this.setStatus(JNPadBundle.getString("saveFile.save", path), 10);
                this.viewer.setTitleAt(index, Utilities.getFileName(path));
                this.viewer.setToolTipTextAt(index, path);
                this.viewer.setComponentIconAt(index);
                this.updateControls(buffer);
            }
            catch (Exception ex) {
                String msg = JNPadBundle.getString("saveFile.error", path);
                this.setStatus(StatusDisplayable.StatusType.ERROR, msg);
                LOGGER.log(Level.WARNING, msg, ex);
                return false;
            }
        }
        return true;
    }

    public boolean saveFileAs() {
        return this.saveFileAs(this.viewer.getActiveBuffer(), -1);
    }

    public void saveAll() {
        int i = 0;
        int j = 0;
        while (j < this.viewer.getBufferCount()) {
            Buffer buffer = this.viewer.getBufferAt(j);
            if (buffer.isDirty()) {
                this.saveFile(buffer.getFilePath());
                ++i;
            }
            ++j;
        }
        this.setSaveAllEnabled();
        if (i > 1) {
            this.setStatus(this.statusBar.getStatus().concat(JNPadBundle.getString("saveAll.save", i)), 10);
        }
    }

    private static byte[] getData(Buffer buffer) throws UnsupportedEncodingException {
        byte[] data;
        String encoding = buffer.getEncoding();
        try {
            data = GUIUtilities.formatString(buffer.getText(), buffer.getLineSeparator().getLineSeparator()).getBytes(encoding);
        }
        catch (Exception ex) {
            LOGGER.fine("Unsupported Encoding " + encoding);
            try {
                encoding = Config.FILE_ENCODING.getValue();
                data = GUIUtilities.formatString(buffer.getText(), buffer.getLineSeparator().getLineSeparator()).getBytes(encoding);
            }
            catch (Exception ex2) {
                LOGGER.fine("Unsupported Encoding " + encoding);
                encoding = (String)Config.FILE_ENCODING.getDefault();
                data = GUIUtilities.formatString(buffer.getText(), buffer.getLineSeparator().getLineSeparator()).getBytes(encoding);
            }
            buffer.setEncoding(encoding, false);
        }
        return data;
    }

    public boolean loadSession() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(JNPadBundle.getString("loadSession.title", new Object[0]));
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new JNPadFileFilter());
        fileChooser.setCurrentDirectory(new File(Config.CHOOSER_FILE_DIRECTORY.getValue()));
        if (fileChooser.showOpenDialog(this.rootPane) != 0) {
            return false;
        }
        File file = fileChooser.getSelectedFile();
        String path = file.getAbsolutePath();
        Config.CHOOSER_FILE_DIRECTORY.setValue(file.getParent());
        JNPadParser parser = new JNPadParser(path);
        try {
            parser.load();
        }
        catch (Exception ex) {
            this.setStatus(StatusDisplayable.StatusType.ERROR, ex.getMessage());
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            return false;
        }
        return this.openFiles(parser.getJNPadInputList());
    }

    public boolean saveSession() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(JNPadBundle.getString("saveSession.title", new Object[0]));
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(new JNPadFileFilter());
        fileChooser.setCurrentDirectory(new File(Config.CHOOSER_FILE_DIRECTORY.getValue()));
        if (fileChooser.showSaveDialog(this.rootPane) != 0) {
            return false;
        }
        File file = fileChooser.getSelectedFile();
        String path = file.getAbsolutePath();
        String name = path.substring(path.lastIndexOf(Utilities.DIR_SEPARATOR) + 1);
        String dir = path.substring(0, path.lastIndexOf(Utilities.DIR_SEPARATOR) + 1);
        if (!name.toLowerCase().endsWith(".jnpad")) {
            name = name.concat(".jnpad");
            path = dir.concat(name);
        }
        Config.CHOOSER_FILE_DIRECTORY.setValue(file.getParent());
        file = new File(path);
        if (file.exists()) {
            Object[] options = new String[]{JNPadBundle.getYesOptionText(), JNPadBundle.getCancelOptionText()};
            int option = JOptionPane.showOptionDialog(this, JNPadBundle.getString("saveFile.warning.message", path), JNPadBundle.getString("saveFile.warning.title", name), -1, 0, null, options, options[0]);
            if (option == 1 || option == -1) {
                return false;
            }
        }
        int selected_index = this.viewer.getActiveIndex();
        ArrayList<JNPadInput> list = new ArrayList<JNPadInput>(this.viewer.getBufferCount());
        int i = 0;
        while (i < this.viewer.getBufferCount()) {
            Buffer buffer = this.viewer.getBufferAt(i);
            String path_ = buffer.getFilePath();
            File file_ = new File(path_);
            if (file_.isFile()) {
                list.add(new JNPadInput(path_, buffer.getCaretPosition(), buffer.isReadOnly(), selected_index == i, buffer.isSplitted() ? buffer.getSplitConfig() : "", buffer.isLineWrapped()));
            }
            ++i;
        }
        if (list.size() > 0) {
            JNPadParser parser = new JNPadParser(path);
            parser.addAll(list);
            try {
                parser.save();
            }
            catch (Exception ex) {
                this.setStatus(StatusDisplayable.StatusType.ERROR, ex.getMessage());
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                return false;
            }
        }
        return true;
    }

    public void openAllRecentFiles() {
        this.menus.openAllRecentFiles();
    }

    public void emptyRecentFilesList() {
        this.menus.emptyRecentFilesList();
    }

    private int getRecentFileCursorPosition(String s) {
        List<JNPadInput> l = Config.getJNPadInputListProp("files.recent");
        for (JNPadInput in : l) {
            if (!Utilities.equals(in.getPath(), s, !Platform.isWindows)) continue;
            return in.getCaretPosition();
        }
        return 0;
    }

    private boolean loadOpenedFiles() {
        return this.openFiles(Config.getJNPadInputListProp("files.opened"));
    }

    private void saveOpenedFiles() {
        int selected_index = this.viewer.getActiveIndex();
        ArrayList<JNPadInput> list = new ArrayList<JNPadInput>(this.viewer.getBufferCount());
        int i = 0;
        while (i < this.viewer.getBufferCount()) {
            Buffer buffer = this.viewer.getBufferAt(i);
            String path = buffer.getFilePath();
            File file = new File(path);
            if (file.isFile()) {
                list.add(new JNPadInput(path, buffer.getCaretPosition(), buffer.isReadOnly(), selected_index == i, buffer.isSplitted() ? buffer.getSplitConfig() : "", buffer.isLineWrapped()));
            }
            ++i;
        }
        if (list.size() > 0) {
            Config.setJNPadInputListProp("files.opened", list);
        } else {
            Config.remove("files.opened");
        }
    }

    public void reload() {
        this.reload(this.getActiveBuffer());
    }

    public void reload(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        try {
            buffer.reload();
            this.setStatus(JNPadBundle.getString("openFile.open", buffer.getFilePath()), 10);
            this.updateControls(buffer);
            buffer.requestFocus();
        }
        catch (Exception ex) {
            String msg = JNPadBundle.getString("reload.error", buffer.getFilePath());
            this.setStatus(StatusDisplayable.StatusType.ERROR, msg);
            LOGGER.log(Level.WARNING, msg, ex);
        }
    }

    @Override
    public void clearStatus() {
        this.statusBar.clearStatus();
    }

    @Override
    public void setStatus(String text) {
        this.statusBar.setStatus(text);
    }

    @Override
    public void setStatus(String text, int timeout_sec) {
        this.statusBar.setStatus(text, timeout_sec);
    }

    @Override
    public void setStatus(StatusDisplayable.StatusType type, String text) {
        this.statusBar.setStatus(type, text);
    }

    @Override
    public void setStatus(StatusDisplayable.StatusType type, String text, int timeout_sec) {
        this.statusBar.setStatus(type, text, timeout_sec);
    }

    @Override
    public String getStatus() {
        return this.statusBar.getStatus();
    }

    public IStatusBar getStatusBar() {
        return this.statusBar;
    }

    public void selectSearchedText(Text text, Component comp) {
        MockBuffer mock = new MockBuffer(text.getPath());
        int index = this.viewer.indexOf(mock);
        if (index == -1) {
            this.openFile(text.getPath());
            if (comp != null) {
                comp.requestFocus();
            }
        }
        if ((index = this.viewer.indexOf(mock)) != -1) {
            Buffer buffer = this.viewer.getBufferAt(index);
            this.viewer.setActiveBuffer(buffer);
            if (comp != null) {
                comp.requestFocus();
            }
            try {
                buffer.getSelectedEditPane().highlightSearch(text.getContext(), text.getStartPosition(), text.getEndPosition());
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    private void saveSettings() {
        boolean isMaximized;
        boolean bl = isMaximized = this.getExtendedState() == 6;
        if (!isMaximized) {
            Config.JNPAD_X.setValue(this.getX());
            Config.JNPAD_Y.setValue(this.getY());
            Config.JNPAD_WIDTH.setValue(this.getWidth());
            Config.JNPAD_HEIGHT.setValue(this.getHeight());
        }
        Config.JNPAD_MAXIMIZE.setValue(isMaximized);
        Config.STATUSBAR_VISIBLE.setValue(this.isStatusBarVisible());
        Config.FINDRESULTS_VISIBLE.setValue(this.isFindResultsVisible());
        Config.TOOLBAR_VISIBLE.setValue(this.isToolBarVisible());
        this.saveOpenedFiles();
    }

    public void exit() {
        if (ExitDialog.showDialog(this, this.viewer.getActiveBufferSet(), 1)) {
            this.saveSettings();
            Config.saveProperties();
            Utilities.exitSuccess();
        }
    }

    public void restart() {
        if (ExitDialog.showDialog(this, this.viewer.getActiveBufferSet(), 1)) {
            this.saveSettings();
            Config.saveProperties();
            try {
                Utilities.restartApplication(null);
            }
            catch (IOException e) {
                try {
                    Utilities.restartApplication2("jnpad-0.3.jar");
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.exit();
            return;
        }
        if (e.getID() == 200) {
            if (Config.FINDRESULTS_VISIBLE.getValue().booleanValue()) {
                this.setFindResultsVisible(true);
            }
            this.setInitialSplitConfiguration();
            Buffer activeBuffer = this.viewer.getActiveBuffer();
            if (activeBuffer != null) {
                GUIUtilities.requestFocus(activeBuffer);
            }
        }
        super.processWindowEvent(e);
    }

    private void setInitialSplitConfiguration() {
        block5: {
            try {
                boolean b = false;
                Buffer[] bufferArray = this.viewer.getBuffers();
                int n = bufferArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Buffer eview = bufferArray[n2];
                    String isc = eview.getInitialSplitConfig();
                    if (Utilities.isNotEmptyString(isc)) {
                        eview.setSplitConfig(isc);
                        b = true;
                    }
                    ++n2;
                }
                if (b) {
                    this.updateControls(2);
                }
            }
            catch (Exception ex) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block5;
                LOGGER.log(Level.FINEST, ex.getMessage(), ex);
            }
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = 7695232497147556601L;

        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propName = e.getPropertyName();
            Object obj = e.getSource();
            Buffer activeBuffer = JNPadFrame.this.getActiveBuffer();
            if (activeBuffer == null || obj != activeBuffer) {
                return;
            }
            if ("Buffer.dirty".equals(propName)) {
                JNPadFrame.this.updateTextChangedControls(activeBuffer);
            } else if ("Buffer.readOnly".equals(propName)) {
                JNPadFrame.this.updateEditableControls(activeBuffer);
            } else if ("Buffer.lineSeparator".equals(propName)) {
                JNPadFrame.this.updateEOLControls(activeBuffer);
            } else if ("Buffer.encoding".equals(propName)) {
                JNPadFrame.this.reload(activeBuffer);
            }
        }
    }
}

