/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import jdomain.util.gui.AntialiasPanel;
import jdomain.util.gui.StandardMainFrame;

public class StandardDialog
extends JDialog
implements KeyEventDispatcher,
WindowFocusListener {
    private static final long serialVersionUID = 1L;
    public static final int APPROVE_ACTION = 1;
    public static final int CANCEL_ACTION = 0;
    public static final int ABORT_ACTION = 2;
    private JButton approveButton = null;
    private final ArrayList buttonList = new ArrayList();
    private final JPanel buttons = new JPanel(new BorderLayout(0, 0));
    private JButton cancelButton = null;
    private JButton abortButton = null;
    private boolean disposeOnClose = true;
    private JComponent firstFocusComponent = null;
    private final boolean ignoreEscapeKey;
    private final JPanel leftButtons = new JPanel(new FlowLayout(0, 0, 0));
    public final AntialiasPanel main = new AntialiasPanel(new BorderLayout(0, 0));
    private int result = 0;
    private final JPanel rightButtons = new JPanel(new FlowLayout(2, 0, 0));

    public StandardDialog(JFrame jFrame, String string, boolean bl) {
        super((Frame)jFrame, string);
        this.ignoreEscapeKey = bl;
        this.setModal(false);
        this.setUndecorated(true);
        this.setContentPane(this.main);
        this.buttons.add((Component)this.leftButtons, "West");
        this.buttons.add((Component)this.rightButtons, "East");
        this.buttons.setBorder(new EmptyBorder(15, 0, 0, 0));
        this.addWindowFocusListener(this);
        this.addWindowListener(new WindowAdapter(){

            public final void windowClosed(WindowEvent windowEvent) {
                FocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(StandardDialog.this);
            }

            public final void windowOpened(WindowEvent windowEvent) {
                if (StandardDialog.this.firstFocusComponent != null) {
                    StandardDialog.this.firstFocusComponent.grabFocus();
                }
                FocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(StandardDialog.this);
            }
        });
    }

    public StandardDialog(JDialog jDialog, String string, boolean bl) {
        super((Dialog)jDialog, string);
        this.ignoreEscapeKey = bl;
        this.setModal(false);
        this.setUndecorated(true);
        this.setContentPane(this.main);
        this.buttons.add((Component)this.leftButtons, "West");
        this.buttons.add((Component)this.rightButtons, "East");
        this.buttons.setBorder(new EmptyBorder(15, 0, 0, 0));
        this.addWindowFocusListener(this);
        this.addWindowListener(new WindowAdapter(){

            public final void windowClosed(WindowEvent windowEvent) {
                FocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(StandardDialog.this);
            }

            public final void windowOpened(WindowEvent windowEvent) {
                if (StandardDialog.this.firstFocusComponent != null) {
                    StandardDialog.this.firstFocusComponent.grabFocus();
                }
                FocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(StandardDialog.this);
            }
        });
    }

    public JPanel getButtonPanel() {
        return this.buttons;
    }

    public JPanel getLeftButtonPanel() {
        return this.leftButtons;
    }

    public JPanel getRightButtonPanel() {
        return this.rightButtons;
    }

    public StandardDialog(StandardMainFrame standardMainFrame, String string) {
        this(standardMainFrame, string, false);
    }

    public final void addButtonPanel() {
        this.main.add((Component)this.buttons, "South");
    }

    public final void addLeftButton(JButton jButton) {
        this.buttonList.add(jButton);
        this.leftButtons.add(jButton);
        this.leftButtons.add(Box.createHorizontalStrut(4));
    }

    public final void addRightButton(JButton jButton) {
        this.buttonList.add(jButton);
        this.rightButtons.add(Box.createHorizontalStrut(4));
        this.rightButtons.add(jButton);
    }

    protected void approve() {
        this.result = 1;
        this.close();
    }

    protected void abort() {
        this.result = 2;
        this.close();
    }

    protected void cancel() {
        this.result = 0;
        this.close();
    }

    public final void center() {
        Point point;
        Dimension dimension;
        if (this.hasValidParent()) {
            dimension = this.getParent().getSize();
            point = this.getParent().getLocation();
        } else {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
            point = new Point(0, 0);
        }
        Dimension dimension2 = this.getPreferredSize();
        point.x = Math.max(0, point.x + dimension.width / 2 - dimension2.width / 2);
        point.y = Math.max(0, point.y + dimension.height / 2 - dimension2.height / 2);
        this.setLocation(point.x, point.y);
    }

    public final void close() {
        this.setVisible(false);
        if (this.disposeOnClose) {
            this.dispose();
        }
    }

    public final boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (!this.isActive()) {
            return false;
        }
        if (keyEvent.getID() == 400 && keyEvent.getKeyChar() == '\u001b' && keyEvent.getModifiers() == 0 && !this.ignoreEscapeKey) {
            this.cancel();
            return true;
        }
        return this.handleKey(keyEvent);
    }

    public JButton getApproveButton() {
        if (this.approveButton == null) {
            this.approveButton = new JButton("OK");
            this.approveButton.setMnemonic('o');
            this.approveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StandardDialog.this.approve();
                }
            });
        }
        return this.approveButton;
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.setMnemonic('c');
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StandardDialog.this.cancel();
                }
            });
        }
        return this.cancelButton;
    }

    public JButton getAbortButton() {
        if (this.abortButton == null) {
            this.abortButton = new JButton("Abort");
            this.abortButton.setMnemonic('a');
            this.abortButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StandardDialog.this.abort();
                }
            });
        }
        return this.abortButton;
    }

    public final int getResult() {
        return this.result;
    }

    protected final void setResult(int n) {
        this.result = n;
    }

    protected boolean handleKey(KeyEvent keyEvent) {
        return false;
    }

    private final boolean hasValidParent() {
        boolean bl;
        Window window = (Window)this.getParent();
        boolean bl2 = bl = window != null && window.isVisible();
        if (window instanceof Frame) {
            return bl && (((Frame)window).getState() & 1) == 0;
        }
        return bl;
    }

    public final void open() {
        if (this.buttonList.size() > 0) {
            this.resizeButtons();
            this.buttons.add(Box.createHorizontalStrut(20), "Center");
        }
        this.pack();
        this.center();
        this.setVisible(true);
    }

    private void resizeButtons() {
        int n = 0;
        Iterator iterator = this.buttonList.iterator();
        while (iterator.hasNext()) {
            int n2 = ((JButton)iterator.next()).getPreferredSize().height;
            if (n2 <= n) continue;
            n = n2;
        }
        iterator = this.buttonList.iterator();
        while (iterator.hasNext()) {
            JButton jButton = (JButton)iterator.next();
            Dimension dimension = jButton.getPreferredSize();
            dimension.height = n;
            jButton.setPreferredSize(dimension);
        }
    }

    public final void setDefaultBorder() {
        this.main.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(10, 10, 10, 10)));
    }

    public void setDisposeOnClose(boolean bl) {
        this.disposeOnClose = bl;
    }

    protected final void setFirstFocusComponent(JComponent jComponent) {
        this.firstFocusComponent = jComponent;
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }
}

