/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util;

import java.util.ArrayList;
import jdomain.util.LogListener;

public final class Log {
    private static ArrayList listeners = new ArrayList();
    private static boolean on = true;
    public static final boolean DEBUG = System.getProperty("log.debug") != null;
    private static String debugPrefix = ":: ";
    private static boolean exitOnException = false;

    private Log() {
    }

    public static void turnOff() {
        on = false;
    }

    public static void turnOn() {
        on = true;
    }

    public static void addLogListener(LogListener logListener) {
        listeners.add(logListener);
    }

    public static void removeListener(LogListener logListener) {
        listeners.remove(logListener);
    }

    private static int getListenerCount() {
        if (!on) {
            return 0;
        }
        return listeners.size();
    }

    public static void close() {
        int n = Log.getListenerCount();
        for (int i = 0; i < n; ++i) {
            LogListener logListener = (LogListener)listeners.get(i);
            logListener.close();
        }
    }

    public static void debug(String string) {
        if (!DEBUG) {
            return;
        }
        int n = Log.getListenerCount();
        for (int i = 0; i < n; ++i) {
            LogListener logListener = (LogListener)listeners.get(i);
            logListener.debug(debugPrefix + string);
        }
    }

    public static void info(String string) {
        int n = Log.getListenerCount();
        for (int i = 0; i < n; ++i) {
            LogListener logListener = (LogListener)listeners.get(i);
            logListener.info(string);
        }
    }

    public static void warning(String string) {
        int n = Log.getListenerCount();
        for (int i = 0; i < n; ++i) {
            LogListener logListener = (LogListener)listeners.get(i);
            logListener.warning(string);
        }
    }

    public static void warning(String string, Object object) {
        int n = Log.getListenerCount();
        for (int i = 0; i < n; ++i) {
            LogListener logListener = (LogListener)listeners.get(i);
            logListener.warning(string, object);
        }
    }

    public static void error(String string) {
        int n = Log.getListenerCount();
        for (int i = 0; i < n; ++i) {
            LogListener logListener = (LogListener)listeners.get(i);
            logListener.error(string);
        }
    }

    public static void exception(Throwable throwable) {
        int n = Log.getListenerCount();
        for (int i = 0; i < n; ++i) {
            LogListener logListener = (LogListener)listeners.get(i);
            logListener.exception(throwable);
        }
        if (exitOnException) {
            System.exit(1);
        } else if (on) {
            throwable.printStackTrace(System.err);
        }
    }

    public static void setDebugPrefix(String string) {
        debugPrefix = string;
    }

    public static void setExitOnException(boolean bl) {
        exitOnException = bl;
    }
}

