/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import jdomain.jdraw.gui.FloatingClip;
import jdomain.jdraw.gui.FramePanel;
import jdomain.jdraw.gui.InfoClip;
import jdomain.jdraw.gui.MainFrame;
import jdomain.jdraw.gui.Tool;
import jdomain.util.Assert;

public final class MouseHandler
implements MouseMotionListener,
MouseListener {
    public static final MouseHandler INSTANCE = new MouseHandler();
    private FramePanel framePanel = null;
    private final TreeSet layerKeys = new TreeSet(new LayoutComparator());
    private final HashMap clipMap = new HashMap();

    private MouseHandler() {
    }

    public void addClip(FloatingClip floatingClip) {
        Assert.isFalse(this.layerKeys.contains(floatingClip.getLayer()), "gui: multiple clips for layer " + String.valueOf(floatingClip.getLayer()));
        this.layerKeys.add(floatingClip.getLayer());
        this.clipMap.put(floatingClip.getLayer(), floatingClip);
        if (MainFrame.INSTANCE != null) {
            Tool.getCurrentFramePanel().addClip(floatingClip);
        }
    }

    private void addClips() {
        Iterator iterator = this.layerKeys.iterator();
        FramePanel framePanel = Tool.getCurrentFramePanel();
        while (iterator.hasNext()) {
            framePanel.addClip(this.getClip(iterator.next()));
        }
    }

    private void hideClips() {
        Iterator iterator = this.layerKeys.iterator();
        while (iterator.hasNext()) {
            this.framePanel.removeClip(this.getClip(iterator.next()));
        }
    }

    public void frameChanged() {
        if (this.framePanel != null) {
            this.framePanel.getDrawPanel().removeMouseListener(this);
            this.framePanel.getDrawPanel().removeMouseMotionListener(this);
            this.hideClips();
        }
        this.framePanel = Tool.getCurrentFramePanel();
        this.addClips();
        this.framePanel.getDrawPanel().addMouseListener(this);
        this.framePanel.getDrawPanel().addMouseMotionListener(this);
        InfoClip.INSTANCE.repeat();
        Tool.getCurrentFramePanel().revalidateFrame();
    }

    public void deleteClip(FloatingClip floatingClip) {
        Assert.isTrue(this.layerKeys.contains(floatingClip.getLayer()), "gui: floating clip for layer " + String.valueOf(floatingClip.getLayer()) + "not found");
        this.layerKeys.remove(floatingClip.getLayer());
        this.clipMap.remove(floatingClip.getLayer());
        Tool.getCurrentFramePanel().getLayeredPane().remove(floatingClip);
    }

    private FloatingClip getClip(Object object) {
        return (FloatingClip)this.clipMap.get(object);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        InfoClip.INSTANCE.mouseDragged(mouseEvent);
        Iterator iterator = this.layerKeys.iterator();
        while (iterator.hasNext() && !mouseEvent.isConsumed()) {
            FloatingClip floatingClip = this.getClip(iterator.next());
            floatingClip.mouseDragged(mouseEvent);
        }
        if (!mouseEvent.isConsumed()) {
            Tool.getCurrentTool().mouseDragged(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        InfoClip.INSTANCE.mouseMoved(mouseEvent);
        Iterator iterator = this.layerKeys.iterator();
        Tool.getCurrentTool().mouseMoved(mouseEvent);
        while (iterator.hasNext() && !mouseEvent.isConsumed()) {
            FloatingClip floatingClip = this.getClip(iterator.next());
            floatingClip.mouseMoved(mouseEvent);
        }
        if (!mouseEvent.isConsumed()) {
            Tool.getCurrentTool().mouseMoved(mouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        InfoClip.INSTANCE.mouseClicked(mouseEvent);
        Iterator iterator = this.layerKeys.iterator();
        while (iterator.hasNext()) {
            FloatingClip floatingClip = this.getClip(iterator.next());
            floatingClip.mouseClicked(mouseEvent);
        }
        if (!mouseEvent.isConsumed()) {
            Tool.getCurrentTool().mouseClicked(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        InfoClip.INSTANCE.mouseEntered(mouseEvent);
        Iterator iterator = this.layerKeys.iterator();
        while (iterator.hasNext()) {
            FloatingClip floatingClip = this.getClip(iterator.next());
            floatingClip.mouseEntered(mouseEvent);
        }
        if (!mouseEvent.isConsumed()) {
            Tool.getCurrentTool().mouseEntered(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        InfoClip.INSTANCE.mouseExited(mouseEvent);
        Iterator iterator = this.layerKeys.iterator();
        while (iterator.hasNext()) {
            FloatingClip floatingClip = this.getClip(iterator.next());
            floatingClip.mouseExited(mouseEvent);
        }
        if (!mouseEvent.isConsumed()) {
            Tool.getCurrentTool().mouseExited(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        InfoClip.INSTANCE.mousePressed(mouseEvent);
        Iterator iterator = this.layerKeys.iterator();
        while (iterator.hasNext()) {
            FloatingClip floatingClip = this.getClip(iterator.next());
            floatingClip.mousePressed(mouseEvent);
        }
        if (!mouseEvent.isConsumed()) {
            Tool.getCurrentTool().mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        InfoClip.INSTANCE.mouseReleased(mouseEvent);
        Iterator iterator = this.layerKeys.iterator();
        while (iterator.hasNext()) {
            FloatingClip floatingClip = this.getClip(iterator.next());
            floatingClip.mouseReleased(mouseEvent);
        }
        if (!mouseEvent.isConsumed()) {
            Tool.getCurrentTool().mouseReleased(mouseEvent);
        }
    }

    private final class LayoutComparator
    implements Comparator {
        private LayoutComparator() {
        }

        public int compare(Object object, Object object2) {
            Integer n = (Integer)object;
            Integer n2 = (Integer)object2;
            return -n.compareTo(n2);
        }
    }
}

