/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import jdomain.jdraw.action.DrawAction;
import jdomain.jdraw.data.Clip;
import jdomain.jdraw.gui.DrawLayers;
import jdomain.jdraw.gui.DrawPanel;
import jdomain.jdraw.gui.FloatingClip;
import jdomain.jdraw.gui.GridListener;
import jdomain.jdraw.gui.MainFrame;
import jdomain.jdraw.gui.RectangularSelectionTool;
import jdomain.jdraw.gui.Tool;
import jdomain.jdraw.gui.undo.DrawClip;
import jdomain.jdraw.gui.undo.UndoManager;
import jdomain.util.Assert;
import jdomain.util.Util;

public final class ClipPanel
extends FloatingClip
implements GridListener {
    private static final long serialVersionUID = 1L;
    private static final int CHANGE_NORTH = 1;
    private static final int CHANGE_WEST = 2;
    private static final int CHANGE_SOUTH = 3;
    private static final int CHANGE_EAST = 4;
    private static final int MOVE = 5;
    protected static final int TOLERANCE = 2;
    private int action = 0;
    private final boolean resizable;
    private int oldGrid;
    private final DrawPanel drawPanel;
    private boolean mousePressed = false;
    private Point start;
    private Rectangle oldRect = null;
    static /* synthetic */ Class class$jdomain$jdraw$action$CropAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$FlipClipHorizontallyAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$FlipClipVerticallyAction;
    static /* synthetic */ Class class$jdomain$jdraw$action$RotateClipAction;

    public ClipPanel(boolean bl) {
        super(DrawLayers.CLIP_TOOL_LAYER);
        this.resizable = bl;
        this.setLayout(new BorderLayout(0, 0));
        this.drawPanel = new DrawPanel();
        this.add((Component)this.drawPanel, "Center");
    }

    public String getName() {
        return "Clip";
    }

    public final Dimension getPreferredSize() {
        return this.drawPanel.getPreferredSize();
    }

    protected void activate() {
        super.activate();
        if (this.isActive()) {
            DrawAction.getAction(class$jdomain$jdraw$action$CropAction == null ? (class$jdomain$jdraw$action$CropAction = ClipPanel.class$("jdomain.jdraw.action.CropAction")) : class$jdomain$jdraw$action$CropAction).setEnabled(true);
            DrawAction.getAction(class$jdomain$jdraw$action$FlipClipHorizontallyAction == null ? (class$jdomain$jdraw$action$FlipClipHorizontallyAction = ClipPanel.class$("jdomain.jdraw.action.FlipClipHorizontallyAction")) : class$jdomain$jdraw$action$FlipClipHorizontallyAction).setEnabled(true);
            DrawAction.getAction(class$jdomain$jdraw$action$FlipClipVerticallyAction == null ? (class$jdomain$jdraw$action$FlipClipVerticallyAction = ClipPanel.class$("jdomain.jdraw.action.FlipClipVerticallyAction")) : class$jdomain$jdraw$action$FlipClipVerticallyAction).setEnabled(true);
            DrawAction.getAction(class$jdomain$jdraw$action$RotateClipAction == null ? (class$jdomain$jdraw$action$RotateClipAction = ClipPanel.class$("jdomain.jdraw.action.RotateClipAction")) : class$jdomain$jdraw$action$RotateClipAction).setEnabled(true);
        }
    }

    protected void deactivate() {
        super.deactivate();
        if (!this.isActive()) {
            DrawAction.getAction(class$jdomain$jdraw$action$CropAction == null ? (class$jdomain$jdraw$action$CropAction = ClipPanel.class$("jdomain.jdraw.action.CropAction")) : class$jdomain$jdraw$action$CropAction).setEnabled(false);
            DrawAction.getAction(class$jdomain$jdraw$action$FlipClipHorizontallyAction == null ? (class$jdomain$jdraw$action$FlipClipHorizontallyAction = ClipPanel.class$("jdomain.jdraw.action.FlipClipHorizontallyAction")) : class$jdomain$jdraw$action$FlipClipHorizontallyAction).setEnabled(false);
            DrawAction.getAction(class$jdomain$jdraw$action$FlipClipVerticallyAction == null ? (class$jdomain$jdraw$action$FlipClipVerticallyAction = ClipPanel.class$("jdomain.jdraw.action.FlipClipVerticallyAction")) : class$jdomain$jdraw$action$FlipClipVerticallyAction).setEnabled(false);
            DrawAction.getAction(class$jdomain$jdraw$action$RotateClipAction == null ? (class$jdomain$jdraw$action$RotateClipAction = ClipPanel.class$("jdomain.jdraw.action.RotateClipAction")) : class$jdomain$jdraw$action$RotateClipAction).setEnabled(false);
        }
    }

    public void rotate() {
        Clip clip = this.drawPanel.getClip();
        clip.rotate();
        Point point = this.getLocation();
        this.defineClip(point.x, point.y, clip.getWidth() * Tool.getGrid(), clip.getHeight() * Tool.getGrid());
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public void flipHorizontally() {
        this.drawPanel.getClip().flipHorizontally();
        this.repaint();
    }

    public void flipVertically() {
        this.drawPanel.getClip().flipVertically();
        this.repaint();
    }

    public void gridChanged(int n, int n2) {
        if (this.isActive()) {
            Rectangle rectangle = this.getBounds();
            int n3 = rectangle.x / this.oldGrid;
            int n4 = rectangle.y / this.oldGrid;
            int n5 = rectangle.width / this.oldGrid;
            int n6 = rectangle.height / this.oldGrid;
            rectangle = Tool.getDrawBounds(n3, n4, n5, n6);
            this.oldGrid = Tool.getGrid();
            this.setBounds(rectangle);
        }
    }

    private boolean inClip(MouseEvent mouseEvent) {
        if (Tool.getRealPixel(mouseEvent) == null) {
            return false;
        }
        Rectangle rectangle = this.getBounds();
        rectangle.x -= 2;
        rectangle.y -= 2;
        rectangle.width += 4;
        rectangle.height += 4;
        return rectangle.contains(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isActive()) {
            if (this.inClip(mouseEvent) && mouseEvent.getClickCount() == 2) {
                Rectangle rectangle = this.getBounds();
                Point point = ClipPanel.toFramePoint(rectangle.x, rectangle.y);
                DrawClip drawClip = new DrawClip(point.x, point.y, this.drawPanel.getClip());
                if (drawClip.isValid()) {
                    UndoManager.INSTANCE.addUndoable(drawClip);
                    drawClip.redo();
                }
            }
            mouseEvent.consume();
        }
    }

    private void paintRubberBand() {
        this.paintRubberBand(this.oldRect);
    }

    private void paintRubberBand(Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)Tool.getDrawPanel().getGraphics();
        Rectangle rectangle2 = Tool.getDrawBounds(rectangle);
        graphics2D.setXORMode(Color.white);
        graphics2D.setColor(Color.darkGray);
        graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        graphics2D.setPaintMode();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isActive() || !this.mousePressed) {
            return;
        }
        mouseEvent.consume();
        if (this.action == 5) {
            this.moveClip(mouseEvent);
        } else if (this.resizable) {
            if (this.oldRect == null) {
                this.oldRect = Tool.getRealBounds(this.getBounds());
                this.paintRubberBand();
            }
            switch (this.action) {
                case 1: {
                    this.changeNorth(mouseEvent);
                    break;
                }
                case 2: {
                    this.changeWest(mouseEvent);
                    break;
                }
                case 3: {
                    this.changeSouth(mouseEvent);
                    break;
                }
                case 4: {
                    this.changeEast(mouseEvent);
                    break;
                }
                default: {
                    Assert.fail("Cannot handle action " + this.action);
                }
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.isActive()) {
            if (!this.mousePressed) {
                MainFrame.INSTANCE.setCursor(Cursor.getPredefinedCursor(0));
            }
            mouseEvent.consume();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.isActive()) {
            mouseEvent.consume();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Rectangle rectangle = this.getBounds();
            int n3 = rectangle.x;
            int n4 = rectangle.x + rectangle.width - 1;
            int n5 = rectangle.y;
            int n6 = rectangle.y + rectangle.height - 1;
            this.action = -1;
            if (this.resizable && this.inClip(mouseEvent)) {
                if (Util.isIn(n, n3 - 2, n3) && Util.isIn(n2, n5, n6)) {
                    MainFrame.INSTANCE.setCursor(Cursor.getPredefinedCursor(10));
                    this.action = 2;
                } else if (Util.isIn(n, n4, n4 + 2)) {
                    MainFrame.INSTANCE.setCursor(Cursor.getPredefinedCursor(11));
                    this.action = 4;
                } else if (Util.isIn(n2, n5 - 2, n5) && Util.isIn(n, n3, n4)) {
                    MainFrame.INSTANCE.setCursor(Cursor.getPredefinedCursor(8));
                    this.action = 1;
                } else if (Util.isIn(n2, n6, n6 + 2) && Util.isIn(n, n3, n4)) {
                    MainFrame.INSTANCE.setCursor(Cursor.getPredefinedCursor(9));
                    this.action = 3;
                }
            }
            if (this.action == -1) {
                if (this.inClip(mouseEvent)) {
                    MainFrame.INSTANCE.setCursor(Cursor.getPredefinedCursor(13));
                    this.action = 5;
                } else {
                    MainFrame.INSTANCE.setCursor(Cursor.getPredefinedCursor(0));
                    this.action = 0;
                }
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isActive() && this.inClip(mouseEvent)) {
            this.start = Tool.getRealPixel(mouseEvent);
            this.mousePressed = true;
            mouseEvent.consume();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mousePressed) {
            mouseEvent.consume();
            this.mousePressed = false;
            MainFrame.INSTANCE.setCursor(Cursor.getPredefinedCursor(0));
            if (this.oldRect != null) {
                this.paintRubberBand();
                if (RectangularSelectionTool.isValidSelection(this.oldRect)) {
                    Clip clip = Tool.getCurrentFrame().createClip(this.oldRect.x, this.oldRect.y, this.oldRect.width, this.oldRect.height);
                    this.setClip(this.oldRect.x, this.oldRect.y, clip);
                }
                this.oldRect = null;
            }
        }
    }

    private void moveClip(MouseEvent mouseEvent) {
        Point point = Tool.getRealPixel(mouseEvent);
        if (point != null && !point.equals(this.start)) {
            int n = Tool.getGrid();
            int n2 = (point.x - this.start.x) * n;
            int n3 = (point.y - this.start.y) * n;
            Rectangle rectangle = this.getBounds();
            rectangle.x += n2;
            rectangle.y += n3;
            this.setBounds(rectangle);
            this.start = point;
        }
    }

    private void changeNorth(MouseEvent mouseEvent) {
        Point point = Tool.getRealPixel(mouseEvent);
        if (point != null && point.y != this.oldRect.y) {
            this.paintRubberBand();
            Rectangle rectangle = Tool.getRealBounds(this.getBounds());
            int n = rectangle.height + (rectangle.y - point.y);
            this.oldRect = new Rectangle(rectangle.x, point.y, rectangle.width, n);
            this.paintRubberBand();
        }
    }

    private void changeSouth(MouseEvent mouseEvent) {
        Point point = Tool.getRealPixel(mouseEvent);
        if (point != null && point.y != this.oldRect.y + this.oldRect.height - 1) {
            this.paintRubberBand();
            Rectangle rectangle = Tool.getRealBounds(this.getBounds());
            int n = point.y - rectangle.y + 1;
            this.oldRect = new Rectangle(rectangle.x, rectangle.y, rectangle.width, n);
            this.paintRubberBand();
        }
    }

    private void changeWest(MouseEvent mouseEvent) {
        Point point = Tool.getRealPixel(mouseEvent);
        if (point != null && point.x != this.oldRect.x) {
            this.paintRubberBand();
            Rectangle rectangle = Tool.getRealBounds(this.getBounds());
            int n = rectangle.width + (rectangle.x - point.x);
            this.oldRect = new Rectangle(point.x, rectangle.y, n, rectangle.height);
            this.paintRubberBand();
        }
    }

    private void changeEast(MouseEvent mouseEvent) {
        Point point = Tool.getRealPixel(mouseEvent);
        if (point != null && point.x != this.oldRect.x + this.oldRect.width - 1) {
            this.paintRubberBand();
            Rectangle rectangle = Tool.getRealBounds(this.getBounds());
            int n = point.x - rectangle.x + 1;
            this.oldRect = new Rectangle(rectangle.x, rectangle.y, n, rectangle.height);
            this.paintRubberBand();
        }
    }

    public void paint(Graphics graphics) {
        if (this.isActive()) {
            super.paint(graphics);
            Dimension dimension = this.getSize();
            graphics.setColor(Color.red);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(Color.white);
            graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
            graphics.setColor(Color.black);
            graphics.drawRect(2, 2, dimension.width - 5, dimension.height - 5);
        }
    }

    protected void setClip(int n, int n2, Clip clip) {
        this.drawPanel.setClip(clip);
        Rectangle rectangle = Tool.getDrawBounds(n, n2, clip.getWidth(), clip.getHeight());
        this.defineClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.oldGrid = Tool.getGrid();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

