/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.data;

import jdomain.jdraw.data.Clip;
import jdomain.jdraw.data.DataChangeListener;
import jdomain.jdraw.data.DataObject;
import jdomain.jdraw.data.FrameSettings;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.data.event.ChangeEvent;
import jdomain.util.Assert;
import jdomain.util.Log;

public final class Frame
extends Clip
implements DataChangeListener {
    private static final long serialVersionUID = 0L;
    private final FrameSettings settings = new FrameSettings();
    private final Picture picture;
    private Palette palette = null;

    public Frame(Picture picture) {
        super(picture.getWidth(), picture.getHeight(), picture.getPictureBackground());
        this.picture = picture;
        this.settings.setIconWidth(this.getWidth());
        this.settings.setIconHeight(this.getHeight());
    }

    protected void crop(int n, int n2, int n3, int n4) {
        int[][] nArray = new int[n4][n3];
        for (int i = n2; i < n2 + n4; ++i) {
            System.arraycopy(this.data[i], n, nArray[i - n2], 0, n3);
        }
        this.data = nArray;
        this.settings.adjust(n3, n4);
    }

    public Frame copy(Picture picture) {
        return this.copy(picture, false);
    }

    public Clip createClip(int n, int n2, int n3, int n4) {
        Clip clip = new Clip(n3, n4, this.picture.getPictureBackground());
        clip.transColour = this.transColour;
        for (int i = n2; i < n2 + n4; ++i) {
            System.arraycopy(this.data[i], n, clip.data[i - n2], 0, n3);
        }
        return clip;
    }

    protected void attach() {
        this.getPalette().addDataChangeListener(this);
    }

    protected void detach() {
        this.getPalette().removeDataChangeListener(this);
    }

    public Frame copy(Picture picture, boolean bl) {
        Frame frame = new Frame(picture);
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(this.data[i], 0, frame.data[i], 0, n);
        }
        if (!bl) {
            frame.settings.setFrom(this.settings);
            frame.setPalette(this.palette, this.transColour);
        }
        return frame;
    }

    public void toggleLocalPalette() {
        if (this.getPalette().isGlobalPalette()) {
            this.setPalette(this.getPalette().copy(), this.transColour);
        } else {
            this.setPalette(null, this.picture.getGlobalTransparent());
        }
    }

    public void setPalette(Palette palette) {
        this.setPalette(palette, this.transColour);
    }

    public void setPalette(Palette palette, int n) {
        int n2;
        int n3 = 0;
        int n4 = -1;
        Palette palette2 = this.getPalette();
        if (palette2 != null) {
            this.detach();
            n3 = palette2.size();
            n2 = palette == null ? this.picture.getPalette().size() : palette.size();
            n4 = n3 - n2;
        }
        this.palette = palette;
        this.setTransparentColour(n);
        this.attach();
        if (n4 > 0) {
            for (n2 = n4; n2 < n3; ++n2) {
                this.replaceColour(n2, 0);
            }
            if (Log.DEBUG) {
                Log.debug("replaced " + n4 + " colours with #0");
            }
        }
        this.notifyDataListeners(new ChangeEvent(this, 11));
    }

    public void enter() {
    }

    public void leave() {
    }

    public FrameSettings getSettings() {
        return this.settings;
    }

    protected void replaceColour(int n, int n2) {
        this.replaceColour(this, this, n, n2);
    }

    private void replaceColour(Frame frame, Frame frame2, int n, int n2) {
        int n3 = this.getHeight();
        int n4 = this.getWidth();
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n5 = frame.getPixel(j, i);
                if (n5 != n) continue;
                bl = true;
                frame2.setPixelQuiet(j, i, n2);
            }
        }
        if (bl) {
            this.notifyDataListeners(new ChangeEvent(this, 0));
        }
    }

    protected void replaceColours(int[] nArray) {
        int n = this.getHeight();
        int n2 = this.getWidth();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.setPixelQuiet(j, i, nArray[this.getPixel(j, i)]);
            }
        }
        if (this.transColour != -1) {
            this.setTransparentColour(nArray[this.transColour]);
        }
        this.notifyDataListeners(new ChangeEvent(this, 0));
    }

    public void addIndex(int n) {
        int n2 = this.getHeight();
        int n3 = this.getWidth();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                this.setPixelQuiet(j, i, this.getPixel(j, i) + n);
            }
        }
    }

    protected void reindexFrom(int n) {
        int n2 = this.getHeight();
        int n3 = this.getWidth();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4 = this.getPixel(j, i);
                if (n4 <= n) continue;
                bl = true;
                this.setPixelQuiet(j, i, n4 - 1);
            }
        }
        if (bl) {
            this.notifyDataListeners(new ChangeEvent(this, 10));
        }
    }

    protected void swapColours(int n, int n2) {
        Frame frame = this.copy(this.picture, true);
        this.replaceColour(this, this, n, n2);
        this.replaceColour(frame, this, n2, n);
    }

    public boolean compress() {
        return this.getPalette().compress(new Frame[]{this});
    }

    public Palette getPalette() {
        if (this.palette == null) {
            return this.picture.getPalette();
        }
        return this.palette;
    }

    protected int[][] getData() {
        return this.data;
    }

    public void setTransparentColour(int n) {
        if (this.transColour != n) {
            int n2 = this.transColour;
            this.transColour = n;
            this.getPalette().updateTransparent(n2, this.transColour);
            this.notifyDataListeners(new ChangeEvent((DataObject)this, 12, n2, this.transColour));
        }
    }

    public final MinMax getDimensions() {
        MinMax minMax = new MinMax();
        int n = this.getHeight();
        int n2 = this.getWidth();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n5 = this.getPixel(j, i);
                if (n5 == this.transColour) continue;
                if (j < minMax.minX) {
                    minMax.minX = j;
                }
                if (i < minMax.minY) {
                    minMax.minY = i;
                }
                if (j > n3) {
                    n3 = j;
                }
                if (i <= n4) continue;
                n4 = i;
            }
        }
        if (minMax.minX == Integer.MAX_VALUE) {
            minMax.minX = 0;
        }
        if (minMax.minY == Integer.MAX_VALUE) {
            minMax.minY = 0;
        }
        minMax.width = n3 - minMax.minX + 1;
        minMax.height = n4 - minMax.minY + 1;
        return minMax;
    }

    protected void setData(int[][] nArray) {
        this.data = nArray;
        this.settings.setIconWidth(this.getWidth());
        this.settings.setIconHeight(this.getHeight());
        this.notifyDataListeners(new ChangeEvent(this, 0));
    }

    public void dataChanged(ChangeEvent changeEvent) {
        switch (changeEvent.changeType) {
            case 21: {
                this.notifyDataListeners(new ChangeEvent(this, 10));
                break;
            }
            case 22: 
            case 37: 
            case 38: {
                break;
            }
            case 20: {
                this.notifyDataListeners(new ChangeEvent(this, 11));
                break;
            }
            default: {
                Assert.fail("cannot handle " + changeEvent.toString());
            }
        }
    }

    public static final class MinMax {
        public int minX = Integer.MAX_VALUE;
        public int minY = Integer.MAX_VALUE;
        public int width = 0;
        public int height = 0;

        public String toString() {
            return "minX: " + this.minX + ", minY: " + this.minY + ", width: " + this.width + ", height: " + this.height;
        }
    }
}

