/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import jdomain.jdraw.Main;
import jdomain.jdraw.data.ChangingData;
import jdomain.jdraw.data.ColourSettings;
import jdomain.jdraw.data.DataChangeListener;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.data.event.ChangeEvent;
import jdomain.jdraw.data.event.EventConstants;
import jdomain.util.Assert;
import jdomain.util.Log;
import jdomain.util.Util;

public abstract class DataObject
implements ChangingData,
EventConstants,
Serializable {
    private static final long serialVersionUID = 0L;
    private static int surpressGUIEvents = 0;
    private static ColourSettings backup;
    private transient ArrayList listeners = null;

    private ArrayList getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        return this.listeners;
    }

    public final void addDataChangeListener(DataChangeListener dataChangeListener) {
        if (!this.getListeners().contains(dataChangeListener)) {
            this.getListeners().add(dataChangeListener);
        }
    }

    public final boolean removeDataChangeListener(DataChangeListener dataChangeListener) {
        return this.getListeners().remove(dataChangeListener);
    }

    public void notifyDataListeners(ChangeEvent changeEvent) {
        Object object;
        if (this.getListeners().size() == 0) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Iterator iterator = this.getListeners().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof DataObject) {
                arrayList2.add(e);
                continue;
            }
            arrayList.add(e);
        }
        if (arrayList2.size() > 0) {
            object = arrayList2.iterator();
            while (object.hasNext()) {
                ((DataChangeListener)object.next()).dataChanged(changeEvent);
            }
        }
        if (!DataObject.isSurpressingGUIEvents() && arrayList.size() > 0) {
            object = new Update(arrayList, changeEvent);
            SwingUtilities.invokeLater((Runnable)object);
            if (!SwingUtilities.isEventDispatchThread()) {
                Util.delay(200L);
            }
        }
    }

    public static boolean isSurpressingGUIEvents() {
        return surpressGUIEvents > 0;
    }

    public static void surpressGUIEvents(Picture picture) {
        if (Main.isVisible(picture)) {
            if (surpressGUIEvents == 0) {
                backup = new ColourSettings(picture);
                if (Log.DEBUG) {
                    Log.debug("colour settings saved.");
                    Log.debug(backup.toString());
                }
            }
            ++surpressGUIEvents;
        }
    }

    public static void allowGUIEvents(Picture picture) {
        if (Main.isVisible(picture)) {
            if (surpressGUIEvents == 1) {
                backup.restore();
            }
            Assert.isTrue(--surpressGUIEvents >= 0, "data: internal error. supressGUIEvents = " + surpressGUIEvents);
            if (!DataObject.isSurpressingGUIEvents()) {
                DataObject.backup.picture.rebuildColourMaps();
                Main.setPicture(DataObject.backup.picture);
            }
        }
    }

    public void initPicture() {
    }

    private class Update
    implements Runnable {
        private final ArrayList list;
        private final ChangeEvent event;

        public Update(ArrayList arrayList, ChangeEvent changeEvent) {
            this.list = new ArrayList(arrayList);
            this.event = changeEvent;
        }

        public void run() {
            try {
                if (Log.DEBUG) {
                    Log.debug("-- sending " + this.event.toString());
                }
                int n = this.list.size();
                for (int i = 0; i < n; ++i) {
                    DataChangeListener dataChangeListener = (DataChangeListener)this.list.get(i);
                    dataChangeListener.dataChanged(this.event);
                }
            }
            catch (Throwable throwable) {
                Log.exception(throwable);
            }
        }
    }
}

