/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.action;

import java.awt.Component;
import java.io.ByteArrayOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import jdomain.jdraw.action.BlockingDrawAction;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.gio.GIFWriter;
import jdomain.jdraw.gui.DrawDialog;
import jdomain.jdraw.gui.MainFrame;
import jdomain.jdraw.gui.Tool;
import jdomain.util.Log;
import jdomain.util.gui.GUIUtil;

public final class ViewAnimationAction
extends BlockingDrawAction {
    private static final long serialVersionUID = 1L;
    private boolean success;
    private ByteArrayOutputStream out;

    public ViewAnimationAction() {
        super("View Animation...", "view_anim.png");
        this.setToolTipText("Displays the animated frames");
        this.setAccelerators(new KeyStroke[]{KeyStroke.getKeyStroke(new Character('V'), 2)});
    }

    public static final boolean checkGIFColours() {
        return ViewAnimationAction.checkColours(256, "In GIF images the number of colours in each palette is limited to 256. This picture uses " + String.valueOf(Tool.getPicture().getMaximalPaletteSize()) + " colours.");
    }

    public static final boolean checkColours(int n, String string) {
        Picture picture = Tool.getPicture();
        if (picture.getMaximalPaletteSize() > n) {
            if (GUIUtil.question(MainFrame.INSTANCE, "Too many colours!", string + "\n\n" + "Do you want to reduce the number of colours?", "Reduce Colours", "Cancel")) {
                picture.reduceColours(256);
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean prepareAction() {
        return ViewAnimationAction.checkGIFColours();
    }

    public void startAction() {
        this.out = new ByteArrayOutputStream();
        this.success = GIFWriter.writeGIF(Tool.getPicture(), this.out);
    }

    public void finishAction() {
        if (this.success) {
            DrawDialog drawDialog = new DrawDialog("Animation");
            ImageIcon imageIcon = new ImageIcon(this.out.toByteArray());
            JLabel jLabel = new JLabel(imageIcon);
            drawDialog.setModal(true);
            drawDialog.main.add((Component)jLabel, "Center");
            drawDialog.setUndecorated(false);
            drawDialog.setDefaultBorder();
            drawDialog.addRightButton(drawDialog.getApproveButton());
            drawDialog.getApproveButton().setText("Close");
            drawDialog.getApproveButton().setMnemonic('c');
            drawDialog.addButtonPanel();
            drawDialog.open();
            return;
        }
        Log.warning("Couldn't create animation.");
    }
}

