/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.action;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jdomain.jdraw.action.DrawAction;
import jdomain.jdraw.gui.DrawWindow;
import jdomain.jdraw.gui.MainFrame;
import jdomain.util.Log;
import jdomain.util.ResourceLoader;

public final class HelpAction
extends DrawAction {
    private static final long serialVersionUID = 1L;
    private DrawWindow dialog;

    protected HelpAction() {
        super("Help...           ", "help.png");
        this.setToolTipText("Displays help about using JDraw");
        this.setAccelerators(new KeyStroke[]{KeyStroke.getKeyStroke(new Character('H'), 2)});
    }

    protected boolean changesImage() {
        return false;
    }

    protected void _actionPerformed(ActionEvent actionEvent) {
        super._actionPerformed(actionEvent);
        if (this.dialog == null) {
            try {
                URL uRL = ResourceLoader.getResourceURL("jdomain/jdraw/help/help.html");
                this.dialog = new DrawWindow("Help", false);
                JEditorPane jEditorPane = new JEditorPane(uRL){
                    private static final long serialVersionUID = 1L;

                    public void paint(Graphics graphics) {
                        Graphics2D graphics2D = (Graphics2D)graphics;
                        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        super.paint(graphics2D);
                        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
                    }
                };
                jEditorPane.addHyperlinkListener(new Hyperactive());
                jEditorPane.setEditable(false);
                JScrollPane jScrollPane = new JScrollPane(jEditorPane);
                Dimension dimension = MainFrame.INSTANCE.getSize();
                dimension.width -= dimension.width / 3;
                dimension.height -= dimension.height / 3;
                jScrollPane.setPreferredSize(dimension);
                this.dialog.setDefaultBorder();
                this.dialog.setUndecorated(false);
                this.dialog.setResizable(true);
                this.dialog.main.add((Component)jScrollPane, "Center");
                this.dialog.addRightButton(this.dialog.getApproveButton());
                this.dialog.getApproveButton().setText("Close");
                this.dialog.getApproveButton().setMnemonic('c');
                this.dialog.addButtonPanel();
            }
            catch (IOException iOException) {
                Log.exception(iOException);
            }
        } else {
            int n = this.dialog.getExtendedState();
            if ((n & 1) != 0) {
                this.dialog.setExtendedState(--n);
            }
        }
        if (this.dialog.isVisible()) {
            return;
        }
        this.dialog.open();
    }

    private class Hyperactive
    implements HyperlinkListener {
        private Hyperactive() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                try {
                    jEditorPane.setPage(hyperlinkEvent.getURL());
                }
                catch (Throwable throwable) {
                    Log.exception(throwable);
                }
            }
        }
    }
}

