/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormatFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshPublicKeyFile {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$transport$publickey$SshPublicKeyFile == null ? (class$com$sshtools$j2ssh$transport$publickey$SshPublicKeyFile = SshPublicKeyFile.class$("com.sshtools.j2ssh.transport.publickey.SshPublicKeyFile")) : class$com$sshtools$j2ssh$transport$publickey$SshPublicKeyFile));
    private SshPublicKeyFormat format;
    private byte[] keyblob;
    private String comment;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$SshPublicKeyFile;

    protected SshPublicKeyFile(byte[] byArray, SshPublicKeyFormat sshPublicKeyFormat) {
        this.keyblob = byArray;
        this.format = sshPublicKeyFormat;
    }

    public byte[] getBytes() {
        return this.format.formatKey(this.keyblob);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public byte[] getKeyBlob() {
        return this.keyblob;
    }

    public static SshPublicKeyFile create(SshPublicKey sshPublicKey, SshPublicKeyFormat sshPublicKeyFormat) {
        SshPublicKeyFile sshPublicKeyFile = new SshPublicKeyFile(sshPublicKey.getEncoded(), sshPublicKeyFormat);
        sshPublicKeyFile.setComment(sshPublicKeyFormat.getComment());
        return sshPublicKeyFile;
    }

    public static SshPublicKeyFile parse(File file) throws InvalidSshKeyException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        return SshPublicKeyFile.parse(byArray);
    }

    public static SshPublicKeyFile parse(byte[] byArray) throws InvalidSshKeyException {
        Object object;
        log.info((Object)"Parsing public key file");
        SshPublicKeyFormat sshPublicKeyFormat = SshPublicKeyFormatFactory.newInstance(SshPublicKeyFormatFactory.getDefaultFormatType());
        boolean bl = sshPublicKeyFormat.isFormatted(byArray);
        if (!bl) {
            log.info((Object)"Public key is not in the default format, attempting parse with other supported formats");
            object = SshPublicKeyFormatFactory.getSupportedFormats().iterator();
            while (object.hasNext() && !bl) {
                String string = (String)object.next();
                log.debug((Object)("Attempting " + string));
                sshPublicKeyFormat = SshPublicKeyFormatFactory.newInstance(string);
                bl = sshPublicKeyFormat.isFormatted(byArray);
            }
        }
        if (bl) {
            object = new SshPublicKeyFile(sshPublicKeyFormat.getKeyBlob(byArray), sshPublicKeyFormat);
            ((SshPublicKeyFile)object).setComment(sshPublicKeyFormat.getComment());
            return object;
        }
        throw new InvalidSshKeyException("The key format is not a supported format");
    }

    public String getAlgorithm() {
        return ByteArrayReader.readString(this.keyblob, 0);
    }

    public void setFormat(SshPublicKeyFormat sshPublicKeyFormat) throws InvalidSshKeyException {
        if (!sshPublicKeyFormat.supportsAlgorithm(this.getAlgorithm())) {
            throw new InvalidSshKeyException("The format does not support the public key algorithm");
        }
        sshPublicKeyFormat.setComment(this.format.getComment());
        this.format = sshPublicKeyFormat;
    }

    public SshPublicKeyFormat getFormat() {
        return this.format;
    }

    public SshPublicKey toPublicKey() throws IOException {
        ByteArrayReader byteArrayReader = new ByteArrayReader(this.keyblob);
        String string = byteArrayReader.readString();
        SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
        return sshKeyPair.decodePublicKey(this.keyblob);
    }

    public String toString() {
        return new String(this.format.formatKey(this.keyblob));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

