/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.net.TransportProvider;
import com.sshtools.j2ssh.transport.AlgorithmInitializationException;
import com.sshtools.j2ssh.transport.AlgorithmNotAgreedException;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.AlgorithmOperationException;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.MessageAlreadyRegisteredException;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.SshMessageStore;
import com.sshtools.j2ssh.transport.SshMsgDebug;
import com.sshtools.j2ssh.transport.SshMsgDisconnect;
import com.sshtools.j2ssh.transport.SshMsgIgnore;
import com.sshtools.j2ssh.transport.SshMsgKexInit;
import com.sshtools.j2ssh.transport.SshMsgNewKeys;
import com.sshtools.j2ssh.transport.SshMsgUnimplemented;
import com.sshtools.j2ssh.transport.TransportProtocol;
import com.sshtools.j2ssh.transport.TransportProtocolAlgorithmSync;
import com.sshtools.j2ssh.transport.TransportProtocolEventHandler;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.TransportProtocolInputStream;
import com.sshtools.j2ssh.transport.TransportProtocolOutputStream;
import com.sshtools.j2ssh.transport.TransportProtocolState;
import com.sshtools.j2ssh.transport.kex.KeyExchangeException;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import com.sshtools.j2ssh.transport.kex.SshKeyExchangeFactory;
import com.sshtools.j2ssh.util.Hash;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TransportProtocolCommon
implements TransportProtocol,
Runnable {
    protected static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$transport$TransportProtocolCommon == null ? (class$com$sshtools$j2ssh$transport$TransportProtocolCommon = TransportProtocolCommon.class$("com.sshtools.j2ssh.transport.TransportProtocolCommon")) : class$com$sshtools$j2ssh$transport$TransportProtocolCommon));
    private static int nextThreadNo = 1;
    public static final int EOL_CRLF = 1;
    public static final int EOL_LF = 2;
    public static final String PROTOCOL_VERSION = "2.0";
    public static String SOFTWARE_VERSION_COMMENTS = "http://www.sshtools.com " + ConfigurationLoader.getVersionString("J2SSH", "j2ssh.properties");
    protected BigInteger k = null;
    private boolean[] completeOnNewKeys = new boolean[]{false};
    protected HostKeyVerification hosts;
    protected Map kexs = new HashMap();
    private boolean sendIgnore = false;
    private int threadNo;
    protected SshConnectionProperties properties;
    protected SshMessageStore messageStore = new SshMessageStore();
    protected SshMsgKexInit clientKexInit = null;
    protected SshMsgKexInit serverKexInit = null;
    protected String clientIdent = null;
    protected String serverIdent = null;
    protected TransportProtocolAlgorithmSync algorithmsIn;
    protected TransportProtocolAlgorithmSync algorithmsOut;
    protected TransportProtocolState state = new TransportProtocolState();
    private byte[] exchangeHash = null;
    protected byte[] sessionIdentifier = null;
    protected byte[] hostKey = null;
    protected byte[] signature = null;
    private Vector eventHandlers = new Vector();
    private List messageStack = new ArrayList();
    private Object kexLock = new Object();
    private Object keyLock = new Object();
    TransportProvider provider;
    private SshThread thread;
    private long kexTimeout = 3600000L;
    private long kexTransferLimit = 0x40000000L;
    private long startTime = System.currentTimeMillis();
    protected String encryptionInUse = null;
    protected String decryptionInUse = null;
    protected String incomingMacInUse = null;
    protected String outgoingMacInUse = null;
    protected String incomingCompInUse = null;
    protected String outgoingCompInUse = null;
    protected TransportProtocolInputStream sshIn;
    protected TransportProtocolOutputStream sshOut;
    private int remoteEOL = 1;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$TransportProtocolCommon;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$SshMsgDisconnect;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$SshMsgIgnore;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$SshMsgUnimplemented;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$SshMsgDebug;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$SshMsgKexInit;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$SshMsgNewKeys;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportProtocolCommon() {
        Class clazz = class$com$sshtools$j2ssh$transport$TransportProtocolCommon == null ? (class$com$sshtools$j2ssh$transport$TransportProtocolCommon = TransportProtocolCommon.class$("com.sshtools.j2ssh.transport.TransportProtocolCommon")) : class$com$sshtools$j2ssh$transport$TransportProtocolCommon;
        synchronized (clazz) {
            this.threadNo = nextThreadNo++;
        }
    }

    public int getConnectionId() {
        return this.threadNo;
    }

    public int getRemoteEOL() {
        return this.remoteEOL;
    }

    public TransportProtocolState getState() {
        return this.state;
    }

    public SshConnectionProperties getProperties() {
        return this.properties;
    }

    protected abstract void onDisconnect();

    public void disconnect(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disconnect: " + string));
        }
        try {
            this.state.setValue(5);
            this.state.setDisconnectReason(string);
            this.sendDisconnect(11, string);
        }
        catch (Exception exception) {
            log.warn((Object)"Failed to send disconnect", (Throwable)exception);
        }
    }

    public void setSendIgnore(boolean bl) {
        this.sendIgnore = bl;
    }

    public void setKexTimeout(long l) throws TransportProtocolException {
        if (l < 60L) {
            throw new TransportProtocolException("Keys can only be re-exchanged every minute or more");
        }
        this.kexTimeout = l * 1000L;
    }

    public void setKexTransferLimit(long l) throws TransportProtocolException {
        if (l < 10L) {
            throw new TransportProtocolException("Keys can only be re-exchanged after every 10k of data, or more");
        }
        this.kexTransferLimit = l * 1024L;
    }

    public long getOutgoingByteCount() {
        return this.sshOut.getNumBytesTransfered();
    }

    public long getIncomingByteCount() {
        return this.sshIn.getNumBytesTransfered();
    }

    public void addEventHandler(TransportProtocolEventHandler transportProtocolEventHandler) {
        if (transportProtocolEventHandler != null) {
            this.eventHandlers.add(transportProtocolEventHandler);
        }
    }

    public abstract void registerTransportMessages() throws MessageAlreadyRegisteredException;

    public byte[] getSessionIdentifier() {
        return (byte[])this.sessionIdentifier.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                this.state.setValue(2);
                log.info((Object)"Registering transport protocol messages with inputstream");
                this.algorithmsOut = new TransportProtocolAlgorithmSync();
                this.algorithmsIn = new TransportProtocolAlgorithmSync();
                this.sshIn = new TransportProtocolInputStream(this, this.provider.getInputStream(), this.algorithmsIn);
                this.sshOut = new TransportProtocolOutputStream(this.provider.getOutputStream(), this, this.algorithmsOut);
                this.messageStore.registerMessage(1, class$com$sshtools$j2ssh$transport$SshMsgDisconnect == null ? (class$com$sshtools$j2ssh$transport$SshMsgDisconnect = TransportProtocolCommon.class$("com.sshtools.j2ssh.transport.SshMsgDisconnect")) : class$com$sshtools$j2ssh$transport$SshMsgDisconnect);
                this.messageStore.registerMessage(2, class$com$sshtools$j2ssh$transport$SshMsgIgnore == null ? (class$com$sshtools$j2ssh$transport$SshMsgIgnore = TransportProtocolCommon.class$("com.sshtools.j2ssh.transport.SshMsgIgnore")) : class$com$sshtools$j2ssh$transport$SshMsgIgnore);
                this.messageStore.registerMessage(3, class$com$sshtools$j2ssh$transport$SshMsgUnimplemented == null ? (class$com$sshtools$j2ssh$transport$SshMsgUnimplemented = TransportProtocolCommon.class$("com.sshtools.j2ssh.transport.SshMsgUnimplemented")) : class$com$sshtools$j2ssh$transport$SshMsgUnimplemented);
                this.messageStore.registerMessage(4, class$com$sshtools$j2ssh$transport$SshMsgDebug == null ? (class$com$sshtools$j2ssh$transport$SshMsgDebug = TransportProtocolCommon.class$("com.sshtools.j2ssh.transport.SshMsgDebug")) : class$com$sshtools$j2ssh$transport$SshMsgDebug);
                this.messageStore.registerMessage(20, class$com$sshtools$j2ssh$transport$SshMsgKexInit == null ? (class$com$sshtools$j2ssh$transport$SshMsgKexInit = TransportProtocolCommon.class$("com.sshtools.j2ssh.transport.SshMsgKexInit")) : class$com$sshtools$j2ssh$transport$SshMsgKexInit);
                this.messageStore.registerMessage(21, class$com$sshtools$j2ssh$transport$SshMsgNewKeys == null ? (class$com$sshtools$j2ssh$transport$SshMsgNewKeys = TransportProtocolCommon.class$("com.sshtools.j2ssh.transport.SshMsgNewKeys")) : class$com$sshtools$j2ssh$transport$SshMsgNewKeys);
                this.registerTransportMessages();
                List list = SshKeyExchangeFactory.getSupportedKeyExchanges();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    SshKeyExchange sshKeyExchange = SshKeyExchangeFactory.newInstance(string);
                    sshKeyExchange.init(this);
                    this.kexs.put(string, sshKeyExchange);
                }
                this.setLocalIdent();
                this.negotiateVersion();
                this.startBinaryPacketProtocol();
            }
            catch (Throwable throwable) {
                if (throwable instanceof IOException) {
                    this.state.setLastError((IOException)throwable);
                }
                if (this.state.getValue() != 5) {
                    log.error((Object)"The Transport Protocol thread failed", throwable);
                    this.stop();
                }
                Object var6_7 = null;
                this.thread = null;
            }
            Object var6_6 = null;
            this.thread = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.thread = null;
            throw throwable;
        }
        log.debug((Object)"The Transport Protocol has been stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendMessage(SshMessage sshMessage, Object object) throws IOException {
        if (log.isDebugEnabled()) {
            log.info((Object)("Sending " + sshMessage.getMessageName()));
        }
        int n = this.state.getValue();
        if (object instanceof SshKeyExchange || object instanceof TransportProtocolCommon || n == 4) {
            this.sshOut.sendMessage(sshMessage);
            if (n == 4 && this.sendIgnore) {
                byte[] byArray = new byte[1];
                ConfigurationLoader.getRND().nextBytes(byArray);
                byte[] byArray2 = new byte[(byArray[0] & 0xFF) + 1];
                ConfigurationLoader.getRND().nextBytes(byArray2);
                SshMsgIgnore sshMsgIgnore = new SshMsgIgnore(new String(byArray2));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending " + sshMsgIgnore.getMessageName()));
                }
                this.sshOut.sendMessage(sshMsgIgnore);
            }
        } else if (n == 3) {
            log.debug((Object)"Adding to message queue whilst in key exchange");
            List list = this.messageStack;
            synchronized (list) {
                this.messageStack.add(sshMessage);
            }
        } else {
            throw new TransportProtocolException("The transport protocol is disconnected");
        }
    }

    protected abstract void onStartTransportProtocol() throws IOException;

    public void startTransportProtocol(TransportProvider transportProvider, SshConnectionProperties sshConnectionProperties) throws IOException {
        this.provider = transportProvider;
        this.properties = sshConnectionProperties;
        log.info((Object)"Starting transport protocol");
        this.thread = new SshThread(this, "Transport protocol", true);
        this.thread.start();
        this.onStartTransportProtocol();
    }

    public String getUnderlyingProviderDetail() {
        return this.provider.getProviderDetail();
    }

    protected abstract String getDecryptionAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getEncryptionAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getInputStreamCompAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getInputStreamMacAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract void setLocalIdent();

    public abstract String getLocalId();

    protected abstract void setLocalKexInit(SshMsgKexInit var1);

    protected abstract SshMsgKexInit getLocalKexInit();

    protected abstract String getOutputStreamCompAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getOutputStreamMacAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract void setRemoteIdent(String var1);

    public abstract String getRemoteId();

    protected abstract void setRemoteKexInit(SshMsgKexInit var1);

    protected abstract SshMsgKexInit getRemoteKexInit();

    protected abstract void performKeyExchange(SshKeyExchange var1, boolean var2, boolean var3) throws IOException, KeyExchangeException;

    protected String getKexAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedKex(), this.serverKexInit.getSupportedKex());
    }

    public boolean isConnected() {
        return this.state.getValue() == 4 || this.state.getValue() == 3;
    }

    protected void beginKeyExchange(boolean bl, boolean bl2) throws IOException, KeyExchangeException {
        log.info((Object)"Starting key exchange");
        String string = "";
        try {
            string = this.getKexAlgorithm();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Key exchange algorithm: " + string));
            }
            SshKeyExchange sshKeyExchange = (SshKeyExchange)this.kexs.get(string);
            this.performKeyExchange(sshKeyExchange, bl, bl2);
            this.exchangeHash = sshKeyExchange.getExchangeHash();
            if (this.sessionIdentifier == null) {
                this.sessionIdentifier = new byte[this.exchangeHash.length];
                System.arraycopy(this.exchangeHash, 0, this.sessionIdentifier, 0, this.sessionIdentifier.length);
                this.thread.setSessionId(this.sessionIdentifier);
            }
            this.hostKey = sshKeyExchange.getHostKey();
            this.signature = sshKeyExchange.getSignature();
            this.k = sshKeyExchange.getSecret();
            this.sendNewKeys();
            sshKeyExchange.reset();
        }
        catch (AlgorithmNotAgreedException algorithmNotAgreedException) {
            this.sendDisconnect(3, "No suitable key exchange algorithm was agreed");
            throw new KeyExchangeException("No suitable key exchange algorithm could be agreed.");
        }
    }

    protected SshMsgKexInit createLocalKexInit() throws IOException {
        return new SshMsgKexInit(this.properties);
    }

    protected void onCorruptMac() {
        log.fatal((Object)"Corrupt Mac on Input");
        this.sendDisconnect(5, "Corrupt Mac on input", new SshException("Corrupt Mac on Imput"));
    }

    protected void sendDisconnect(int n, String string) {
        SshMsgDisconnect sshMsgDisconnect = new SshMsgDisconnect(n, string, "");
        try {
            this.sendMessage(sshMsgDisconnect, this);
            this.stop();
        }
        catch (Exception exception) {
            log.warn((Object)"Failed to send disconnect", (Throwable)exception);
        }
    }

    protected void sendDisconnect(int n, String string, IOException iOException) {
        this.state.setLastError(iOException);
        this.sendDisconnect(n, string);
    }

    protected void sendKeyExchangeInit() throws IOException {
        this.setLocalKexInit(this.createLocalKexInit());
        this.sendMessage(this.getLocalKexInit(), this);
        this.state.setValue(3);
    }

    protected void sendNewKeys() throws IOException {
        SshMsgNewKeys sshMsgNewKeys = new SshMsgNewKeys();
        this.sendMessage(sshMsgNewKeys, this);
        this.algorithmsOut.lock();
        int[] nArray = new int[]{21};
        sshMsgNewKeys = (SshMsgNewKeys)this.readMessage(nArray);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received " + sshMsgNewKeys.getMessageName()));
        }
        this.completeKeyExchange();
    }

    protected abstract void setupNewKeys(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6) throws AlgorithmNotAgreedException, AlgorithmOperationException, AlgorithmNotSupportedException, AlgorithmInitializationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeKeyExchange() throws IOException {
        log.info((Object)"Completing key exchange");
        try {
            log.debug((Object)"Making keys from key exchange output");
            byte[] byArray = this.makeSshKey('C');
            byte[] byArray2 = this.makeSshKey('A');
            byte[] byArray3 = this.makeSshKey('D');
            byte[] byArray4 = this.makeSshKey('B');
            byte[] byArray5 = this.makeSshKey('E');
            byte[] byArray6 = this.makeSshKey('F');
            log.debug((Object)"Creating algorithm objects");
            this.setupNewKeys(byArray, byArray2, byArray3, byArray4, byArray5, byArray6);
            this.clientKexInit = null;
            this.serverKexInit = null;
            this.algorithmsOut.release();
            this.state.setValue(4);
            List list = this.messageStack;
            synchronized (list) {
                Iterator iterator = this.messageStack.iterator();
                log.debug((Object)"Sending queued messages");
                while (iterator.hasNext()) {
                    SshMessage sshMessage = (SshMessage)iterator.next();
                    this.sendMessage(sshMessage, this);
                }
                this.messageStack.clear();
            }
        }
        catch (AlgorithmNotAgreedException algorithmNotAgreedException) {
            this.sendDisconnect(3, "Algorithm not agreed");
            throw new TransportProtocolException("The connection was disconnected because an algorithm could not be agreed");
        }
        catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("The connection was disconnected because an algorithm class could not be loaded");
        }
        catch (AlgorithmOperationException algorithmOperationException) {
            this.sendDisconnect(3, "Algorithm operation error");
            throw new TransportProtocolException("The connection was disconnected because of an algorithm operation error");
        }
        catch (AlgorithmInitializationException algorithmInitializationException) {
            this.sendDisconnect(3, "Algorithm initialization error");
            throw new TransportProtocolException("The connection was disconnected because of an algorithm initialization error");
        }
    }

    protected List getEventHandlers() {
        return this.eventHandlers;
    }

    protected String determineAlgorithm(List list, List list2) throws AlgorithmNotAgreedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Determine Algorithm");
            log.debug((Object)("Client Algorithms: " + list.toString()));
            log.debug((Object)("Server Algorithms: " + list2.toString()));
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (!string.equals(string2)) continue;
                log.debug((Object)("Returning " + string));
                return string;
            }
        }
        throw new AlgorithmNotAgreedException("Could not agree algorithm");
    }

    protected void startBinaryPacketProtocol() throws IOException {
        this.sendKeyExchangeInit();
        while (this.state.getValue() != 5) {
            SshMessage sshMessage = this.processMessages();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received " + sshMessage.getMessageName()));
            }
            switch (sshMessage.getMessageId()) {
                case 20: {
                    this.onMsgKexInit((SshMsgKexInit)sshMessage);
                    break;
                }
                case 1: {
                    this.onMsgDisconnect((SshMsgDisconnect)sshMessage);
                    break;
                }
                case 2: {
                    this.onMsgIgnore((SshMsgIgnore)sshMessage);
                    break;
                }
                case 3: {
                    this.onMsgUnimplemented((SshMsgUnimplemented)sshMessage);
                    break;
                }
                case 4: {
                    this.onMsgDebug((SshMsgDebug)sshMessage);
                    break;
                }
                default: {
                    this.messageStore.addMessage(sshMessage);
                }
            }
        }
    }

    protected final void stop() {
        this.state.setValue(5);
        this.onDisconnect();
        Iterator iterator = this.eventHandlers.iterator();
        while (iterator.hasNext()) {
            TransportProtocolEventHandler transportProtocolEventHandler = (TransportProtocolEventHandler)iterator.next();
            transportProtocolEventHandler.onDisconnect(this);
        }
        if (this.messageStore != null) {
            this.messageStore.close();
        }
        this.messageStore = null;
        try {
            this.provider.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte[] makeSshKey(char c) throws IOException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byte[] byArray = new byte[20];
            Hash hash = new Hash("SHA");
            hash.putBigInteger(this.k);
            hash.putBytes(this.exchangeHash);
            hash.putByte((byte)c);
            hash.putBytes(this.sessionIdentifier);
            byArray = hash.doFinal();
            byteArrayWriter.write(byArray);
            hash.reset();
            hash.putBigInteger(this.k);
            hash.putBytes(this.exchangeHash);
            hash.putBytes(byArray);
            byArray = hash.doFinal();
            byteArrayWriter.write(byArray);
            return byteArrayWriter.toByteArray();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("SHA algorithm not supported");
        }
        catch (IOException iOException) {
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("Error writing key data");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void negotiateVersion() throws IOException {
        var3_1 = "";
        TransportProtocolCommon.log.info((Object)"Negotiating protocol version");
        TransportProtocolCommon.log.debug((Object)("Local identification: " + this.getLocalId()));
        var4_2 = this.getLocalId() + "\r\n";
        this.provider.getOutputStream().write(var4_2.getBytes());
        var5_3 = new StringBuffer();
        var7_4 = 255;
        ** GOTO lbl17
        {
            var5_3.append(var6_5);
            do {
                if ((var6_5 = (char)this.provider.getInputStream().read()) != '\n' && var5_3.length() < var7_4) continue block0;
                var3_1 = var5_3.toString();
                this.remoteEOL = var3_1.endsWith("\r") != false ? 1 : 2;
                TransportProtocolCommon.log.debug((Object)("EOL is guessed at " + (this.remoteEOL == 1 ? "CR+LF" : "LF")));
                var3_1 = var3_1.trim();
lbl17:
                // 2 sources

            } while (!var3_1.startsWith("SSH-") && var5_3.length() < var7_4);
        }
        var8_6 = var3_1.indexOf("-");
        var9_7 = var3_1.indexOf("-", var8_6 + 1);
        this.setRemoteIdent(var3_1.trim());
        if (TransportProtocolCommon.log.isDebugEnabled()) {
            TransportProtocolCommon.log.debug((Object)("Remote identification: " + this.getRemoteId()));
        }
        if (!(var10_8 = var3_1.substring(var8_6 + 1, var9_7)).equals("2.0") && !var10_8.equals("1.99")) {
            TransportProtocolCommon.log.fatal((Object)"The remote computer does not support protocol version 2.0");
            throw new TransportProtocolException("The protocol version of the remote computer is not supported!");
        }
        TransportProtocolCommon.log.info((Object)"Protocol negotiation complete");
    }

    private void onMsgDebug(SshMsgDebug sshMsgDebug) {
        log.debug((Object)sshMsgDebug.getMessage());
    }

    private void onMsgDisconnect(SshMsgDisconnect sshMsgDisconnect) throws IOException {
        log.info((Object)("The remote computer disconnected: " + sshMsgDisconnect.getDescription()));
        this.state.setValue(5);
        this.state.setDisconnectReason(sshMsgDisconnect.getDescription());
        this.stop();
    }

    private void onMsgIgnore(SshMsgIgnore sshMsgIgnore) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SSH_MSG_IGNORE with " + String.valueOf(sshMsgIgnore.getData().length()) + " bytes of data"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMsgKexInit(SshMsgKexInit sshMsgKexInit) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sshMsgKexInit.toString());
        }
        Object object = this.kexLock;
        synchronized (object) {
            this.setRemoteKexInit(sshMsgKexInit);
            if (this.state.getValue() != 3) {
                this.sendKeyExchangeInit();
            }
            this.encryptionInUse = this.getEncryptionAlgorithm();
            this.decryptionInUse = this.getDecryptionAlgorithm();
            this.incomingMacInUse = this.getInputStreamMacAlgorithm();
            this.outgoingMacInUse = this.getOutputStreamMacAlgorithm();
            this.incomingCompInUse = this.getInputStreamCompAlgorithm();
            this.outgoingCompInUse = this.getOutputStreamCompAlgorithm();
            boolean bl = false;
            if (sshMsgKexInit.firstPacketFollows() && sshMsgKexInit.getSupportedKex().get(0).equals(this.properties.getPrefCSMac()) && sshMsgKexInit.getSupportedPublicKeys().get(0).equals(this.properties.getPrefPublicKey())) {
                bl = true;
            }
            this.beginKeyExchange(sshMsgKexInit.firstPacketFollows(), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMsgNewKeys(SshMsgNewKeys sshMsgNewKeys) throws IOException {
        log.debug((Object)"Received New Keys");
        this.algorithmsIn.lock();
        boolean[] blArray = this.completeOnNewKeys;
        synchronized (blArray) {
            if (this.completeOnNewKeys[0]) {
                this.completeKeyExchange();
            } else {
                this.completeOnNewKeys[0] = true;
            }
        }
    }

    private void onMsgUnimplemented(SshMsgUnimplemented sshMsgUnimplemented) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("The message with sequence no " + sshMsgUnimplemented.getSequenceNo() + " was reported as unimplemented by the remote end."));
        }
    }

    public SshMessageStore getMessageStore() {
        return this.messageStore;
    }

    public SshMessage readMessage(int[] nArray) throws IOException {
        byte[] byArray = null;
        while (this.state.getValue() != 5) {
            SshMessage sshMessage;
            boolean bl = false;
            while (!bl) {
                byArray = this.sshIn.readMessage();
                bl = true;
            }
            Integer n = SshMessage.getMessageId(byArray);
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] == n) {
                    if (this.messageStore.isRegisteredMessage(n)) {
                        return this.messageStore.createMessage(byArray);
                    }
                    log.info((Object)("Unimplemented message received " + String.valueOf(n)));
                    sshMessage = new SshMsgUnimplemented(this.sshIn.getSequenceNo());
                    this.sendMessage(sshMessage, this);
                }
                ++n2;
            }
            if (this.messageStore.isRegisteredMessage(n)) {
                sshMessage = this.messageStore.createMessage(byArray);
                switch (n) {
                    case 1: {
                        this.onMsgDisconnect((SshMsgDisconnect)sshMessage);
                        break;
                    }
                    case 2: {
                        this.onMsgIgnore((SshMsgIgnore)sshMessage);
                        break;
                    }
                    case 3: {
                        this.onMsgUnimplemented((SshMsgUnimplemented)sshMessage);
                        break;
                    }
                    case 4: {
                        this.onMsgDebug((SshMsgDebug)sshMessage);
                        break;
                    }
                    default: {
                        this.messageStore.addMessage(sshMessage);
                        break;
                    }
                }
                continue;
            }
            throw new IOException("Unexpected message received");
        }
        throw new IOException("The transport protocol disconnected");
    }

    /*
     * Unable to fully structure code
     */
    protected SshMessage processMessages() throws IOException {
        var1_1 = null;
        while (this.state.getValue() != 5) {
            var4_3 = System.currentTimeMillis();
            if (var4_3 - this.startTime > this.kexTimeout || this.sshIn.getNumBytesTransfered() + this.sshOut.getNumBytesTransfered() > this.kexTransferLimit) {
                this.startTime = var4_3;
                this.sendKeyExchangeInit();
            }
            var6_4 = false;
            block3: while (!var6_4) {
                try {
                    var1_1 = this.sshIn.readMessage();
                    var6_4 = true;
                    continue;
                }
                catch (InterruptedIOException var7_6) {
                    TransportProtocolCommon.log.info((Object)"Possible timeout on transport inputstream");
                    var8_7 = this.eventHandlers.iterator();
                    ** while (var8_7.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    var9_8 = (TransportProtocolEventHandler)var8_7.next();
                    var9_8.onSocketTimeout(this);
                    continue;
lbl20:
                    // 1 sources

                }
            }
            var7_5 = SshMessage.getMessageId(var1_1);
            if (!this.messageStore.isRegisteredMessage(var7_5)) {
                TransportProtocolCommon.log.info((Object)("Unimplemented message received " + String.valueOf(var7_5)));
                var2_2 = new SshMsgUnimplemented(this.sshIn.getSequenceNo());
                this.sendMessage(var2_2, this);
                continue;
            }
            return this.messageStore.createMessage(var1_1);
        }
        throw new IOException("The transport protocol has disconnected");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

