/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.transport.MessageNotAvailableException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.SshMessageStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChannelInputStream
extends InputStream {
    private static Log log = LogFactory.getLog((Class)(class$com$sshtools$j2ssh$connection$ChannelInputStream == null ? (class$com$sshtools$j2ssh$connection$ChannelInputStream = ChannelInputStream.class$("com.sshtools.j2ssh.connection.ChannelInputStream")) : class$com$sshtools$j2ssh$connection$ChannelInputStream));
    int[] filter;
    byte[] msgdata;
    int currentPos = 0;
    private SshMessageStore messageStore;
    private Integer type = null;
    private int interrupt = 5000;
    private boolean isBlocking = false;
    private Object lock = new Object();
    private Thread blockingThread = null;
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$ChannelInputStream;

    public ChannelInputStream(SshMessageStore sshMessageStore, Integer n) {
        this.messageStore = sshMessageStore;
        this.filter = new int[1];
        this.type = n;
        this.filter[0] = n != null ? 95 : 94;
    }

    public ChannelInputStream(SshMessageStore sshMessageStore) {
        this(sshMessageStore, null);
    }

    public int available() {
        int n = 0;
        if (this.msgdata != null) {
            n = this.msgdata.length - this.currentPos;
            if (log.isDebugEnabled() && n > 0) {
                log.debug((Object)(String.valueOf(n) + " bytes of channel data available"));
            }
            int n2 = n = n >= 0 ? n : 0;
        }
        if (n == 0) {
            try {
                if (this.type != null) {
                    SshMsgChannelExtendedData sshMsgChannelExtendedData = (SshMsgChannelExtendedData)this.messageStore.peekMessage(this.filter);
                    n = sshMsgChannelExtendedData.getChannelData().length;
                } else {
                    SshMsgChannelData sshMsgChannelData = (SshMsgChannelData)this.messageStore.peekMessage(this.filter);
                    n = sshMsgChannelData.getChannelData().length;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(String.valueOf(n) + " bytes of channel data available"));
                }
            }
            catch (MessageStoreEOFException messageStoreEOFException) {
                log.debug((Object)"No bytes available since the MessageStore is EOF");
                n = -1;
            }
            catch (MessageNotAvailableException messageNotAvailableException) {
                n = 0;
            }
            catch (InterruptedException interruptedException) {
                log.info((Object)"peekMessage was interrupted, no data available!");
                n = 0;
            }
        }
        return n;
    }

    public void close() throws IOException {
        log.info((Object)"Closing ChannelInputStream");
        this.messageStore.close();
    }

    public boolean isClosed() {
        return this.messageStore.isClosed();
    }

    public void setBlockInterrupt(int n) {
        this.interrupt = n < 1000 ? 1000 : n;
    }

    public void interrupt() {
        this.messageStore.breakWaiting();
    }

    public int read() throws IOException {
        try {
            this.block();
            return this.msgdata[this.currentPos++] & 0xFF;
        }
        catch (MessageStoreEOFException messageStoreEOFException) {
            return -1;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException("The thread was interrupted whilst waiting for channel data");
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.block();
            int n3 = this.available();
            if (n3 > n2) {
                n3 = n2;
            }
            if (n3 > 0) {
                System.arraycopy(this.msgdata, this.currentPos, byArray, n, n3);
                this.currentPos += n3;
            }
            return n3;
        }
        catch (MessageStoreEOFException messageStoreEOFException) {
            return -1;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException("The thread was interrupted whilst waiting for channel data");
        }
    }

    private void block() throws MessageStoreEOFException, InterruptedException, IOException {
        if (this.msgdata == null) {
            this.collectNextMessage();
        }
        if (this.currentPos >= this.msgdata.length) {
            this.collectNextMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBlockingOperation() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isBlocking) {
                throw new IOException("Cannot read from InputStream! " + this.blockingThread == null ? "**NULL THREAD**" : this.blockingThread.getName() + " is currently performing a blocking operation");
            }
            log.debug((Object)"Starting blocking operation");
            this.blockingThread = Thread.currentThread();
            this.isBlocking = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBlockingOperation() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            log.debug((Object)"Completed blocking operation");
            this.blockingThread = null;
            this.isBlocking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void collectNextMessage() throws MessageStoreEOFException, InterruptedException, IOException {
        this.startBlockingOperation();
        try {
            if (this.type != null) {
                SshMsgChannelExtendedData sshMsgChannelExtendedData = null;
                while (sshMsgChannelExtendedData == null && (!this.isClosed() || this.messageStore.hasMessages())) {
                    try {
                        log.debug((Object)"Waiting for extended channel data");
                        sshMsgChannelExtendedData = (SshMsgChannelExtendedData)this.messageStore.getMessage(this.filter, this.interrupt);
                    }
                    catch (MessageNotAvailableException messageNotAvailableException) {
                        // empty catch block
                    }
                }
                if (sshMsgChannelExtendedData == null) throw new MessageStoreEOFException();
                this.msgdata = sshMsgChannelExtendedData.getChannelData();
                this.currentPos = 0;
            } else {
                SshMsgChannelData sshMsgChannelData = null;
                while (sshMsgChannelData == null && (!this.isClosed() || this.messageStore.hasMessages())) {
                    try {
                        log.debug((Object)"Waiting for channel data");
                        sshMsgChannelData = (SshMsgChannelData)this.messageStore.getMessage(this.filter, this.interrupt);
                    }
                    catch (MessageNotAvailableException messageNotAvailableException) {
                        // empty catch block
                    }
                }
                if (sshMsgChannelData == null) throw new MessageStoreEOFException();
                this.msgdata = sshMsgChannelData.getChannelData();
                this.currentPos = 0;
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.stopBlockingOperation();
            throw throwable;
        }
        this.stopBlockingOperation();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

