/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import com.ice.util.UserProperties;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;

public abstract class DynamicConfig {
    protected String name = null;
    protected File homeDir = null;
    protected Properties workingProps = null;

    public DynamicConfig(String name) {
        this.name = name;
        this.workingProps = new Properties();
        this.determineHomeDirectory();
    }

    public String getName() {
        return this.name;
    }

    public void saveProperties() throws IOException {
        UserProperties.saveDynamicProperties(this.name);
    }

    public void setProperty(String propName, boolean value) {
        UserProperties.setDynamicProperty(this.name, propName, value ? "true" : "false");
    }

    public void setProperty(String propName, int value) {
        UserProperties.setDynamicProperty(this.name, propName, "" + value);
    }

    public void setProperty(String propName, String value) {
        UserProperties.setDynamicProperty(this.name, propName, value);
    }

    public void removeProperty(String propName) {
        UserProperties.removeDynamicProperty(this.name, propName);
    }

    public void setStringArray(String propName, String[] strArray) {
        StringBuffer buf = new StringBuffer();
        int idx = 0;
        while (idx < strArray.length) {
            buf.append(strArray[idx]);
            if (idx < strArray.length - 1) {
                buf.append(":");
            }
            ++idx;
        }
        UserProperties.setDynamicProperty(this.name, propName, buf.toString());
    }

    public void setStringArray(String propName, Vector strArray) {
        int size = strArray.size();
        StringBuffer buf = new StringBuffer();
        int idx = 0;
        while (idx < size) {
            buf.append((String)strArray.elementAt(idx));
            if (idx < size - 1) {
                buf.append(":");
            }
            ++idx;
        }
        UserProperties.setDynamicProperty(this.name, propName, buf.toString());
    }

    public File getHomeDirectory() {
        return this.homeDir;
    }

    public Rectangle getBounds(String propName, Rectangle defBounds) {
        this.workingProps.clear();
        Rectangle result = new Rectangle();
        defBounds.x = UserProperties.getProperty(propName + ".x", defBounds.x);
        defBounds.y = UserProperties.getProperty(propName + ".y", defBounds.y);
        defBounds.width = UserProperties.getProperty(propName + ".width", defBounds.width);
        defBounds.height = UserProperties.getProperty(propName + ".height", defBounds.height);
        return defBounds;
    }

    public void saveBounds(String propName, Rectangle bounds) {
        this.saveBounds(propName, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void saveBounds(String propName, int x, int y, int w, int h) {
        this.workingProps.clear();
        this.workingProps.put(propName + ".x", "" + x);
        this.workingProps.put(propName + ".y", "" + y);
        this.workingProps.put(propName + ".width", "" + w);
        this.workingProps.put(propName + ".height", "" + h);
        UserProperties.setDynamicProperties(this.name, this.workingProps);
    }

    public void saveLocation(String propName, int x, int y) {
        this.workingProps.clear();
        this.workingProps.put(propName + ".x", "" + x);
        this.workingProps.put(propName + ".y", "" + y);
        UserProperties.setDynamicProperties(this.name, this.workingProps);
    }

    public void saveSize(String propName, int w, int h) {
        this.workingProps.clear();
        this.workingProps.put(propName + ".width", "" + w);
        this.workingProps.put(propName + ".height", "" + h);
        UserProperties.setDynamicProperties(this.name, this.workingProps);
    }

    protected boolean isPropertySet(String propName) {
        boolean result = true;
        String propValue = UserProperties.getProperty(propName, null);
        if (propValue == null) {
            result = false;
        }
        return result;
    }

    private void determineHomeDirectory() {
        String userDirName = System.getProperty("user.home", null);
        if (userDirName == null) {
            userDirName = System.getProperty("user.dir", null);
        }
        this.homeDir = userDirName == null ? new File(File.separatorChar == ':' ? ":" : ".") : new File(userDirName);
    }
}

