/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSProject;
import com.ice.cvsc.CVSProjectDef;
import com.ice.jcvsii.Config;
import com.ice.jcvsii.ResourceMgr;
import com.ice.jcvsii.WorkBenchDefinition;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class WorkBenchDetailPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    protected JLabel title;
    protected JLabel projectToke;
    protected JLabel repository;
    protected JLabel rootDirectory;
    protected JLabel localDirectory;
    protected JLabel userName;
    protected JLabel hostName;
    protected JLabel connectMethod;
    protected JPanel descPan;
    protected JTextArea descText;
    protected int descOffset = 10;

    public WorkBenchDetailPanel() {
        this.establishContents();
    }

    public void savePreferences() {
        UserPrefs prefs = Config.getPreferences();
        prefs.removePropertyChangeListener("workBench.details.title.bg", this);
        prefs.removePropertyChangeListener("workBench.details.title.font", this);
        prefs.removePropertyChangeListener("workBench.details.title.height", this);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("UNKNOWN")) {
            // empty if block
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        UserPrefs p = (UserPrefs)evt.getSource();
        if (propName.equals("workBench.details.title.bg")) {
            this.title.setBackground(p.getColor("workBench.details.title.bg", this.title.getBackground()));
        } else if (propName.equals("workBench.details.title.height")) {
            this.title.setPreferredSize(new Dimension(125, p.getInteger("workBench.details.title.height", this.title.getSize().height)));
            this.title.revalidate();
        } else if (propName.equals("workBench.details.title.font")) {
            this.title.setFont(p.getFont("workBench.details.title.font", this.title.getFont()));
            this.title.revalidate();
        }
        this.title.repaint(500L);
    }

    public void clearDefinition() {
        String titleStr = ResourceMgr.getInstance().getUIString("wb.detail.title");
        this.title.setText(titleStr);
        this.projectToke.setText(" ");
        this.repository.setText(" ");
        this.rootDirectory.setText(" ");
        this.userName.setText(" ");
        this.hostName.setText(" ");
        this.connectMethod.setText(" ");
        this.localDirectory.setText(" ");
        this.descText.setText(" ");
        this.revalidate();
        this.repaint(250L);
    }

    public void showDefinition(WorkBenchDefinition def) {
        this.projectToke.setText(def.getName());
        this.title.setText(def.getDisplayName());
        this.descText.setText(def.getDescription());
        if (def.isFolder()) {
            this.localDirectory.setText(" ");
            this.repository.setText(" ");
            this.rootDirectory.setText(" ");
            this.userName.setText(" ");
            this.hostName.setText(" ");
            this.connectMethod.setText(" ");
        } else {
            this.localDirectory.setText(def.getLocalDirectory());
            String adminPath = CVSProject.rootPathToAdminPath(def.getLocalDirectory());
            try {
                CVSProjectDef projDef = CVSProjectDef.readDef(adminPath);
                this.repository.setText(projDef.getRepository());
                this.rootDirectory.setText(projDef.getRootDirectory());
                this.userName.setText(projDef.getUserName());
                this.hostName.setText(projDef.getHostName());
                this.connectMethod.setText(projDef.getConnectMethodString());
            }
            catch (IOException ex) {
                String errMsg = ResourceMgr.getInstance().getUIString("wb.details.error.repos");
                this.localDirectory.setText(def.getLocalDirectory());
                this.repository.setText(errMsg);
                this.rootDirectory.setText(" ");
                this.userName.setText(" ");
                this.hostName.setText(" ");
                this.connectMethod.setText(" ");
            }
        }
        this.revalidate();
        this.repaint(250L);
    }

    private void establishContents() {
        UserPrefs prefs = Config.getPreferences();
        ResourceMgr rmgr = ResourceMgr.getInstance();
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(175, 100));
        this.setPreferredSize(new Dimension(325, 125));
        String titleStr = ResourceMgr.getInstance().getUIString("wb.detail.title");
        this.title = new JLabel(titleStr, 2);
        this.title.setOpaque(true);
        this.title.setForeground(Color.black);
        this.title.setPreferredSize(new Dimension(125, prefs.getInteger("workBench.details.title.height", 35)));
        this.title.setBackground(prefs.getColor("workBench.details.title.bg", new Color(232, 232, 255)));
        this.title.setFont(prefs.getFont("workBench.details.title.font", new Font("SansSerif", 1, 14)));
        this.title.setBorder(new CompoundBorder(new LineBorder(Color.black), new EmptyBorder(5, 5, 5, 5)));
        prefs.addPropertyChangeListener("workBench.details.title.bg", this);
        prefs.addPropertyChangeListener("workBench.details.title.font", this);
        prefs.addPropertyChangeListener("workBench.details.title.height", this);
        JPanel infoPan = new JPanel();
        infoPan.setLayout(new GridBagLayout());
        infoPan.setBorder(new EmptyBorder(9, 9, 9, 9));
        int row = 0;
        String lblStr = rmgr.getUIString("wb.detail.token.lbl");
        JLabel lbl = new JLabel(lblStr);
        AWTUtilities.constrain(infoPan, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
        WorkBenchDetailPanel workBenchDetailPanel = this;
        workBenchDetailPanel.getClass();
        this.projectToke = workBenchDetailPanel.new DetailLabel("  ");
        AWTUtilities.constrain(infoPan, this.projectToke, 2, 17, 1, row++, 1, 1, 1.0, 0.0, new Insets(1, 3, 3, 1));
        lblStr = rmgr.getUIString("wb.detail.repos.lbl");
        lbl = new JLabel(lblStr);
        AWTUtilities.constrain(infoPan, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
        WorkBenchDetailPanel workBenchDetailPanel2 = this;
        workBenchDetailPanel2.getClass();
        this.repository = workBenchDetailPanel2.new DetailLabel("  ");
        AWTUtilities.constrain(infoPan, this.repository, 2, 17, 1, row++, 1, 1, 1.0, 0.0, new Insets(1, 3, 3, 1));
        lblStr = rmgr.getUIString("wb.detail.rootdir.lbl");
        lbl = new JLabel(lblStr);
        AWTUtilities.constrain(infoPan, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
        WorkBenchDetailPanel workBenchDetailPanel3 = this;
        workBenchDetailPanel3.getClass();
        this.rootDirectory = workBenchDetailPanel3.new DetailLabel("  ");
        AWTUtilities.constrain(infoPan, this.rootDirectory, 2, 17, 1, row++, 1, 1, 1.0, 0.0, new Insets(1, 3, 3, 1));
        lblStr = rmgr.getUIString("wb.detail.localdir.lbl");
        lbl = new JLabel(lblStr);
        AWTUtilities.constrain(infoPan, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
        WorkBenchDetailPanel workBenchDetailPanel4 = this;
        workBenchDetailPanel4.getClass();
        this.localDirectory = workBenchDetailPanel4.new DetailLabel("  ");
        AWTUtilities.constrain(infoPan, this.localDirectory, 2, 17, 1, row++, 1, 1, 1.0, 0.0, new Insets(1, 3, 3, 1));
        lblStr = rmgr.getUIString("wb.detail.user.lbl");
        lbl = new JLabel(lblStr);
        AWTUtilities.constrain(infoPan, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
        WorkBenchDetailPanel workBenchDetailPanel5 = this;
        workBenchDetailPanel5.getClass();
        this.userName = workBenchDetailPanel5.new DetailLabel("  ");
        AWTUtilities.constrain(infoPan, this.userName, 2, 17, 1, row++, 1, 1, 1.0, 0.0, new Insets(1, 3, 3, 1));
        lblStr = rmgr.getUIString("wb.detail.host.lbl");
        lbl = new JLabel(lblStr);
        AWTUtilities.constrain(infoPan, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
        WorkBenchDetailPanel workBenchDetailPanel6 = this;
        workBenchDetailPanel6.getClass();
        this.hostName = workBenchDetailPanel6.new DetailLabel("  ");
        AWTUtilities.constrain(infoPan, this.hostName, 2, 17, 1, row++, 1, 1, 1.0, 0.0, new Insets(1, 3, 3, 1));
        lblStr = rmgr.getUIString("wb.detail.method.lbl");
        lbl = new JLabel(lblStr);
        AWTUtilities.constrain(infoPan, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
        WorkBenchDetailPanel workBenchDetailPanel7 = this;
        workBenchDetailPanel7.getClass();
        this.connectMethod = workBenchDetailPanel7.new DetailLabel("  ");
        AWTUtilities.constrain(infoPan, this.connectMethod, 2, 17, 1, row++, 1, 1, 1.0, 0.0, new Insets(1, 3, 3, 1));
        this.descText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.descText.setEnabled(false);
        this.descText.setEditable(false);
        this.descText.setDisabledTextColor(Color.black);
        this.descText.setLineWrap(true);
        this.descText.setWrapStyleWord(true);
        this.descText.setOpaque(false);
        String descTitle = rmgr.getUIString("wb.detail.descpan.title");
        this.descPan = new JPanel();
        this.descPan.setLayout(new BorderLayout());
        this.descPan.add("Center", this.descText);
        this.descPan.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(0), descTitle), new EmptyBorder(10, 15, 15, 15)));
        AWTUtilities.constrain(infoPan, this.descPan, 1, 15, 0, row++, 2, 1, 1.0, 1.0, new Insets(10, 5, 5, 5));
        this.add("North", this.title);
        this.add("Center", infoPan);
    }

    private class DetailLabel
    extends JLabel {
        public DetailLabel(String text) {
            super(text);
            this.setOpaque(true);
            this.setBackground(new Color(240, 240, 240));
            this.setForeground(Color.black);
            this.setBorder(new CompoundBorder(new LineBorder(Color.darkGray), new EmptyBorder(1, 3, 1, 3)));
        }
    }
}

