/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.jcvsii.Config;
import com.ice.jcvsii.ConnectInfoPanel;
import com.ice.jcvsii.ResourceMgr;
import com.ice.jcvsii.ServerDef;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ServersDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private JList serverList;
    private JTextArea descText;
    private JPanel descPan;
    private JPanel infoPanel;
    private JLabel userNameLbl;
    private JLabel hostNameLbl;
    private JLabel repositoryLbl;
    private JLabel moduleLbl;
    private JLabel connMethodLbl;
    private UserPrefs prefs;
    private ConnectInfoPanel info;
    private ServerDef definition;
    private int descOffset = 15;

    public ServersDialog(Frame parent, UserPrefs prefs, ConnectInfoPanel info) {
        super(parent, "CVS Servers", true);
        this.info = info;
        this.prefs = prefs;
        this.definition = null;
        this.establishDialogContents(Config.getInstance().getServerDefinitions());
        Dimension sz = this.getPreferredSize();
        if (sz.width < 480) {
            sz.width = 480;
        }
        if (sz.height < 400) {
            sz.height = 400;
        }
        this.setSize(sz);
        Point location = AWTUtilities.centerDialogInParent(this, parent);
        this.setLocation(location.x, location.y);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
            }
        });
    }

    public ServerDef getServerDefinition() {
        return this.definition;
    }

    public Vector loadServerDefs(UserPrefs prefs) {
        Vector<ServerDef> result = new Vector<ServerDef>();
        result.addElement(new ServerDef("Giant Java Tree", "pserver", "java", "anoncvs", "cvs.gjt.org", "/gjt/cvsroot", "This is the anonymous Giant Java Tree server.\n\nThis definition allows anyone to checkout the Giant Java Tree, but not commit changes."));
        return result;
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.definition = (ServerDef)this.serverList.getSelectedValue();
            if (this.definition == null) {
                this.userNameLbl.setText(" ");
                this.hostNameLbl.setText(" ");
                this.repositoryLbl.setText(" ");
                this.moduleLbl.setText(" ");
                this.connMethodLbl.setText(" ");
                this.descText.setText(" ");
            } else {
                this.userNameLbl.setText(this.definition.getUserName());
                this.hostNameLbl.setText(this.definition.getHostName());
                this.repositoryLbl.setText(this.definition.getRepository());
                this.moduleLbl.setText(this.definition.getModule());
                this.connMethodLbl.setText(this.definition.getConnectMethodName());
                this.descText.setText(this.definition.getDescription());
            }
            this.repaint(0L);
        }
    }

    public void actionPerformed(ActionEvent event) {
        boolean doDispose = false;
        String command = event.getActionCommand();
        if (command.compareTo("OK") == 0) {
            doDispose = true;
        } else if (command.compareTo("CANCEL") == 0) {
            this.definition = null;
            doDispose = true;
        }
        if (doDispose) {
            this.dispose();
        }
    }

    public void establishDialogContents(Vector defs) {
        ResourceMgr rmgr = ResourceMgr.getInstance();
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        JPanel mainPan = new JPanel();
        mainPan.setLayout(new BorderLayout());
        mainPan.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.serverList = new JList(defs);
        this.serverList.addListSelectionListener(this);
        JScrollPane scroller = new JScrollPane(this.serverList);
        scroller.setPreferredSize(new Dimension(150, 75));
        JPanel scrollerPanel = new JPanel();
        scrollerPanel.setLayout(new BorderLayout());
        scrollerPanel.add(scroller);
        scrollerPanel.setBorder(new CompoundBorder(new EtchedBorder(0), new EmptyBorder(2, 2, 2, 2)));
        this.infoPanel = new JPanel();
        this.infoPanel.setLayout(new GridBagLayout());
        this.infoPanel.setBorder(new EmptyBorder(5, 10, 0, 5));
        int row = 0;
        JLabel lbl = new JLabel(rmgr.getUIString("name.for.user.name"));
        AWTUtilities.constrain(this.infoPanel, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
        ServersDialog serversDialog = this;
        serversDialog.getClass();
        this.userNameLbl = serversDialog.new DetailLabel(" ");
        AWTUtilities.constrain(this.infoPanel, this.userNameLbl, 2, 17, 1, row++, 1, 1, 1.0, 0.0, new Insets(1, 4, 2, 4));
        lbl = new JLabel(rmgr.getUIString("name.for.cvsserver"));
        AWTUtilities.constrain(this.infoPanel, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
        ServersDialog serversDialog2 = this;
        serversDialog2.getClass();
        this.hostNameLbl = serversDialog2.new DetailLabel(" ");
        AWTUtilities.constrain(this.infoPanel, this.hostNameLbl, 2, 17, 1, row++, 1, 1, 1.0, 0.0, new Insets(1, 4, 2, 4));
        lbl = new JLabel(rmgr.getUIString("name.for.cvsrepos"));
        AWTUtilities.constrain(this.infoPanel, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
        ServersDialog serversDialog3 = this;
        serversDialog3.getClass();
        this.repositoryLbl = serversDialog3.new DetailLabel(" ");
        AWTUtilities.constrain(this.infoPanel, this.repositoryLbl, 2, 17, 1, row++, 1, 1, 1.0, 0.0, new Insets(1, 4, 2, 4));
        lbl = new JLabel(rmgr.getUIString("name.for.cvsmodule"));
        AWTUtilities.constrain(this.infoPanel, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
        ServersDialog serversDialog4 = this;
        serversDialog4.getClass();
        this.moduleLbl = serversDialog4.new DetailLabel(" ");
        AWTUtilities.constrain(this.infoPanel, this.moduleLbl, 2, 17, 1, row++, 1, 1, 1.0, 0.0, new Insets(1, 4, 2, 4));
        lbl = new JLabel(rmgr.getUIString("name.for.connect.method"));
        AWTUtilities.constrain(this.infoPanel, lbl, 0, 17, 0, row, 1, 1, 0.0, 0.0);
        ServersDialog serversDialog5 = this;
        serversDialog5.getClass();
        this.connMethodLbl = serversDialog5.new DetailLabel(" ");
        AWTUtilities.constrain(this.infoPanel, this.connMethodLbl, 2, 17, 1, row++, 1, 1, 1.0, 0.0, new Insets(1, 4, 2, 4));
        this.descText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.descText.setEnabled(false);
        this.descText.setEditable(false);
        this.descText.setDisabledTextColor(Color.black);
        this.descText.setLineWrap(true);
        this.descText.setWrapStyleWord(true);
        this.descText.setOpaque(false);
        this.descPan = new JPanel();
        this.descPan.setLayout(new BorderLayout());
        this.descPan.add("Center", this.descText);
        this.descPan.setBorder(new CompoundBorder(new EmptyBorder(this.descOffset, 5, 0, 5), new CompoundBorder(new TitledBorder(new EtchedBorder(0), "Description"), new EmptyBorder(10, 10, 10, 10))));
        AWTUtilities.constrain(this.infoPanel, this.descPan, 1, 15, 0, row++, 2, 1, 1.0, 1.0);
        mainPan.add("Center", this.infoPanel);
        JPanel ctlPan = new JPanel();
        ctlPan.setLayout(new BorderLayout());
        JPanel btnPan = new JPanel();
        btnPan.setLayout(new GridLayout(1, 2, 20, 5));
        btnPan.setBorder(new EmptyBorder(5, 5, 5, 5));
        JButton okBtn = new JButton(rmgr.getUIString("name.for.ok"));
        okBtn.addActionListener(this);
        okBtn.setActionCommand("OK");
        btnPan.add(okBtn);
        JButton canBtn = new JButton(rmgr.getUIString("name.for.cancel"));
        canBtn.addActionListener(this);
        canBtn.setActionCommand("CANCEL");
        btnPan.add(canBtn);
        JSeparator sep = new JSeparator(0);
        ctlPan.add("North", sep);
        ctlPan.add("East", btnPan);
        mainPan.add("West", scrollerPanel);
        content.add("South", ctlPan);
        content.add("Center", mainPan);
    }

    private class DetailLabel
    extends JLabel {
        public DetailLabel(String text) {
            super(text);
            this.setOpaque(true);
            this.setBackground(new Color(250, 250, 250));
            this.setForeground(Color.black);
            this.setBorder(new CompoundBorder(new LineBorder(Color.darkGray), new EmptyBorder(1, 3, 1, 3)));
        }
    }
}

