/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSEntry;
import com.ice.cvsc.CVSEntryVector;
import com.ice.cvsc.CVSIgnore;
import com.ice.jcvsii.Config;
import com.ice.jcvsii.ResourceMgr;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NewFilesDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private boolean okClicked = false;
    private File dirFile = null;
    private CVSEntry dirEntry;
    private Vector fileV;
    private JList fileList = null;
    private JTextField ignoreText;
    private JButton okButton;
    private String ignoreStr = Config.getPreferences().getProperty("global.userIgnores", null);

    public NewFilesDialog(Frame parent, boolean modal, String prompt) {
        super(parent, "New Files", modal);
        this.establishDialogContents(prompt);
        Dimension sz = this.getPreferredSize();
        if (sz.width < 360) {
            sz.width = 360;
        }
        if (sz.height < 240) {
            sz.height = 240;
        }
        this.setSize(sz);
        Point location = AWTUtilities.centerDialogInParent(this, parent);
        this.setLocation(location.x, location.y);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                NewFilesDialog.this.fileList.requestFocus();
            }
        });
    }

    public void refreshFileList(File dirF, CVSEntry dirEntry) {
        File ignFile;
        this.dirFile = dirF;
        this.dirEntry = dirEntry;
        this.fileV = new Vector();
        String[] files = this.dirFile.list();
        UserPrefs prefs = Config.getPreferences();
        CVSIgnore dirIgnore = new CVSIgnore();
        String ignoreName = prefs.getProperty("global.ignoreFileName", null);
        this.ignoreStr = this.ignoreText.getText();
        if (this.ignoreStr != null) {
            dirIgnore.addIgnoreSpec(this.ignoreStr);
        }
        if ((ignFile = new File(this.dirFile, ignoreName)).exists() && ignFile.canRead()) {
            dirIgnore.addIgnoreFile(ignFile);
        }
        if ((ignFile = new File(this.dirFile, ".cvsignore")).exists()) {
            dirIgnore.addIgnoreFile(ignFile);
        }
        int i = 0;
        while (i < files.length) {
            String fileName = files[i];
            File f = new File(this.dirFile, fileName);
            if (f.isFile() && f.exists() && f.canRead() && !fileName.equals(ignoreName) && !fileName.equals(".cvsignore") && !dirIgnore.isFileToBeIgnored(fileName)) {
                CVSEntryVector eV = this.dirEntry.getEntryList();
                if (this.dirEntry.locateEntry(fileName) == null) {
                    this.fileV.addElement(fileName);
                }
            }
            ++i;
        }
        this.fileList.setListData(this.fileV);
    }

    public String[] getSelectedFiles() {
        if (this.okClicked) {
            Object[] items = this.fileList.getSelectedValues();
            String[] result = new String[items.length];
            if (items.length > 0) {
                System.arraycopy(items, 0, result, 0, items.length);
            }
            return result;
        }
        return new String[0];
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (this.fileList.getSelectedIndex() == -1) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.compareTo("OK") == 0) {
            this.okClicked = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NewFilesDialog.this.dispose();
                }
            });
        } else if (command.compareTo("CANCEL") == 0) {
            this.okClicked = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NewFilesDialog.this.dispose();
                }
            });
        } else if (command.compareTo("CLEAR") == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NewFilesDialog.this.fileList.clearSelection();
                }
            });
        }
    }

    public void establishDialogContents(String prompt) {
        UserPrefs prefs = Config.getPreferences();
        JLabel promptLabel = new JLabel(prompt);
        promptLabel.setBorder(new EmptyBorder(2, 2, 0, 0));
        promptLabel.setFont(prefs.getFont("newFileDialog.prompt.font", new Font("Dialog", 1, 14)));
        this.fileList = new JList();
        this.fileList.addListSelectionListener(this);
        this.fileList.setFont(prefs.getFont("newFileDialog.text.font", new Font("Dialog", 1, 12)));
        JScrollPane scroller = new JScrollPane(this.fileList);
        JPanel ignorePanel = new JPanel();
        ignorePanel.setLayout(new BorderLayout());
        ignorePanel.setBorder(new EmptyBorder(1, 2, 8, 2));
        JLabel ignoreLbl = new JLabel("Ignore:");
        ignoreLbl.setBorder(new EmptyBorder(1, 1, 1, 4));
        this.ignoreText = new JTextField(this.ignoreStr);
        this.ignoreText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewFilesDialog.this.refreshFileList(NewFilesDialog.this.dirFile, NewFilesDialog.this.dirEntry);
            }
        });
        ignorePanel.add("West", ignoreLbl);
        ignorePanel.add("Center", this.ignoreText);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridLayout(1, 2, 20, 20));
        ResourceMgr rmgr = ResourceMgr.getInstance();
        this.okButton = new JButton(rmgr.getUIString("name.for.ok"));
        this.okButton.addActionListener(this);
        this.okButton.setActionCommand("OK");
        this.okButton.setEnabled(false);
        controlPanel.add(this.okButton);
        JButton button = new JButton(rmgr.getUIString("name.for.cancel"));
        button.addActionListener(this);
        button.setActionCommand("CANCEL");
        controlPanel.add(button);
        button = new JButton(rmgr.getUIString("name.for.clear"));
        button.addActionListener(this);
        button.setActionCommand("CLEAR");
        controlPanel.add(button);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        JPanel contPan = new JPanel();
        contPan.setLayout(new BorderLayout(2, 2));
        contPan.setBorder(new EmptyBorder(3, 3, 3, 3));
        content.add("Center", contPan);
        JPanel southPan = new JPanel();
        southPan.setLayout(new BorderLayout());
        southPan.add("North", ignorePanel);
        southPan.add("West", button);
        southPan.add("East", controlPanel);
        southPan.setBorder(new EmptyBorder(3, 0, 3, 0));
        contPan.add("North", promptLabel);
        contPan.add("Center", scroller);
        contPan.add("South", southPan);
    }
}

