/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSCUtilities;
import com.ice.cvsc.CVSLog;
import com.ice.cvsc.CVSProject;
import com.ice.jcvsii.AboutDialog;
import com.ice.jcvsii.Config;
import com.ice.jcvsii.HTMLDialog;
import com.ice.jcvsii.JCVS;
import com.ice.jcvsii.MainPanel;
import com.ice.jcvsii.ProjectFrame;
import com.ice.jcvsii.ProjectFrameMgr;
import com.ice.jcvsii.ResourceMgr;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class MainFrame
extends JFrame
implements ActionListener {
    private JCVS app;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private MainPanel mainPanel;
    private String lastBrowseDirectory = null;
    static /* synthetic */ Class class$com$ice$jcvsii$MainFrame;
    static /* synthetic */ Class class$java$awt$Container;

    public MainFrame(JCVS jcvs, String title, Rectangle bounds) {
        super(title);
        this.app = jcvs;
        this.mainPanel = new MainPanel(this);
        this.getContentPane().add(this.mainPanel);
        this.establishMenuBar();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainFrame.this.app.performShutDown();
            }
        });
        this.pack();
        if (bounds != null) {
            this.setBounds(bounds);
        }
    }

    public void loadPreferences() {
        this.mainPanel.loadPreferences();
    }

    public void savePreferences() {
        Rectangle bounds = this.getBounds();
        if (bounds.x >= 0 && bounds.y >= 0 && bounds.width > 0 && bounds.height > 0) {
            Config.getPreferences().setBounds("mainFrame.bounds", bounds);
        }
        this.mainPanel.savePreferences();
    }

    public void addProjectToWorkBench(CVSProject project) {
        this.mainPanel.addProjectToWorkBench(project);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("QUIT")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.app.performShutDown();
                }
            });
        } else if (command.equals("ABOUT")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AboutDialog dlg = new AboutDialog(MainFrame.this);
                    dlg.show();
                }
            });
        } else if (command.equals("BUGREPORT")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.showHTMLDialog("info.howto.report.bug.title", "info.howto.report.bug.html");
                }
            });
        } else if (command.equals("HOMEPAGE")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.showHTMLDialog("info.homepage.title", "info.homepage.html");
                }
            });
        } else if (command.equals("MAILLIST")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.showHTMLDialog("info.maillist.title", "info.maillist.html");
                }
            });
        } else if (command.equals("BROWSE")) {
            this.performBrowse();
        } else if (command.equals("CONFIG")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Config.getInstance().editConfiguration(MainFrame.this);
                }
            });
        } else {
            System.err.println("UNKNOWN Command '" + command + "'");
        }
    }

    public void showHTMLDialog(String titleKey, String msgKey) {
        String msgStr = ResourceMgr.getInstance().getUIString(msgKey);
        String title = ResourceMgr.getInstance().getUIString(titleKey);
        HTMLDialog dlg = new HTMLDialog(null, title, true, msgStr);
        Dimension newSz = new Dimension(560, 420);
        dlg.setSize(newSz);
        Point location = AWTUtilities.computeDialogLocation(dlg);
        dlg.setLocation(location.x, location.y);
        dlg.show();
    }

    public void performBrowse() {
        Config cfg = Config.getInstance();
        UserPrefs prefs = cfg.getPreferences();
        String prompt = ResourceMgr.getInstance().getUIString("open.project.prompt");
        String localRootDirName = ProjectFrame.getUserSelectedProject(this, prompt, this.lastBrowseDirectory);
        if (localRootDirName != null) {
            this.lastBrowseDirectory = CVSCUtilities.exportPath(localRootDirName);
            if (!ProjectFrameMgr.checkProjectOpen(localRootDirName)) {
                String entriesPath = CVSProject.getAdminEntriesPath(CVSProject.rootPathToAdminPath(localRootDirName));
                File entriesFile = new File(entriesPath);
                File rootDirFile = new File(localRootDirName);
                ProjectFrame.openProject(rootDirFile, null);
            }
        }
    }

    private void establishMenuBar() {
        this.menuBar = new JMenuBar();
        this.addFileMenu(this.menuBar);
        this.addHelpMenu(this.menuBar);
        this.setJMenuBar(this.menuBar);
    }

    private void addFileMenu(JMenuBar mbar) {
        ResourceMgr rmgr = ResourceMgr.getInstance();
        this.fileMenu = new JMenu(rmgr.getUIString("menu.file.name"));
        mbar.add(this.fileMenu);
        JMenuItem item = new JMenuItem(rmgr.getUIString("menu.file.open.name"));
        this.fileMenu.add(item);
        item.addActionListener(this);
        item.setActionCommand("BROWSE");
        item.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.fileMenu.addSeparator();
        item = new JMenuItem(rmgr.getUIString("menu.file.edit.name"));
        this.fileMenu.add(item);
        item.addActionListener(this);
        item.setActionCommand("CONFIG");
        this.fileMenu.addSeparator();
        item = new JMenuItem(rmgr.getUIString("menu.file.quit.name"));
        this.fileMenu.add(item);
        item.addActionListener(this);
        item.setActionCommand("QUIT");
        item.setAccelerator(KeyStroke.getKeyStroke(81, 2));
    }

    private void addHelpMenu(JMenuBar mbar) {
        ResourceMgr rmgr = ResourceMgr.getInstance();
        this.helpMenu = new JMenu(rmgr.getUIString("menu.help.name"));
        mbar.add(this.helpMenu);
        boolean haveJH = false;
        try {
            Class<?> cls = Class.forName("javax.help.HelpSet");
            haveJH = true;
        }
        catch (ClassNotFoundException ex) {
            haveJH = false;
        }
        if (haveJH) {
            this.addJavaHelpItem();
        } else {
            CVSLog.logMsgStderr("JavaHelp is not available.");
        }
        JMenuItem item = new JMenuItem(rmgr.getUIString("menu.help.homepage.name"));
        this.helpMenu.add(item);
        item.addActionListener(this);
        item.setActionCommand("HOMEPAGE");
        item = new JMenuItem(rmgr.getUIString("menu.help.maillist.name"));
        this.helpMenu.add(item);
        item.addActionListener(this);
        item.setActionCommand("MAILLIST");
        item = new JMenuItem(rmgr.getUIString("menu.help.bugreport.name"));
        this.helpMenu.add(item);
        item.addActionListener(this);
        item.setActionCommand("BUGREPORT");
        this.helpMenu.addSeparator();
        item = new JMenuItem(rmgr.getUIString("menu.help.about.name"));
        this.helpMenu.add(item);
        item.addActionListener(this);
        item.setActionCommand("ABOUT");
    }

    private void addJavaHelpItem() {
        String helpSetUrlName = "com/ice/jcvsii/doc/help/help.hs";
        ResourceMgr rmgr = ResourceMgr.getInstance();
        try {
            ClassLoader loader = (class$com$ice$jcvsii$MainFrame == null ? (class$com$ice$jcvsii$MainFrame = MainFrame.class$("com.ice.jcvsii.MainFrame")) : class$com$ice$jcvsii$MainFrame).getClassLoader();
            URL hsURL = HelpSet.findHelpSet(loader, helpSetUrlName);
            if (hsURL == null) {
                throw new Exception("HelpSet URL is null (not found?)");
            }
            HelpSet hs = new HelpSet(loader, hsURL);
            HelpBroker hb = hs.createHelpBroker();
            JMenuItem item = new JMenuItem(rmgr.getUIString("menu.help.javahelp.name"));
            this.helpMenu.add(item);
            item.addActionListener(new CSH.DisplayHelpFromSource(hb));
            this.helpMenu.addSeparator();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Could not open HelpSet '" + helpSetUrlName + "',\n" + ex.getMessage(), "Warning", 2);
        }
    }

    public static void setWaitCursor(Container cont, boolean busy) {
        Cursor curs = busy ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0);
        cont.setCursor(curs);
        int i = 0;
        int sz = cont.getComponentCount();
        while (i < sz) {
            Component comp;
            Class<?> compCls;
            Class contCls = class$java$awt$Container == null ? MainFrame.class$("java.awt.Container") : class$java$awt$Container;
            if (contCls.isAssignableFrom(compCls = (comp = cont.getComponent(i)).getClass())) {
                MainFrame.setWaitCursor((Container)comp, busy);
            } else {
                comp.setCursor(curs);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

