/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSArgumentVector;
import com.ice.cvsc.CVSClient;
import com.ice.cvsc.CVSEntry;
import com.ice.cvsc.CVSEntryVector;
import com.ice.cvsc.CVSIgnore;
import com.ice.cvsc.CVSMode;
import com.ice.cvsc.CVSProject;
import com.ice.cvsc.CVSRequest;
import com.ice.cvsc.CVSResponse;
import com.ice.cvsc.CVSScramble;
import com.ice.cvsc.CVSTracer;
import com.ice.cvsc.CVSUserInterface;
import com.ice.jcvsii.CVSThread;
import com.ice.jcvsii.CVSUtilities;
import com.ice.jcvsii.Config;
import com.ice.jcvsii.ConnectInfoPanel;
import com.ice.jcvsii.MainPanel;
import com.ice.jcvsii.MainTabPanel;
import com.ice.jcvsii.ResourceMgr;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class ImportPanel
extends MainTabPanel
implements ActionListener,
CVSUserInterface {
    protected CVSClient client;
    protected JTextField argumentsText;
    protected JTextField releaseText;
    protected JTextField vendorText;
    protected JTextArea outputText;
    protected JTextArea messageText;
    protected JTextArea ignoreText;
    protected JTextArea binariesText;
    protected JCheckBox descendCheck;
    protected JLabel feedback;
    protected JButton actionButton;
    protected StringBuffer scanText = new StringBuffer();
    protected String ignoreName;
    protected JTabbedPane tabbed;
    protected AdditionalInfoPanel addPan;
    protected ConnectInfoPanel infoPan;

    public ImportPanel(MainPanel parent) {
        super(parent);
        this.establishContents();
    }

    public void loadPreferences() {
        this.addPan.loadPreferences("importadd");
        this.infoPan.loadPreferences("import");
    }

    public void savePreferences() {
        this.addPan.savePreferences("importadd");
        this.infoPan.savePreferences("import");
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equalsIgnoreCase("IMPORT")) {
            this.performImport();
        } else if (command.equalsIgnoreCase("CANCEL")) {
            this.cancelImport();
        }
    }

    private void cancelImport() {
        this.client.setCanceled(true);
    }

    private void performImport() {
        boolean descend;
        String ignoreStr;
        Config cfg = Config.getInstance();
        UserPrefs prefs = cfg.getPreferences();
        ResourceMgr rmgr = ResourceMgr.getInstance();
        boolean allok = true;
        CVSEntryVector entries = new CVSEntryVector();
        CVSEntryVector binEntries = new CVSEntryVector();
        CVSArgumentVector arguments = CVSArgumentVector.parseArgumentString(this.infoPan.getArguments());
        String userName = this.infoPan.getUserName();
        String passWord = this.infoPan.getPassword();
        String hostname = this.infoPan.getServer();
        String repository = this.infoPan.getModule();
        String rootDirectory = this.infoPan.getRepository();
        String importDirectory = this.infoPan.getImportDirectory();
        String vendorTag = this.addPan.getVendorTag();
        String releaseTag = this.addPan.getReleaseTag();
        String messageStr = this.addPan.getLogMessage();
        if (repository.startsWith("/")) {
            repository = repository.substring(1);
        }
        if (repository.endsWith("/")) {
            repository = repository.substring(0, repository.length() - 1);
        }
        if (rootDirectory.endsWith("/")) {
            rootDirectory = rootDirectory.substring(0, rootDirectory.length() - 1);
        }
        String rootRepository = rootDirectory + "/" + repository;
        boolean isPServer = this.infoPan.isPServer();
        int connMethod = this.infoPan.getConnectionMethod();
        int cvsPort = CVSUtilities.computePortNum(hostname, connMethod, isPServer);
        if (hostname.length() < 1 || repository.length() < 1 || rootDirectory.length() < 1 || vendorTag.length() < 1 || releaseTag.length() < 1 || messageStr.length() < 1 || importDirectory.length() < 1) {
            Object[] fmtArgs = new String[]{hostname.length() < 1 ? rmgr.getUIString("name.for.cvsserver") : (repository.length() < 1 ? rmgr.getUIString("name.for.cvsmodule") : (rootDirectory.length() < 1 ? rmgr.getUIString("name.for.cvsrepos") : (importDirectory.length() < 1 ? rmgr.getUIString("name.for.importdir") : (vendorTag.length() < 1 ? rmgr.getUIString("name.for.vendortag") : (releaseTag.length() < 1 ? rmgr.getUIString("name.for.releasetag") : rmgr.getUIString("name.for.logmsg"))))))};
            String msg = rmgr.getUIFormat("import.needs.input.msg", fmtArgs);
            String title = rmgr.getUIString("import.needs.input.title");
            JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), msg, title, 0);
            return;
        }
        if (userName.length() < 1 && (connMethod == 2 || connMethod == 3)) {
            String msg = rmgr.getUIString("common.rsh.needs.user.msg");
            String title = rmgr.getUIString("common.rsh.needs.user.title");
            JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), msg, title, 0);
            return;
        }
        this.scanText.setLength(0);
        this.ignoreName = prefs.getProperty("global.ignoreFileName", null);
        CVSIgnore ignore = new CVSIgnore();
        String userIgnores = prefs.getProperty("global.userIgnores", null);
        if (userIgnores != null) {
            ignore.addIgnoreSpec(userIgnores);
        }
        if ((ignoreStr = this.addPan.getIgnores()).length() > 0) {
            ignore.addIgnoreSpec(ignoreStr);
        }
        CVSIgnore binaries = new CVSIgnore("");
        String binariesStr = this.addPan.getBinaries();
        if (binariesStr.length() > 0) {
            binaries.addIgnoreSpec(binariesStr);
        }
        if (!(allok = this.importScan(rootDirectory, repository, importDirectory, descend = this.addPan.isDescendChecked(), entries, ignore, binEntries, binaries))) {
            String msg = rmgr.getUIString("import.scan.error.msg");
            String title = rmgr.getUIString("import.scan.error.title");
            JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), msg, title, 0);
            this.outputText.setText(this.scanText.toString());
            this.outputText.repaint(500L);
            return;
        }
        String serverCommand = CVSUtilities.establishServerCommand(hostname, connMethod, isPServer);
        this.client = CVSUtilities.createCVSClient(hostname, cvsPort);
        this.client.setTempDirectory(cfg.getTemporaryDirectory());
        CVSRequest request = new CVSRequest();
        request.setPServer(isPServer);
        request.setUserName(userName);
        if (isPServer) {
            String scrambled = CVSScramble.scramblePassword(passWord, 'A');
            request.setPassword(scrambled);
        } else if (connMethod == 3) {
            request.setPassword(passWord);
        }
        request.setConnectionMethod(connMethod);
        request.setServerCommand(serverCommand);
        if (connMethod == 2) {
            CVSUtilities.establishRSHProcess(request);
        }
        request.setPort(this.client.getPort());
        request.setHostName(this.client.getHostName());
        request.setRepository(repository);
        request.setRootDirectory(rootDirectory);
        request.setRootRepository(rootRepository);
        request.setLocalDirectory(importDirectory);
        request.setSetVariables(CVSUtilities.getUserSetVariables(this.client.getHostName()));
        request.setCommand("import");
        request.sendModifieds = true;
        request.sendArguments = true;
        request.includeNotifies = false;
        request.traceRequest = CVSProject.overTraceRequest;
        request.traceResponse = CVSProject.overTraceResponse;
        request.traceTCPData = CVSProject.overTraceTCP;
        request.traceProcessing = CVSProject.overTraceProcessing;
        request.allowGzipFileMode = prefs.getBoolean("global.allowGzipFileMode", false);
        request.setGzipStreamLevel(prefs.getInteger("global.gzipStreamLevel", 0));
        arguments.appendArgument("-m");
        arguments.appendArgument(messageStr);
        arguments.appendArgument(repository);
        arguments.appendArgument(vendorTag);
        arguments.appendArgument(releaseTag);
        request.setEntries(entries);
        request.setArguments(arguments);
        request.setUserInterface(this);
        CVSResponse response = new CVSResponse();
        ImportPanel importPanel = this;
        importPanel.getClass();
        MyRunner myRunner = importPanel.new MyRunner(this.client, request, response, binEntries);
        ImportPanel importPanel2 = this;
        importPanel2.getClass();
        CVSThread thread = new CVSThread("Import", (Runnable)myRunner, importPanel2.new MyMonitor(request, response));
        thread.start();
    }

    public boolean importScan(String repository, String module, String importPath, boolean descend, CVSEntryVector entries, CVSIgnore ignore, CVSEntryVector binEntries, CVSIgnore binaries) {
        boolean result = true;
        File dirFile = new File(importPath);
        if (!dirFile.exists()) {
            result = false;
            Object[] fmtArgs = new String[]{dirFile.getPath()};
            this.scanText.append(ResourceMgr.getInstance().getUIFormat("import.scan.dir.doesnotexist", fmtArgs));
            this.scanText.append("   " + ResourceMgr.getInstance().getUIString("import.scan.aborted"));
        } else if (!dirFile.isDirectory()) {
            result = false;
            Object[] fmtArgs = new String[]{dirFile.getPath()};
            this.scanText.append(ResourceMgr.getInstance().getUIFormat("import.scan.dir.notdir", fmtArgs));
            this.scanText.append("   " + ResourceMgr.getInstance().getUIString("import.scan.aborted"));
        } else {
            result = this.importScanDescend(repository, module, "", dirFile, descend, entries, ignore, binEntries, binaries);
        }
        return result;
    }

    private boolean importScanDescend(String repository, String module, String localDirectory, File dirFile, boolean descend, CVSEntryVector entries, CVSIgnore ignore, CVSEntryVector binEntries, CVSIgnore binaries) {
        boolean result = true;
        String[] contents = dirFile.list();
        if (contents == null) {
            return true;
        }
        CVSIgnore dirIgnore = null;
        File ignFile = new File(dirFile, this.ignoreName);
        if (ignFile.exists()) {
            dirIgnore = new CVSIgnore("");
            dirIgnore.addIgnoreFile(ignFile);
            CVSTracer.traceIf(false, "ImportDescend: DIRECTORY IGNORE '" + ignFile.getPath() + "' added '" + dirIgnore.size() + "' ignores.");
        }
        if ((ignFile = new File(dirFile, ".cvsignore")).exists()) {
            dirIgnore = new CVSIgnore("");
            dirIgnore.addIgnoreFile(ignFile);
            CVSTracer.traceIf(false, "ImportDescend: DIRECTORY IGNORE '" + ignFile.getPath() + "' added '" + dirIgnore.size() + "' ignores.");
        }
        int i = 0;
        while (result && i < contents.length) {
            String fileName = contents[i];
            File file = new File(dirFile, fileName);
            CVSTracer.traceIf(false, "ImportDescend[" + i + "] fileName '" + fileName + "' isDir '" + file.isDirectory() + "' filePath '" + file.getPath() + "'");
            if (!fileName.equals(this.ignoreName) && !fileName.equals(".cvsignore")) {
                if (ignore.isFileToBeIgnored(fileName) || dirIgnore != null && dirIgnore.isFileToBeIgnored(fileName)) {
                    CVSTracer.traceIf(false, "ImportDescend[" + i + "] IGNORE '" + fileName + "'");
                    this.scanText.append("I " + localDirectory + fileName + "\n");
                } else if (file.isDirectory()) {
                    String newLocal = localDirectory + fileName + "/";
                    if (descend) {
                        result = this.importScanDescend(repository, module, newLocal, file, descend, entries, ignore, binEntries, binaries);
                    }
                } else {
                    CVSEntry entry = new CVSEntry();
                    String modPath = module + "/" + localDirectory;
                    String localDir = localDirectory;
                    if (localDir.length() == 0) {
                        localDir = "./";
                    }
                    String reposPath = repository + "/" + module;
                    if (localDirectory.length() > 0) {
                        reposPath = reposPath + "/" + localDirectory.substring(0, localDirectory.length() - 1);
                    }
                    entry.setName(fileName);
                    entry.setLocalDirectory(localDir);
                    entry.setRepository(reposPath);
                    entry.setMode(new CVSMode());
                    entry.setNewUserFile(true);
                    if (binaries.isFileToBeIgnored(fileName)) {
                        entry.setOptions("-kb");
                        binEntries.appendEntry(entry);
                    } else {
                        entries.appendEntry(entry);
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public void uiDisplayProgressMsg(String message) {
        this.feedback.setText(message);
        this.feedback.repaint(0L);
    }

    public void uiDisplayProgramError(String error) {
    }

    public void uiDisplayResponse(CVSResponse response) {
    }

    private void establishContents() {
        ResourceMgr rmgr = ResourceMgr.getInstance();
        this.setLayout(new GridBagLayout());
        this.tabbed = new JTabbedPane();
        this.infoPan = new ConnectInfoPanel("import");
        this.infoPan.setPServerMode(true);
        this.infoPan.setUsePassword(true);
        this.tabbed.addTab(rmgr.getUIString("import.tab.connection"), null, this.infoPan);
        this.addPan = new AdditionalInfoPanel();
        this.tabbed.addTab(rmgr.getUIString("import.tab.additional"), null, this.addPan);
        int row = 0;
        AWTUtilities.constrain(this, this.tabbed, 2, 17, 0, row++, 1, 1, 1.0, 0.0);
        this.actionButton = new JButton(rmgr.getUIString("import.perform.label"));
        this.actionButton.setActionCommand("IMPORT");
        this.actionButton.addActionListener(this);
        AWTUtilities.constrain(this, this.actionButton, 0, 10, 0, row++, 1, 1, 0.0, 0.0, new Insets(5, 5, 5, 5));
        this.feedback = new JLabel(rmgr.getUIString("name.for.ready"));
        this.feedback.setOpaque(true);
        this.feedback.setBackground(Color.white);
        this.feedback.setBorder(new CompoundBorder(new LineBorder(Color.darkGray), new EmptyBorder(1, 3, 1, 3)));
        AWTUtilities.constrain(this, this.feedback, 2, 10, 0, row++, 1, 1, 1.0, 0.0, new Insets(4, 0, 3, 0));
        this.outputText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.outputText.setEditable(false);
        JScrollPane scroller = new JScrollPane(this.outputText);
        scroller.setVerticalScrollBarPolicy(22);
        AWTUtilities.constrain(this, scroller, 1, 10, 0, row++, 1, 1, 1.0, 1.0);
    }

    private class AdditionalInfoPanel
    extends JPanel {
        private JTextArea ignores;
        private JTextArea binaries;
        private JTextArea logmsg;
        private JTextField vendor;
        private JTextField release;
        private JCheckBox descend;

        public String getIgnores() {
            return this.ignores.getText();
        }

        public void setIgnores(String ignoreText) {
            this.ignores.setText(ignoreText);
        }

        public String getBinaries() {
            return this.binaries.getText();
        }

        public void setBinaries(String binText) {
            this.binaries.setText(binText);
        }

        public String getLogMessage() {
            return this.logmsg.getText();
        }

        public void setLogMessage(String logText) {
            this.logmsg.setText(logText);
        }

        public String getVendorTag() {
            return this.vendor.getText();
        }

        public void setVendorTag(String tag) {
            this.vendor.setText(tag);
        }

        public String getReleaseTag() {
            return this.release.getText();
        }

        public void setReleaseTag(String tag) {
            this.release.setText(tag);
        }

        public boolean isDescendChecked() {
            return this.descend.isSelected();
        }

        public void loadPreferences(String panName) {
            UserPrefs prefs = Config.getPreferences();
            this.setIgnores(prefs.getProperty(panName + "." + "addimport.user", ""));
            this.setBinaries(prefs.getProperty(panName + "." + "addimport.server", ""));
            this.setLogMessage(prefs.getProperty(panName + "." + "addimport.module", ""));
            this.setVendorTag(prefs.getProperty(panName + "." + "addimport.repository", ""));
            this.setReleaseTag(prefs.getProperty(panName + "." + "addimport.exportdir", ""));
        }

        public void savePreferences(String panName) {
            UserPrefs prefs = Config.getPreferences();
            prefs.setProperty(panName + "." + "addimport.user", this.getIgnores());
            prefs.setProperty(panName + "." + "addimport.server", this.getBinaries());
            prefs.setProperty(panName + "." + "addimport.module", this.getLogMessage());
            prefs.setProperty(panName + "." + "addimport.repository", this.getVendorTag());
            prefs.setProperty(panName + "." + "addimport.exportdir", this.getReleaseTag());
        }

        public AdditionalInfoPanel() {
            this.setLayout(new GridLayout(2, 2, 4, 4));
            ResourceMgr rmgr = ResourceMgr.getInstance();
            JPanel tagPan = new JPanel();
            tagPan.setLayout(new GridBagLayout());
            int row = 0;
            this.descend = new JCheckBox(rmgr.getUIString("import.subdir.checkbox.label"));
            this.descend.setSelected(true);
            AWTUtilities.constrain(tagPan, this.descend, 0, 10, 0, row++, 2, 1, 1.0, 0.0, new Insets(1, 3, 1, 3));
            AWTUtilities.constrain(tagPan, new JLabel(rmgr.getUIString("import.vendortag.label")), 0, 17, 0, row, 1, 1, 0.0, 0.0, new Insets(0, 3, 1, 0));
            this.vendor = new JTextField();
            AWTUtilities.constrain(tagPan, this.vendor, 2, 10, 1, row++, 1, 1, 1.0, 0.0, new Insets(3, 3, 3, 3));
            AWTUtilities.constrain(tagPan, new JLabel(rmgr.getUIString("import.releasetag.label")), 0, 17, 0, row, 1, 1, 0.0, 0.0, new Insets(0, 3, 1, 0));
            this.release = new JTextField();
            AWTUtilities.constrain(tagPan, this.release, 2, 10, 1, row++, 1, 1, 1.0, 0.0, new Insets(1, 3, 3, 3));
            this.logmsg = new JTextArea();
            JPanel logPan = new JPanel();
            logPan.setLayout(new BorderLayout());
            logPan.add("Center", this.logmsg);
            logPan.setBorder(new TitledBorder(new EtchedBorder(0), rmgr.getUIString("import.logmsg.label")));
            this.ignores = new JTextArea();
            JPanel ignPan = new JPanel();
            ignPan.setLayout(new BorderLayout());
            ignPan.add("Center", this.ignores);
            ignPan.setBorder(new TitledBorder(new EtchedBorder(0), rmgr.getUIString("import.ignores.label")));
            this.binaries = new JTextArea();
            JPanel binPan = new JPanel();
            binPan.setLayout(new BorderLayout());
            binPan.add("Center", this.binaries);
            binPan.setBorder(new TitledBorder(new EtchedBorder(0), rmgr.getUIString("import.binaries.label")));
            this.add(tagPan);
            this.add(logPan);
            this.add(ignPan);
            this.add(binPan);
        }
    }

    private class MyMonitor
    implements CVSThread.Monitor {
        private CVSRequest request;
        private CVSResponse response;

        public MyMonitor(CVSRequest request, CVSResponse response) {
            this.request = request;
            this.response = response;
        }

        public void threadStarted() {
            ImportPanel.this.actionButton.setText(ResourceMgr.getInstance().getUIString("import.cancel.label"));
        }

        public void threadCanceled() {
        }

        public void threadFinished() {
            ImportPanel.this.actionButton.setText(ResourceMgr.getInstance().getUIString("import.perform.label"));
            String resultStr = this.response.getDisplayResults();
            if (this.response.getStatus() == 0) {
                ImportPanel.this.uiDisplayProgressMsg(ResourceMgr.getInstance().getUIString("import.status.success"));
            } else {
                ImportPanel.this.uiDisplayProgressMsg(ResourceMgr.getInstance().getUIString("import.status.failure"));
            }
            ImportPanel.this.outputText.setText(resultStr);
            ImportPanel.this.outputText.revalidate();
            ImportPanel.this.outputText.repaint();
            if (this.response != null && !this.request.saveTempFiles) {
                this.response.deleteTempFiles();
            }
            ImportPanel.this.getMainPanel().setAllTabsEnabled(true);
        }
    }

    private class MyRunner
    implements Runnable {
        private CVSClient client;
        private CVSProject project;
        private CVSRequest request;
        private CVSResponse response;
        private CVSEntryVector binEntries;

        public MyRunner(CVSClient client, CVSRequest request, CVSResponse response, CVSEntryVector binEntries) {
            this.client = client;
            this.request = request;
            this.response = response;
            this.binEntries = binEntries;
        }

        public void run() {
            boolean success;
            this.client.processCVSRequest(this.request, this.response);
            this.response.appendStderr(ImportPanel.this.scanText.toString());
            boolean bl = success = this.response.getStatus() == 0;
            if (this.binEntries.size() > 0) {
                CVSResponse binResponse = new CVSResponse();
                this.request.setEntries(this.binEntries);
                this.request.getArguments().insertElementAt("-kb", 0);
                this.client.processCVSRequest(this.request, binResponse);
                if (binResponse.getStatus() != 0) {
                    success = false;
                }
                this.response.appendStdout("\n\n--------- " + ResourceMgr.getInstance().getUIString("name.for.binary.files") + " ---------\n");
                this.response.appendStdout(binResponse.getDisplayResults());
                if (!this.request.saveTempFiles) {
                    binResponse.deleteTempFiles();
                }
            }
            if (success) {
                ImportPanel.this.uiDisplayProgressMsg(ResourceMgr.getInstance().getUIString("import.perform.label"));
            } else {
                ImportPanel.this.uiDisplayProgressMsg(ResourceMgr.getInstance().getUIString("import.status.failure"));
            }
            if (!this.request.saveTempFiles) {
                this.response.deleteTempFiles();
            }
        }
    }
}

