/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSLog;
import com.ice.jcvsii.Config;
import com.ice.jcvsii.ResourceMgr;
import com.ice.util.StringUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import javax.activation.CommandObject;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.swing.JOptionPane;

public class ExecViewer
extends Thread
implements CommandObject {
    private Process proc = null;
    BufferedReader errRdr;
    BufferedReader outRdr;

    public void setCommandContext(String verb, DataHandler dh) throws IOException {
        DataSource ds = dh.getDataSource();
        String fileName = "unknown";
        if (ds instanceof FileDataSource) {
            FileDataSource fds = (FileDataSource)ds;
            fileName = fds.getFile().getPath();
        }
        this.exec(verb, dh);
    }

    public void exec(String verb, DataHandler dh) {
        Object cmdSpec = null;
        String extension = null;
        DataSource ds = dh.getDataSource();
        if (!(ds instanceof FileDataSource)) {
            return;
        }
        FileDataSource fds = (FileDataSource)ds;
        File file = fds.getFile();
        String name = file.getName();
        String path = file.getParent();
        String fileName = file.getAbsolutePath();
        String cwdPath = Config.getPreferences().getCurrentDirectory();
        path = path.replace('/', File.separatorChar);
        cwdPath = cwdPath.replace('/', File.separatorChar);
        fileName = fileName.replace('/', File.separatorChar);
        String envSpec = null;
        String argSpec = null;
        String[] env = null;
        String[] args = null;
        Config cfg = Config.getInstance();
        int index = name.lastIndexOf(".");
        if (index != -1 && index < name.length() - 1) {
            extension = name.substring(index);
            envSpec = cfg.getExecCommandEnv(verb, extension);
            argSpec = cfg.getExecCommandArgs(verb, extension);
        } else {
            envSpec = cfg.getExecCommandEnv(verb, "." + name);
            argSpec = cfg.getExecCommandArgs(verb, "." + name);
        }
        if (argSpec == null) {
            envSpec = cfg.getExecCommandEnv(verb, "._DEF_");
            argSpec = cfg.getExecCommandArgs(verb, "._DEF_");
        }
        if (argSpec == null) {
            Object[] fmtArgs = new String[]{verb, fileName, extension};
            String msg = ResourceMgr.getInstance().getUIFormat("execviewer.not.found.msg", fmtArgs);
            String title = ResourceMgr.getInstance().getUIString("execviewer.not.found.title");
            JOptionPane.showMessageDialog(null, msg, title, 0);
            return;
        }
        Hashtable<String, String> subHash = new Hashtable<String, String>();
        if (cfg.isWindows() && fileName.indexOf(32) > -1) {
            fileName = '\"' + fileName + '\"';
        }
        subHash.put("FILE", fileName);
        subHash.put("PATH", path);
        subHash.put("NAME", name);
        subHash.put("CWD", cwdPath);
        env = this.parseCommandEnv(envSpec, subHash);
        args = this.parseCommandArgs(argSpec, subHash);
        try {
            this.proc = env.length < 1 ? Runtime.getRuntime().exec(args) : Runtime.getRuntime().exec(args, env);
            this.start();
        }
        catch (IOException ex) {
            Object[] fmtArgs = new String[]{verb, fileName, ex.getMessage()};
            String msg = ResourceMgr.getInstance().getUIFormat("execviewer.exec.error.msg", fmtArgs);
            String title = ResourceMgr.getInstance().getUIString("execviewer.exec.error.title");
            JOptionPane.showMessageDialog(null, msg, title, 0);
        }
    }

    public String[] parseCommandArgs(String argStr, Hashtable subHash) {
        if (argStr == null || argStr.length() == 0) {
            return new String[0];
        }
        String[] args = StringUtilities.parseArgumentString(argStr);
        return StringUtilities.argumentSubstitution(args, subHash);
    }

    public String[] parseCommandEnv(String envStr, Hashtable subHash) {
        if (envStr == null || envStr.length() == 0) {
            return new String[0];
        }
        String[] env = StringUtilities.parseArgumentString(envStr);
        return StringUtilities.argumentSubstitution(env, subHash);
    }

    public void run() {
        try {
            String ln;
            this.proc.getOutputStream().close();
            this.errRdr = new BufferedReader(new InputStreamReader(this.proc.getErrorStream()));
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        String ln;
                        while ((ln = ExecViewer.this.errRdr.readLine()) != null) {
                        }
                        ExecViewer.this.errRdr.close();
                    }
                    catch (IOException ex) {
                        CVSLog.traceMsg(ex, "reading exec stderr stream");
                    }
                }
            });
            t.start();
            this.outRdr = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
            while ((ln = this.outRdr.readLine()) != null) {
            }
            this.outRdr.close();
            try {
                t.join();
            }
            catch (InterruptedException ex) {
                CVSLog.traceMsg(ex, "interrupted joining the stderr reader");
            }
        }
        catch (IOException ex) {
            CVSLog.traceMsg(ex, "reading exec stdout stream");
        }
        try {
            this.proc.waitFor();
        }
        catch (InterruptedException ex) {
            CVSLog.traceMsg(ex, "interrupted waiting for process");
        }
        int n = this.proc.exitValue();
    }
}

