/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.activation.DataSource;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;

public class ComponentFrame
extends Frame {
    private String contentType;

    public ComponentFrame(Component comp, String name, DataSource source) {
        super(name);
        try {
            MimeType mime = new MimeType(source.getContentType());
            this.contentType = mime.getBaseType();
        }
        catch (MimeTypeParseException ex) {
            this.contentType = source.getContentType();
        }
        this.addWindowListener(new WinClose());
        this.setLayout(new BorderLayout(1, 1));
        if (comp != null) {
            this.add(comp, "Center");
        }
        this.pack();
        this.loadLayoutProperties();
    }

    public void loadLayoutProperties() {
    }

    public void saveLayoutProperties() {
    }

    private Rectangle computeDefaultPosition() {
        Dimension sz = this.getSize();
        Dimension scrnSz = this.getToolkit().getScreenSize();
        if (sz.width > scrnSz.width - 10) {
            sz.width = scrnSz.width - 10;
        }
        if (sz.height > scrnSz.height - 10) {
            sz.height = scrnSz.height - 10;
        }
        int x = (scrnSz.width - sz.width) / 2;
        int y = (scrnSz.height - sz.height) / 3;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x + sz.width > scrnSz.width) {
            sz.width = scrnSz.width - x;
        }
        if (y + sz.height > scrnSz.height) {
            sz.height = scrnSz.height - y;
        }
        return new Rectangle(x, y, sz.width, sz.height);
    }

    class WinClose
    extends WindowAdapter {
        WinClose() {
        }

        public void windowClosing(WindowEvent e) {
            ComponentFrame.this.saveLayoutProperties();
            e.getWindow().dispose();
        }
    }
}

