/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jcvsii;

import com.ice.cvsc.CVSArgumentVector;
import com.ice.cvsc.CVSCUtilities;
import com.ice.cvsc.CVSClient;
import com.ice.cvsc.CVSEntryVector;
import com.ice.cvsc.CVSProject;
import com.ice.cvsc.CVSProjectDef;
import com.ice.cvsc.CVSRequest;
import com.ice.cvsc.CVSResponse;
import com.ice.cvsc.CVSScramble;
import com.ice.cvsc.CVSUserInterface;
import com.ice.jcvsii.CVSThread;
import com.ice.jcvsii.CVSUtilities;
import com.ice.jcvsii.Config;
import com.ice.jcvsii.ConnectInfoPanel;
import com.ice.jcvsii.MainPanel;
import com.ice.jcvsii.MainTabPanel;
import com.ice.jcvsii.ProjectFrame;
import com.ice.jcvsii.ProjectFrameMgr;
import com.ice.jcvsii.ResourceMgr;
import com.ice.pref.UserPrefs;
import com.ice.util.AWTUtilities;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class CheckOutPanel
extends MainTabPanel
implements ActionListener,
CVSUserInterface {
    protected CVSClient client;
    protected ConnectInfoPanel info;
    protected JTextField argumentsText;
    protected JTextField localDirText;
    protected JTextArea outputText;
    protected JLabel feedback;
    protected JButton actionButton;

    public CheckOutPanel(MainPanel parent) {
        super(parent);
        this.establishContents();
    }

    public void loadPreferences() {
        this.info.loadPreferences("chkout");
    }

    public void savePreferences() {
        this.info.savePreferences("chkout");
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equalsIgnoreCase("CHECKOUT")) {
            this.performCheckout();
        } else if (command.equalsIgnoreCase("CANCEL")) {
            this.cancelCheckout();
        }
    }

    private void cancelCheckout() {
        this.client.setCanceled(true);
    }

    private void performCheckout() {
        String msg;
        String title;
        Object[] fmtArgs;
        boolean listingModules = false;
        Config cfg = Config.getInstance();
        UserPrefs prefs = cfg.getPreferences();
        ResourceMgr rmgr = ResourceMgr.getInstance();
        String argumentStr = this.info.getArguments();
        String userName = this.info.getUserName();
        String passWord = this.info.getPassword();
        String hostname = this.info.getServer();
        String repository = this.info.getModule();
        String rootDirectory = this.info.getRepository();
        String localDirectory = CVSCUtilities.stripFinalSeparator(this.info.getLocalDirectory());
        boolean isPServer = this.info.isPServer();
        int connMethod = this.info.getConnectionMethod();
        int cvsPort = CVSUtilities.computePortNum(hostname, connMethod, isPServer);
        CVSArgumentVector arguments = CVSArgumentVector.parseArgumentString(argumentStr);
        if (arguments.containsArgument("-c")) {
            listingModules = true;
        } else if (repository.length() < 1) {
            fmtArgs = new String[]{rmgr.getUIString("name.for.cvsmodule")};
            title = rmgr.getUIString("checkout.needs.input.title");
            msg = rmgr.getUIFormat("checkout.needs.input.msg", fmtArgs);
            JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), msg, title, 0);
        }
        if (hostname.length() < 1 || rootDirectory.length() < 1 || localDirectory.length() < 1) {
            fmtArgs = new String[]{hostname.length() < 1 ? rmgr.getUIString("name.for.cvsserver") : (rootDirectory.length() < 1 ? rmgr.getUIString("name.for.cvsrepos") : rmgr.getUIString("name.for.checkoutdir"))};
            String msg2 = rmgr.getUIFormat("checkout.needs.input.msg", fmtArgs);
            String title2 = rmgr.getUIString("checkout.needs.input.title");
            JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), msg2, title2, 0);
            return;
        }
        if (userName.length() < 1 && (connMethod == 2 || connMethod == 3)) {
            String msg3 = rmgr.getUIString("common.rsh.needs.user.msg");
            title = rmgr.getUIString("common.rsh.needs.user.title");
            JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), msg3, title, 0);
            return;
        }
        File localRootDir = new File(localDirectory);
        if (!(localRootDir.exists() || listingModules || localRootDir.mkdirs())) {
            Object[] fmtArgs2 = new String[]{localRootDir.getPath()};
            msg = ResourceMgr.getInstance().getUIFormat("checkout.create.dir.failed.msg", fmtArgs2);
            String title3 = ResourceMgr.getInstance().getUIString("checkout.create.dir.failed.title");
            JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), msg, title3, 0);
            return;
        }
        CVSRequest request = new CVSRequest();
        String checkOutCommand = prefs.getProperty("global.checkOutCommand", ":co:N:ANP:deou:");
        if (!request.parseControlString(checkOutCommand)) {
            Object[] fmtArgs3 = new String[]{checkOutCommand, request.getVerifyFailReason()};
            String msg4 = rmgr.getUIFormat("checkout.cmd.parse.failed.msg", fmtArgs3);
            String title4 = rmgr.getUIString("checkout.cmd.parse.failed.title");
            JOptionPane.showMessageDialog((Frame)this.getTopLevelAncestor(), msg4, title4, 0);
            return;
        }
        CVSEntryVector entries = new CVSEntryVector();
        if (!listingModules) {
            arguments.appendArgument(repository);
        }
        this.getMainPanel().setAllTabsEnabled(false);
        this.client = CVSUtilities.createCVSClient(hostname, cvsPort);
        CVSProject project = new CVSProject(this.client);
        CVSProjectDef projectDef = new CVSProjectDef(connMethod, isPServer, false, hostname, userName, rootDirectory, repository);
        project.setProjectDef(projectDef);
        project.setUserName(userName);
        project.setTempDirectory(cfg.getTemporaryDirectory());
        project.setRepository(repository);
        project.setRootDirectory(rootDirectory);
        project.setLocalRootDirectory(localDirectory);
        project.setPServer(isPServer);
        project.setConnectionPort(cvsPort);
        project.setConnectionMethod(connMethod);
        project.setSetVariables(CVSUtilities.getUserSetVariables(hostname));
        project.setServerCommand(CVSUtilities.establishServerCommand(hostname, connMethod, isPServer));
        project.setAllowsGzipFileMode(prefs.getBoolean("global.allowGzipFileMode", false));
        project.setGzipStreamLevel(prefs.getInteger("global.gzipStreamLevel", 0));
        if (isPServer) {
            String scrambled = CVSScramble.scramblePassword(passWord, 'A');
            project.setPassword(scrambled);
        } else if (connMethod == 3) {
            project.setPassword(passWord);
        }
        if (connMethod == 2) {
            CVSUtilities.establishRSHProcess(project);
        }
        project.establishRootEntry(rootDirectory);
        if (!ProjectFrameMgr.checkProjectOpen(project.getLocalRootDirectory())) {
            String title5 = repository + " project";
            request.setPServer(isPServer);
            request.setUserName(userName);
            if (isPServer || connMethod == 3) {
                request.setPassword(project.getPassword());
            }
            request.setConnectionMethod(connMethod);
            request.setServerCommand(project.getServerCommand());
            request.setRshProcess(project.getRshProcess());
            request.setPort(cvsPort);
            request.setHostName(this.client.getHostName());
            request.setRepository(repository);
            request.setRootDirectory(rootDirectory);
            request.setRootRepository(rootDirectory);
            request.setLocalDirectory(localRootDir.getPath());
            request.setSetVariables(project.getSetVariables());
            request.responseHandler = project;
            request.traceRequest = CVSProject.overTraceRequest;
            request.traceResponse = CVSProject.overTraceResponse;
            request.traceTCPData = CVSProject.overTraceTCP;
            request.traceProcessing = CVSProject.overTraceProcessing;
            request.allowGzipFileMode = project.allowsGzipFileMode();
            request.setGzipStreamLevel(project.getGzipStreamLevel());
            request.setEntries(entries);
            request.appendArguments(arguments);
            request.setUserInterface(this);
            CVSResponse response = new CVSResponse();
            CheckOutPanel checkOutPanel = this;
            checkOutPanel.getClass();
            MyRunner myRunner = checkOutPanel.new MyRunner(project, this.client, request, response, listingModules);
            CheckOutPanel checkOutPanel2 = this;
            checkOutPanel2.getClass();
            CVSThread thread = new CVSThread("CheckOut", (Runnable)myRunner, checkOutPanel2.new MyMonitor(request, response, listingModules));
            thread.start();
        }
    }

    public void uiDisplayProgressMsg(String message) {
        this.feedback.setText(message);
        this.feedback.repaint(0L);
    }

    public void uiDisplayProgramError(String error) {
    }

    public void uiDisplayResponse(CVSResponse response) {
    }

    private void establishContents() {
        this.setLayout(new GridBagLayout());
        this.info = new ConnectInfoPanel("checkout");
        this.info.setPServerMode(true);
        this.info.setUsePassword(true);
        int row = 0;
        AWTUtilities.constrain(this, this.info, 2, 17, 0, row++, 1, 1, 1.0, 0.0);
        this.actionButton = new JButton(ResourceMgr.getInstance().getUIString("checkout.perform.label"));
        this.actionButton.setActionCommand("CHECKOUT");
        this.actionButton.addActionListener(this);
        AWTUtilities.constrain(this, this.actionButton, 0, 10, 0, row++, 1, 1, 0.0, 0.0, new Insets(5, 5, 5, 5));
        this.feedback = new JLabel(ResourceMgr.getInstance().getUIString("name.for.ready"));
        this.feedback.setOpaque(true);
        this.feedback.setBackground(Color.white);
        this.feedback.setBorder(new CompoundBorder(new LineBorder(Color.darkGray), new EmptyBorder(1, 3, 1, 3)));
        AWTUtilities.constrain(this, this.feedback, 2, 10, 0, row++, 1, 1, 1.0, 0.0, new Insets(4, 0, 3, 0));
        this.outputText = new JTextArea(){

            public boolean isFocusTraversable() {
                return false;
            }
        };
        this.outputText.setEditable(false);
        JScrollPane scroller = new JScrollPane(this.outputText);
        scroller.setVerticalScrollBarPolicy(22);
        AWTUtilities.constrain(this, scroller, 1, 10, 0, row++, 1, 1, 1.0, 1.0);
    }

    private class MyMonitor
    implements CVSThread.Monitor {
        private CVSRequest request;
        private CVSResponse response;
        private boolean listingMods;

        public MyMonitor(CVSRequest request, CVSResponse response, boolean listingMods) {
            this.request = request;
            this.response = response;
            this.listingMods = listingMods;
        }

        public void threadStarted() {
            CheckOutPanel.this.actionButton.setActionCommand("CANCEL");
            CheckOutPanel.this.actionButton.setText(ResourceMgr.getInstance().getUIString("checkout.cancel.label"));
        }

        public void threadCanceled() {
        }

        public void threadFinished() {
            CheckOutPanel.this.actionButton.setActionCommand("CHECKOUT");
            CheckOutPanel.this.actionButton.setText(ResourceMgr.getInstance().getUIString("checkout.perform.label"));
            String resultStr = this.response.getDisplayResults();
            if (this.response.getStatus() == 0) {
                CheckOutPanel.this.uiDisplayProgressMsg(ResourceMgr.getInstance().getUIString("checkout.status.success"));
                if (!this.listingMods) {
                    File rootDirFile = new File(this.request.getLocalDirectory() + "/" + this.request.getRepository());
                    ProjectFrame.openProject(rootDirFile, this.request.getPassword());
                }
            } else {
                CheckOutPanel.this.uiDisplayProgressMsg(ResourceMgr.getInstance().getUIString("checkout.status.failure"));
            }
            CheckOutPanel.this.outputText.setText(resultStr);
            CheckOutPanel.this.outputText.revalidate();
            CheckOutPanel.this.outputText.repaint();
            if (this.response != null && !this.request.saveTempFiles) {
                this.response.deleteTempFiles();
            }
            CheckOutPanel.this.getMainPanel().setAllTabsEnabled(true);
        }
    }

    private class MyRunner
    implements Runnable {
        private CVSClient client;
        private CVSProject project;
        private CVSRequest request;
        private CVSResponse response;
        private boolean listingMods;

        public MyRunner(CVSProject project, CVSClient client, CVSRequest request, CVSResponse response, boolean listingMods) {
            this.client = client;
            this.project = project;
            this.request = request;
            this.response = response;
            this.listingMods = listingMods;
        }

        public void run() {
            this.client.processCVSRequest(this.request, this.response);
            if (!this.listingMods) {
                this.project.processCVSResponse(this.request, this.response);
                if (this.request.getArguments().containsArgument("-P") || this.request.getArguments().containsArgument("-r") || this.request.getArguments().containsArgument("-D")) {
                    this.project.pruneEmptySubDirs(this.request.handleEntries);
                }
            }
        }
    }
}

