/*
 * Decompiled with CFR 0.152.
 */
package com.ice.cvsc;

import com.ice.cvsc.CVSLog;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class CVSTracer {
    public static final String RCS_ID = "$Id: CVSTracer.java,v 2.4 2003/07/27 01:08:32 time Exp $";
    public static final String RCS_REV = "$Revision: 2.4 $";
    private static PrintWriter out = null;
    private static boolean on = false;
    private static boolean ifOverOn = true;
    private static int traceState = 0;
    private static boolean outIsSystem = false;
    private static boolean echoAccum = false;
    private static StringBuffer outBuffer = null;

    public static void turnOn() {
        on = true;
    }

    public static void turnOff() {
        on = false;
    }

    public static void setEchoAccumulation(boolean state) {
        echoAccum = state;
    }

    public static void accumulateInBuffer(StringBuffer buffer) {
        outBuffer = buffer;
    }

    public static void turnOffAccumulation() {
        outBuffer = null;
    }

    public static StringBuffer getAccumulationBuffer() {
        return outBuffer;
    }

    public static void println(String line) {
        if (line == null) {
            return;
        }
        if (outBuffer != null) {
            outBuffer.append(line);
            outBuffer.append("\n");
            if (!echoAccum) {
                return;
            }
        }
        if (out != null) {
            out.println(line);
        } else {
            CVSLog.logMsg(line);
        }
    }

    public static void trace(String line) {
        if (line == null) {
            return;
        }
        if (on) {
            CVSTracer.println(line);
        }
    }

    public static void traceIf(boolean flag, String line) {
        if (!flag || line == null) {
            return;
        }
        if (ifOverOn) {
            CVSTracer.println(line);
        }
    }

    public static void traceException(String line, Exception ex) {
        if (line == null) {
            return;
        }
        if (on) {
            CVSTracer.println(line);
        }
        if (out == null) {
            ex.printStackTrace(System.err);
        } else {
            ex.printStackTrace(out);
        }
    }

    public static void traceWithStack(String line) {
        if (line == null) {
            return;
        }
        Throwable thrower = new Throwable(line);
        if (on) {
            CVSTracer.println(line);
        }
        if (out == null) {
            thrower.printStackTrace(System.err);
        } else {
            thrower.printStackTrace(out);
        }
    }

    private static void checkClose() {
        if (out != null && !outIsSystem) {
            out.close();
            out = null;
            outIsSystem = false;
        }
    }

    public static void setWriter(PrintWriter newOut) {
        CVSTracer.checkClose();
        out = newOut;
        outIsSystem = false;
        outBuffer = null;
    }

    public static void setWriterToStdout() {
        PrintWriter newOut = new PrintWriter(new OutputStreamWriter(System.out));
        if (newOut != null) {
            CVSTracer.checkClose();
            out = newOut;
            outIsSystem = true;
            outBuffer = null;
        }
    }

    public static void setWriterToStderr() {
        PrintWriter newOut = new PrintWriter(new OutputStreamWriter(System.err));
        if (newOut != null) {
            CVSTracer.checkClose();
            out = newOut;
            outIsSystem = true;
            outBuffer = null;
        }
    }
}

