/*
 * Decompiled with CFR 0.152.
 */
package com.ice.cvsc;

import com.ice.cvsc.CVSArgumentVector;
import com.ice.cvsc.CVSCUtilities;
import com.ice.cvsc.CVSClient;
import com.ice.cvsc.CVSEntry;
import com.ice.cvsc.CVSEntryVector;
import com.ice.cvsc.CVSFileException;
import com.ice.cvsc.CVSIgnore;
import com.ice.cvsc.CVSLog;
import com.ice.cvsc.CVSNotifyItem;
import com.ice.cvsc.CVSProjectDef;
import com.ice.cvsc.CVSRequest;
import com.ice.cvsc.CVSRespItemVector;
import com.ice.cvsc.CVSResponse;
import com.ice.cvsc.CVSResponseHandler;
import com.ice.cvsc.CVSResponseItem;
import com.ice.cvsc.CVSScramble;
import com.ice.cvsc.CVSTimestamp;
import com.ice.cvsc.CVSTimestampFormat;
import com.ice.cvsc.CVSTracer;
import com.ice.cvsc.CVSUserInterface;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class CVSProject
implements CVSResponseHandler {
    public static final String RCS_ID = "$Id: CVSProject.java,v 2.26 2003/07/27 01:08:32 time Exp $";
    public static final String RCS_REV = "$Revision: 2.26 $";
    private static final String INFO_PREFIX = "#   ";
    private static final String ERROR_PREFIX = "*** ";
    private static final String NOTICE_PREFIX = "==> ";
    public static boolean overTraceRequest = false;
    public static boolean overTraceResponse = false;
    public static boolean overTraceProcessing = false;
    public static boolean overTraceTCP = false;
    public static boolean deepDebug = false;
    public static boolean debugEntryIO = false;
    private boolean valid;
    private boolean isPServer;
    private boolean allowGzipFileMode;
    private int gzipStreamLevel;
    private int connMethod;
    private int connPort;
    private String serverCommand;
    private String rshProcess;
    private String userName;
    private String password;
    private String tempPath;
    private String repository;
    private String rootDirectory;
    private String localRootDirectory;
    private String[] setVars;
    private File localRootDirFile;
    private File localAdminDirFile;
    private CVSClient client;
    private CVSIgnore ignore;
    private CVSProjectDef projectDef;
    private CVSEntry rootEntry;
    private Hashtable pathTable;

    public static boolean isValidAdminPath(String dirName) {
        if (!CVSCUtilities.caseSensitivePathNames()) {
            dirName = dirName.toUpperCase();
            CVSTracer.traceIf(deepDebug, "CVSProject.isValidAdminPath:\n   adjusted dirName to '" + dirName + "'");
        }
        return dirName.endsWith("/CVS") || dirName.endsWith("/CVS/");
    }

    public static String rootPathToAdminPath(String dirName) {
        return dirName + (dirName.endsWith("/") ? "" : "/") + "CVS";
    }

    public static String adminPathToRootPath(String dirName) {
        int index;
        String path = dirName;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((index = path.lastIndexOf(47)) < 0) {
            return path;
        }
        return path.substring(0, index);
    }

    public static String entriesPathToAdminPath(String entriesPath) {
        int index = entriesPath.lastIndexOf(47);
        if (index < 0) {
            return null;
        }
        return entriesPath.substring(0, index);
    }

    public static boolean verifyAdminDirectory(String dirName) {
        CVSTracer.traceIf(deepDebug || debugEntryIO, "CVSProject.verifyAdminDirectory:\n   dirName = '" + dirName + "'");
        if (!CVSProject.isValidAdminPath(dirName)) {
            CVSTracer.traceIf(deepDebug || debugEntryIO, "CVSProject.verifyAdminDirectory:\n   IS NOT a valid admin directory.");
            return false;
        }
        File file = new File(dirName = CVSCUtilities.exportPath(CVSCUtilities.stripFinalSlash(dirName)), "Entries");
        if (!file.exists()) {
            CVSTracer.traceIf(deepDebug || debugEntryIO, "CVSProject.verifyAdminDirectory:\n   DOES NOT EXIST --> 'Entries'.");
            return false;
        }
        file = new File(dirName, "Repository");
        if (!file.exists()) {
            CVSTracer.traceIf(deepDebug || debugEntryIO, "CVSProject.verifyAdminDirectory:\n   DOES NOT EXIST --> 'Repository'.");
            return false;
        }
        file = new File(dirName, "Root");
        if (!file.exists()) {
            CVSTracer.traceIf(deepDebug || debugEntryIO, "CVSProject.verifyAdminDirectory:\n   DOES NOT EXIST --> 'Root'.");
            return false;
        }
        return true;
    }

    public static String getAdminEntriesPath(String adminDirPath) {
        return adminDirPath + "/Entries";
    }

    public static String getAdminRepositoryPath(String adminDirPath) {
        return adminDirPath + "/Repository";
    }

    public static String getAdminRootPath(String adminDirPath) {
        return adminDirPath + "/Root";
    }

    public static String getAdminNotifyPath(String adminDirPath) {
        return adminDirPath + "/Notify";
    }

    public static String getAdminPrefsPath(String adminDirPath) {
        return adminDirPath + "/jcvs.txt";
    }

    public CVSProject() {
        this.initFields();
        this.client = null;
    }

    public CVSProject(CVSClient client) {
        this.initFields();
        this.client = client;
    }

    private void initFields() {
        this.valid = false;
        this.isPServer = false;
        this.allowGzipFileMode = true;
        this.gzipStreamLevel = 0;
        this.userName = "";
        this.password = null;
        this.connMethod = 2;
        this.connPort = 2401;
        this.serverCommand = "cvs server";
        this.rshProcess = null;
        this.repository = null;
        this.rootDirectory = null;
        this.localRootDirectory = null;
        this.client = null;
        this.projectDef = null;
        this.setVars = null;
        this.ignore = new CVSIgnore();
        this.rootEntry = null;
        this.pathTable = new Hashtable();
        this.tempPath = null;
        this.localRootDirFile = null;
        this.localAdminDirFile = null;
    }

    public CVSClient getClient() {
        return this.client;
    }

    public void setClient(CVSClient client) {
        this.client = client;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public boolean isPServer() {
        return this.isPServer;
    }

    public void setPServer(boolean isPServer) {
        this.isPServer = isPServer;
    }

    public boolean allowsGzipFileMode() {
        return this.allowGzipFileMode;
    }

    public void setAllowsGzipFileMode(boolean allow) {
        this.allowGzipFileMode = allow;
    }

    public int getGzipStreamLevel() {
        return this.gzipStreamLevel;
    }

    public void setGzipStreamLevel(int level) {
        this.gzipStreamLevel = level;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String name) {
        this.userName = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(String rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public String getLocalRootPath() {
        return this.localRootDirectory;
    }

    public String getLocalRootDirectory() {
        return this.localRootDirectory;
    }

    public void setLocalRootDirectory(String dirName) {
        this.localRootDirectory = dirName;
        this.localRootDirFile = new File(dirName);
        this.localAdminDirFile = new File(dirName + "/CVS");
    }

    public String getTempDirectory() {
        return this.tempPath;
    }

    public void setTempDirectory(String dirName) {
        this.tempPath = dirName;
        if (this.client != null) {
            this.client.setTempDirectory(dirName);
        }
    }

    public int getConnectionPort() {
        return this.connPort;
    }

    public void setConnectionPort(int port) {
        this.connPort = port;
    }

    public int getConnectionMethod() {
        return this.connMethod;
    }

    public void setConnectionMethod(int method) {
        this.connMethod = method;
    }

    public boolean isSSHServer() {
        return this.connMethod == 3;
    }

    public String getServerCommand() {
        return this.serverCommand;
    }

    public void setServerCommand(String command) {
        this.serverCommand = command;
    }

    public String getRshProcess() {
        return this.rshProcess;
    }

    public void setRshProcess(String rshProcess) {
        this.rshProcess = rshProcess;
    }

    public String[] getSetVariables() {
        return this.setVars;
    }

    public void setSetVariables(String[] vars) {
        this.setVars = vars;
    }

    public CVSEntry getRootEntry() {
        return this.rootEntry;
    }

    public CVSProjectDef getProjectDef() {
        return this.projectDef;
    }

    public void setProjectDef(CVSProjectDef projectDef) {
        this.projectDef = projectDef;
    }

    public File getEntryFile(CVSEntry entry) {
        String relPath = entry.getFullName();
        File file = new File(CVSCUtilities.exportPath(this.localRootDirFile.getPath()), CVSCUtilities.exportPath(entry.getFullPathName()));
        if (deepDebug) {
            CVSTracer.traceIf(false, "CVSProject.getEntryFile: relPath '" + relPath + "' localRootDir '" + this.localRootDirFile.getPath() + "' result '" + file.getPath() + "'");
        }
        return file;
    }

    public boolean hasValidLogin(String userName) {
        return this.userName.equals(userName) && this.password != null;
    }

    public void addEntryNotify(CVSEntryVector entries, String type, String options) {
        PrintWriter out;
        String fileName = CVSProject.getAdminNotifyPath(CVSProject.rootPathToAdminPath(this.getLocalRootPath()));
        try {
            out = new PrintWriter(new FileWriter(fileName, true));
        }
        catch (IOException ex) {
            CVSTracer.traceWithStack("ERROR opening Notification file '" + fileName + "' for append");
            return;
        }
        CVSTimestamp now = new CVSTimestamp();
        CVSTimestampFormat stamper = CVSTimestampFormat.getInstance();
        String stampStr = stamper.format(now);
        int eIdx = 0;
        while (entries != null && eIdx < entries.size()) {
            CVSEntry entry = entries.entryAt(eIdx);
            if (entry != null) {
                out.println(type + entry.getName() + "\t" + stamper.format(now) + " GMT" + "\t" + "remote.via.jCVS" + "\t" + entry.getLocalDirectory() + "\t" + options);
            } else {
                CVSTracer.traceWithStack("NULL ENTRY[" + eIdx + "] on index '" + eIdx + "'");
            }
            ++eIdx;
        }
        out.flush();
        out.close();
    }

    public void includeNotifies(CVSRequest request) {
        block9: {
            BufferedReader in;
            request.notifies = new Vector();
            if (this.rootEntry == null) {
                return;
            }
            File notFile = new File(CVSProject.getAdminNotifyPath(CVSProject.rootPathToAdminPath(this.getLocalRootPath())));
            if (!notFile.exists()) break block9;
            try {
                in = new BufferedReader(new FileReader(notFile));
            }
            catch (IOException ex) {
                CVSLog.logMsg("ERROR opening Notification file '" + notFile.getPath() + "'");
                return;
            }
            while (true) {
                String noteLine;
                try {
                    noteLine = in.readLine();
                }
                catch (IOException ex) {
                    CVSLog.logMsg("ERROR reading Notification file '" + notFile.getPath() + "'");
                    noteLine = null;
                }
                if (noteLine == null) break;
                CVSNotifyItem notifyItem = this.parseNotifyLine(noteLine = noteLine.trim());
                if (notifyItem != null) {
                    request.notifies.addElement(notifyItem);
                    continue;
                }
                CVSLog.logMsg("ERROR bad 'CVS/Notify' line:\n   " + noteLine);
            }
            try {
                in.close();
            }
            catch (IOException ex) {}
        }
    }

    public boolean verifyPassword(CVSUserInterface ui, String userName, String password, boolean trace) {
        boolean result = false;
        if (!this.isPServer() && !this.isSSHServer()) {
            return true;
        }
        if (this.hasValidLogin(userName)) {
            return true;
        }
        String scrambled = CVSScramble.scramblePassword(password, 'A');
        CVSRequest request = new CVSRequest();
        request.setPServer(this.isPServer());
        request.setUserName(userName);
        request.setPassword(this.isSSHServer() ? password : scrambled);
        request.setPort(this.getClient().getPort());
        request.setHostName(this.getClient().getHostName());
        request.setRepository(this.repository);
        request.setRootDirectory(this.rootDirectory);
        request.setLocalDirectory(this.localRootDirectory);
        request.verificationOnly = true;
        request.traceRequest = trace;
        request.traceResponse = trace;
        request.traceProcessing = trace;
        request.traceTCPData = trace;
        request.allowGzipFileMode = this.allowGzipFileMode;
        request.gzipStreamLevel = this.gzipStreamLevel;
        request.setConnectionMethod(this.getConnectionMethod());
        request.setServerCommand(this.getServerCommand());
        request.setRshProcess(this.getRshProcess());
        request.setUserInterface(ui);
        CVSResponse response = this.client.processCVSRequest(request);
        if (response.getStatus() == 0) {
            result = true;
            this.setUserName(userName);
            this.setPassword(this.isSSHServer() ? password : scrambled);
            response.appendStdout("Authentication of '" + userName + "' succeeded.\n");
        } else {
            result = false;
            this.password = null;
            response.appendStdout("Authentication of '" + userName + "' failed.\n");
        }
        if (ui != null && response != null) {
            ui.uiDisplayResponse(response);
        }
        if (response != null && !request.saveTempFiles) {
            response.deleteTempFiles();
        }
        return result;
    }

    CVSEntry getPathIgnoringCase(String subPath) {
        Enumeration enumeration = this.pathTable.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.equalsIgnoreCase(subPath)) continue;
            return (CVSEntry)this.pathTable.get(key);
        }
        return null;
    }

    public CVSEntry getDirEntryForLocalDir(String localDir) {
        return this.getPathTableEntry(localDir);
    }

    private CVSEntry getPathTableEntry(String path) {
        CVSEntry result = null;
        result = (CVSEntry)this.pathTable.get(path);
        if (result == null && !CVSCUtilities.caseSensitivePathNames()) {
            result = this.getPathIgnoringCase(path);
            if (deepDebug) {
                CVSTracer.traceIf(true, "getPathTableEntry: CASE INsensitive TABLE CHECK\n   result    '" + (result == null ? "(null)" : result.getName()) + "'\n" + "   reposirory  '" + (result != null ? result.getRepository() : "null") + "'");
            }
        }
        return result;
    }

    private CVSEntry reversePathTableEntry(String repository) {
        CVSEntry result = null;
        Enumeration enumeration = this.pathTable.keys();
        boolean match = false;
        while (!match && enumeration.hasMoreElements()) {
            String localDir = (String)enumeration.nextElement();
            CVSEntry tblEntry = (CVSEntry)this.pathTable.get(localDir);
            match = CVSCUtilities.caseSensitivePathNames() ? repository.equals(tblEntry.getRepository()) : repository.equalsIgnoreCase(tblEntry.getRepository());
            if (!match) continue;
            result = tblEntry;
        }
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.reversePathTableEntry:\n   repository = '" + repository + "'\n" + "   RESULT =\n" + (result == null ? "(null)" : result.dumpString("   ")));
        }
        return result;
    }

    public CVSResponse ensureRepositoryPath(CVSUserInterface ui, String localDirectory, CVSResponse resultResp) {
        CVSTracer.traceIf(deepDebug, "CVSProject.ensureRepositoryPath: \n   localDirectory '" + localDirectory + "'");
        CVSEntryVector entries = new CVSEntryVector();
        entries.appendEntry(null);
        entries.appendEntry(null);
        CVSTracer.traceIf(deepDebug, "ensureRepositoryPath: ROOT =\n   " + this.rootEntry.dumpString());
        String repository = this.rootEntry.getRepository();
        CVSTracer.traceIf(deepDebug, "ensureRepositoryPath: rootEntry repository = '" + repository + "'");
        resultResp.setStatus(0);
        CVSEntry parentEntry = this.rootEntry;
        int offset = 2;
        while (true) {
            String out;
            int index = localDirectory.indexOf(47, offset);
            CVSTracer.traceIf(deepDebug, "ensureRepositoryPath: indexOf( '/'," + offset + " ) = " + index);
            if (index < 0) {
                CVSTracer.traceIf(deepDebug, "ensureRepositoryPath: DONE w/ REMAINDER '" + localDirectory.substring(offset) + "'");
                break;
            }
            offset = index + 1;
            String localDir = localDirectory.substring(0, index + 1);
            CVSEntry dirEntry = this.getPathTableEntry(localDir);
            CVSTracer.traceIf(deepDebug, "ensureRepositoryPath: localDir '" + localDir + "' returns " + (dirEntry == null ? "null" : dirEntry.dumpString()));
            if (dirEntry != null) {
                if (deepDebug) {
                    CVSTracer.traceIf(true, "ensureRepositoryPath: EXISTING DIRECTORY '" + localDir + "'\n" + "   localDir    '" + dirEntry.getLocalDirectory() + "'\n" + "   repository  '" + dirEntry.getRepository() + "'");
                }
                parentEntry = dirEntry;
                continue;
            }
            CVSTracer.traceIf(deepDebug, "ensureRepositoryPath: NEW CVS DIRECTORY '" + localDir + "'\n" + "   Parent LocalDirectory '" + parentEntry.getLocalDirectory() + "'\n" + "   Parent Repository     '" + parentEntry.getRepository() + "'");
            CVSRequest request = new CVSRequest();
            String name = localDir.substring(0, localDir.length() - 1);
            index = name.lastIndexOf(47);
            if (index >= 0 && index < name.length() - 1) {
                name = name.substring(index + 1);
            }
            String rootDir = CVSCUtilities.ensureFinalSlash(this.getRootDirectory());
            dirEntry = new CVSEntry();
            dirEntry.setName(name);
            dirEntry.setLocalDirectory(localDir);
            dirEntry.setRepository(parentEntry.getRepository() + "/" + name);
            dirEntry.setDirectoryEntryList(new CVSEntryVector());
            entries.setElementAt(parentEntry, 0);
            entries.setElementAt(dirEntry, 1);
            request.setEntries(entries);
            CVSTracer.traceIf(deepDebug, "ensureRepositoryPath: DIR ENTRY\n   Name       " + dirEntry.getName() + "\n" + "   LocalDir   " + dirEntry.getLocalDirectory() + "\n" + "   Repository " + dirEntry.getRepository());
            CVSTracer.traceIf(deepDebug, "ensureRepositoryPath: PARENT ENTRY\n   Name       " + parentEntry.getName() + "\n" + "   LocalDir   " + parentEntry.getLocalDirectory() + "\n" + "   Reposirory " + parentEntry.getRepository());
            request.execInCurDir = true;
            request.setDirEntry(parentEntry);
            request.sendEntries = true;
            request.sendArguments = true;
            request.sendEntryFiles = false;
            request.traceRequest = true;
            request.traceResponse = true;
            request.traceTCPData = true;
            request.traceProcessing = true;
            request.allowGzipFileMode = this.allowGzipFileMode;
            request.gzipStreamLevel = this.gzipStreamLevel;
            request.setUserName(this.userName);
            request.setPServer(this.isPServer());
            if (this.isPServer() || this.isSSHServer()) {
                request.setPassword(this.password);
            }
            request.setPort(this.getClient().getPort());
            request.setHostName(this.getClient().getHostName());
            request.setRshProcess(this.getRshProcess());
            request.setPort(this.getConnectionPort());
            request.setConnectionMethod(this.getConnectionMethod());
            request.setRepository(this.repository);
            request.setRootRepository(this.rootEntry.getRepository());
            request.setRootDirectory(this.rootDirectory);
            request.setLocalDirectory(this.localRootDirectory);
            request.setServerCommand(this.getServerCommand());
            request.setSetVariables(this.setVars);
            this.establishNewDirSticky(request, dirEntry);
            this.establishStickys(request);
            this.establishStatics(request);
            request.setCommand("add");
            request.setUserInterface(ui == null ? (CVSUserInterface)((Object)this) : ui);
            request.includeNotifies = false;
            request.queueResponse = true;
            CVSArgumentVector arguments = new CVSArgumentVector();
            arguments.appendArgument(name);
            request.setArguments(arguments);
            CVSResponse response = this.client.processCVSRequest(request);
            response.deleteTempFiles();
            String err = response.getStderr();
            if (err != null && err.length() > 0) {
                resultResp.appendStderr(err);
            }
            if ((out = response.getStdout()) != null && out.length() > 0) {
                resultResp.appendStdout(out);
            }
            if (response.getStatus() == 0) {
                CVSTracer.traceIf(deepDebug, "ensureRepositoryPath: ensureEntryHierarchy( " + dirEntry.getLocalDirectory() + ", " + dirEntry.getRepository() + " )");
                this.ensureEntryHierarchy(dirEntry.getLocalDirectory(), dirEntry.getRepository());
                dirEntry = this.getPathTableEntry(localDir);
                if (dirEntry == null) {
                    CVSTracer.traceWithStack("WHAT?! ensured, but no pathTable entry '" + localDir + "'?!?!");
                } else {
                    dirEntry.setDirty(true);
                }
            } else {
                resultResp.setStatus(1);
                resultResp.appendStdOut(response.getStdout());
                resultResp.appendStdErr(response.getStderr());
                if (request.getUserInterface() != null) {
                    request.getUserInterface().uiDisplayResponse(resultResp);
                }
                CVSTracer.traceIf(true, "ensureRepositoryPath: ERROR! SERVER RESPONSE:\n" + response.getStderr() + "\n" + response.getStdout());
                break;
            }
            this.ensureProperWorkingDirectory(this.localRootDirectory, localDir, true);
            repository = repository + "/" + name;
        }
        return resultResp;
    }

    private String getStickyTagspec(CVSEntry entry) {
        String result = "";
        String rootPath = CVSProject.rootPathToAdminPath(this.getLocalRootDirectory() + "/" + entry.getLocalPathName());
        File stickyFile = new File(rootPath, "Tag");
        if (stickyFile.exists()) {
            try {
                result = CVSCUtilities.readStringFile(stickyFile);
            }
            catch (IOException ex) {
                result = "";
            }
            if (!(result.startsWith("D") || result.startsWith("T") || result.startsWith("N"))) {
                result = "";
            }
        }
        return result;
    }

    public void establishNewDirSticky(CVSRequest request, CVSEntry entry) {
        Hashtable<String, String> stickys = request.getStickys();
        if (stickys == null) {
            stickys = new Hashtable<String, String>();
        }
        String localDir = entry.getLocalDirectory();
        String parentDir = CVSCUtilities.getLocalParent(localDir);
        String rootPath = CVSProject.rootPathToAdminPath(this.getLocalRootDirectory() + "/" + parentDir);
        String tagSpec = "";
        File stickyFile = new File(rootPath, "Tag");
        if (stickyFile.exists()) {
            try {
                tagSpec = CVSCUtilities.readStringFile(stickyFile);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (tagSpec.length() > 0) {
            rootPath = CVSProject.rootPathToAdminPath(this.getLocalRootDirectory() + "/" + localDir);
            File adminDir = new File(rootPath);
            adminDir.mkdirs();
            stickyFile = new File(rootPath, "Tag");
            try {
                if (!stickyFile.exists()) {
                    CVSCUtilities.writeStringFile(stickyFile, tagSpec);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        stickys.put(localDir, tagSpec);
        stickys.put(parentDir, tagSpec);
        request.setStickys(stickys);
    }

    public void establishStickys(CVSRequest request) {
        Hashtable<String, String> stickys = new Hashtable<String, String>();
        CVSEntryVector entries = request.getEntries();
        int i = 0;
        int sz = entries.size();
        while (i < sz) {
            CVSEntry entry = (CVSEntry)entries.elementAt(i);
            String localDir = entry.getLocalDirectory();
            if (stickys.get(localDir) == null) {
                String tagSpec = this.getStickyTagspec(entry);
                stickys.put(localDir, tagSpec);
            }
            ++i;
        }
        if (stickys.size() > 0) {
            request.setStickys(stickys);
        }
    }

    private boolean isStaticDirectory(CVSEntry entry) {
        String rootPath = CVSProject.rootPathToAdminPath(this.getLocalRootDirectory() + "/" + entry.getLocalPathName());
        File staticFile = new File(rootPath, "Entries.static");
        return staticFile.exists();
    }

    public void establishStatics(CVSRequest request) {
        Hashtable<String, String> statics = new Hashtable<String, String>();
        CVSEntryVector entries = request.getEntries();
        int i = 0;
        int sz = entries.size();
        while (i < sz) {
            CVSEntry entry = (CVSEntry)entries.elementAt(i);
            String localDir = entry.getLocalDirectory();
            if (statics.get(localDir) == null && this.isStaticDirectory(entry)) {
                statics.put(localDir, "");
            }
            ++i;
        }
        if (statics.size() > 0) {
            request.setStatics(statics);
        }
    }

    public boolean performCVSRequest(CVSRequest request) {
        return this.performCVSRequest(request, new CVSResponse());
    }

    public boolean performCVSRequest(CVSRequest request, CVSResponse response) {
        boolean result = true;
        request.setUserName(this.userName);
        request.setPServer(this.isPServer());
        if (this.isPServer() || this.isSSHServer()) {
            request.setPassword(this.password);
        }
        String rootRepository = this.rootEntry != null ? this.rootEntry.getRepository() : (this.repository.equals(".") ? this.rootDirectory : this.rootDirectory + "/" + this.repository);
        request.setHostName(this.getClient().getHostName());
        request.setRepository(this.repository);
        request.setRootRepository(rootRepository);
        request.setRootDirectory(this.rootDirectory);
        request.setLocalDirectory(this.localRootDirectory);
        request.setPort(this.getConnectionPort());
        request.setConnectionMethod(this.getConnectionMethod());
        request.setServerCommand(this.getServerCommand());
        request.setRshProcess(this.getRshProcess());
        request.setSetVariables(this.setVars);
        this.establishStickys(request);
        this.establishStatics(request);
        if (request.includeNotifies) {
            this.includeNotifies(request);
        }
        if (!request.queueResponse && request.responseHandler == null) {
            request.responseHandler = this;
        }
        if (overTraceRequest) {
            request.traceRequest = overTraceRequest;
        }
        if (overTraceResponse) {
            request.traceResponse = overTraceResponse;
        }
        if (overTraceProcessing) {
            request.traceProcessing = overTraceProcessing;
        }
        if (overTraceTCP) {
            request.traceTCPData = overTraceTCP;
        }
        request.allowGzipFileMode = this.allowGzipFileMode;
        request.gzipStreamLevel = this.gzipStreamLevel;
        if (!request.verifyRequest()) {
            CVSLog.logMsg("CVSProject.performCVSRequest: BAD CVSRequest: '" + request.getVerifyFailReason() + "'");
            return false;
        }
        this.client.processCVSRequest(request, response);
        this.processCVSResponse(request, response);
        if (request.getCommand().equals("update") && (request.getArguments().containsArgument("-P") || request.getArguments().containsArgument("-r") || request.getArguments().containsArgument("-D"))) {
            this.pruneEmptySubDirs(request.handleEntries);
        }
        if (request.getUserInterface() != null && response != null) {
            request.getUserInterface().uiDisplayResponse(response);
        }
        if (response != null && !request.saveTempFiles) {
            response.deleteTempFiles();
        }
        return response.getStatus() == 0;
    }

    public CVSEntry entryLineToEntry(String entryLine) {
        CVSEntry entry = new CVSEntry();
        try {
            entry.parseEntryLine(entryLine, true);
        }
        catch (ParseException ex) {
            entry = null;
            CVSLog.traceMsg(ex, "CVSProject.entryFromEntryLine: ERROR could not process entry line '" + entryLine);
        }
        return entry;
    }

    public File getLocalEntryFile(CVSEntry entry) {
        File result = new File(CVSCUtilities.exportPath(this.localRootDirectory), CVSCUtilities.exportPath(entry.getFullPathName()));
        return result;
    }

    public String normalizeLocalDirectory(String pathName, String repository) {
        String result = pathName;
        if (pathName.equals("./")) {
            CVSTracer.traceIf(deepDebug, "normalizeLocalDirectory: SPECIAL './' CASE.\n    pathName '" + pathName + "'\n" + "  repository '" + repository + "'");
            CVSEntry revEntry = this.reversePathTableEntry(repository);
            if (revEntry != null) {
                result = revEntry.getLocalDirectory();
            } else {
                result = null;
                CVSTracer.traceIf(true, "COULD NOT RESOLVE '" + pathName + "' with '" + repository + "'");
                CVSTracer.traceWithStack("COULD NOT RESOLVE '" + pathName + "' with '" + repository + "'");
            }
        }
        CVSTracer.traceIf(deepDebug, "normalizeLocalDirectory: RESULT '" + pathName + "' ---> '" + result + "'");
        return result;
    }

    public CVSEntry createItemEntry(CVSResponseItem item) {
        String entryLine = item.getEntriesLine();
        CVSTracer.traceIf(deepDebug, "createItemEntry:\n   item.getPathName    '" + item.getPathName() + "'\n" + "   item.repositoryName '" + item.getRepositoryName() + "'\n" + "   item.getEntriesLine '" + item.getEntriesLine() + "'");
        CVSEntry entry = entryLine == null ? new CVSEntry() : this.entryLineToEntry(item.getEntriesLine());
        if (entry != null) {
            String repos = item.getRepositoryName();
            int index = repos.lastIndexOf(47);
            if (index < 0) {
                CVSTracer.traceWithStack("CVSProject.createItemEntry: ERROR repository '" + repos + "' has no slash!");
                entry.setName(repos);
                entry.setRepository("");
            } else {
                entry.setName(repos.substring(index + 1));
                entry.setRepository(repos.substring(0, index));
            }
            String localDir = this.normalizeLocalDirectory(item.getPathName(), entry.getRepository());
            entry.setLocalDirectory(localDir);
        }
        return entry;
    }

    public boolean handleResponseItem(CVSRequest request, CVSResponse response, CVSResponseItem item) {
        CVSTracer.traceIf(request.traceProcessing, "CVSProject.handleResponseItem:\n   " + item.toString());
        boolean result = this.processResponseItem(request, response, item);
        if (!request.saveTempFiles) {
            item.deleteFile();
        }
        return result;
    }

    public boolean processCVSResponse(CVSRequest request, CVSResponse response) {
        Object entry = null;
        boolean result = true;
        Object localFile = null;
        CVSResponseItem item = null;
        if (response == null) {
            return true;
        }
        CVSRespItemVector items = response.getItemList();
        int idx = 0;
        while (result && idx < items.size()) {
            item = items.itemAt(idx);
            CVSTracer.traceIf(request.traceProcessing, "CVSResponse: item[" + idx + "] type '" + item.getType() + "'");
            result = this.processResponseItem(request, response, item);
            ++idx;
        }
        if (response.getStatus() != 0) {
            if (request.traceProcessing) {
                CVSTracer.traceIf(true, "CVSProject.processCVSResponse: ERROR errorCode '" + response.getErrorCode() + "' errorText '" + response.getErrorText() + "'");
            }
            if (response.getErrorCode().length() > 0 || response.getErrorText().length() > 0) {
                response.appendStderr("\nError Code '" + response.getErrorCode() + "'" + " Message '" + response.getErrorText() + "'\n");
            }
        } else {
            CVSTracer.traceIf(request.traceProcessing, "CVSProject.processCVSResponse: OK");
            if (request.handleEntries) {
                this.writeAdminFiles();
            }
        }
        if (request.ignoreResult) {
            response.setStatus(0);
        }
        return result;
    }

    private boolean processResponseItem(CVSRequest request, CVSResponse response, CVSResponseItem item) {
        CVSEntry entry = null;
        boolean result = true;
        File localFile = null;
        if (item.getPathName().endsWith("./")) {
            item.setPathName(item.getPathName().substring(0, item.getPathName().length() - 2));
            CVSTracer.traceIf(deepDebug, "\nPROCESSResponseItem: STRIPPED FINAL './' CASE\n   item.pathName = '" + item.getPathName() + "'");
        }
        if (!item.getPathName().startsWith("./")) {
            String itemRepos = item.getRepositoryName();
            int slashIdx = itemRepos.lastIndexOf("/");
            if (slashIdx != -1) {
                itemRepos = itemRepos.substring(0, slashIdx);
            }
            CVSEntry hackEntry = this.reversePathTableEntry(itemRepos);
            CVSTracer.traceIf(deepDebug, "\nPROCESSResponseItem: APPLY ITEM PATHNAME HACK\n   item.pathName = '" + item.getPathName() + "'\n" + "   item.repos    = '" + item.getRepositoryName() + "'\n" + " lookup repos    = '" + itemRepos + "'\n" + "   pathTable.entry:\n" + (hackEntry == null ? "   NULL" : hackEntry.dumpString("   ")));
            if (hackEntry != null) {
                item.setPathName(hackEntry.getLocalDirectory());
                CVSTracer.traceIf(deepDebug, "\nPROCESSResponseItem: ITEM PATH set to '" + hackEntry.getLocalDirectory() + "'\n");
            } else {
                item.setPathName("./" + item.getPathName());
                CVSTracer.traceIf(deepDebug, "\nPROCESSResponseItem: NO PATH TABLE ENTRY, PREFIX w/ './'\n   ITEM PATH set to '" + item.getPathName() + "'");
            }
        }
        CVSTracer.traceIf(deepDebug, "PROCESSResponseItem:\n   item.getType        '" + item.getType() + "'\n" + "   item.getPathName    '" + item.getPathName() + "'\n" + "   item.repositoryName '" + item.getRepositoryName() + "'\n" + "   item.getModeLine    '" + item.getModeLine() + "'\n" + "   item.getEntriesLine '" + item.getEntriesLine() + "'");
        switch (item.getType()) {
            case 1: {
                CVSTracer.traceIf(request.traceProcessing, "CHECKED_IN: pathName '" + item.getPathName() + "'\n   repository " + item.getRepositoryName() + "'\n   entryLine " + item.getEntriesLine());
                if (!request.handleEntries || (entry = this.createItemEntry(item)) == null) break;
                CVSTracer.traceIf(request.traceProcessing, "CHECKED_IN: entry '" + entry.getFullName() + "'");
                localFile = this.getEntryFile(entry);
                entry.setTimestamp(localFile);
                this.updateEntriesItem(entry);
                break;
            }
            case 10: {
                CVSTracer.traceIf(request.traceProcessing, "NOTIFIED: pathName '" + item.getPathName() + "'\n          repository '" + item.getRepositoryName() + "'");
                this.processNotified(item);
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                CVSTracer.traceIf(request.traceProcessing, "COPY-FILE: pathName '" + item.getPathName() + "'\n           newName '" + item.getNewName() + "'");
                if (this.performCopyFile(item)) break;
                response.appendStderr("ERROR copying file '" + item.getPathName() + "' to '" + item.getNewName() + "'.");
                break;
            }
            case 4: {
                CVSTracer.traceIf(request.traceProcessing, "Clear-sticky: pathName '" + item.getPathName() + "'\n");
                this.setSticky(item, false, request.handleEntries);
                break;
            }
            case 19: {
                CVSTracer.traceIf(request.traceProcessing, "Set-sticky: pathName '" + item.getPathName() + "'\n");
                this.setSticky(item, true, request.handleEntries);
                break;
            }
            case 3: {
                CVSTracer.traceIf(request.traceProcessing, "Clear-static-directory: pathName '" + item.getPathName() + "'\n");
                this.setStaticDirectory(item, false, request.handleEntries);
                break;
            }
            case 18: {
                CVSTracer.traceIf(request.traceProcessing, "Set-static-directory: pathName '" + item.getPathName() + "'\n");
                this.setStaticDirectory(item, true, request.handleEntries);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                CVSTracer.traceIf(request.traceProcessing, "NEW_ENTRY: name '" + item.getPathName() + "' entryLine '" + item.getEntriesLine() + "'");
                if (!request.handleEntries || (entry = this.createItemEntry(item)) == null) break;
                this.updateEntriesItem(entry);
                break;
            }
            case 12: {
                CVSTracer.traceIf(request.traceProcessing, "REMOVED: " + item.getPathName());
                if (!request.handleEntries) break;
                this.removeEntriesItem(item);
                break;
            }
            case 13: {
                CVSTracer.traceIf(request.traceProcessing, "REMOVE_ENTRY: " + item.getPathName());
                if (!request.handleEntries) break;
                this.removeEntriesItem(item);
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                if (!request.handleFlags) break;
                request.setCheckInProgram(item.getPathName());
                break;
            }
            case 20: {
                if (!request.handleFlags) break;
                request.setUpdateProgram(item.getPathName());
                break;
            }
            case 11: {
                CVSTracer.traceIf(true, "CVSProject.CVSResponseItem.PATCHED '" + item.getEntriesLine() + "' " + "PATCHED currently unimplemented.\n" + "WE SHOULD NOT BE GETTING THIS!!!");
                response.appendStderr("The 'Patched' response is not implemented:\n    '" + item.getEntriesLine() + "'");
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                if (!request.handleUpdated) break;
                String cmdName = item.getType() == 6 ? "Created" : (item.getType() == 7 ? "Merged" : (item.getType() == 14 ? "Updated" : "Updated existing"));
                entry = this.createItemEntry(item);
                if (entry != null) {
                    boolean isInConflict = entry.isInConflict();
                    boolean ok = this.ensureEntryHierarchy(item.getPathName(), item.getRepositoryPath());
                    localFile = this.getEntryFile(entry);
                    if (ok) {
                        ok = this.ensureLocalTree(localFile, request.handleEntries);
                    }
                    if (localFile.exists()) {
                        entry.setTimestamp(localFile);
                    }
                    if (ok) {
                        request.getUserInterface().uiDisplayProgressMsg(cmdName + " local file '" + localFile.getPath() + "'.");
                        ok = this.updateLocalFile(item, entry, localFile);
                    }
                    if (ok) {
                        if (isInConflict) {
                            entry.setConflict(localFile);
                        } else if (item.getType() == 7) {
                            entry.setTimestamp("Result of merge");
                        } else {
                            entry.setTimestamp(localFile);
                        }
                        if (!request.handleEntries) break;
                        this.updateEntriesItem(entry);
                        break;
                    }
                    CVSLog.logMsg("CVSResponse: ERROR merging local file '" + entry.getFullName() + "'");
                    response.appendStderr("ERROR failed updating local file '" + localFile.getPath() + "'.");
                    result = false;
                    break;
                }
                CVSLog.logMsg("CVSResponse: ERROR creating item entry '" + item.toString() + "'");
                result = false;
            }
        }
        return result;
    }

    public boolean performCopyFile(CVSResponseItem item) {
        boolean result = true;
        CVSEntry entry = this.createItemEntry(item);
        if (entry != null) {
            File fromFile = this.getEntryFile(entry);
            entry.setName(item.getNewName());
            File toFile = this.getEntryFile(entry);
            if (fromFile.exists()) {
                result = this.copyFileRaw(fromFile, toFile, item.isGZIPed());
                if (!result) {
                    CVSLog.logMsg("CVSProject.performCopyFile: ERROR renaming '" + fromFile.getPath() + "' to '" + toFile.getPath() + "'");
                }
            } else {
                CVSLog.logMsg("CVSProject.performCopyFile: file '" + fromFile.getPath() + "' does not exist!");
            }
        } else {
            CVSTracer.traceWithStack("WHY is this entry NULL?! item '" + item.toString() + "'");
        }
        return result;
    }

    public boolean setSticky(CVSResponseItem item, boolean isSet, boolean writeFile) {
        String localDir = this.normalizeLocalDirectory(item.getPathName(), item.getRepositoryPath());
        boolean result = this.ensureEntryHierarchy(localDir, item.getRepositoryPath());
        if (result) {
            result = this.ensureProperWorkingDirectory(this.localRootDirectory, localDir, writeFile);
        }
        if (result && writeFile) {
            CVSEntry entry = this.createItemEntry(item);
            if (entry != null) {
                entry.setName("CVS/Tag");
                File file = this.getEntryFile(entry);
                if (isSet) {
                    if (!file.exists()) {
                        try {
                            CVSCUtilities.writeStringFile(file, item.getTagSpec());
                        }
                        catch (IOException ex) {
                            CVSTracer.traceWithStack("ERROR writing sticky tag file '" + file.getPath() + "', " + ex.getMessage());
                        }
                    }
                } else if (file.exists()) {
                    file.delete();
                }
            }
        } else if (!result) {
            CVSTracer.traceWithStack("ensureEntryHierarchy( '" + item.getPathName() + "', '" + item.getRepositoryPath() + "' ) FAILED");
        }
        return result;
    }

    public boolean setStaticDirectory(CVSResponseItem item, boolean isSet, boolean writeFile) {
        boolean result = this.ensureEntryHierarchy(item.getPathName(), item.getRepositoryPath());
        if (result) {
            result = this.ensureProperWorkingDirectory(this.localRootDirectory, this.normalizeLocalDirectory(item.getPathName(), item.getRepositoryPath()), writeFile);
        }
        if (result && writeFile) {
            CVSEntry entry = this.createItemEntry(item);
            if (entry != null) {
                entry.setName("CVS/Entries.static");
                File file = this.getEntryFile(entry);
                if (isSet) {
                    if (!file.exists()) {
                        CVSCUtilities.createEmptyFile(file);
                    }
                } else if (file.exists()) {
                    file.delete();
                }
            }
        } else if (!result) {
            CVSTracer.traceWithStack("ensureEntryHierarchy( '" + item.getPathName() + "', '" + item.getRepositoryPath() + "' ) FAILED");
        }
        return result;
    }

    public CVSNotifyItem parseNotifyLine(String notifyLine) {
        CVSNotifyItem result = null;
        String notType = notifyLine.substring(0, 1);
        StringTokenizer toker = new StringTokenizer(notifyLine = notifyLine.substring(1), "\t");
        int count = toker.countTokens();
        if (count > 3) {
            CVSEntry entry;
            String name = null;
            String time = null;
            String host = null;
            String wdir = null;
            String watches = null;
            try {
                name = toker.nextToken();
                time = toker.nextToken();
                host = toker.nextToken();
                wdir = toker.nextToken();
            }
            catch (NoSuchElementException ex) {
                name = null;
            }
            try {
                watches = toker.nextToken();
            }
            catch (NoSuchElementException ex) {
                watches = null;
            }
            if (name != null && time != null && host != null && wdir != null && (entry = (CVSEntry)this.pathTable.get(wdir)) != null) {
                result = new CVSNotifyItem(notType, name, time, host, wdir, watches == null ? "" : watches, entry.getRepository());
            }
        }
        return result;
    }

    protected boolean processNotified(CVSResponseItem item) {
        PrintWriter write;
        BufferedReader read;
        boolean result = true;
        CVSEntry entry = this.createItemEntry(item);
        String itemPath = entry.getFullName();
        String fileName = CVSProject.getAdminNotifyPath(CVSProject.rootPathToAdminPath(this.getLocalRootPath()));
        File notFile = new File(fileName);
        File tmpFile = new File(fileName + ".tmp");
        try {
            read = new BufferedReader(new FileReader(notFile));
            write = new PrintWriter(new FileWriter(tmpFile));
        }
        catch (IOException ex) {
            String msg = "ERROR opening Notification file '" + fileName + "' for Notified response.";
            CVSLog.logMsg(msg);
            CVSTracer.traceWithStack(msg);
            return false;
        }
        int count = 0;
        boolean chk = true;
        while (true) {
            String inline;
            try {
                inline = read.readLine();
            }
            catch (IOException ex) {
                String msg = "ERROR reading Notification file during Notified response.";
                CVSLog.logMsg(msg);
                CVSTracer.traceWithStack(msg);
                inline = null;
            }
            if (inline == null) break;
            if (!chk) {
                write.println(inline);
                ++count;
                continue;
            }
            CVSNotifyItem notifyItem = this.parseNotifyLine(inline);
            if (notifyItem != null) {
                String fullName = notifyItem.getWorkingDirectory() + notifyItem.getName();
                if (itemPath.equals(fullName)) continue;
                write.println(inline);
                chk = false;
                ++count;
                continue;
            }
            CVSLog.logMsg("ERROR, bad line in 'CVS/Notify':\n   File: '" + fileName + "'\n" + "   Line: " + inline);
        }
        try {
            read.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        write.flush();
        write.close();
        if (result && (result = notFile.delete())) {
            if (count > 0) {
                result = tmpFile.renameTo(notFile);
            } else {
                tmpFile.delete();
            }
        }
        return result;
    }

    public String readRootDirectory(File rootFile) {
        String result = null;
        try {
            result = CVSCUtilities.readStringFile(rootFile);
        }
        catch (IOException ex) {
            result = null;
        }
        return result;
    }

    public String readRepository(File reposFile) {
        String result = null;
        try {
            result = CVSCUtilities.readStringFile(reposFile);
        }
        catch (IOException ex) {
            result = null;
        }
        return result;
    }

    public void establishRootEntry(String repository) {
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.establishRootEntry: repository  '" + repository + "'");
        }
        CVSEntry rootEntry = new CVSEntry();
        rootEntry.setDirty(true);
        rootEntry.setName(".");
        rootEntry.setRepository(repository);
        rootEntry.setLocalDirectory("./");
        rootEntry.setDirectoryEntryList(new CVSEntryVector());
        this.pathTable.put(rootEntry.getLocalDirectory(), rootEntry);
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.establishRootEntry: ROOT ESTABLISHED:\n" + rootEntry.dumpString("   "));
        }
        this.rootEntry = rootEntry;
    }

    public void openProject(File localRootFile) throws IOException {
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.openProject: OPEN PROJECT '" + localRootFile.getPath() + "'");
        }
        File adminDirFile = new File(localRootFile.getPath(), "CVS");
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.openProject: adminDirFile '" + adminDirFile.getPath() + "'");
        }
        if (!adminDirFile.exists()) {
            throw new IOException("admin directory '" + adminDirFile.getPath() + "' does not exist");
        }
        String rootPath = CVSProject.getAdminRootPath(CVSCUtilities.importPath(adminDirFile.getPath()));
        File adminRootFile = new File(CVSCUtilities.exportPath(rootPath));
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.openProject: adminRootFile '" + adminRootFile.getPath() + "'");
        }
        if (!adminRootFile.exists()) {
            throw new IOException("admin Root file '" + adminRootFile.getPath() + "' does not exist");
        }
        String reposPath = CVSProject.getAdminRepositoryPath(adminDirFile.getPath());
        File adminRepositoryFile = new File(reposPath);
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.openProject: adminRepositoryFile '" + adminRepositoryFile.getPath() + "'");
        }
        if (!adminRepositoryFile.exists()) {
            throw new IOException("admin Repository file '" + adminRepositoryFile.getPath() + "' does not exist");
        }
        String rootDirectoryStr = this.readRootDirectory(adminRootFile);
        if (rootDirectoryStr == null) {
            throw new IOException("could not read admin Root file '" + adminRootFile.getPath() + "'");
        }
        String repositoryStr = this.readRepository(adminRepositoryFile);
        if (repositoryStr == null) {
            throw new IOException("could not read admin Repository file '" + adminRepositoryFile.getPath() + "'");
        }
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.openProject: Read Admin directory\n   rootPath   '" + rootPath + "'\n" + "   reposPath  '" + reposPath + "'\n" + "   rootDirStr '" + rootDirectoryStr + "'\n" + "   reposStr   '" + repositoryStr + "'");
        }
        this.projectDef = new CVSProjectDef(rootDirectoryStr, repositoryStr);
        if (!this.projectDef.isValid()) {
            throw new IOException("could not parse project specification, " + this.projectDef.getReason());
        }
        this.isPServer = this.projectDef.isPServer();
        this.connMethod = this.projectDef.getConnectMethod();
        this.userName = this.projectDef.getUserName();
        this.getClient().setHostName(this.projectDef.getHostName());
        rootDirectoryStr = this.projectDef.getRootDirectory();
        if (!repositoryStr.startsWith(rootDirectoryStr)) {
            repositoryStr = rootDirectoryStr + "/" + repositoryStr;
        }
        String localRootStr = CVSCUtilities.importPath(localRootFile.getPath());
        int index = localRootStr.lastIndexOf(47);
        String repos = repositoryStr.substring(rootDirectoryStr.length());
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.openProject: LOCAL ROOT CHECK\n   localRootStr  '" + localRootStr + "'\n" + "   repos         '" + repos + "'");
        }
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.openProject: Establish ROOT\n   localRootStr  '" + localRootStr + "'\n" + "   repositoryStr '" + repositoryStr + "'\n" + "   rootDirStr    '" + rootDirectoryStr + "'\n" + "   repos         '" + repos + "'");
        }
        if (repos.startsWith("/")) {
            repos = repos.substring(1);
        }
        if (repos.length() < 1) {
            repos = ".";
        }
        this.setRepository(repos);
        this.setLocalRootDirectory(localRootStr);
        this.setRootDirectory(rootDirectoryStr);
        this.establishRootEntry(rootDirectoryStr);
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.openProject:\n   Root Directory:  " + this.rootDirectory + "\n" + "   Repository:      " + this.repository + "\n" + "   rootRepos:       " + repositoryStr + "\n" + "   Local Root:      " + this.localRootDirectory + "\n");
        }
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.openProject: ROOT ENTRY\n" + this.rootEntry.dumpString());
        }
        if (!this.readEntries()) {
            throw new IOException("ERROR reading 'Entries' file ");
        }
        if (deepDebug) {
            StringBuffer buf = new StringBuffer();
            this.dumpCVSProject(buf, "Project Open");
            CVSLog.logMsg(buf.toString());
        }
    }

    public void removeAllEntries() {
        this.rootEntry.removeAllEntries();
    }

    public void addNewEntry(CVSEntry entry) {
        if (this.rootEntry == null) {
            CVSTracer.traceWithStack("CVSProject.addNewEntry: NULL ROOT ENTRY!!!!");
        }
        String name = entry.getName();
        String localDirectory = entry.getLocalDirectory();
        String repository = entry.getRepository();
        this.ensureEntryHierarchy(localDirectory, repository);
        CVSEntry parentEntry = this.getPathTableEntry(localDirectory);
        if (parentEntry == null) {
            CVSTracer.traceWithStack("ENTRY '" + entry.getFullName() + "' NO PARENT!");
            return;
        }
        parentEntry.appendEntry(entry);
    }

    public String reposNameToRepository(String fullRepos) {
        int index = fullRepos.lastIndexOf(47);
        if (index < 0) {
            CVSTracer.traceWithStack("CVSProject.reposNameToRepository: ERROR repository '" + fullRepos + "' has no slash!");
            return fullRepos;
        }
        return fullRepos.substring(0, index);
    }

    public String reposNameToFileName(String fullRepos) {
        int index = fullRepos.lastIndexOf(47);
        if (index < 0) {
            CVSTracer.traceWithStack("CVSProject.reposNameToFileName: ERROR repository '" + fullRepos + "' has no slash!");
            return fullRepos;
        }
        return fullRepos.substring(index + 1);
    }

    public boolean removeEntriesItem(CVSResponseItem item) {
        String localDirectory;
        CVSEntry parentEntry;
        boolean result = true;
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.removeEntriesItem: pathName '" + item.getPathName() + "'");
        }
        if ((parentEntry = this.getPathTableEntry(localDirectory = this.normalizeLocalDirectory(item.getPathName(), this.reposNameToRepository(item.getRepositoryName())))) == null) {
            result = false;
            CVSTracer.traceWithStack("CVSProject.removeEntriesItem: NO PARENT! pathName '" + item.getPathName() + "' (localDir '" + localDirectory + "').");
        } else {
            String entryName = this.reposNameToFileName(item.getRepositoryName());
            result = parentEntry.removeEntry(entryName);
            if (item.getType() == 12) {
                String fileName;
                File file;
                String pathName = item.getPathName();
                if (pathName.startsWith("./")) {
                    pathName = pathName.substring(2);
                }
                if (!(file = new File((fileName = this.localRootDirectory + File.separator + pathName + entryName).replace('/', File.separatorChar))).delete()) {
                    CVSTracer.traceWithStack("CVSProject.removeEntriesItem: Could not delete file " + file.getAbsolutePath());
                }
            }
        }
        return result;
    }

    public void updateEntriesItem(CVSEntry newEntry) {
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.UPDATEEntriesItem: newEntry\n   getFullName       '" + newEntry.getFullName() + "'\n" + "   getLocalDirectory '" + newEntry.getLocalDirectory() + "'\n" + "   getAdminEntryLine '" + newEntry.getAdminEntryLine() + "'");
        }
        String name = newEntry.getName();
        String localDirectory = newEntry.getLocalDirectory();
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.updateEntriesItem: localDirectory '" + localDirectory + "' name '" + name + "'  ENTRY '" + newEntry + "'");
        }
        CVSEntry parentEntry = this.getPathTableEntry(localDirectory);
        CVSEntry entry = null;
        if (parentEntry != null) {
            entry = parentEntry.locateEntry(name);
        }
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.updateEntriesItem: Parent '" + (parentEntry == null ? "(null)" : parentEntry.getFullName()) + "'");
        }
        if (entry != null) {
            if (deepDebug) {
                CVSTracer.traceIf(true, "CVSProject.updateEntriesItem: newUserfile? '" + (newEntry.isNewUserFile() ? "yes" : "no") + "'");
            }
            if (!newEntry.isNewUserFile() && !entry.getVersion().equals(newEntry.getVersion()) && deepDebug) {
                CVSTracer.traceIf(true, "CVSProject.updateEntriesItem: WARNING: version mismatch: Entry '" + newEntry.getFullName() + "' New '" + newEntry.getVersion() + "' Existing: '" + entry.getVersion() + "'");
            }
            if (newEntry.getVersion() != null) {
                entry.setVersion(newEntry.getVersion());
            }
            if (newEntry.isNewUserFile()) {
                entry.setNewUserFile(true);
            }
            if (newEntry.isToBeRemoved()) {
                entry.setToBeRemoved(true);
            }
            if (newEntry.completeTimestamp() != null) {
                entry.setTimestamp(newEntry.completeTimestamp());
            }
            if (newEntry.getOptions() != null && newEntry.getOptions().length() > 0) {
                entry.setOptions(newEntry.getOptions());
            }
            if (newEntry.getTag() != null) {
                entry.setTag(newEntry.getTag());
            } else if (newEntry.getDate() != null) {
                entry.setDate(newEntry.getDate());
            } else {
                entry.setTag(null);
            }
            entry.setDirty(true);
            if (deepDebug) {
                CVSTracer.traceIf(true, "CVSProject.updateEntriesItem: FINAL:\n   getFullName       '" + entry.getFullName() + "'\n" + "   getAdminEntryLine '" + entry.getAdminEntryLine() + "'\n" + "   getLocalDirectory '" + entry.getLocalDirectory() + "'");
            }
        } else {
            if (parentEntry == null) {
                CVSTracer.traceIf(true, "CVSProject.updateEntriesItem: PARENT IS NULL!!!");
                CVSTracer.traceWithStack("NULL PARENT!");
            }
            this.addNewEntry(newEntry);
            newEntry.setDirty(true);
        }
    }

    public boolean readEntries() {
        CVSEntryVector entries;
        boolean ok = true;
        if (debugEntryIO) {
            CVSTracer.traceIf(true, "CVSProject.readEntries:\n   locaRootPath '" + this.getLocalRootPath() + "'\n" + "   ROOT ENTRY   '" + this.rootEntry.dumpString() + "'");
        }
        String rootStr = CVSCUtilities.exportPath(this.getLocalRootPath());
        File workingDirectory = new File(rootStr);
        if (debugEntryIO) {
            CVSTracer.traceIf(true, "CVSProject.readEntries:\n   WkgDirPath '" + workingDirectory.getPath() + "'");
        }
        if ((entries = this.readEntriesFile(this.rootEntry, workingDirectory)) == null) {
            return false;
        }
        this.rootEntry.setDirectoryEntryList(entries);
        return true;
    }

    public CVSEntryVector readEntriesFile(CVSEntry dirEntry, File workingDirectory) {
        CVSEntryVector entries;
        block32: {
            String repositoryStr;
            String rootDirectoryStr;
            int linenum = 0;
            String line = null;
            boolean ok = true;
            boolean isDir = false;
            BufferedReader in = null;
            entries = new CVSEntryVector();
            String localDirectory = CVSCUtilities.importPath(workingDirectory.getPath().substring(this.localRootDirectory.length()));
            if (localDirectory.startsWith("/")) {
                localDirectory = localDirectory.substring(1);
            }
            localDirectory = CVSCUtilities.ensureFinalSlash("./" + localDirectory);
            if (debugEntryIO) {
                CVSTracer.traceIf(true, "CVSProject.readEntriesFile: ENTER\n   wkgDir    '" + workingDirectory.getPath() + "'\n" + "   localDir  '" + localDirectory + "'\n" + "   dirEntry\n" + dirEntry.dumpString("   "));
            }
            String adminRootPath = CVSProject.rootPathToAdminPath(CVSCUtilities.importPath(workingDirectory.getPath()));
            File adminRootFile = new File(CVSCUtilities.exportPath(CVSProject.getAdminRootPath(adminRootPath)));
            if (debugEntryIO) {
                CVSTracer.traceIf(true, "CVSProject.readEntriesFile: adminRootFile '" + adminRootFile.getPath() + "'\n");
            }
            if ((rootDirectoryStr = this.readRootDirectory(adminRootFile)) == null) {
                CVSLog.logMsg("ERROR admin 'Root' file '" + adminRootFile.getPath() + "' is empty!");
                return null;
            }
            int index = -1;
            if (!rootDirectoryStr.startsWith(":")) {
                index = rootDirectoryStr.indexOf(58, 0);
            } else {
                int i = 0;
                while (i < 3) {
                    if ((index = rootDirectoryStr.indexOf(58, index + 1)) == -1) break;
                    ++i;
                }
            }
            if (index >= 0) {
                rootDirectoryStr = rootDirectoryStr.substring(index + 1);
            } else {
                CVSLog.logMsg("ERROR admin 'Root' file is MISSING COLONS!");
            }
            File adminRepositoryFile = new File(CVSCUtilities.exportPath(CVSProject.getAdminRepositoryPath(adminRootPath)));
            if (debugEntryIO) {
                CVSTracer.traceIf(true, "CVSProject.readEntriesFile: adminRepositoryFile '" + adminRepositoryFile.getPath() + "'\n");
            }
            if ((repositoryStr = this.readRepository(adminRepositoryFile)) == null) {
                CVSLog.logMsg("ERROR admin 'Repository' file '" + adminRepositoryFile.getPath() + "' is empty!");
                return null;
            }
            if (!repositoryStr.startsWith(rootDirectoryStr)) {
                repositoryStr = repositoryStr.equals(".") ? rootDirectoryStr : rootDirectoryStr + "/" + repositoryStr;
            }
            dirEntry.setRepository(repositoryStr);
            this.pathTable.put(localDirectory, dirEntry);
            if (debugEntryIO) {
                CVSTracer.traceIf(true, "READENTRIES: ADDED PATH TABLE ENTRY\n   dirEntry:       " + dirEntry.getFullName() + "\n" + "   localDirectory: " + localDirectory + "\n" + "   repository:     " + repositoryStr);
            }
            try {
                CVSCUtilities.integrateEntriesLog(new File(CVSCUtilities.exportPath(adminRootPath)));
            }
            catch (IOException ex) {
                CVSLog.logMsg("ERROR integrating 'Entries.Log' file in Admin Path '" + adminRootPath + "', " + ex.getMessage());
                ex.printStackTrace();
            }
            File entriesFile = new File(CVSCUtilities.exportPath(CVSProject.getAdminEntriesPath(adminRootPath)));
            if (debugEntryIO) {
                CVSTracer.traceIf(true, "CVSProject.readEntriesFile: entriesFile '" + entriesFile.getPath() + "'\n");
            }
            try {
                in = new BufferedReader(new FileReader(entriesFile));
            }
            catch (IOException ex) {
                in = null;
                ok = false;
            }
            linenum = 1;
            while (ok) {
                try {
                    line = in.readLine();
                }
                catch (IOException ex) {
                    line = null;
                    break;
                }
                if (line == null) break;
                if (line.startsWith("D")) {
                    isDir = true;
                    line = line.substring(1);
                }
                if (line.startsWith("/")) {
                    CVSEntry entry = new CVSEntry();
                    try {
                        entry.parseEntryLine(line, false);
                    }
                    catch (ParseException ex) {
                        CVSLog.logMsg("Bad admin 'Entries' line " + linenum + ", '" + line + "' isDir '" + isDir + "' - " + ex.getMessage());
                        ok = false;
                    }
                    if (ok) {
                        if (debugEntryIO) {
                            CVSTracer.traceIf(true, "CVSProject.readEntriesFile: PARSED ENTRY\n   entry:          " + entry.getName() + "\n" + "   repository:     " + repositoryStr + "\n" + "   localDirectory: " + localDirectory);
                        }
                        entry.setRepository(repositoryStr);
                        entry.setLocalDirectory(localDirectory);
                        entries.appendEntry(entry);
                        if (isDir) {
                            CVSEntryVector newEntries;
                            String newLocal = localDirectory + entry.getName() + "/";
                            String newRepos = repositoryStr + "/" + entry.getName();
                            entry.setRepository(newRepos);
                            entry.setLocalDirectory(newLocal);
                            String newWkgPath = workingDirectory.getPath() + File.separator + entry.getName() + File.separator;
                            String adminPath = newLocal + "CVS";
                            File newWorking = new File(workingDirectory, entry.getName());
                            if (debugEntryIO) {
                                CVSTracer.traceIf(true, "readEntriesFile: IS DIRECTORY:\n   entriesFile   '" + entriesFile.getPath() + "'\n" + "   NewWorkingDir '" + newWorking.getPath() + "'\n" + "   newRepos      '" + newRepos + "'\n" + "   newLocal      '" + newLocal + "'");
                            }
                            if ((newEntries = this.readEntriesFile(entry, newWorking)) == null) {
                                CVSLog.logMsg("ERROR failed reading Entries file from '" + newWorking.getPath() + "'");
                                newEntries = new CVSEntryVector();
                            }
                            entry.setDirectoryEntryList(newEntries);
                        }
                    }
                    isDir = false;
                }
                ++linenum;
            }
            if (in == null) break block32;
            try {
                in.close();
            }
            catch (IOException ex) {}
        }
        return entries;
    }

    public boolean writeAdminFiles() {
        boolean result = false;
        String localPath = this.getLocalRootDirectory();
        if (debugEntryIO) {
            CVSTracer.traceIf(true, "CVSProject.writeAdminFiles: WRITE ADMIN FILES\n   localPath   '" + localPath + "'\n" + "   rootEntry    " + this.rootEntry.dumpString());
        }
        if (!(result = this.writeAdminAndDescend(localPath, this.rootEntry))) {
            CVSLog.logMsg("CVSProject.writeAdminFiles:\n  ERROR Writing the CVS administrative files FAILED!");
        }
        return result;
    }

    private boolean writeAdminAndDescend(String localRoot, CVSEntry dirEntry) {
        boolean result = true;
        String localDir = dirEntry.getLocalDirectory();
        String localPath = localRoot;
        if (localDir.length() > 2) {
            localPath = localPath + "/" + localDir.substring(2);
        }
        if (debugEntryIO) {
            CVSTracer.traceIf(true, "CVSProject.writeAdminFiles: WRITE AND DESCEND LOCAL PATH\n   localPath   '" + localPath + "'");
        }
        String adminRootPath = CVSProject.rootPathToAdminPath(localPath);
        File adminFile = new File(CVSCUtilities.exportPath(adminRootPath));
        File rootFile = new File(CVSCUtilities.exportPath(CVSProject.getAdminRootPath(adminRootPath)));
        File reposFile = new File(CVSCUtilities.exportPath(CVSProject.getAdminRepositoryPath(adminRootPath)));
        File entriesFile = new File(CVSCUtilities.exportPath(CVSProject.getAdminEntriesPath(adminRootPath)));
        CVSEntryVector entries = dirEntry.getEntryList();
        if (debugEntryIO) {
            CVSTracer.traceIf(true, "========================================================================");
            CVSTracer.traceIf(true, "CVSProject.writeAdminAndDescend:\n   dirEntry      '" + dirEntry.getFullName() + "'\n" + "   isDirty       '" + dirEntry.isDirty() + "'\n" + "   dirRepos      '" + dirEntry.getRepository() + "'\n" + "   localRoot     '" + localPath + "'\n" + "   localDir      '" + localDir + "'\n" + "   adminFile     '" + adminFile.getPath() + "'\n" + "   rootFile      '" + rootFile.getPath() + "'\n" + "   reposFile     '" + reposFile.getPath() + "'\n" + "   entriesFile   '" + entriesFile.getPath() + "'\n" + "   entries.size  '" + entries.size() + "'\n" + "   entries.dirty '" + entries.isDirty() + "'");
        }
        if (!dirEntry.isDirty() && !entries.isDirty()) {
            if (debugEntryIO) {
                CVSTracer.traceIf(true, "\nCVSProject.writeAdminAndDescend: NO DIRTY ENTRIES --> SKIP WRITE\n");
            }
        } else {
            if (!adminFile.exists() && !adminFile.mkdir()) {
                CVSTracer.traceWithStack("ERROR could not create the admin directory '" + adminFile.getPath() + "'");
            }
            if (result = this.writeAdminEntriesFile(entriesFile, entries)) {
                String rootDirStr = this.projectDef.getRootDirectorySpec();
                if (debugEntryIO) {
                    CVSTracer.traceIf(true, "CVSProject.writeAdminAndDescend: WRITE ROOT FILE\n   rootFile   '" + rootFile.getPath() + "'\n" + "   " + rootDirStr);
                }
                if (result = this.writeAdminRootFile(rootFile, rootDirStr)) {
                    if (debugEntryIO) {
                        CVSTracer.traceIf(true, "CVSProject.writeAdminAndDescend: WRITE REPOSITORYy FILE\n   reposFile  '" + reposFile.getPath() + "'\n" + "   " + dirEntry.getRepository());
                    }
                    result = this.writeAdminRepositoryFile(reposFile, dirEntry.getRepository());
                }
            }
        }
        if (!result) {
            CVSLog.logMsg("CVSProject.writeAdminAndDescend: ERROR writing admin files '" + entriesFile.getPath() + "' et.al.");
            result = false;
        }
        int i = 0;
        while (result && i < entries.size()) {
            CVSTracer.traceIf(debugEntryIO, "CVSProject.writeAdminAndDescend: LOOP i = " + i);
            CVSEntry entry = entries.entryAt(i);
            CVSTracer.traceIf(debugEntryIO, "CVSProject.writeAdminAndDescend: LOOP[" + i + "] repository '" + this.repository + "' entry '" + entry.getName() + "'");
            if (entry.isDirectory()) {
                CVSTracer.traceIf(debugEntryIO, "CVSProject.writeAdminAndDescend: DESCEND into '" + entry.getFullName() + "'");
                result = this.writeAdminAndDescend(localRoot, entry);
                CVSTracer.traceIf(debugEntryIO, "CVSProject.writeAdminAndDescend: RETURNED from '" + entry.getFullName() + "' with '" + result + "'");
            }
            ++i;
        }
        if (result) {
            entries.setDirty(false);
            dirEntry.setDirty(false);
        }
        CVSTracer.traceIf(debugEntryIO, "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
        return result;
    }

    public boolean writeAdminEntriesFile(File entriesFile, CVSEntryVector entries) {
        boolean ok = true;
        boolean result = true;
        CVSEntry entry = null;
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(entriesFile));
        }
        catch (Exception ex) {
            CVSLog.logMsg("CVSProject.writeAdminEntriesFile: ERROR opening entries file '" + entriesFile.getPath() + "' - " + ex.getMessage());
            return false;
        }
        int i = 0;
        while (result && i < entries.size()) {
            entry = entries.entryAt(i);
            try {
                out.write(entry.getAdminEntryLine());
                out.newLine();
            }
            catch (IOException ex) {
                CVSLog.logMsg("CVSProject.writeAdminEntriesFile: ERROR writing entries file '" + entriesFile.getPath() + "' - " + ex.getMessage());
                result = false;
            }
            ++i;
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            CVSLog.logMsg("CVSProject.writeAdminEntriesFile: ERROR closing entries file '" + entriesFile.getPath() + "' - " + ex.getMessage());
            result = false;
        }
        return result;
    }

    public boolean writeAdminRootFile(File rootFile, String rootDirectoryStr) {
        boolean result;
        block4: {
            result = true;
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(new FileWriter(rootFile));
            }
            catch (Exception ex) {
                CVSLog.logMsg("CVSProject.writeAdminRootFile: failed opening 'Root' file to '" + rootFile.getPath() + "' - " + ex.getMessage());
                result = false;
            }
            if (!result) break block4;
            try {
                out.write(rootDirectoryStr);
                out.newLine();
                out.close();
            }
            catch (IOException ex) {
                CVSLog.logMsg("CVSProject.writeAdminRootFile: failed writing 'Root' file to '" + rootFile.getPath() + "' - " + ex.getMessage());
                result = false;
            }
        }
        return result;
    }

    public boolean writeAdminRepositoryFile(File repFile, String repository) {
        boolean result;
        block5: {
            result = true;
            BufferedWriter out = null;
            if (deepDebug) {
                CVSTracer.traceIf(true, "CVSProject.writeAdminRepositoryFile:\n   File:   " + repFile.getPath() + "\n" + "   Repos:  " + repository);
            }
            try {
                out = new BufferedWriter(new FileWriter(repFile));
            }
            catch (Exception ex) {
                CVSLog.logMsg("CVSProject.writeAdminRepositoryFile: failed opening 'Repository' file to '" + repFile.getPath() + "' - " + ex.getMessage());
                result = false;
            }
            if (!result) break block5;
            try {
                out.write(repository);
                out.newLine();
                out.close();
            }
            catch (IOException ex) {
                CVSLog.logMsg("CVSProject.writeAdminRepositoryFile: failed writing 'Repository' file to '" + repFile.getPath() + "' - " + ex.getMessage());
                result = false;
            }
        }
        return result;
    }

    public boolean isLocalFileModified(CVSEntry entry) {
        File entryFile = this.getEntryFile(entry);
        return entry.isLocalFileModified(entryFile);
    }

    public boolean checkReleaseStatus(CVSIgnore ignore, Vector mods, Vector adds, Vector rems, Vector unks) {
        CVSEntryVector rootEntries = this.getRootEntry().getEntryList();
        if (rootEntries == null || rootEntries.size() == 0) {
            CVSTracer.traceWithStack("THIS SHOULD NEVER HAPPEN!!");
            return true;
        }
        this.checkReleaseAndDescend(this.getRootEntry(), ignore, mods, adds, rems, unks);
        return mods.size() > 0 || adds.size() > 0 || rems.size() > 0 || unks.size() > 0;
    }

    private void checkReleaseAndDescend(CVSEntry parent, CVSIgnore ignore, Vector mods, Vector adds, Vector rems, Vector unks) {
        int i;
        CVSEntryVector entries = parent.getEntryList();
        File dirF = this.getLocalEntryFile(parent);
        String[] list = dirF.list();
        Vector<String> fileV = new Vector<String>(list == null ? 0 : list.length);
        if (list != null) {
            i = 0;
            while (i < list.length) {
                fileV.addElement(list[i]);
                ++i;
            }
        }
        i = 0;
        while (i < entries.size()) {
            CVSEntry entry = entries.entryAt(i);
            fileV.removeElement(entry.getName());
            if (entry.isDirectory()) {
                this.checkReleaseAndDescend(entry, ignore, mods, adds, rems, unks);
            } else if (entry.isNewUserFile()) {
                adds.addElement(entry.getFullName());
            } else if (entry.isToBeRemoved()) {
                rems.addElement(entry.getFullName());
            } else if (entry.isInConflict()) {
                mods.addElement(entry.getFullName());
            } else if (this.isLocalFileModified(entry)) {
                mods.addElement(entry.getFullName());
            } else if (this.isLocalFileModified(entry)) {
                mods.addElement(entry.getFullName());
            }
            ++i;
        }
        int i2 = 0;
        int sz = fileV.size();
        while (i2 < sz) {
            String fileName = (String)fileV.elementAt(i2);
            if (!ignore.isFileToBeIgnored(fileName)) {
                unks.addElement(parent.getFullName() + fileName);
            }
            ++i2;
        }
    }

    public void pruneEmptySubDirs(boolean saveAdminFiles) {
        this.pruneEmptySubDirs(this.getRootEntry());
        if (saveAdminFiles) {
            this.writeAdminFiles();
        }
    }

    public void pruneEmptySubDirs(CVSEntry parent) {
        CVSEntryVector entries = parent.getEntryList();
        int i = entries.size() - 1;
        while (i >= 0) {
            CVSEntry entry = entries.getEntryAt(i);
            if (entry.isDirectory()) {
                File dirF = this.getEntryFile(entry);
                String[] list = dirF.list();
                if (list == null || list.length == 0) {
                    this.descendAndDelete(dirF);
                    parent.removeEntry(entry);
                } else if (list.length == 1 && list[0].equals("CVS")) {
                    File cvsF = new File(dirF, "CVS");
                    if (!cvsF.exists() || cvsF.isDirectory()) {
                        this.descendAndDelete(dirF);
                        parent.removeEntry(entry);
                    }
                } else {
                    this.pruneEmptySubDirs(entry);
                }
            }
            --i;
        }
    }

    public void releaseProject() {
        String[] files;
        CVSEntryVector rootEntries = this.getRootEntry().getEntryList();
        if (rootEntries == null || rootEntries.size() == 0) {
            CVSTracer.traceWithStack("THIS SHOULD NEVER HAPPEN!!");
            return;
        }
        int i = rootEntries.size() - 1;
        while (i >= 0) {
            CVSEntry entry = rootEntries.getEntryAt(i);
            File eFile = this.getEntryFile(entry);
            if (!CVSCUtilities.isSubpathInPath(this.getLocalRootPath(), eFile.getPath())) {
                String msg = "ROOT '" + this.getLocalRootPath() + "' NOT parent of '" + eFile.getPath() + "'";
                CVSTracer.traceWithStack(msg);
                return;
            }
            this.descendAndDelete(eFile);
            --i;
        }
        File rootDir = new File(this.getLocalRootDirectory());
        if (rootDir.exists() && ((files = rootDir.list()) == null || files.length < 2)) {
            boolean doit = true;
            if (files.length == 1) {
                if (files[0].equals("CVS")) {
                    File cvsDir = new File(rootDir, "CVS");
                    files = cvsDir.list();
                    int c = 0;
                    while (c < files.length) {
                        File dFile = new File(cvsDir, files[c]);
                        dFile.delete();
                        ++c;
                    }
                    cvsDir.delete();
                } else {
                    doit = false;
                }
            }
            if (doit) {
                rootDir.delete();
            }
        }
    }

    private void descendAndDelete(File eFile) {
        String[] files;
        if (eFile.isDirectory() && (files = eFile.list()) != null) {
            int i = 0;
            while (i < files.length) {
                File f = new File(eFile, files[i]);
                if (f.exists()) {
                    this.descendAndDelete(f);
                }
                ++i;
            }
        }
        eFile.delete();
    }

    public boolean checkOverwrite(CVSEntry entry, File file) {
        boolean result = true;
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.checkOverWrite( " + entry.getFullName() + ", " + file.getPath() + " )");
        }
        if (!file.exists()) {
            CVSTracer.trace("CVSProject.checkOverWrite: FILE '" + file.getPath() + "' DOES NOT EXIST");
            return true;
        }
        CVSEntry checkEntry = this.locateEntry(entry.getFullName());
        if (checkEntry == null) {
            NullPointerException ex = new NullPointerException("locateEntry(" + entry.getFullName() + ") returns null!");
            CVSLog.traceMsg(ex, "CVSProject.checkOverWrite:");
            return false;
        }
        result = !checkEntry.isLocalFileModified(file);
        CVSTracer.traceIf(false, "CVSProject.checkOverWrite: RESULT '" + result + "'");
        return result;
    }

    public CVSEntry locateEntry(String fullPath) {
        int index;
        CVSEntry entry = null;
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.locateEntry( " + fullPath + " )");
        }
        if ((index = fullPath.lastIndexOf(47)) < 0) {
            CVSTracer.traceWithStack("CVSProject.locateEntry: NO SLASH IN '" + fullPath + "'");
            entry = this.rootEntry.locateEntry(fullPath);
        } else {
            String name = fullPath.substring(index + 1);
            String localDirectory = fullPath.substring(0, index + 1);
            CVSEntry parentEntry = this.getPathTableEntry(localDirectory);
            if (parentEntry == null) {
                CVSTracer.traceWithStack("CVSProject.locateEntry: LOCAL DIRECTORY '" + localDirectory + "' NOT IN TABLE");
            } else {
                entry = parentEntry.locateEntry(name);
            }
        }
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.locateEntry: fullPath '" + fullPath + "' resulting entry '" + (entry == null ? "(null)" : entry.getFullName()));
        }
        return entry;
    }

    public boolean ensureEntryHierarchy(String localDirectory, String repository) {
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.ENSUREEntryHierarchy:\n   localDirectory '" + localDirectory + "'\n" + "   repository '" + repository);
        }
        if (localDirectory.equals("./")) {
            if (this.rootEntry == null) {
                if (deepDebug) {
                    CVSTracer.traceIf(true, "CVSProject.ENSUREEntryHierarchy: ESTABLISH '.' ROOT ENTRY\n   repository '" + repository);
                }
                this.establishRootEntry(repository);
                return true;
            }
            CVSTracer.traceIf(true, "CVSProject.ENSUREEntryHierarchy: IGNORING '.' localDirectory!\n   repository '" + repository);
            return true;
        }
        CVSEntry lookupEntry = this.getPathTableEntry(localDirectory);
        if (lookupEntry != null) {
            return true;
        }
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.ensureEntryHierarchy: START LOOP\n   localDirectory '" + localDirectory + "'\n" + "   repository     '" + repository + "'");
        }
        CVSEntry curEntry = this.rootEntry;
        while (true) {
            int length = curEntry.getLocalDirectory().length();
            int slashIdx = localDirectory.indexOf("/", length);
            if (deepDebug) {
                CVSTracer.traceIf(true, "CVSProject.ensureEntryHierarchy: TOP LOOP\n   length = " + length + "  slashIdx = " + slashIdx + "\n" + "   curEntry: " + curEntry.dumpString("   "));
            }
            if (slashIdx == -1) break;
            String subLocal = localDirectory.substring(0, slashIdx + 1);
            CVSEntry pathEntry = this.getPathTableEntry(subLocal);
            if (deepDebug) {
                CVSTracer.traceIf(true, "CVSProject.ensureEntryHierarchy: LOOP lookup path '" + subLocal + "' returns:\n" + (pathEntry == null ? "NULL" : pathEntry.dumpString("   ")));
            }
            if (pathEntry == null) break;
            curEntry = pathEntry;
        }
        Vector<String[]> elements = new Vector<String[]>();
        String workingRepos = CVSCUtilities.ensureFinalSlash(repository);
        int reposIdx = workingRepos.length() - 1;
        int localIdx = localDirectory.length() - 1;
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSProject.ensureEntryHierarchy: START MULTI LEVEL LOOP\n         reposIdx =  " + reposIdx + "  localIdx =  " + localIdx + "\n" + "   localDirectory = '" + localDirectory + "'\n" + "     workingRepos = '" + workingRepos + "'\n" + "         curEntry = \n" + curEntry.dumpString("   "));
        }
        while (true) {
            int newRepIdx = workingRepos.lastIndexOf("/", reposIdx - 1);
            int newLocIdx = localDirectory.lastIndexOf("/", localIdx - 1);
            if (deepDebug) {
                CVSTracer.traceIf(true, "CVSProject.ensureEntryHierarchy: PARSE PATH LOOP\n    reposIdx =  " + reposIdx + "    localIdx =  " + localIdx + "\n" + "   newRepIdx =  " + newRepIdx + "   newLocIdx =  " + newLocIdx);
            }
            String name = localDirectory.substring(newLocIdx + 1, localIdx);
            String subRepos = workingRepos.substring(0, reposIdx);
            String subLocal = localDirectory.substring(0, localIdx + 1);
            if (deepDebug) {
                CVSTracer.traceIf(true, "CVSProject.ensureEntryHierarchy: CHECK PATH\n       name = '" + name + "'\n" + "   subRepos = '" + subRepos + "'\n" + "   subLocal = '" + subLocal + "'");
            }
            if (subLocal.equals(curEntry.getLocalDirectory())) {
                if (!deepDebug) break;
                CVSTracer.traceIf(true, "CVSProject.ensureEntryHierarchy: HIT CUR-ENTRY, BREAK");
                break;
            }
            if (deepDebug) {
                CVSTracer.traceIf(true, "CVSProject.ensureEntryHierarchy: ADDED PATH!");
            }
            String[] parms = new String[]{name, subRepos, subLocal};
            elements.addElement(parms);
            reposIdx = newRepIdx;
            localIdx = newLocIdx;
        }
        int i = elements.size() - 1;
        while (i >= 0) {
            String[] parms = (String[])elements.elementAt(i);
            CVSEntry newEntry = new CVSEntry();
            newEntry.setDirty(true);
            newEntry.setName(parms[0]);
            newEntry.setRepository(parms[1]);
            newEntry.setLocalDirectory(parms[2]);
            newEntry.setVersion("");
            newEntry.setTimestamp("");
            newEntry.setOptions("");
            newEntry.setTag("");
            newEntry.setDirectoryEntryList(new CVSEntryVector());
            File workingDirF = new File(CVSCUtilities.exportPath(this.getLocalRootDirectory()));
            workingDirF = new File(workingDirF, CVSCUtilities.exportPath(newEntry.getFullPathName()));
            CVSEntryVector entries = this.readEntriesFile(newEntry, workingDirF);
            if (deepDebug) {
                CVSTracer.traceIf(true, "CVSProject.ensureEntryHierarchy: Entries = " + entries + ", size=" + (entries == null ? 0 : entries.size()) + ", at '" + workingDirF.getAbsolutePath() + "'");
            }
            if (entries != null) {
                newEntry.setDirectoryEntryList(entries);
            }
            if (deepDebug) {
                CVSTracer.traceIf(true, "CVSProject.ensureEntryHierarchy: MULTI LEVEL APPEND NEW ENTRY\n   CUR ENTRY:" + curEntry.dumpString("   ") + "\n" + "   NEW ENTRY:" + newEntry.dumpString("   "));
            }
            this.pathTable.put(newEntry.getLocalDirectory(), newEntry);
            curEntry.appendEntry(newEntry);
            curEntry = newEntry;
            --i;
        }
        return true;
    }

    public boolean ensureProperWorkingDirectory(String localRoot, String subPath, boolean ensureAdmin) {
        boolean result = true;
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSClient.ENSURE Proper WORKING Directory:\n    localRoot '" + localRoot + "'\n" + "      subPath '" + subPath + "'\n" + "    ensureAdm '" + ensureAdmin + "'");
        }
        if ((subPath = CVSCUtilities.stripFinalSlash(subPath)).startsWith("./")) {
            subPath = subPath.substring(2);
        }
        String remainder = subPath;
        while (result && remainder.length() > 0) {
            int index = remainder.indexOf(47);
            if (index < 0) {
                subPath = remainder;
                remainder = "";
            } else {
                subPath = remainder.substring(0, index);
                remainder = remainder.substring(index + 1);
            }
            File dir = new File(localRoot + "/" + subPath);
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (!dir.exists()) {
                result = false;
                CVSLog.logMsg("ERROR could not create local path '" + dir.getPath() + "'");
            } else if (!dir.isDirectory()) {
                result = false;
                CVSLog.logMsg("ERROR local directory '" + dir.getPath() + "' is not a directory!");
            } else if (result && ensureAdmin) {
                File adminDir = new File(dir.getPath() + "/CVS");
                if (deepDebug) {
                    CVSTracer.traceIf(true, "CVSClient.ensureProperWorkingDirectory: ADMINDIR '" + adminDir.getPath() + "'");
                }
                if (!adminDir.exists()) {
                    adminDir.mkdir();
                }
                if (!adminDir.exists()) {
                    result = false;
                    CVSLog.logMsg("ERROR could not create Admin path '" + this.localAdminDirFile.getPath() + "'");
                }
            }
            localRoot = localRoot + "/" + subPath;
        }
        return result;
    }

    public boolean ensureLocalTree(File localFile, boolean ensureAdmin) {
        boolean result = true;
        String localPath = localFile.getPath();
        String localRoot = CVSCUtilities.exportPath(this.localRootDirectory);
        int index = localPath.lastIndexOf(File.separatorChar);
        if (index < 0) {
            return true;
        }
        String localSub = localPath.substring(0, index);
        if (!CVSCUtilities.isSubpathInPath(localRoot, localSub)) {
            CVSLog.logMsg("CVSClient.ensureLocalTree:  LOCAL SUBDIR IS NOT IN ROOT!!\n   localRoot   '" + this.localRootDirectory + "'\n" + "   localSubDir '" + localSub + "'");
            result = false;
        }
        localSub = localSub.equals(localRoot) ? "./" : localSub.substring(localRoot.length() + 1);
        if (deepDebug) {
            CVSTracer.traceIf(true, "CVSClient.ensureLocalTree: tempFile '" + localFile.getPath() + "' localPath '" + localPath + "' --> '" + localSub + "'");
        }
        result = this.ensureProperWorkingDirectory(this.localRootDirectory, localSub, ensureAdmin);
        return result;
    }

    public void moveLocalFile(File localFile, String versionStr) throws CVSFileException {
        String localPath = localFile.getPath();
        String base = "";
        String name = localPath;
        int index = localPath.lastIndexOf(47);
        if (index >= 0) {
            base = localPath.substring(0, index);
            name = localPath.substring(index + 1);
        }
        String newPath = base + "/" + "#" + name + "." + versionStr;
        CVSTracer.traceIf(overTraceProcessing, "CVSProject.moveLocalFile: move '" + localFile.getPath() + "' to '" + newPath + "'");
        File toFile = new File(newPath);
        boolean result = localFile.renameTo(toFile);
        CVSTracer.traceIf(false, "CVSProject.moveLocalFile: rename returns '" + result + "'");
        if (!result) {
            throw new CVSFileException("failed renaming '" + localFile.getPath() + "' to '" + toFile.getPath() + "'");
        }
    }

    public boolean updateLocalFile(CVSResponseItem item, CVSEntry entry, File localFile) {
        boolean result = true;
        int trans = CVSCUtilities.computeTranslation(entry);
        result = this.copyFile(item.getFile(), localFile, trans, item.isGZIPed());
        return result;
    }

    public boolean copyFile(File from, File to, int translation, boolean isGZIPed) {
        boolean result = false;
        CVSTracer.traceIf(overTraceProcessing, "CVSProject.copyFile: from '" + from.getPath() + "' to '" + to.getPath() + "' trans '" + (translation == 1 ? "ASCII" : "NONE") + "' gzip-ed? '" + isGZIPed + "'");
        switch (translation) {
            case 1: {
                result = this.copyFileAscii(from, to, isGZIPed);
                break;
            }
            default: {
                result = this.copyFileRaw(from, to, isGZIPed);
            }
        }
        return result;
    }

    public boolean copyFileAscii(File from, File to, boolean isGZIPed) {
        boolean ok = true;
        NewLineReader in = null;
        BufferedWriter out = null;
        String line = null;
        try {
            if (isGZIPed) {
                CVSProject cVSProject = this;
                cVSProject.getClass();
                in = cVSProject.new NewLineReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(from))));
            } else {
                in = new NewLineReader(new FileReader(from));
            }
        }
        catch (IOException ex) {
            in = null;
            ok = false;
            CVSLog.logMsg("CVSProject.copyFileAscii: failed creating in reader: " + ex.getMessage());
        }
        if (ok) {
            try {
                out = new BufferedWriter(new FileWriter(to));
            }
            catch (IOException ex) {
                out = null;
                ok = false;
                CVSLog.logMsg("CVSProject.copyFileAscii: failed creating out writer: " + ex.getMessage());
            }
        }
        if (out == null || in == null) {
            ok = false;
            CVSLog.logMsg("CVSProject.copyFileAscii: failed creating '" + (out == null ? "output writer" : "input reader") + "'");
        }
        if (ok) {
            while (true) {
                try {
                    line = ((BufferedReader)in).readLine();
                    if (line == null) break;
                    out.write(line);
                }
                catch (IOException ex) {
                    CVSLog.logMsg("CVSProject.copyFileAscii: failed during copy: " + ex.getMessage());
                    ok = false;
                    break;
                }
            }
            try {
                out.flush();
            }
            catch (IOException ex) {
                CVSLog.logMsg("CVSProject.copyFileAscii: failed flushing output: " + ex.getMessage());
                ok = false;
            }
        }
        try {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        catch (IOException ex) {
            CVSLog.logMsg("CVSProject.copyFileAscii: failed closing files: " + ex.getMessage());
            ok = false;
        }
        return ok;
    }

    public boolean copyFileRaw(File from, File to, boolean isGZIPed) {
        boolean ok = true;
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        Object line = null;
        try {
            in = isGZIPed ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(from))) : new BufferedInputStream(new FileInputStream(from));
        }
        catch (Exception ex) {
            in = null;
            ok = false;
            CVSLog.logMsg("CVSProject.copyFileRaw: failed creating in reader: " + ex.getMessage());
        }
        if (ok) {
            try {
                out = new BufferedOutputStream(new FileOutputStream(to));
            }
            catch (Exception ex) {
                out = null;
                ok = false;
                CVSLog.logMsg("CVSProject.copyFileRaw: failed creating out writer: " + ex.getMessage());
            }
        }
        if (out == null || in == null) {
            ok = false;
            CVSLog.logMsg("CVSProject.copyFileRaw: failed creating '" + (out == null ? "output writer" : "input reader") + "'");
        }
        if (ok) {
            byte[] buffer = new byte[8192];
            long fileSize = from.length();
            while (true) {
                int bytes;
                try {
                    bytes = in.read(buffer, 0, 8192);
                }
                catch (IOException ex) {
                    ok = false;
                    CVSLog.logMsg("CVSProject.copyFileRaw: ERROR reading file data:\n   " + ex.getMessage());
                    break;
                }
                if (bytes < 0) break;
                try {
                    out.write(buffer, 0, bytes);
                }
                catch (IOException ex) {
                    ok = false;
                    CVSLog.logMsg("CVSProject.copyFileRaw: ERROR writing output file:\n   " + ex.getMessage());
                    break;
                }
            }
        }
        try {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        catch (IOException ex) {
            CVSLog.logMsg("CVSProject.copyFileRaw: failed closing files: " + ex.getMessage());
            ok = false;
        }
        return ok;
    }

    public void uiDisplayProgressMsg(String message) {
    }

    public void uiDisplayProgramError(String error) {
    }

    public void uiDisplayResponse(CVSResponse response) {
    }

    public String toString() {
        return "CVSProject: name '" + this.repository + "'";
    }

    public StringBuffer dumpCVSProject(StringBuffer buf, String description) {
        buf.append("##############################################################\n");
        buf.append("#\n");
        buf.append("# CVSProject  '").append(this.repository).append("'\n");
        buf.append("#\n");
        buf.append("# Description '").append(description).append("'\n");
        buf.append("#\n");
        buf.append("##############################################################\n");
        buf.append("\n");
        buf.append("  valid?      '").append(this.valid).append("'\n");
        buf.append("  isPServer?  '").append(this.isPServer).append("'\n");
        buf.append("  allowsGzip? '").append(this.allowGzipFileMode).append("'\n");
        buf.append("  gzipLevel   '").append(this.gzipStreamLevel).append("'\n");
        buf.append("  connMethod  '").append(this.connMethod).append("'\n");
        buf.append("  serverCmd   '").append(this.serverCommand).append("'\n");
        buf.append("  rshProcess  '").append(this.rshProcess).append("'\n");
        buf.append("  userName    '").append(this.userName).append("'\n");
        buf.append("  tempPath    '").append(this.tempPath).append("'\n");
        buf.append("  repository  '").append(this.repository).append("'\n");
        buf.append("  rootDir     '").append(this.rootDirectory).append("'\n");
        buf.append("  localRoot   '").append(this.localRootDirectory).append("'\n");
        buf.append("\n");
        buf.append("------- Path Table -------\n");
        buf.append("\n");
        Enumeration enumeration = this.pathTable.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            CVSEntry val = (CVSEntry)this.pathTable.get(key);
            buf.append(key).append(" =\n\n   ");
            buf.append(val.dumpString()).append("\n\n");
        }
        buf.append("\n");
        buf.append("------- Root Entry -------\n");
        if (this.rootEntry == null) {
            buf.append("   Root Entry Is Null.\n");
        } else {
            buf.append("  ").append(this.rootEntry.dumpString()).append("\n");
        }
        buf.append("\n");
        buf.append("------- ENTRY TREE -------\n");
        buf.append("\n");
        buf.append("").append("./").append("\n");
        this.dumpEntry(buf, "   ", this.rootEntry);
        return buf;
    }

    public StringBuffer dumpEntry(StringBuffer buf, String prefix, CVSEntry dirEntry) {
        CVSEntryVector entries = dirEntry.getEntryList();
        int i = 0;
        int sz = entries.size();
        while (i < sz) {
            CVSEntry entry = entries.getEntryAt(i);
            buf.append(prefix).append(entry.getFullName()).append("\n");
            if (entry.isDirectory()) {
                this.dumpEntry(buf, prefix + "   ", entry);
            }
            ++i;
        }
        return buf;
    }

    private class NewLineReader
    extends BufferedReader {
        public NewLineReader(Reader in) {
            super(in);
        }

        public String readLine() {
            StringBuffer line = new StringBuffer(132);
            try {
                while (true) {
                    int inByte;
                    if ((inByte = this.read()) == -1) {
                        if (line.length() == 0) {
                            line = null;
                        }
                        break;
                    }
                    char ch = (char)inByte;
                    if (ch == '\n') {
                        line.append(System.getProperty("line.separator"));
                        break;
                    }
                    line.append(ch);
                }
            }
            catch (IOException ex) {
                line = null;
            }
            return line != null ? line.toString() : null;
        }
    }
}

