/*
 * Decompiled with CFR 0.152.
 */
package com.ice.cvsc;

import com.ice.cvsc.CVSCUtilities;
import com.ice.cvsc.CVSEntryVector;
import com.ice.cvsc.CVSMode;
import com.ice.cvsc.CVSTimestamp;
import com.ice.cvsc.CVSTimestampFormat;
import com.ice.cvsc.CVSTracer;
import java.io.File;
import java.text.ParseException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class CVSEntry
implements Cloneable {
    public static final String RCS_ID = "$Id: CVSEntry.java,v 2.11 2003/07/27 01:08:32 time Exp $";
    public static final String RCS_REV = "$Revision: 2.11 $";
    private boolean valid = false;
    private boolean isDir = false;
    private CVSEntryVector entryList = null;
    private String repository = null;
    private String localDirectory = null;
    private boolean isNoUserFile = false;
    private boolean isNewUserFile = false;
    private boolean isToBeRemoved = false;
    private boolean isDirty = false;
    private boolean forceModified = false;
    private boolean forceNoExistence = false;
    private CVSMode mode = null;
    private CVSTimestamp tsCache = null;
    private CVSTimestamp cfCache = null;
    private String name = "";
    private String version = "";
    private String timestamp = "";
    private String conflict = null;
    private String options = null;
    private String tag = null;
    private String date = null;
    private Vector childListeners = new Vector();

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public boolean isForceModified() {
        return this.forceModified;
    }

    public void setForceModified(boolean forceModified) {
        this.forceModified = forceModified;
    }

    public boolean isForceNoExistence() {
        return this.forceNoExistence;
    }

    public void setForceNoExistence(boolean forceNoExistence) {
        this.forceNoExistence = forceNoExistence;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = CVSCUtilities.stripFinalSlash(repository);
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    public void setLocalDirectory(String directory) {
        this.localDirectory = CVSCUtilities.ensureFinalSlash(directory);
    }

    public String getFullName() {
        if (this.isDirectory()) {
            return this.getLocalDirectory();
        }
        return this.getLocalDirectory() + this.getName();
    }

    private String stripDotSlashPrefix(String path) {
        if (path.startsWith("./")) {
            path = path.substring(2);
        }
        return path;
    }

    public String getFullPathName() {
        return this.stripDotSlashPrefix(this.getFullName());
    }

    public String getLocalPathName() {
        return this.stripDotSlashPrefix(this.getLocalDirectory());
    }

    public String getRepositoryName() {
        return this.getRepository() + this.getName();
    }

    public String getArgumentName() {
        return this.getFullName();
    }

    public boolean isDirectory() {
        return this.isDir;
    }

    public void appendEntry(CVSEntry entry) {
        this.entryList.appendEntry(entry);
        CVSEntry cVSEntry = this;
        cVSEntry.getClass();
        this.fireChildAddedEvent(cVSEntry.new ChildEvent(this.entryList.size() - 1, entry));
    }

    public boolean removeEntry(CVSEntry entry) {
        boolean result = false;
        int index = this.entryList.indexOf(entry);
        if (index != -1) {
            result = true;
            this.isDirty = true;
            CVSEntry child = this.entryList.entryAt(index);
            this.entryList.removeElementAt(index);
            CVSEntry cVSEntry = this;
            cVSEntry.getClass();
            this.fireChildRemovedEvent(cVSEntry.new ChildEvent(index, child));
        }
        return result;
    }

    public boolean removeEntry(String entryName) {
        boolean result = false;
        int i = 0;
        int sz = this.entryList.size();
        while (i < sz) {
            CVSEntry entry = this.entryList.entryAt(i);
            if (entryName.equals(entry.getName())) {
                result = true;
                this.isDirty = true;
                this.entryList.removeElementAt(i);
                CVSEntry cVSEntry = this;
                cVSEntry.getClass();
                this.fireChildRemovedEvent(cVSEntry.new ChildEvent(i, entry));
                break;
            }
            ++i;
        }
        return result;
    }

    public void removeAllEntries() {
        if (this.isDirectory() && this.entryList != null) {
            this.entryList.removeAllEntries();
            CVSEntry cVSEntry = this;
            cVSEntry.getClass();
            this.fireChildRemovedEvent(cVSEntry.new ChildEvent(-1, null));
        }
    }

    public CVSEntry locateEntry(String name) {
        return this.entryList.locateEntry(name);
    }

    public CVSEntryVector getEntryList() {
        return this.entryList;
    }

    public void setDirectoryEntryList(CVSEntryVector entryList) {
        if (entryList != null) {
            this.isDir = true;
            this.entryList = entryList;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.isNoUserFile = false;
        this.isNewUserFile = false;
        this.isToBeRemoved = false;
        if (version == null || version.length() == 0) {
            this.isNoUserFile = true;
            this.version = "";
        } else if (version.startsWith("-")) {
            this.isToBeRemoved = true;
            this.version = version.substring(1);
        } else if (version.startsWith("0")) {
            this.isNewUserFile = true;
            this.version = version.substring(1);
        } else {
            this.version = version;
        }
    }

    public void markForRemoval(boolean markState) {
        this.isToBeRemoved = markState;
    }

    private CVSTimestamp parseTimestamp(String stampStr) {
        CVSTimestamp result;
        block2: {
            result = new CVSTimestamp(0L);
            if (stampStr == null) break block2;
            CVSTimestampFormat stamper = CVSTimestampFormat.getInstance();
            try {
                result = stamper.parse(stampStr);
            }
            catch (ParseException ex) {
                result = new CVSTimestamp(0L);
                CVSTracer.traceWithStack("CVSEntry.parseTimestamp: could not parse timestamp: '" + stampStr + "' - " + ex.getMessage());
            }
        }
        return result;
    }

    public CVSTimestamp getCVSTime() {
        return this.tsCache;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String completeTimestamp() {
        return this.timestamp + (this.conflict == null ? "" : "+" + this.conflict);
    }

    public String getTerseTimestamp() {
        if (this.tsCache == null) {
            this.tsCache = this.parseTimestamp(this.timestamp);
        }
        if (this.tsCache == null) {
            return this.timestamp;
        }
        CVSTimestampFormat stamper = CVSTimestampFormat.getInstance();
        return stamper.formatTerse(this.tsCache);
    }

    public void setTimestamp(File entryFile) {
        long mTime = entryFile.lastModified();
        mTime = mTime / 1000L * 1000L;
        CVSTimestamp stamp = new CVSTimestamp(mTime);
        CVSTimestampFormat stamper = CVSTimestampFormat.getInstance();
        String stampStr = stamper.format(stamp);
        this.setTimestamp(stampStr);
    }

    public void setTimestamp(String timeStamp) {
        block22: {
            if (timeStamp == null) {
                CVSTracer.traceWithStack("NULL TIMESTAMP!!!");
                timeStamp = "";
            }
            String tstamp = new String(timeStamp);
            this.cfCache = null;
            this.conflict = null;
            if (tstamp.length() < 1) {
                this.timestamp = "";
                this.tsCache = null;
            } else if (tstamp.startsWith("+")) {
                this.conflict = tstamp.substring(1);
                if (this.conflict.equals("=")) {
                    this.conflict = "";
                }
            } else {
                int index = tstamp.indexOf(43);
                if (index < 0) {
                    if (tstamp.startsWith("Initial ")) {
                        this.timestamp = "";
                        this.tsCache = null;
                    } else if (tstamp.equals("Result of merge")) {
                        this.timestamp = "";
                        this.tsCache = null;
                    } else if (!tstamp.equals(this.timestamp)) {
                        this.tsCache = null;
                        this.timestamp = tstamp;
                    }
                } else {
                    this.conflict = tstamp.substring(index + 1);
                    if (!(tstamp = tstamp.substring(0, index)).equals(this.timestamp)) {
                        this.tsCache = null;
                        if (tstamp.equals("Result of merge")) {
                            if ((this.timestamp == null || this.timestamp.length() == 0) && this.conflict.length() > 0) {
                                this.timestamp = this.conflict;
                            }
                        } else {
                            this.timestamp = tstamp;
                        }
                    }
                }
            }
            CVSTimestampFormat stamper = CVSTimestampFormat.getInstance();
            if (this.tsCache == null && this.timestamp.length() > 0) {
                try {
                    this.tsCache = stamper.parse(this.timestamp);
                }
                catch (ParseException ex) {
                    this.tsCache = null;
                }
            }
            if (this.conflict == null || this.conflict.length() <= 0) break block22;
            try {
                this.cfCache = stamper.parse(this.conflict);
            }
            catch (ParseException ex) {
                this.cfCache = null;
            }
        }
    }

    public void setConflict(File entryFile) {
        String stampStr;
        long mTime = entryFile.lastModified();
        mTime = mTime / 1000L * 1000L;
        this.cfCache = new CVSTimestamp(mTime);
        CVSTimestamp stamp = new CVSTimestamp(this.cfCache.getTime());
        CVSTimestampFormat stamper = CVSTimestampFormat.getInstance();
        this.conflict = stampStr = stamper.format(stamp);
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public boolean isBinary() {
        return this.options.indexOf("-kb") != -1;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
        this.date = null;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.tag = null;
        this.date = date;
    }

    public CVSMode getMode() {
        return this.mode;
    }

    public void setMode(CVSMode mode) {
        this.mode = mode;
    }

    public String getModeLine() {
        return this.mode == null ? "u=rw,g=r,o=r" : this.mode.getModeLine();
    }

    public boolean isNoUserFile() {
        return this.isNoUserFile;
    }

    public void setNoUserFile(boolean isNo) {
        this.isNoUserFile = isNo;
    }

    public boolean isInConflict() {
        return this.conflict != null;
    }

    private String getConflict() {
        return this.conflict;
    }

    public boolean isNewUserFile() {
        return this.isNewUserFile;
    }

    public void setNewUserFile(boolean isNew) {
        this.isNewUserFile = isNew;
    }

    public boolean isToBeRemoved() {
        return this.isToBeRemoved;
    }

    public void setToBeRemoved(boolean toBe) {
        this.isToBeRemoved = toBe;
    }

    public boolean isLocalFileModified(File localFile) {
        if (this.forceModified) {
            System.err.println("CVSENTRY: force MOD? " + this.forceModified);
            return true;
        }
        if (this.tsCache == null) {
            return true;
        }
        return !this.tsCache.equalsTime(localFile.lastModified());
    }

    private String parseAToken(StringTokenizer toker) {
        String token = null;
        try {
            token = toker.nextToken();
        }
        catch (NoSuchElementException ex) {
            token = null;
        }
        return token;
    }

    public boolean parseEntryLine(String parseLine, boolean fromServer) throws ParseException {
        StringTokenizer toker;
        int tokeCount;
        String token = null;
        String nameToke = null;
        String versionToke = null;
        String conflictToke = null;
        String optionsToke = null;
        String tagToke = null;
        this.valid = false;
        String entryLine = parseLine;
        if (entryLine.startsWith("D/")) {
            this.isDir = true;
            entryLine = entryLine.substring(1);
        }
        if ((tokeCount = (toker = new StringTokenizer(entryLine, "/", true)).countTokens()) < 6) {
            throw new ParseException("not enough tokens in entries line (min 6, parsed " + tokeCount + ")", 0);
        }
        token = this.parseAToken(toker);
        if (token == null || !token.equals("/")) {
            throw new ParseException("could not parse name's starting slash", 0);
        }
        nameToke = this.parseAToken(toker);
        if (nameToke == null) {
            throw new ParseException("could not parse entry name", 0);
        }
        if (nameToke.equals("/")) {
            throw new ParseException("entry has an empty name", 0);
        }
        token = this.parseAToken(toker);
        if (token == null || !token.equals("/")) {
            throw new ParseException("could not parse version's starting slash", 0);
        }
        versionToke = this.parseAToken(toker);
        if (versionToke == null) {
            throw new ParseException("out of tokens getting version field", 0);
        }
        if (versionToke.equals("/")) {
            versionToke = "";
        } else {
            token = this.parseAToken(toker);
            if (token == null || !token.equals("/")) {
                throw new ParseException("could not parse conflict's starting slash", 0);
            }
        }
        conflictToke = this.parseAToken(toker);
        if (conflictToke == null) {
            throw new ParseException("out of tokens getting conflict field", 0);
        }
        if (conflictToke.equals("/")) {
            conflictToke = "";
        } else {
            token = this.parseAToken(toker);
            if (token == null || !token.equals("/")) {
                throw new ParseException("could not parse options' starting slash", 0);
            }
        }
        optionsToke = this.parseAToken(toker);
        if (optionsToke == null) {
            throw new ParseException("out of tokens getting options field", 0);
        }
        if (optionsToke.equals("/")) {
            optionsToke = "";
        } else {
            token = this.parseAToken(toker);
            if (token == null || !token.equals("/")) {
                throw new ParseException("could not parse tag's starting slash", 0);
            }
        }
        tagToke = this.parseAToken(toker);
        if (tagToke == null || tagToke.equals("/")) {
            tagToke = "";
        }
        this.valid = true;
        if (fromServer && conflictToke.length() > 0 && !conflictToke.startsWith("+")) {
            conflictToke = "";
        }
        this.setName(nameToke);
        this.setVersion(versionToke);
        this.setTimestamp(conflictToke);
        this.setOptions(optionsToke);
        if (tagToke == null || tagToke.length() < 1) {
            this.setTag(null);
        } else if (tagToke.startsWith("D")) {
            this.setDate(tagToke.substring(1));
        } else {
            this.setTag(tagToke.substring(1));
        }
        return this.valid;
    }

    public String padString(String str, int width) {
        StringBuffer result = new StringBuffer(width);
        result.append(str);
        int i = result.length() - 1;
        while (i < width) {
            result.append(" ");
            ++i;
        }
        return result.toString();
    }

    public String getAdminEntryLine() {
        if (this.isDirectory()) {
            return "D/" + this.name + "////";
        }
        StringBuffer result = new StringBuffer("");
        result.append("/" + this.name + "/");
        if (!this.isNoUserFile()) {
            if (this.isNewUserFile()) {
                result.append("0");
            } else {
                if (this.isToBeRemoved()) {
                    result.append("-");
                }
                if (this.version != null) {
                    result.append(this.version);
                }
            }
        }
        result.append("/");
        if (this.isNewUserFile()) {
            result.append("Initial " + this.getName());
        } else {
            result.append(this.timestamp);
            if (this.isInConflict()) {
                result.append("+" + this.conflict);
            }
        }
        result.append("/");
        if (this.options != null) {
            result.append(this.options);
        }
        result.append("/");
        if (this.tag != null) {
            result.append("T" + this.tag);
        } else if (this.date != null) {
            result.append("D" + this.date);
        }
        return result.toString();
    }

    public String getServerEntryLine(boolean exists, boolean isModified) {
        if (this.isDirectory()) {
            return "/" + this.name + "////";
        }
        StringBuffer result = new StringBuffer("");
        result.append("/" + this.name + "/");
        if (!this.isNoUserFile()) {
            if (this.isNewUserFile()) {
                result.append("0");
            } else {
                if (this.isToBeRemoved()) {
                    result.append("-");
                }
                if (this.version != null && !this.forceNoExistence) {
                    result.append(this.version);
                }
            }
        }
        result.append("/");
        if (this.isNewUserFile()) {
            result.append("Initial " + this.getName());
        } else if (exists && !this.forceNoExistence) {
            if (this.isInConflict()) {
                result.append("+");
            }
            if (isModified || this.forceModified) {
                result.append("modified");
            } else {
                result.append("=");
            }
        }
        result.append("/");
        if (this.options != null) {
            result.append(this.options);
        }
        result.append("/");
        if (this.tag != null && !this.forceNoExistence) {
            result.append("T" + this.tag);
        } else if (this.date != null && !this.forceNoExistence) {
            result.append("D" + this.date);
        }
        CVSTracer.traceIf(false, "getServerEntryLine: '" + result.toString() + "'");
        return result.toString();
    }

    public String toString() {
        return "[ " + this.getFullName() + "," + this.getAdminEntryLine() + " ]";
    }

    public void addFileEntries(CVSEntryVector vector) {
        CVSEntryVector entries = this.getEntryList();
        int idx = 0;
        while (idx < entries.size()) {
            CVSEntry entry = entries.entryAt(idx);
            if (!entry.isDirectory()) {
                vector.appendEntry(entry);
            }
            ++idx;
        }
    }

    public void addAllSubTreeEntries(CVSEntryVector vector) {
        CVSEntryVector dirs = new CVSEntryVector();
        CVSEntryVector list = this.getEntryList();
        int idx = 0;
        while (idx < list.size()) {
            CVSEntry entry = list.entryAt(idx);
            if (entry.isDirectory()) {
                dirs.appendEntry(entry);
            } else {
                vector.appendEntry(entry);
            }
            ++idx;
        }
        int idx2 = 0;
        while (idx2 < dirs.size()) {
            CVSEntry entry = dirs.entryAt(idx2);
            entry.addAllSubTreeEntries(vector);
            ++idx2;
        }
    }

    protected void fireChildAddedEvent(ChildEvent event) {
        int i = this.childListeners.size() - 1;
        while (i >= 0) {
            ((ChildEventListener)this.childListeners.elementAt(i)).cvsEntryAddedChild(event);
            --i;
        }
    }

    protected void fireChildRemovedEvent(ChildEvent event) {
        int i = this.childListeners.size() - 1;
        while (i >= 0) {
            ((ChildEventListener)this.childListeners.elementAt(i)).cvsEntryRemovedChild(event);
            --i;
        }
    }

    public void addChildEventListener(ChildEventListener l) {
        this.childListeners.addElement(l);
    }

    public void removeChildEventListener(ChildEventListener l) {
        this.childListeners.removeElement(l);
    }

    public String dumpString() {
        return this.dumpString("");
    }

    public String dumpString(String prefix) {
        return prefix + "CVSEntry: " + super.toString() + "\n" + prefix + "   Name: " + this.getName() + "\n" + prefix + "   FullName: " + this.getFullName() + "\n" + prefix + "   LocalDir: " + this.getLocalDirectory() + "\n" + prefix + "   Repository: " + this.getRepository() + "\n" + prefix + "   Timestamp: " + this.getTimestamp() + "\n" + prefix + "   Conflict: " + this.getConflict();
    }

    public static interface ChildEventListener {
        public void cvsEntryAddedChild(ChildEvent var1);

        public void cvsEntryRemovedChild(ChildEvent var1);
    }

    public class ChildEvent {
        CVSEntry entry;
        CVSEntry childEntry;
        int childIndex;

        public ChildEvent(int index, CVSEntry child) {
            this.childIndex = index;
            this.childEntry = child;
        }

        public CVSEntry getCVSEntry() {
            return CVSEntry.this;
        }

        public int getChildIndex() {
            return this.childIndex;
        }

        public CVSEntry getChildEntry() {
            return this.childEntry;
        }
    }
}

