/*
 * Decompiled with CFR 0.152.
 */
package com.ice.cvsc;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class CVSArgumentVector
extends Vector {
    public static final String RCS_ID = "$Id: CVSArgumentVector.java,v 2.3 2003/07/27 01:08:32 time Exp $";
    public static final String RCS_REV = "$Revision: 2.3 $";

    public CVSArgumentVector() {
    }

    public CVSArgumentVector(int initCap) {
        super(initCap);
    }

    public CVSArgumentVector(int initCap, int capIncr) {
        super(initCap, capIncr);
    }

    public String argumentAt(int index) {
        return (String)this.elementAt(index);
    }

    public void appendArgument(String argument) {
        this.addElement(argument);
    }

    public void appendArguments(Vector args) {
        int i = 0;
        int sz = args.size();
        while (i < sz) {
            this.addElement(args.elementAt(i));
            ++i;
        }
    }

    public boolean containsArgument(String argument) {
        int i = 0;
        while (i < this.size()) {
            String argStr = (String)this.elementAt(i);
            if (argStr.equals(argument)) {
                return true;
            }
            if (argStr.startsWith("-")) {
                ++i;
            }
            ++i;
        }
        return false;
    }

    public boolean containsString(String string) {
        int i = 0;
        while (i < this.size()) {
            String argStr = (String)this.elementAt(i);
            if (argStr.equals(string)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static CVSArgumentVector parseArgumentString(String argStr) {
        String newDelim = null;
        boolean matchQuote = false;
        CVSArgumentVector result = new CVSArgumentVector();
        StringTokenizer toker = new StringTokenizer(argStr, " '\"", true);
        boolean startArg = true;
        StringBuffer argBuf = new StringBuffer(argStr.length());
        while (toker.hasMoreTokens()) {
            String token;
            try {
                token = newDelim == null ? toker.nextToken() : toker.nextToken(newDelim);
                newDelim = null;
            }
            catch (NoSuchElementException ex) {
                break;
            }
            if (token.equals(" ")) {
                if (!startArg) {
                    result.addElement(argBuf.toString());
                    argBuf.setLength(0);
                }
                startArg = true;
                continue;
            }
            if (token.equals("'")) {
                startArg = false;
                if (matchQuote) {
                    newDelim = " '\"";
                    matchQuote = false;
                    continue;
                }
                newDelim = "'";
                matchQuote = true;
                continue;
            }
            if (token.equals("\"")) {
                startArg = false;
                if (matchQuote) {
                    newDelim = " '\"";
                    matchQuote = false;
                    continue;
                }
                newDelim = "\"";
                matchQuote = true;
                continue;
            }
            startArg = false;
            argBuf.append(token);
        }
        if (!startArg) {
            result.addElement(argBuf.toString());
        }
        return result;
    }
}

