/*
 * Decompiled with CFR 0.152.
 */
package com.ice.config;

import com.ice.config.ConfigurePanel;
import com.ice.pref.PrefsTuple;
import com.ice.pref.PrefsTupleTable;
import com.ice.pref.UserPrefs;
import com.ice.pref.UserPrefsFileLoader;
import com.ice.pref.UserPrefsLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class ConfigureTest
extends JPanel
implements ActionListener {
    protected JButton ok;
    protected JButton cancel;
    protected ConfigurePanel configure;
    protected UserPrefs prefs;
    protected UserPrefs specs;

    public ConfigureTest() throws IOException {
        this.setLayout(new BorderLayout());
        String dir = System.getProperty("user.dir");
        UserPrefsFileLoader loader = (UserPrefsFileLoader)UserPrefsLoader.getLoader("FileLoader");
        this.prefs = new UserPrefs("ConfigTest", null);
        this.prefs.setPropertyPrefix("com.ice.config");
        File f = new File(dir, "testprops.txt");
        if (f.exists() && f.isFile() && f.canRead()) {
            System.err.println("Loading properties file '" + f.getPath() + "'");
            loader.setFile(f);
            loader.loadPreferences(this.prefs);
        } else {
            System.err.println("Loading default properties.");
            this.setDefaultProperties(this.prefs);
        }
        this.specs = new UserPrefs("ConfigSpecs", null);
        this.specs.setPropertyPrefix("");
        f = new File(dir, "testspecs.txt");
        if (f.exists() && f.isFile() && f.canRead()) {
            System.err.println("Loading specifications file '" + f.getPath() + "'");
            loader.setFile(f);
            loader.loadPreferences(this.specs);
        } else {
            System.err.println("Loading default specifications.");
            this.setDefaultSpecifications(this.specs);
        }
        this.configure = new ConfigurePanel(this.prefs, this.specs);
        this.add("Center", this.configure);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 2));
        this.ok = new JButton("OK");
        buttons.add(this.buttonPanel(this.ok));
        this.cancel = new JButton("Cancel");
        buttons.add(this.buttonPanel(this.cancel));
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        JPanel butPan = new JPanel();
        butPan.setLayout(new BorderLayout());
        butPan.add("East", buttons);
        JPanel south = new JPanel();
        south.setLayout(new BorderLayout());
        south.add("North", new JSeparator(0));
        south.add("Center", butPan);
        this.add("South", south);
    }

    private void setDefaultProperties(UserPrefs prefs) {
        prefs.setProperty("contactDialog.title", "Contact Information");
        prefs.setProperty("contactDialog.nodesc", "No Description");
        prefs.setBoolean("contactDialog.visible", true);
        prefs.setPoint("contactDialog.origin", new Point(120, 120));
        prefs.setDimension("contactDialog.size", new Dimension(120, 120));
        prefs.setBounds("contactDialog.bounds", new Rectangle(5, 5, 120, 120));
        prefs.setDouble("contactDialog.quantity", 714.431);
        prefs.setColor("ui.color", new Color(255, 178, 64));
        prefs.setFont("ui.font", new Font("San-Serif", 1, 18));
        prefs.setFloat("numbers.float", 1990.0725f);
        prefs.setDouble("numbers.double", 1992.0618);
        prefs.setLong("numbers.long", 71404021961L);
        prefs.setInteger("numbers.integer", 19870814);
        prefs.setProperty("misc.choice", "Choice Three");
        String[] sa = new String[]{"This is string one.", "This is string two.", "This is string three. This string is going to be very very very long to see what happens.", "This is string four.", "This is string five."};
        prefs.setStringArray("misc.people", sa);
        String[] ta = new String[]{"token1", "token2", "token3"};
        prefs.setTokens("misc.tokens", ta);
        PrefsTupleTable tupT = new PrefsTupleTable();
        sa = new String[]{"1", "4", "Urgent Clinical"};
        tupT.putTuple(new PrefsTuple("1-Urgent Clinical", sa));
        sa = new String[]{"2", "4", "Urgent Member"};
        tupT.putTuple(new PrefsTuple("2-Urgent Member", sa));
        sa = new String[]{"5", "24", "Non Urgent/Routine"};
        tupT.putTuple(new PrefsTuple("5-Non Urgent/Routine", sa));
        sa = new String[]{"6", "720", "Upon Return"};
        tupT.putTuple(new PrefsTuple("6-Upon Return", sa));
        prefs.setTupleTable("misc.priorities", tupT);
    }

    private void setDefaultSpecifications(UserPrefs specs) {
        specs.setProperty("spec.client.misc.choice", "choice:misc.choice:A Choice property.");
        specs.setProperty("choice.misc.choice.1", "Choice One");
        specs.setProperty("choice.misc.choice.2", "Choice Two");
        specs.setProperty("choice.misc.choice.3", "Choice Three");
        specs.setProperty("spec.client.misc.tokens", "tokens:misc.tokens:A Tokens property.");
        specs.setProperty("spec.client.misc.people", "stringarray:misc.people:A String Array property.");
        specs.setProperty("spec.client.misc.priorities", "tupletable:misc.priorities:A Tuple Table property of priorities.");
        specs.setProperty("spec.client.ui.color", "color:ui.color:A Color property.");
        specs.setProperty("spec.client.ui.font", "font:ui.font:A Font property.");
        specs.setProperty("spec.client.numbers.float", "float:numbers.float:A Float property.");
        specs.setProperty("spec.client.numbers.double", "double:numbers.double:A Double property.");
        specs.setProperty("spec.client.numbers.long", "long:numbers.long:A Long property.");
        specs.setProperty("spec.client.numbers.integer", "integer:numbers.integer:An Integer property.");
        specs.setProperty("spec.client.contactDialog.quantity", "double:contactDialog.quantity:The quantity.");
        specs.setProperty("spec.client.contactDialog.origin", "point:contactDialog.origin:The topleft corner of the dialog when displayed.");
        specs.setProperty("spec.client.contactDialog.size", "dimension:contactDialog.size:The width and height of the dialog when it is displayed and layed out.");
        specs.setProperty("spec.client.contactDialog.title", "string:contactDialog.title:The title of the Dialog window.");
        specs.setProperty("spec.client.contactDialog.nodesc", "string:contactDialog.nodesc:");
        specs.setProperty("spec.client.contactDialog.bounds", "rectangle:contactDialog.bounds:The bounds of the Dialog window.");
        specs.setProperty("spec.client.contactDialog.visible", "boolean:contactDialog.visible:Whether or not the dialog box is visible.");
    }

    private JPanel buttonPanel(JButton button) {
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.setLayout(new BorderLayout());
        panel.add("Center", button);
        return panel;
    }

    public void actionPerformed(ActionEvent event) {
        boolean doExit = false;
        Object source = event.getSource();
        if (source == this.ok) {
            this.saveProperties();
            doExit = true;
        } else if (source == this.cancel) {
            doExit = true;
        }
        if (doExit) {
            this.setVisible(false);
            System.exit(0);
        }
    }

    public void saveProperties() {
        block2: {
            this.configure.saveCurrentEdit();
            this.configure.commit();
            String dir = System.getProperty("user.dir");
            FileDialog dlg = new FileDialog((Frame)this.getTopLevelAncestor(), "Save Properties To", 1);
            dlg.setFile("saveprops.txt");
            dlg.setDirectory(dir);
            dlg.show();
            String file = dlg.getFile();
            dir = dlg.getDirectory();
            if (file == null || dir == null) break block2;
            UserPrefsFileLoader loader = (UserPrefsFileLoader)UserPrefsLoader.getLoader("FileLoader");
            File f = new File(dir, file);
            loader.setFile(f);
            try {
                loader.storePreferences(this.prefs);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        JFrame frame = new JFrame("Configure Test");
        frame.setBounds(100, 100, 500, 440);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add("Center", new ConfigureTest());
        frame.show();
    }
}

