<?xml version="1.0"?>

  <!--XSLT 1.0 - http://www.untravelledsphere.com -->
  
  <!-- A GENERIC TRANSFORM TEMPLATE TO EMIT HTML -->

<!--
<xsl:transform xmlns:xlink="http://www.w3c.org/1999/xlink"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               xmlns:saxon="http://icl.com/saxon"
               extension-element-prefixes="saxon"
               version="1.0">
-->

<xsl:transform xmlns:xlink="http://www.w3c.org/1999/xlink"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
               xmlns:xmlorigin='http://www.xmlorigin.com/xslt'
               extension-element-prefixes="xmlorigin"
               version="1.0">
   

 <xsl:output method="html" omit-xml-declaration="yes"/>

  
  <xsl:template match="TechNote">
    <!-- <xsl:apply-templates select="Section" />  -->
    <xsl:apply-templates select="Section" mode="full">
      <xsl:with-param name="namingPrefix"></xsl:with-param>
      <xsl:with-param name="filePrefix"></xsl:with-param>
      <xsl:with-param name="relativePathPrefix"></xsl:with-param>
      <xsl:with-param name="parentPageName"></xsl:with-param>
    </xsl:apply-templates>
  </xsl:template>

  <xsl:template match="Cover">
  </xsl:template>
  

<!-- SECTION -->  
  <xsl:template match="Section" mode="full">
    <xsl:param name="namingPrefix"/>
    <xsl:param name="filePrefix"/>
    <xsl:param name="relativePathPrefix"/>
    <xsl:param name="parentPageName" />
    
     
    <xsl:variable name="dirName">
      <xsl:value-of select="$namingPrefix"/><xsl:value-of select="normalize-space(./SectionTitle)"/><xsl:text>/</xsl:text>
    </xsl:variable>

    <xsl:variable name='depth'>
       <xsl:value-of select="count(./ancestor::node())" />
    </xsl:variable >
  
    <xsl:variable name='saveFileName'>
      <xsl:if test="position() = 1"><xsl:value-of select="$filePrefix"/>index.html</xsl:if>
      <xsl:if test="position() > 1">
        <xsl:value-of select="concat($filePrefix,'page_',position(),'.html')" />
      </xsl:if>
    </xsl:variable>
    
    <xsl:variable name='fileName'>
      <xsl:if test="position() = 1"><xsl:value-of select="$namingPrefix"/>index.html</xsl:if>
      <xsl:if test="position() > 1">
        <xsl:value-of select="concat($namingPrefix,'page_',position(),'.html')" />
      </xsl:if>
    </xsl:variable>

    <xsl:variable name='prevFileName'> 
      <xsl:if test="position() = 1">
        <xsl:value-of select="concat('page_',last(),'.html')" />
      </xsl:if>
      <xsl:if test="position() = 2">index.html</xsl:if>
      <xsl:if test="position() > 2">
        <xsl:value-of select="concat('page_', position() - 1, '.html')" />
      </xsl:if>
    </xsl:variable>
    
    <xsl:variable name='nextFileName' >
      <xsl:if test="position() = last()">index.html</xsl:if>
      <xsl:if test="position() &lt; last()">
        <xsl:value-of  select="concat('page_', position() + 1, '.html')" />
      </xsl:if>
    </xsl:variable>



    
    <!-- <saxon:output href="{$saveFileName}" > -->
    <xmlorigin:document href="{$saveFileName}" method="html">
    <html>
    <head><title><xsl:value-of select="//Cover/Title" /></title></head>
    <body>

      <table border='0'>
        <tr>
           <td rowspan='2'><center><img src="{$relativePathPrefix}images/MiniLogo.jpg"/></center> </td>
           <td><center><font size='8' color='008899'><xsl:value-of select="SectionTitle"/></font></center></td>
        </tr>
        <tr>
           <td><center>
              <xsl:if test="last() > 1">
                <xsl:if test="position() > 1">
                <a href="{$prevFileName}" ><img border='0' src="{$relativePathPrefix}images/previous.jpg"/></a>
                </xsl:if>
              </xsl:if>
              <xsl:if test='$depth>2'>
                <a href="{concat('../',$parentPageName)}" ><img border='0' src="{$relativePathPrefix}images/parent.jpg"/></a>
              </xsl:if>
              <xsl:if test='$depth=2'>
                <!-- <a href="index.html" ><img border='0' src="{$relativePathPrefix}images/parent.jpg"/></a>  -->
              </xsl:if>
              <xsl:if test="last() > 1">
                <xsl:if test="position() &lt; last()" >
                <a href="{$nextFileName}" ><img border='0' src="{$relativePathPrefix}images/next.jpg" /></a>
                </xsl:if>
              </xsl:if>
              </center>
          </td>
        </tr>

      </table>

    <hr/>

    <xsl:apply-templates select="SectionContent">
      <!-- <xsl:with-param name="relativePathPrefix" select="concat('../',$relativePathPrefix)" />  -->
      <xsl:with-param name="relativePathPrefix" select="$relativePathPrefix" />
    </xsl:apply-templates>
    <hr/>

    <center>
    <table border='0'>
    <xsl:apply-templates select="./Section" mode="subsectionLinks">
      <xsl:with-param name="namingPrefix" select="$dirName" />
      <xsl:with-param name="relativePathPrefix" select="$relativePathPrefix" />
    </xsl:apply-templates>
    </table>
    </center>

    <!-- <hr size='3'/> -->
    <center>
      <small><font color='blue'>This page is maintained by Gregory Bourassa<br/>
        <a href="mailto:bourassa@magma.ca?SUBJECT=WarpStock_2002_Slides">bourassa@magma.ca</a>
        <br/>The entire site is generated automatically from a single XML document<br/>
        conforming to the TechNote DTD </font></small> 
    </center>

    </body>
    </html>
    </xmlorigin:document >
    <!-- </saxon:output> -->
    

  <xsl:apply-templates select="./Section" mode="full" >
      <xsl:with-param name="namingPrefix" select="$namingPrefix" />
      <xsl:with-param name="filePrefix" >
        <!-- select="$dirName" /> -->
        <xsl:value-of select="$filePrefix"/><xsl:value-of select="normalize-space(./SectionTitle)"/><xsl:text>/</xsl:text>
      </xsl:with-param>
      <xsl:with-param name="relativePathPrefix" select="concat('../',$relativePathPrefix)" />
      <xsl:with-param name="parentPageName" select="$fileName" />
    </xsl:apply-templates >

  </xsl:template>



  <xsl:template match="Section" mode="subsectionLinks">
    <xsl:param name="namingPrefix"/>
    <xsl:param name="filePrefix"/>
    <xsl:param name="relativePathPrefix"/>
    <xsl:param name="parentPageName"/>
    
    <xsl:variable name='fileName'>
      <xsl:if test="position() = 1"><xsl:value-of select="$namingPrefix"/>index.html</xsl:if>
      <xsl:if test="position() > 1">
        <xsl:value-of select="concat($namingPrefix,'page_',position(),'.html')" />
      </xsl:if>
    </xsl:variable>

    <tr>
      <td bgcolor='FFFF99' width='400'>
        <img src='{$relativePathPrefix}images/bulletB.gif' align='center'/>
        <strong><a href="{$fileName}"><xsl:value-of select="normalize-space(./SectionTitle)"/></a></strong>
      </td>
      <td bgcolor='DDDDFF'>
        <xsl:value-of select="./SectionContent/Paragraph[1]/List/Member[1]"/>
      </td>
    </tr>
  </xsl:template>


   
  <xsl:template match="SectionContent">
     <xsl:param name="relativePathPrefix"/>
   <xsl:apply-templates >
      <xsl:with-param name="relativePathPrefix" select="$relativePathPrefix" />
   </xsl:apply-templates >
 
  </xsl:template>

  <xsl:template match="Paragraph">
     <xsl:param name="relativePathPrefix"/>
   <xsl:apply-templates >
      <xsl:with-param name="relativePathPrefix" select="$relativePathPrefix" />
   </xsl:apply-templates >
  </xsl:template>

  <xsl:template match="List">
     <xsl:param name="relativePathPrefix"/>
    <xsl:if test="@style = 'presentation'" >
        <xsl:apply-templates select="Member" >
          <xsl:with-param name="relativePathPrefix" select="$relativePathPrefix" />
        </xsl:apply-templates>
    </xsl:if>
    <xsl:if test="@style = 'ordered'" >
       <ol><xsl:apply-templates select="Member" /></ol>
    </xsl:if>
    <xsl:if test="@style = 'unordered'" >
       <ul><xsl:apply-templates select="Member" /></ul>
    </xsl:if>
  </xsl:template>

  <xsl:template match="Member">
     <xsl:param name="relativePathPrefix"/>
    <xsl:if test="../@style='presentation'"> 
       <font size='6' color='black'>
          <img src="{$relativePathPrefix}images/spacer_1.jpg" /><xsl:value-of select="./*[1]"/>
         </font>
       <br/>
       <xsl:apply-templates select="./*[position()>1]" />
    </xsl:if>
    <xsl:if test="../@style!='presentation'"> 
       <font size='5' color='blue'><li><xsl:apply-templates/></li></font>
    </xsl:if>
  </xsl:template>

  <xsl:template match="Paragraph/T">
     <xsl:param name="relativePathPrefix"/>
    <table border='0'>
      <tr><td><img src="{$relativePathPrefix}images/spacer_2.jpg" /></td>
          <td><font size='5' color='gray'>
              <xsl:value-of select="."/>
             </font>
          </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="Member/T[position()>1]">
     <xsl:param name="relativePathPrefix"/>
    <table border='0'>
      <tr><td><img src="{$relativePathPrefix}images/spacer_2.jpg" /></td>
          <td><font size='5' color='gray'>
              <xsl:value-of select="."/>
             </font>
          </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="PageLink">
     <xsl:param name="relativePathPrefix"/>
    <table border='0'>
      <tr><td><img src="{$relativePathPrefix}images/spacer_2.jpg" /></td>
          <td><font size='5' color='gray'>
                  <a href='{@xlink:href}'><xsl:value-of select='.' /></a>
             </font>
          </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="ImageLink">
     <xsl:param name="relativePathPrefix"/>
    <br/>
  <center>
    <strong><xsl:value-of select='.' /></strong>
    <br/>
    <img alt='{.}' border='0' src='{@xlink:href}'/>
  </center>
  </xsl:template>


  <xsl:template match="CodeExample">
    <br/>
    <center>
    <table border='2'>
    <tr><td bgcolor='DDDDFF'>
    <font face='Courier' size='3' color='black'>
    <b>
    <pre>
       <xsl:value-of select='.' />
    </pre>
    </b>
    </font>
    </td></tr>
    </table>
    </center>
    <br/>
  </xsl:template>

</xsl:transform>


 