/* Print2PS.cmd v0.4 for ePDF */
"cls"
/* setup */
/* named-pipe server setup */
pipename = '\pipe\ePDF'
openmode = 'WIN'
pipemode = 'WTR'
instance_count = 1
outbuf = 4096
inbuf = 4096
timeout = -1
readbufsize = 4096

/* ps dump setup */
EOF = x2c(4) /* end of file */
oldpath = directory() /* working dir */


/* ERROR HANDLING */
SIGNAL ON SYNTAX NAME errorHandler 
SIGNAL ON ERROR NAME errorHandler
SIGNAL ON FAILURE NAME errorHandler


/* - - - - - init RXU - - - - - */
if rxfuncquery('rxuinit') then do
 Call RxFuncAdd 'rxuinit','rxu','rxuinit'
 Call rxuinit
end


/* - - - - - init RexxUtil - - - - - */
if rxfuncquery('SysLoadFuncs') then do
 call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs
end

dosrc = rxcreatenpipe('hpipe',pipename,openmode,pipemode,instance_count,
                     ,outbuf,inbuf,timeout)
if dosrc <> 0 then
  do
  say 'RxCreateNPipe failed with rc =' dosrc
  exit
  end


ReadFromPipe:

/* - - - - - get temp dir and file - - - - - */
tempdir = value(TEMP,,'OS2ENVIRONMENT')
if tempdir = '' then tempdir = value(TMP,,'OS2ENVIRONMENT')
if tempdir = '' then tempdir = directory()
rc = directory(tempdir)
if rc = 0 then do
say "Error: invalid temp directory: " tempdir
signal exit
end
if lastpos('\', tempdir) >< length(tempdir) then tempdir = tempdir||'\'
tempfile=SysTempFileName(tempdir||postscript.???)

say;say 'Waiting for PostScript data ...';say

dosrc = rxconnectnpipe(hpipe)
if dosrc <> 0 then
  do
  say 'RxConnectNPipe failed with rc =' dosrc
  exit
  end

say "   Write PostScript data to file: "tempfile
FoundEOF = 0
dosrc = rxread('data',hpipe,readbufsize)
do while word(dosrc,1) = 0 & word(dosrc,2) > 0

	/* check EOF */
	if pos(EOF, data) > 0  then do
		FoundEOF = 1
		rc = charout(tempfile, substr(data,1,pos(EOF, data)))
		end
	else if FoundEOF >< 1 then rc = charout(tempfile, data)
		/* else flush pipe */

dosrc = rxread('data',hpipe,readbufsize)

end

say "   ...done!"
rc=stream(tempfile,'c','close')
/* start ePDF */
rc = directory(oldpath)
say "   Launching ePDF..."

"@start ePDF.EXE -PS:'"||tempfile||"'"

/* flush pipe -------- */
/*
do until chars(pipename	) = 0
ps_char = charin(hpipe,,readbufsize)
end
*/

call rxdisconnectnpipe hpipe
call ReadFromPipe

exit


errorHandler:
if hpipe >< "" & hpipe >< "HPIPE" then do
 call rxdisconnectnpipe hpipe
 call rxcloseh hpipe
end
exit