/*
* WebDB.h
*
* Copyright, 1999 dSOFT Development Inc.
*
*******************************************/
#ifndef _WEBDB_H_
#define _WEBDB_H_

#define PROLOG \
    printf("HTTP/1.0 200 OK\n"); \
    printf("Content-type: text/html\n\n\n"); \
    printf("<html>\n"); \
    printf("<head>\n"); \
    printf("<title>WebDb</title>\n"); \
    printf("</head>\n");\
    printf("<body bgcolor=#CCCCCC text=#000077>\n")

#define EPILOG \
    printf("<center><hr>"); \
    printf("WebDb - dbfLIB Web Database Sample</center>\n"); \
    printf("</body>\n"); \
    printf("</html>\n")

#define IS_LEAP_YEAR( _iy1 )   \
  (( _iy1%4 == 0 && _iy1%100 != 0 || _iy1%400 == 0 ) ?  1 : 0 )

#define LEAP_DAYS_TO_ADD( _month, _year )   \
  ((_month == 2 && IS_LEAP_YEAR(_year) ) ? 1 : 0)

#define FORM_PROLOG              \
	printf("<form action=\"%s\" METHOD=\"POST\">\n",WebApp); \
	printf("<input name=\"DATABASE\" type=\"hidden\" value=\"%s\">\n", szDatabase); \
	printf("<input name=\"TRANSPATH\" type=\"hidden\" value=\"%s\">\n", szPathTranslated)

#define GET   0
#define POST  1

#define PASS_ONE   1
#define PASS_TWO   2
#define PASS_THREE 3

#define ACTION_NONE    0
#define ACTION_NEXT    1
#define ACTION_PREV    2
#define ACTION_TOP     3
#define ACTION_BOTTOM  4
#define ACTION_FIND    5
#define ACTION_ADD     6
#define ACTION_DEL	   7

#define ACTION_SAVE   90 
#define ACTION_END    99

#define ACTION_NEXT_STR		"Next >"
#define ACTION_PREV_STR		"< Prev"
#define ACTION_TOP_STR		"|<< Top"
#define ACTION_BOTTOM_STR	"Bottom >>|"
#define ACTION_FIND_STR		"Find"
#define ACTION_SAVE_STR		"Save"
#define ACTION_ADD_STR      "Save As New"
#define ACTION_DEL_STR      "Delete"

#define ACTION_NEXT_NAME	"*Next"
#define ACTION_PREV_NAME	"*Prev"
#define ACTION_TOP_NAME		"*Top"
#define ACTION_BOTTOM_NAME	"*Bottom"
#define ACTION_FIND_NAME	"*Find"
#define ACTION_SAVE_NAME	"*Save"
#define ACTION_ADD_NAME		"*Add"
#define ACTION_DEL_NAME		"*Del"

typedef struct _ACTION{
	int	 iAction;
	char szActionWord[16]; // this is the "name=" part of submit button
} ACTION, *PACTION;

int GetValue( char* pInput, char* pStr, char* pDest);
void FilterStr(char* pStr, int ip);
void CompressCopy( char* pStart, int iSkip);
void Calendar(SYSTEMTIME st, SYSTEMTIME realtime);
int rtrim( char* pStr );


#endif // _WEBDB_H_