/**************************************************
* WebDB - Sample web database program using dbfLIB
*
* This sample is provided as an example of how to 
* use dbfLIB to integrate database data into your
* web site.
*
* dbfLIB can be used many ways on the internet.
*
* Copyright 1999, dSOFT Development Inc.
* http://www.dsoftusa.com
* Email: info@dsoftusa.com
***************************************************/
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>

#define  NT 1
#include "dbftypes.h"
#include "dbflib.h"
#include "WebDb.h"

//#define DBG 1
#define DBG 0
#if DBG
	#define DBGPRINTF( _s_ )  printf _s_
#else
	#define DBGPRINTF( _s_ )  
#endif

//
// Globals
//
char input[8192], output[8192];
char szImagePath[128];
char szDatabase[_MAX_PATH];
char szPathTranslated[_MAX_PATH];
char szPath[_MAX_PATH];
char WebApp[64], workbuf[256];
char szHttpHost[128];
char szTmp[256]; 
PDBF pDbf;

ACTION Action[] = {
	{ACTION_NEXT, ACTION_NEXT_NAME}, 
	{ACTION_PREV, ACTION_PREV_NAME},
	{ACTION_TOP,  ACTION_TOP_NAME},
	{ACTION_BOTTOM, ACTION_BOTTOM_NAME},
	{ACTION_FIND, ACTION_FIND_NAME},
	{ACTION_SAVE, ACTION_SAVE_NAME},
	{ACTION_ADD, ACTION_ADD_NAME},
	{ACTION_DEL, ACTION_DEL_NAME},

	{ACTION_END, " "}
};

//////////////////////////////////////////////////////////////
main( int argc, char *argv[ ], char *envp[ ])
{
	char *pev, *ptr;
	int iMode = PASS_ONE, iAction = 0, iDateLen;
	size_t content_length = 0;
    SYSTEMTIME curtime, date, defDate;
	long RequestMethod = -1; 
	DS_SHORT i, numflds, iType;
	char szFldName[16];
	long recno = 0;

	memset(szImagePath, 0x0, sizeof(szImagePath));
	memset(szDatabase,  0x0, sizeof(szDatabase));
	//
	// Parse the command line, looking for database name
	//
	if (argc > 1){
		strcpy(szDatabase, argv[1]);
	}


    PROLOG;

	//
	// Set some defaults for dbfLIB...
	//
	SetPadding( OFF );
	defDate.wMonth = 0; // set default date to invalid.

	//
	// Get our environment...
	//
	pev = getenv("REQUEST_METHOD");
	if (pev)
    {
        if (strstr(pev, "GET"))
			RequestMethod = GET;
		else if (strstr(pev, "POST"))
			RequestMethod = POST;
    }


	pev = getenv("CONTENT_LENGTH");
	if (pev)
    {
		content_length = atoi(pev);
	}

	if (RequestMethod == POST)
	{
		if (!fread(input, content_length, 1, stdin)) {
			// 
			// Un-comment the following if you are expecting to
			// read in form input, but dont get any...
			//
			// printf("<b>ERROR: Couldn't read CGI input from STDIN.\n") ;
		} 

	}
	if (RequestMethod == GET)
	{
		pev = getenv("QUERY_STRING");
		if (pev)
			strcpy(input, pev);
	}

	if (RequestMethod != GET && RequestMethod != POST)
	{
		printf("<b>ERROR: Do not recognize REQUEST_METHOD.</b>\n");
		goto Epilog;
	}

	//
	// Read in the real path to our web page
	//
	pev = getenv("PATH_TRANSLATED");
	if (pev)
    {
		strcpy(szPathTranslated, pev);
        strcat(szPathTranslated, "\\");
    }

	//
	// The name of our executable as presented by the webserver
	//
	pev = getenv("SCRIPT_NAME");
	if (pev)
    {
		strcpy(WebApp, pev);
		DBGPRINTF(("SCRIPT_NAME is %s<br>\n", pev));
    }

	////////////
	//
	// Parse the input
	//

	FilterStr( input, iMode );

    GetLocalTime( &curtime );

	szHttpHost[0] = 0x0;
	//
	// Lets first check to see if the raw translated path
	// is provided.  This will normally NOT be provided 
	// the first time the exe is invoked from an html file.
	// The order of precedence is to use the TRANSPATH if
	// it exists, and if not then go try to figure it out.
	//
	if (GetValue(input, "TRANSPATH",  szPath))
	{
		// using TRANSPATH instead of PATH_TRANSLATED
		strcpy(szPathTranslated, szPath);
		DBGPRINTF(("Path provided is %s<br>\n", szPathTranslated));

	}else{
		// 
		// When this program is invoked from the html file
		// the path is not obvious.  For example if the
		// html file is in www.myname.com/mydir
		// then PATH_TRANSLATED will simply be the
		// path to www.myname.com (like C:\Web )
		// So, in an attempt to be able to get to
		// the proper directory we take HTTP_REFERER
		// which in this case will contain 
		// www.myname.com/mydir/myfile.htm  then we
		// subtract out the host name from it and 
		// strip off the html filename we end up
		// with C:\Web\mydir  which works fine.
		//
		// There is one exception to this working, and
		// that is if /mydir is a virtual directory
		// then the previous logic for getting to the real
		// path wont work.
		//

		pev = getenv("HTTP_HOST");
		if (pev)
		{
			DBGPRINTF(("HTTP_HOST is %s<br>\n",
				pev));
			strcpy(szHttpHost, pev);

			pev = getenv("HTTP_REFERER");
			if (pev)
			{
				DBGPRINTF(("HTTP_REFERER is %s<br>\n",
					pev));
				strcpy(szImagePath, pev);
				// look for http_host in http_referer
				ptr = strstr(pev, szHttpHost);
				if (ptr)
				{
					ptr += (strlen(szHttpHost) + 1);
					strcat(szPathTranslated, ptr);
					// now cut off referer html filename
					ptr = strrchr(szPathTranslated, '/');
					if (ptr)
						*ptr = 0x0;
					strcat(szPathTranslated, "\\");
				}
				// now cut off referer html filename so we can load images
				ptr = strrchr(szImagePath, '/');
				if (ptr)
					*ptr = 0x0;
			}
		}
	} // endif GetValue("TRANSPATH")	

	//
	// Get the database to edit from the input buffer if it
	// was not provided on the command line.
	//
	if (strlen(szDatabase) == 0)
	{
		if ( !GetValue(input, "DATABASE",  szDatabase) )
		{
			// Since no database name provided, define a default
			strcpy(szDatabase, "WebDb.dbf");
		}
	}

	//
	// Open the database here 
	// 
	strcpy(szPath, szPathTranslated);
	strcat(szPath, szDatabase);
	DBGPRINTF(("Opening %s<br>\n",szPath));

	pDbf = DbfUse(szPath);
	if (pDbf == NULL)
	{
		// Put code here to create the database if not found!
		//
		printf("<b>ERROR:</b> Could not open database %s.<br>\n",szPath);
		goto Epilog;
	}
	// 
	// At this point, you could open or create an index file so that
	// the records would appear in some logical order.  Without an
	// index, they simply appear in physical order.
	//
	/******
	// open the index
	strcpy(szPath, szPathTranslated);
	strcat(szPath, "WebDb.ndx");
	if (IndexOpen(pDbf, szPath, AUTO_INDEX) < 0)
	{
		if (IndexCreate(pDbf, szPath, "LASTNAME+FIRSTNAME", NDX) < 0)
		{
			printf("<b>Error:</b> Creating user lastname index.<br>\n");
			goto Epilog;
		}
	}
	************/


	DbfTop(pDbf);
	SetDbfDateFormat("MM/DD/CCYY");
	iDateLen= strlen("MM/DD/CCYY");

	//
	// Now, simply print out HTML and you have your displayed
	// web page, dynamically created.
	//
	printf("<table border=0><tr><td>");
	printf("<h1>WebDb - Sample dbfLIB Web Database App</h1>\n");
	printf(	"<i>This entire web page was generated dynamically by "
			"a an executable running on a webserver.  Each time "
			"you interact with this web page, you are creating "
			"new content.</i><hr>\n");
	printf("Enter your name (or any name) and press the \"Save As New\" "
		   "button which will add the record to the database. You can "
		   "also press the navigation buttons to show each record "
		   "individually.");

	printf("</td><td Align=right>");

	// 
	// Print a calendar
	//
	date = curtime;
	Calendar( date, curtime );
	printf("</td></tr></table>");

	//
	// Get the intended user action...
	//
	iAction = ACTION_NONE;
	i = 0;
	while ( Action[i].iAction != ACTION_END )
	{
		if (GetValue(input, Action[i].szActionWord, workbuf)){
			DBGPRINTF(("Action %s = %s<br>", 
				Action[i].szActionWord, workbuf));
			iAction = Action[i].iAction;
			break;
		}
		i++;
	} // end for


	//
	// See if previous record number was provided and go to it.
	//
	if (GetValue(input, "RECNO", szTmp))
	{
		recno = atol(szTmp);
		if (DbfGo(pDbf, recno) != recno) // if problem go top 
			DbfTop(pDbf);
	}
	else
	{
		DbfTop(pDbf);
	}

	switch (iAction)
	{
	case ACTION_NEXT:
		DbfSkip(pDbf, 1);
		break;
	case ACTION_PREV:
		DbfSkip(pDbf, -1);
		break;
	case ACTION_TOP:
		DbfTop(pDbf);
		break;
	case ACTION_BOTTOM:
		DbfBottom(pDbf);
		break;
	case ACTION_DEL:
		DbfDelete(pDbf, pDbf->recno);
		DbfSkip(pDbf, 1);
		break;
	case ACTION_ADD:
		DbfClearRecBuf( pDbf );
		recno = 0; // default to new record with zero
		
		numflds = FldCount( pDbf );
		for( i=0; i < numflds; i++)
		{
			DS_SHORT iWidth;
			double dTmp;
			short int sLogical;

			iWidth = FldWidth(pDbf, (DS_SHORT)i);
			FldName(pDbf, i, szFldName);
			iType = FldType(pDbf, i);
			if ( GetValue(input, szFldName, szTmp) )
			{
				switch( iType ){
				case CHARACTER_FLD:
					FldReplace(pDbf, i, szTmp);
					break;
				case NUMERIC_FLD:
					dTmp = atof(szTmp);
					FldReplaceNum(pDbf, i, &dTmp);
					break;
				case LOGICAL_FLD:  // use check-box for logical
					sLogical = (szTmp[0] == 'T');
					FldReplaceLog(pDbf, i, &sLogical);
					break;
				case DATE_FLD:
					FldReplaceDate(pDbf, i, szTmp);
					break;
				case MEMO_FLD:
					// BUGBUG: TODO
					// do nothing for memo fields right now
					break;
				default: 
					break;
				}

			} // endif GetValue
			else
			{	
				// 
				// Since a variable is not posted when a field is
				// empty or a checkbox is un-checked, we must assume 
				// that the field is empty (or false if logical field)
				// 
				char* pFld = FldPtr(pDbf, i);

				switch( iType )
				{
					case CHARACTER_FLD:
					case DATE_FLD:
					case NUMERIC_FLD:
						if (pFld)
							memset(pFld, ' ', iWidth);
						break;
					case LOGICAL_FLD:
						sLogical = FALSE;
						FldReplaceLog(pDbf, i, &sLogical);
						break;
				} // end switch
			}
		}

		if (DbfWriteRec(pDbf, recno) != DBF_SUCCESS)
			printf("<b>ERROR:</b> Unable to save record.<br>");

		break;
	//
	// If you wanted to update an existing record here, you would
	// do the same thing as ACTION_ADD without clearing the record
	// buffer, and setting the recno to the record you wished to
	// update.
	// case ACTION_SAVE: 
	//	recno = pDbf->recno;

	default:
		break;
	} // end switch (iAction)

	//
	// Show the record database
	//
	FORM_PROLOG;
	
	printf("<table border=0 width=\"100%%\"><td>");

	printf("<input name=\"RECNO\" type=\"hidden\" value=\"%d\">\n", 
		DbfRecno(pDbf) ); 
	numflds = FldCount( pDbf );
	printf("<table border=1>\n");
	//
	// Get the data from the user
	//
	printf("<tr><td align=right width=\"15%%\"><b>Firstname:</b>");
	printf("</td>\n<td align=left>");
	printf("<input name=\"FNAME\" size=\"25\"></td></tr>\n");

	printf("<tr><td align=right width=\"15%%\"><b>Lastname:</b>");
	printf("</td>\n<td align=left>");
	printf("<input name=\"LNAME\" size=\"25\"></td></tr>\n");

	printf("<tr><td align=right width=\"15%%\"><b>Email:</b>");
	printf("</td>\n<td align=left>");
	printf("<input name=\"EMAIL\" size=\"25\"></td></tr>\n");

	printf("<tr><td><input type=\"SUBMIT\" value=\"%s\" name=\"%s\"></td></tr>", 
		ACTION_ADD_STR, ACTION_ADD_NAME);    
	printf("</table>\n");

	printf("</td><td>");

	printf("<table border=1");
	printf("<tr><td align=right width=\"15%%\"><b>Firstname:</b>");
	printf("</td>\n<td align=left>");
	FldRefCopy(pDbf, "FNAME", szTmp);
	printf("%s</td>\n",szTmp);

	printf("<tr><td align=right width=\"15%%\"><b>Lastname:</b>");
	printf("</td>\n<td align=left>");
	FldRefCopy(pDbf, "LNAME", szTmp);
	printf("%s</td>\n",szTmp);

	printf("<tr><td align=right width=\"15%%\"><b>Email:</b>");
	printf("</td>\n<td align=left>");
	FldRefCopy(pDbf, "EMAIL", szTmp);
	printf("%s</td>\n",szTmp);

	printf("</table>\n");

	printf("<table border=0 width=\"100%%\"><tr><td>\n");
	printf("<input type=\"SUBMIT\" value=\"%s\" name=\"%s\">\n", 
		ACTION_TOP_STR, ACTION_TOP_NAME);    
	printf("<input type=\"SUBMIT\" value=\"%s\" name=\"%s\">\n", 
		ACTION_PREV_STR, ACTION_PREV_NAME);    
	printf("<input type=\"SUBMIT\" value=\"%s\" name=\"%s\">\n", 
		ACTION_NEXT_STR, ACTION_NEXT_NAME);    
	printf("<input type=\"SUBMIT\" value=\"%s\" name=\"%s\">\n", 
		ACTION_BOTTOM_STR, ACTION_BOTTOM_NAME);

	printf("</td><td align=right>Record %d of %d", pDbf->recno, DbfReccount(pDbf));
	printf("</td></tr>\n");
	printf("</table>");

	printf("</table><br>\n");

	//
	// Get the user action
	//
	printf("</form>\n");    

	//
	// Print the database
	//
	DbfBottom(pDbf);
	printf("<table border=0 width=\"100%%\">\n");
	printf("<tr BGCOLOR=#00CCCC><td align=left><b>Record</b></td>"
			"<td Align=left><b>Firstname</b></td>\n"
			   "<td Align=left><b>Lastname</b></td>\n"
			   "<td Align=left><b>Email</b></td></tr>\n");

	do {

		printf("<tr>\n"); // new row

		printf("<td>%ld</td>\n",pDbf->recno);

		FldRefCopy(pDbf, "FNAME", szTmp);
		printf("<td>%s</td>\n",szTmp);

		FldRefCopy(pDbf, "LNAME", szTmp);
		printf("<td>%s</td>\n",szTmp);

		FldRefCopy(pDbf, "EMAIL", szTmp);
		printf("<td>%s</td>\n",szTmp);

		printf("</tr>\n"); // end of row


	}while(DbfSkip(pDbf, -1) == DBF_SUCCESS);

	printf("</table><br>\n");
		
Epilog:
	EPILOG;
	DbfCloseAll();
return 0;
}

/////////////////////////////////////////////////////////////////
// Function: GetValue
//
// This function retrieves a set value from an input string.
// The format of the input string is as recieved from the
// GET or POST format.
//
int GetValue( char* pInput, char* pStr, char* pDest)
{
    char* ptr;
	char* pEq;
	char* pVal;
	int len;

	pDest[0] = 0x0;

	ptr = strstr(pInput, pStr);
	if (ptr == NULL)
		return FALSE;

    pEq = strchr(ptr, '=');
	if (pEq == NULL)
		return FALSE;

	pVal = pEq + 1;
	if (*pVal == '&' || *pVal == 0x0 || *pVal == ' ')
		return FALSE;

	pEq = strchr(pVal, '&'); // re-use pEq here...
	if (pEq)
		len = pEq - pVal;
	else
		len = strlen(pVal);

	strncpy(pDest, pVal, len);
	pDest[len] = 0x0;
return TRUE;
} // GetValue()

////////////////////////////////////////////////////////////////
// Function: FilterStr
//
// This function translates hex codes for certain characters in
// the input string received from the webserver into the 
// proper character.  
// 
// For example, a pound sign (#) is received in the input string
// as %23.  This function simply replaces all instances of %23
// with #.
//
void FilterStr(char* pStr, int iPass)
{
	char* ptr;

	// Ampersand presents a problem, because it is used to delimit
	// form variables in the input stream. If we replace "%26"
	// with "&" then GetValue() does not work right.  So, for now,
	// we will replace ampersand with the word "and".
	ptr = strstr(pStr, "%26"); // ampersand
	while ( ptr ){
		strncpy(ptr, "and", 3);
		ptr = strstr(pStr, "%26"); // ampersand
	}
	
	// Change double quotes to single quotes.
	ptr = strstr(pStr, "%22"); // double quote
	while ( ptr ){
		*ptr = 0x27;
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%22"); // double quote
	}
	
	ptr = strstr(pStr, "%23"); // pound sign
	while ( ptr ){
		*ptr = '#';
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%23"); // pound sign
	}
	
	ptr = strstr(pStr, "%27"); // APOSTROPHE
	while ( ptr ){
		*ptr = 0x27;
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%27"); // APOSTROPHE
	}

	ptr = strstr(pStr, "%28"); // left paren
	while ( ptr ){
		*ptr = '(';
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%28"); // left paren
	}
	
	ptr = strstr(pStr, "%29"); // right paren
	while ( ptr ){
		*ptr = ')';
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%29"); // right paren
	}
	
	ptr = strstr(pStr, "%2C"); // COMMA
	while ( ptr ){
		*ptr = ',';
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%2C"); // COMMA
	}

	ptr = strstr(pStr, "%2F"); // SLASH
	while ( ptr ){
		*ptr = '/';
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%2F"); // SLASH
	}

	ptr = strstr(pStr, "%3A"); // COLON
	while ( ptr ){
		*ptr = 0x3A;
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%3A"); // COLON
	}

	ptr = strstr(pStr, "%0D%0A"); // CR-LF
	while ( ptr ){
		strncpy(ptr, "<br>", 4);
		ptr += 4;
		CompressCopy(ptr, 2);
		ptr = strstr(pStr, "%0D%0A"); // CR-LF
	}

	ptr = strchr(pStr, '+'); // PLUS signs need to be spaces
	while ( ptr ){
		*ptr = ' ';
		ptr = strchr(pStr, '+');
	}

	ptr = strstr(pStr, "%5C"); // BACKSLASH
	while ( ptr ){
		*ptr = '\\';
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%5C"); // BACKSLASH
	}

	ptr = strstr(pStr, "%7E"); // tilde
	while ( ptr ){
		*ptr = '~';
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%7E"); // tilde
	}

	ptr = strstr(pStr, "%21"); // exclaimation point
	while ( ptr ){
		*ptr = '!';
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%21"); 
	}

	ptr = strstr(pStr, "%24"); // dollar sign
	while ( ptr ){
		*ptr = '$';
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%24"); 
	}

	ptr = strstr(pStr, "%25"); // percent
	while ( ptr ){
		*ptr = 0x25;
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%25"); 
	}

	ptr = strstr(pStr, "%5E"); // up carat
	while ( ptr ){
		*ptr = 0x5E;
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%5E"); 
	}

	ptr = strstr(pStr, "%2B"); // plus sign
	while ( ptr ){
		*ptr = 0x2B;
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%2B"); 
	}

	ptr = strstr(pStr, "%60"); // left single quote
	while ( ptr ){
		*ptr = 0x60;
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%60"); 
	}

	ptr = strstr(pStr, "%3D"); // equal sign
	while ( ptr ){
		*ptr = '=';
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%3D"); 
	}

	ptr = strstr(pStr, "%5B"); // left square bracket
	while ( ptr ){
		*ptr = '[';
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%5B"); 
	}

	ptr = strstr(pStr, "%5D"); // right square bracket
	while ( ptr ){
		*ptr = ']';
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%5D"); 
	}

	ptr = strstr(pStr, "%7B"); // left curly bracket
	while ( ptr ){
		*ptr = 0x7B;
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%7B"); 
	}

	ptr = strstr(pStr, "%7D"); // right curly bracket
	while ( ptr ){
		*ptr = 0x7D;
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%7D"); 
	}

	ptr = strstr(pStr, "%7C"); // logical OR character |
	while ( ptr ){
		*ptr = 0x7C;
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%7C"); 
	}

	ptr = strstr(pStr, "%3B"); // semi-colon
	while ( ptr ){
		*ptr = 0x3B;
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%3B"); 
	}

	ptr = strstr(pStr, "%3C"); // less than
	while ( ptr ){
		*ptr = 0x3C;
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%3C"); 
	}

	ptr = strstr(pStr, "%3E"); // greater than
	while ( ptr ){
		*ptr = 0x3E;
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%3E"); 
	}

	ptr = strstr(pStr, "%3F"); // question mark
	while ( ptr ){
		*ptr = 0x3F;
		CompressCopy(++ptr, 2);
		ptr = strstr(pStr, "%3F"); 
	}

return;
}
/////////////////////////////////////////////////////////////////
// Function: CompressCopy
//
// This function copies a string from right to left skipping the
// number of characters indicated.
//
void CompressCopy( char* pStart, int iSkip)
{
	char* ptr  = pStart;
	char* psrc = pStart + iSkip;

	do {
		*ptr = *psrc;
		ptr++;
		psrc++;
	} while(*psrc != 0x0);

	*ptr = 0x0;
}
//////////////////////////////////////////////////////////////////////////////
// Function: Calendar()
//
// This function simply prints out a month in html table format
// using the input date. It also highlights the current day 
// based on the date provided in the 'realtime' parameter.
//
void Calendar(SYSTEMTIME st, SYSTEMTIME realtime)
{
    FILETIME ft;
	SYSTEMTIME curtime;
    int i, days, dow;
	static WORD daysInMonth[] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
	static char szMonth[12][10] = {
    "January", "February", "March", "April", "May", "June",
    "July", "August", "September", "October", "November", "December"};

	curtime = st;

    days = daysInMonth[ curtime.wMonth-1 ] +
               LEAP_DAYS_TO_ADD( curtime.wMonth, curtime.wYear );

    // now get day of week for first day of current month
    curtime.wDay = 1;
    SystemTimeToFileTime( &curtime, &ft );
    FileTimeToSystemTime( &ft, &curtime );
    dow = curtime.wDayOfWeek;

    printf("\n<table border=1><caption><b>%s %d</b></caption>\n", 
		szMonth[curtime.wMonth-1], curtime.wYear);
    printf("<tr>\n"
           "  <th>S</th>\n"
           "  <th>M</th>\n"
           "  <th>T</th>\n"
           "  <th>W</th>\n"
           "  <th>T</th>\n"
           "  <th>F</th>\n"
           "  <th>S</th>\n");

    printf("</tr><tr>\n");

    for (i = 0; i < dow; i++)
        printf("  <td>*</td>\n");

    for (i=1; i <= days; i++)
    {
		if (i == realtime.wDay && curtime.wMonth == realtime.wMonth)
			printf("  <td BGCOLOR=#FFFFCC><b>%d</b></td>\n",i);
		else
			printf("  <td>%d</td>\n",i);
        if (++dow > 6){
            dow = 0;
            printf("</tr><tr>\n");
            }
    }
    printf("</tr>\n</table>\n");

} // Calendar()

//////////////////////////////////////////////////////////////////////
// Function: rtrim()
//
// This function simply trims off trailing spaces from a string.
//
int rtrim( char* pStr )
{
	int i;
	for (i=0; i < (int)strlen(pStr); i++)
		{
		if (pStr[i] == ' ')   // trim off white space
			pStr[i] = 0x0;
		if (pStr[i] == 0x0)
			break;
		}
	return (strlen(pStr));
} // rtrim()
