/*
 * Decompiled with CFR 0.152.
 */
package net.dnsalias.pcb.csveditor.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.dnsalias.pcb.csveditor.gui.CsvEditor;
import net.dnsalias.pcb.utilities.HelperClass;

public class DelimiterDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    public static final long serialVersionUID = 19650221L;
    private int option;
    private char colDelimiterSelection;
    private char colDelimiterFormerSelection;
    private char textDelimiterSelection;
    private char textDelimiterFormerSelection;
    private boolean isValid = false;
    private JFrame owner;
    private JTextField tfColDelimiter;
    private JTextField tfTextDelimiter;
    private JOptionPane dialogPane;
    private JLabel lblColDelimiter;
    private JLabel lblTextDelimiter;
    private ButtonGroup bgColDelimiterButtons;
    private ButtonGroup bgTextDelimiterButtons;
    private JRadioButton rbColDelimiterSemicolon;
    private JRadioButton rbColDelimiterComma;
    private JRadioButton rbColDelimiterTab;
    private JRadioButton rbColDelimiterSpace;
    private JRadioButton rbColDelimiterOther;
    private JRadioButton rbTextDelimiterDoubleQuote;
    private JRadioButton rbTextDelimiterSingleQuote;
    private JRadioButton rbTextDelimiterOther;
    private ResourceBundle resourceBundle;
    private static final String resourceSrc = "resources/DelimiterDialogResources";

    public DelimiterDialog(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.resourceBundle = HelperClass.getResourceBundleFromJar(resourceSrc, "UTF-8");
        this.createAndShowGUI();
    }

    public DelimiterDialog(CsvEditor owner, boolean modal, char colFormerSelection, char textFormerSelection) {
        this(owner, owner.getAppname(), modal, colFormerSelection, textFormerSelection);
    }

    public DelimiterDialog(CsvEditor owner, String title, boolean modal, char colFormerSelection, char textFormerSelection) {
        super(owner, title, modal);
        this.owner = owner;
        this.colDelimiterFormerSelection = colFormerSelection;
        this.colDelimiterSelection = colFormerSelection;
        this.textDelimiterFormerSelection = textFormerSelection;
        this.textDelimiterSelection = textFormerSelection;
        this.resourceBundle = HelperClass.getResourceBundleFromJar(resourceSrc, "UTF-8");
        this.createAndShowGUI();
    }

    private void createAndShowGUI() {
        this.dialogPane = new JOptionPane(this.resourceBundle.getString("Select_Delimiter"), -1, 2);
        this.dialogPane.addPropertyChangeListener(this);
        this.lblColDelimiter = new JLabel(this.resourceBundle.getString("Select_ColumnDelimiter"));
        this.rbColDelimiterSemicolon = new JRadioButton(this.resourceBundle.getString("Semicolon"));
        this.rbColDelimiterSemicolon.addActionListener(this);
        this.rbColDelimiterComma = new JRadioButton(this.resourceBundle.getString("Comma"));
        this.rbColDelimiterComma.addActionListener(this);
        this.rbColDelimiterTab = new JRadioButton(this.resourceBundle.getString("Tabulator"));
        this.rbColDelimiterTab.addActionListener(this);
        this.rbColDelimiterSpace = new JRadioButton(this.resourceBundle.getString("Space"));
        this.rbColDelimiterSpace.addActionListener(this);
        this.rbColDelimiterOther = new JRadioButton(this.resourceBundle.getString("Other"));
        this.rbColDelimiterOther.addActionListener(this);
        this.bgColDelimiterButtons = new ButtonGroup();
        this.bgColDelimiterButtons.add(this.rbColDelimiterSemicolon);
        this.bgColDelimiterButtons.add(this.rbColDelimiterComma);
        this.bgColDelimiterButtons.add(this.rbColDelimiterTab);
        this.bgColDelimiterButtons.add(this.rbColDelimiterSpace);
        this.bgColDelimiterButtons.add(this.rbColDelimiterOther);
        this.tfColDelimiter = new JTextField();
        this.tfColDelimiter.setDocument(new LengthLimitedDocument(1));
        this.tfColDelimiter.setAlignmentX(0.0f);
        this.tfColDelimiter.addPropertyChangeListener(this);
        this.tfColDelimiter.setEnabled(false);
        this.lblTextDelimiter = new JLabel(this.resourceBundle.getString("Select_TextDelimiter"));
        this.rbTextDelimiterSingleQuote = new JRadioButton(this.resourceBundle.getString("SingleQuote"));
        this.rbTextDelimiterSingleQuote.addActionListener(this);
        this.rbTextDelimiterDoubleQuote = new JRadioButton(this.resourceBundle.getString("DoubleQuote"));
        this.rbTextDelimiterDoubleQuote.addActionListener(this);
        this.rbTextDelimiterOther = new JRadioButton(this.resourceBundle.getString("Other"));
        this.rbTextDelimiterOther.addActionListener(this);
        this.bgTextDelimiterButtons = new ButtonGroup();
        this.bgTextDelimiterButtons.add(this.rbTextDelimiterSingleQuote);
        this.bgTextDelimiterButtons.add(this.rbTextDelimiterDoubleQuote);
        this.bgTextDelimiterButtons.add(this.rbTextDelimiterOther);
        this.tfTextDelimiter = new JTextField();
        this.tfTextDelimiter.setDocument(new LengthLimitedDocument(1));
        this.tfTextDelimiter.setAlignmentX(0.0f);
        this.tfTextDelimiter.addPropertyChangeListener(this);
        this.tfTextDelimiter.setEnabled(false);
        JPanel panel = new JPanel();
        GridBagLayout l = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(l);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.anchor = 17;
        panel.add((Component)this.lblColDelimiter, c);
        c.gridy = 1;
        panel.add((Component)this.rbColDelimiterSemicolon, c);
        c.gridy = 2;
        panel.add((Component)this.rbColDelimiterComma, c);
        c.gridy = 3;
        panel.add((Component)this.rbColDelimiterTab, c);
        c.gridy = 4;
        panel.add((Component)this.rbColDelimiterSpace, c);
        c.gridy = 5;
        c.gridwidth = 1;
        panel.add((Component)this.rbColDelimiterOther, c);
        c.gridx = 1;
        c.insets = new Insets(0, 4, 0, 0);
        c.fill = 2;
        panel.add((Component)this.tfColDelimiter, c);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 2;
        c.insets = new Insets(0, 40, 0, 0);
        c.fill = 0;
        panel.add((Component)this.lblTextDelimiter, c);
        c.gridy = 1;
        panel.add((Component)this.rbTextDelimiterSingleQuote, c);
        c.gridy = 2;
        panel.add((Component)this.rbTextDelimiterDoubleQuote, c);
        c.gridy = 3;
        c.gridwidth = 1;
        panel.add((Component)this.rbTextDelimiterOther, c);
        c.gridx = 3;
        c.insets = new Insets(0, 4, 0, 0);
        c.fill = 2;
        panel.add((Component)this.tfTextDelimiter, c);
        panel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        this.dialogPane.add((Component)panel, 1);
        this.setContentPane(this.dialogPane);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.owner);
        this.setColDelimiterSelection(this.colDelimiterSelection);
        this.setTextDelimiterSelection(this.textDelimiterSelection);
        this.setVisible(true);
        this.dialogPane.selectInitialValue();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char c = '/';
        if (e.getSource() == this.rbColDelimiterSemicolon) {
            c = ';';
            this.setColDelimiterSelection(c);
        } else if (e.getSource() == this.rbColDelimiterComma) {
            c = ',';
            this.setColDelimiterSelection(c);
        } else if (e.getSource() == this.rbColDelimiterTab) {
            c = '\t';
            this.setColDelimiterSelection(c);
        } else if (e.getSource() == this.rbColDelimiterSpace) {
            c = ' ';
            this.setColDelimiterSelection(c);
        } else if (e.getSource() == this.rbColDelimiterOther) {
            c = '/';
            this.setColDelimiterSelection(c);
        } else if (e.getSource() == this.rbTextDelimiterSingleQuote) {
            c = '\'';
            this.setTextDelimiterSelection(c);
        } else if (e.getSource() == this.rbTextDelimiterDoubleQuote) {
            c = '\"';
            this.setTextDelimiterSelection(c);
        } else if (e.getSource() == this.rbTextDelimiterOther) {
            c = '\\';
            this.setTextDelimiterSelection(c);
        }
    }

    private void setColDelimiterSelection(char c) {
        switch (c) {
            case ';': {
                this.rbColDelimiterSemicolon.setSelected(true);
                this.tfColDelimiter.setText(Character.toString(c));
                this.tfColDelimiter.setEnabled(false);
                break;
            }
            case ',': {
                this.rbColDelimiterComma.setSelected(true);
                this.tfColDelimiter.setText(Character.toString(c));
                this.tfColDelimiter.setEnabled(false);
                break;
            }
            case '\t': {
                this.rbColDelimiterTab.setSelected(true);
                this.tfColDelimiter.setText(Character.toString(c));
                this.tfColDelimiter.setEnabled(false);
                break;
            }
            case ' ': {
                this.rbColDelimiterSpace.setSelected(true);
                this.tfColDelimiter.setText(Character.toString(c));
                this.tfColDelimiter.setEnabled(false);
                break;
            }
            default: {
                this.rbColDelimiterOther.setSelected(true);
                this.tfColDelimiter.setText(Character.toString(c));
                this.tfColDelimiter.setEnabled(true);
            }
        }
    }

    private void setTextDelimiterSelection(char c) {
        switch (c) {
            case '\'': {
                this.rbTextDelimiterSingleQuote.setSelected(true);
                this.tfTextDelimiter.setText(Character.toString(c));
                this.tfTextDelimiter.setEnabled(false);
                break;
            }
            case '\"': {
                this.rbTextDelimiterDoubleQuote.setSelected(true);
                this.tfTextDelimiter.setText(Character.toString(c));
                this.tfTextDelimiter.setEnabled(false);
                break;
            }
            default: {
                this.rbTextDelimiterOther.setSelected(true);
                this.tfTextDelimiter.setText(Character.toString(c));
                this.tfTextDelimiter.setEnabled(true);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.dialogPane && prop.equals("value")) {
            this.isValid = false;
            try {
                this.colDelimiterSelection = this.tfColDelimiter.getText().charAt(0);
                this.textDelimiterSelection = this.tfTextDelimiter.getText().charAt(0);
                this.isValid = true;
            }
            catch (IndexOutOfBoundsException ioobe) {
                this.isValid = false;
                this.colDelimiterSelection = this.colDelimiterFormerSelection;
                this.textDelimiterSelection = this.textDelimiterFormerSelection;
            }
            this.option = (Integer)this.dialogPane.getValue();
            if (this.option == 2) {
                this.colDelimiterSelection = this.colDelimiterFormerSelection;
                this.textDelimiterSelection = this.textDelimiterFormerSelection;
                this.setVisible(false);
            }
            if (this.option == 0 && this.isValid) {
                this.setVisible(false);
            }
        }
    }

    public int getOption() {
        return this.option;
    }

    public char getColDelimiterSelection() {
        return this.colDelimiterSelection;
    }

    public char getTextDelimiterSelection() {
        return this.textDelimiterSelection;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DelimiterDialog dialog = new DelimiterDialog(new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private class LengthLimitedDocument
    extends PlainDocument {
        public static final long serialVersionUID = 19650221L;
        int lengthLimit;

        public LengthLimitedDocument(int lengthLimit) {
            this.lengthLimit = lengthLimit;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= this.lengthLimit) {
                super.insertString(offset, str, a);
            }
        }
    }
}

