/*
 * Decompiled with CFR 0.152.
 */
package net.dnsalias.pcb.csveditor.gui;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.dnsalias.pcb.csveditor.actions.ButtonActionFactory;
import net.dnsalias.pcb.csveditor.gui.AboutDialog;
import net.dnsalias.pcb.csveditor.gui.DefaultTableSizeDialog;
import net.dnsalias.pcb.csveditor.gui.DelimiterDialog;
import net.dnsalias.pcb.csveditor.gui.Enums;
import net.dnsalias.pcb.csveditor.gui.FileDialog;
import net.dnsalias.pcb.csveditor.gui.FontDialog;
import net.dnsalias.pcb.csveditor.gui.HelpDialog;
import net.dnsalias.pcb.csveditor.gui.PrintFormatDialog;
import net.dnsalias.pcb.csveditor.gui.RecentDialog;
import net.dnsalias.pcb.csveditor.gui.RowHeaderRenderer;
import net.dnsalias.pcb.csveditor.gui.TableModelListenerClass;
import net.dnsalias.pcb.utilities.HelperClass;
import net.dnsalias.pcb.utilities.dnd.TableCellTransferHandler;

public class CsvEditor
extends JFrame {
    public final String appName = "CsvEditor";
    public static final String VERSION = "1.3.12";
    public static final int DEFAULTCOLUMNWIDTH = 80;
    private final String defaultEncoding = "ISO-8859-1";
    private char colDelimiter;
    private char textDelimiter;
    private Font currentFont;
    private Dimension frameSize;
    private Dimension initFrameSize;
    private Point frameLocation;
    private Point initFrameLocation;
    private String currentEncoding = "ISO-8859-1";
    private int defaultRows;
    private int defaultColumns;
    private DefaultListModel recentListModel = new DefaultListModel();
    private JList recent = new JList(this.recentListModel);
    private ButtonActionFactory factory = new ButtonActionFactory();
    private static final String resourceSrc = "resources/CsvEditorResources";
    private ResourceBundle resourceBundle = HelperClass.getResourceBundleFromJar("resources/CsvEditorResources", "UTF-8");
    private boolean hasChanged = false;
    private File currentOpenFile;
    private String currentOpenFileString;
    private String toOpenFileString = null;
    private boolean useColumnNames;
    private static final String Frame_LocationX = "Frame.LocationX";
    private static final String Frame_LocationY = "Frame.LocationY";
    private static final String Frame_Width = "Frame.Width";
    private static final String Frame_Height = "Frame.Height";
    private static final String Font_Name = "Font.Name";
    private static final String Font_Style = "Font.Style";
    private static final String Font_Size = "Font.Size";
    private static final String Font_Encoding = "Font.Encoding";
    private static final String ColDelimiter = "ColDelimiter";
    private static final String TextDelimiter = "TextDelimiter";
    private static final String Recent_1 = "Recent.1";
    private static final String Recent_2 = "Recent.2";
    private static final String Recent_3 = "Recent.3";
    private static final String Recent_4 = "Recent.4";
    private static final String Default_Rows = "Default_Rows";
    private static final String Default_Columns = "Default_Columns";
    private JPanel centerPanel;
    private JScrollPane centerPanelScrollPane;
    private JMenuItem fileExitMenuItem;
    private JMenu fileMenu;
    private JSeparator fileMenuSeparator1;
    private JSeparator fileMenuSeparator2;
    private JMenuItem fileNewMenuItem;
    private JMenuItem fileOpenMenuItem;
    private JMenuItem fileOpenRecentMenuItem;
    private JMenuItem filePrintMenuItem;
    private JMenuItem fileSaveAsMenuItem;
    private JMenuItem fileSaveMenuItem;
    private JMenuItem formatDelimiterMenuItem;
    private JMenuItem formatFontMenuItem;
    private JMenu formatMenu;
    private JMenuItem helpAboutMenuItem;
    private JMenuItem helpHelpMenuItem;
    private JMenu helpMenu;
    private JMenuBar menuBar;
    private JSeparator popUpMenuSeparator1;
    private JPopupMenu popupMenu;
    private JTable table;
    private JMenuItem tableDeleteColumnMenuItem;
    private JMenuItem tableDeleteColumnPopupMenuItem;
    private JMenuItem tableDeleteRowMenuItem;
    private JMenuItem tableDeleteRowPopupMenuItem;
    private JMenuItem tableInsertColumnAfterMenuItem;
    private JMenuItem tableInsertColumnAfterPopupMenuItem;
    private JMenuItem tableInsertColumnBeforeMenuItem;
    private JMenuItem tableInsertColumnBeforePopupMenuItem;
    private JMenuItem tableInsertRowAfterMenuItem;
    private JMenuItem tableInsertRowAfterPopupMenuItem;
    private JMenuItem tableInsertRowBeforeMenuItem;
    private JMenuItem tableInsertRowBeforePopupMenuItem;
    private JMenu tableMenu;
    private JSeparator tableMenuSeparator1;
    private JSeparator tableMenuSeparator2;
    private JMenuItem tablePackColumnsMenuItem;
    private JMenuItem tablePackRowsMenuItem;
    private JMenuItem tablePackTableMenuItem;
    private JMenuItem tableUnsortTableMenuItem;
    private JCheckBoxMenuItem tableUseAsColumnNamesCheckBoxMenuItem;

    public CsvEditor() {
        this.init();
        this.initComponents();
        if (this.useColumnNames) {
            this.tableUseAsColumnNamesCheckBoxMenuItem.setText(this.resourceBundle.getString("removeColumnNames"));
            this.tableUseAsColumnNamesCheckBoxMenuItem.setSelected(true);
        }
        this.setSize(this.initFrameSize);
        this.setLocation(this.initFrameLocation);
        this.setVisible(true);
    }

    public CsvEditor(String filePath) {
        this.toOpenFileString = filePath;
        this.init();
        this.initComponents();
        this.setSize(this.initFrameSize);
        this.setLocation(this.initFrameLocation);
        this.setVisible(true);
        this.fileOpenEventHandler(this.toOpenFileString);
    }

    private String[] fillColumnNames(String[] currentColNames, int existingCols) {
        String[] newTitles = Arrays.copyOf(currentColNames, existingCols);
        for (int i = currentColNames.length; i < existingCols; ++i) {
            newTitles[i] = String.format("%1$s %2$d", this.resourceBundle.getString("ColumnHeader"), i + 1);
        }
        return newTitles;
    }

    private void init() {
        Properties props = new Properties();
        try {
            Preferences prefs = Preferences.userNodeForPackage(CsvEditor.class);
            props.setProperty(Frame_LocationX, prefs.get(Frame_LocationX, "0"));
            props.setProperty(Frame_LocationY, prefs.get(Frame_LocationY, "0"));
            props.setProperty(Font_Name, prefs.get(Font_Name, "Dialog"));
            props.setProperty(Font_Size, prefs.get(Font_Size, "12"));
            props.setProperty(Font_Style, prefs.get(Font_Style, "0"));
            props.setProperty(Font_Encoding, prefs.get(Font_Encoding, this.currentEncoding));
            props.setProperty(Frame_Width, prefs.get(Frame_Width, "640"));
            props.setProperty(Frame_Height, prefs.get(Frame_Height, "480"));
            props.setProperty(Recent_1, prefs.get(Recent_1, ""));
            props.setProperty(Recent_2, prefs.get(Recent_2, ""));
            props.setProperty(Recent_3, prefs.get(Recent_3, ""));
            props.setProperty(Recent_4, prefs.get(Recent_4, ""));
            props.setProperty(ColDelimiter, prefs.get(ColDelimiter, ";"));
            props.setProperty(TextDelimiter, prefs.get(TextDelimiter, "\""));
            props.setProperty(Default_Rows, prefs.get(Default_Rows, "4"));
            props.setProperty(Default_Columns, prefs.get(Default_Columns, "4"));
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        catch (IllegalStateException ise) {
            ise.printStackTrace();
        }
        String fontName = props.getProperty(Font_Name, "Dialog");
        String fontSize = props.getProperty(Font_Size, "12");
        String fontStyle = props.getProperty(Font_Style);
        int iFontStyle = 0;
        if (fontStyle != null && !fontStyle.equals("")) {
            try {
                iFontStyle = Integer.parseInt(fontStyle);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        try {
            this.currentFont = new Font(fontName, iFontStyle, Integer.parseInt(fontSize));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        this.currentEncoding = props.getProperty(Font_Encoding, System.getProperty("file.encoding", "ISO-8859-1"));
        try {
            String sWidth = props.getProperty(Frame_Width, "640");
            String sHeight = props.getProperty(Frame_Height, "480");
            this.initFrameSize = new Dimension(Integer.parseInt(sWidth), Integer.parseInt(sHeight));
        }
        catch (NumberFormatException e) {
            this.initFrameSize = new Dimension(640, 480);
        }
        try {
            String sPositionX = props.getProperty(Frame_LocationX, "0");
            String sPositionY = props.getProperty(Frame_LocationY, "0");
            this.initFrameLocation = new Point(Integer.parseInt(sPositionX), Integer.parseInt(sPositionY));
        }
        catch (NumberFormatException e) {
            this.initFrameLocation = new Point(0, 0);
        }
        try {
            String sDefaultRows = props.getProperty(Default_Rows, "4");
            String sDefaultCols = props.getProperty(Default_Columns, "4");
            this.defaultRows = Integer.parseInt(sDefaultRows);
            this.defaultColumns = Integer.parseInt(sDefaultCols);
        }
        catch (NumberFormatException e) {
            this.defaultRows = 4;
            this.defaultColumns = 4;
        }
        String sDelimiter = props.getProperty(ColDelimiter, ";");
        this.colDelimiter = sDelimiter.charAt(0);
        sDelimiter = props.getProperty(TextDelimiter, "\"");
        this.textDelimiter = sDelimiter.charAt(0);
        String recentFile = null;
        recentFile = props.getProperty(Recent_4, "");
        if (!recentFile.equals("")) {
            this.recentListModel.add(0, recentFile);
        }
        if (!(recentFile = props.getProperty(Recent_3, "")).equals("")) {
            this.recentListModel.add(0, recentFile);
        }
        if (!(recentFile = props.getProperty(Recent_2, "")).equals("")) {
            this.recentListModel.add(0, recentFile);
        }
        if (!(recentFile = props.getProperty(Recent_1, "")).equals("")) {
            this.recentListModel.add(0, recentFile);
        }
    }

    protected void finalize() {
        Properties props = new Properties();
        props.setProperty(Frame_LocationX, Integer.toString((int)this.frameLocation.getX()));
        props.setProperty(Frame_LocationY, Integer.toString((int)this.frameLocation.getY()));
        props.setProperty(Font_Name, this.currentFont.getFamily());
        props.setProperty(Font_Size, Integer.toString(this.currentFont.getSize()));
        props.setProperty(Font_Style, Integer.toString(this.currentFont.getStyle()));
        props.setProperty(Font_Encoding, this.currentEncoding);
        props.setProperty(Frame_Width, Integer.toString((int)this.frameSize.getWidth()));
        props.setProperty(Frame_Height, Integer.toString((int)this.frameSize.getHeight()));
        props.setProperty(Default_Rows, Integer.toString(this.defaultRows));
        props.setProperty(Default_Columns, Integer.toString(this.defaultColumns));
        props.setProperty(ColDelimiter, Character.toString(this.colDelimiter));
        props.setProperty(TextDelimiter, Character.toString(this.textDelimiter));
        int i = this.recentListModel.getSize();
        switch (i) {
            case 0: {
                break;
            }
            case 4: {
                props.setProperty(Recent_4, (String)this.recentListModel.getElementAt(i - 1));
                --i;
            }
            case 3: {
                props.setProperty(Recent_3, (String)this.recentListModel.getElementAt(i - 1));
                --i;
            }
            case 2: {
                props.setProperty(Recent_2, (String)this.recentListModel.getElementAt(i - 1));
                --i;
            }
            case 1: {
                props.setProperty(Recent_1, (String)this.recentListModel.getElementAt(i - 1));
                --i;
            }
        }
        try {
            Preferences prefs = Preferences.userNodeForPackage(CsvEditor.class);
            prefs.put(Frame_LocationX, props.getProperty(Frame_LocationX, "0"));
            prefs.put(Frame_LocationY, props.getProperty(Frame_LocationY, "0"));
            prefs.put(Font_Name, props.getProperty(Font_Name, "Dialog"));
            prefs.put(Font_Size, props.getProperty(Font_Size, "12"));
            prefs.put(Font_Style, props.getProperty(Font_Style, "0"));
            prefs.put(Font_Encoding, props.getProperty(Font_Encoding));
            prefs.put(Frame_Width, props.getProperty(Frame_Width, "640"));
            prefs.put(Frame_Height, props.getProperty(Frame_Height, "480"));
            prefs.put(ColDelimiter, props.getProperty(ColDelimiter, ";"));
            prefs.put(TextDelimiter, props.getProperty(TextDelimiter, "\""));
            prefs.put(Default_Rows, props.getProperty(Default_Rows, "4"));
            prefs.put(Default_Columns, props.getProperty(Default_Columns, "4"));
            i = this.recentListModel.getSize();
            switch (i) {
                case 0: {
                    break;
                }
                case 4: {
                    prefs.put(Recent_4, props.getProperty(Recent_4, ""));
                    --i;
                }
                case 3: {
                    prefs.put(Recent_3, props.getProperty(Recent_3, ""));
                    --i;
                }
                case 2: {
                    prefs.put(Recent_2, props.getProperty(Recent_2, ""));
                    --i;
                }
                case 1: {
                    prefs.put(Recent_1, props.getProperty(Recent_1, ""));
                    --i;
                }
            }
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
    }

    private Component createRowHeader(JTable tbl) {
        DefaultListModel<String> lm = new DefaultListModel<String>();
        JList rowHeader = new JList(lm);
        RowHeaderRenderer cellRenderer = new RowHeaderRenderer();
        cellRenderer.setFont(tbl.getTableHeader().getFont());
        rowHeader.setCellRenderer(cellRenderer);
        rowHeader.setFixedCellWidth(40);
        rowHeader.setFixedCellHeight(tbl.getRowHeight());
        rowHeader.setSelectionMode(2);
        rowHeader.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    CsvEditor.this.tableSelectRowAction(evt);
                }
            }
        });
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            lm.add(i, String.format("%d", i + 1));
        }
        return rowHeader;
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.tableInsertRowBeforePopupMenuItem = new JMenuItem();
        this.tableInsertRowAfterPopupMenuItem = new JMenuItem();
        this.tableDeleteRowPopupMenuItem = new JMenuItem();
        this.popUpMenuSeparator1 = new JSeparator();
        this.tableInsertColumnBeforePopupMenuItem = new JMenuItem();
        this.tableInsertColumnAfterPopupMenuItem = new JMenuItem();
        this.tableDeleteColumnPopupMenuItem = new JMenuItem();
        this.tableUseAsColumnNamesCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.centerPanel = new JPanel();
        this.centerPanelScrollPane = new JScrollPane();
        this.table = this.createEmptyTable(this.toOpenFileString);
        this.table.setTransferHandler(new CsvTableTransferHandler());
        this.table.setDragEnabled(true);
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.fileNewMenuItem = new JMenuItem();
        this.fileMenuSeparator2 = new JSeparator();
        this.fileOpenMenuItem = new JMenuItem();
        this.fileOpenRecentMenuItem = new JMenuItem();
        this.fileSaveMenuItem = new JMenuItem();
        this.fileSaveAsMenuItem = new JMenuItem();
        this.filePrintMenuItem = new JMenuItem();
        this.fileMenuSeparator1 = new JSeparator();
        this.fileExitMenuItem = new JMenuItem();
        this.tableMenu = new JMenu();
        this.tableUnsortTableMenuItem = new JMenuItem();
        this.tablePackTableMenuItem = new JMenuItem();
        this.tablePackRowsMenuItem = new JMenuItem();
        this.tablePackColumnsMenuItem = new JMenuItem();
        this.tableMenuSeparator2 = new JSeparator();
        this.tableInsertRowBeforeMenuItem = new JMenuItem();
        this.tableInsertRowAfterMenuItem = new JMenuItem();
        this.tableDeleteRowMenuItem = new JMenuItem();
        this.tableMenuSeparator1 = new JSeparator();
        this.tableInsertColumnBeforeMenuItem = new JMenuItem();
        this.tableInsertColumnAfterMenuItem = new JMenuItem();
        this.tableDeleteColumnMenuItem = new JMenuItem();
        this.formatMenu = new JMenu();
        this.formatDelimiterMenuItem = new JMenuItem();
        this.formatFontMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpAboutMenuItem = new JMenuItem();
        this.helpHelpMenuItem = new JMenuItem();
        this.tableInsertRowBeforePopupMenuItem.setAction(this.factory.getTableInsertRowBeforeAction());
        this.tableInsertRowBeforePopupMenuItem.setMnemonic(this.resourceBundle.getString("Btn_InsertRow_Before_Mnemonic").charAt(0));
        this.tableInsertRowBeforePopupMenuItem.setText(this.resourceBundle.getString("Btn_InsertRow_Before"));
        this.tableInsertRowBeforePopupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tableInsertRowBeforeAction(evt);
            }
        });
        this.popupMenu.add(this.tableInsertRowBeforePopupMenuItem);
        this.tableInsertRowAfterPopupMenuItem.setAction(this.factory.getTableInsertRowAfterAction());
        this.tableInsertRowAfterPopupMenuItem.setMnemonic(this.resourceBundle.getString("Btn_InsertRow_After_Mnemonic").charAt(0));
        this.tableInsertRowAfterPopupMenuItem.setText(this.resourceBundle.getString("Btn_InsertRow_After"));
        this.tableInsertRowAfterPopupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tableInsertRowAfterAction(evt);
            }
        });
        this.popupMenu.add(this.tableInsertRowAfterPopupMenuItem);
        this.tableDeleteRowPopupMenuItem.setAction(this.factory.getTableDeleteRowAction());
        this.tableDeleteRowPopupMenuItem.setMnemonic(this.resourceBundle.getString("Btn_DeleteRow_Mnemonic").charAt(0));
        this.tableDeleteRowPopupMenuItem.setText(this.resourceBundle.getString("Btn_DeleteRow"));
        this.tableDeleteRowPopupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tableDeleteRowAction(evt);
            }
        });
        this.popupMenu.add(this.tableDeleteRowPopupMenuItem);
        this.popupMenu.add(this.popUpMenuSeparator1);
        this.tableInsertColumnBeforePopupMenuItem.setAction(this.factory.getTableInsertColumnBeforeAction());
        this.tableInsertColumnBeforePopupMenuItem.setMnemonic(this.resourceBundle.getString("Btn_InsertColumn_Before_Mnemonic").charAt(0));
        this.tableInsertColumnBeforePopupMenuItem.setText(this.resourceBundle.getString("Btn_InsertColumn_Before"));
        this.tableInsertColumnBeforePopupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tableInsertColumnBeforeAction(evt);
            }
        });
        this.popupMenu.add(this.tableInsertColumnBeforePopupMenuItem);
        this.tableInsertColumnAfterPopupMenuItem.setAction(this.factory.getTableInsertColumnAfterAction());
        this.tableInsertColumnAfterPopupMenuItem.setMnemonic(this.resourceBundle.getString("Btn_InsertColumn_After_Mnemonic").charAt(0));
        this.tableInsertColumnAfterPopupMenuItem.setText(this.resourceBundle.getString("Btn_InsertColumn_After"));
        this.tableInsertColumnAfterPopupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tableInsertColumnAfterAction(evt);
            }
        });
        this.popupMenu.add(this.tableInsertColumnAfterPopupMenuItem);
        this.tableDeleteColumnPopupMenuItem.setAction(this.factory.getTableDeleteColumnAction());
        this.tableDeleteColumnPopupMenuItem.setMnemonic(this.resourceBundle.getString("Btn_DeleteColumn_Mnemonic").charAt(0));
        this.tableDeleteColumnPopupMenuItem.setText(this.resourceBundle.getString("Btn_DeleteColumn"));
        this.tableDeleteColumnPopupMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tableDeleteColumnAction(evt);
            }
        });
        this.popupMenu.add(this.tableDeleteColumnPopupMenuItem);
        this.tableUseAsColumnNamesCheckBoxMenuItem.setAction(this.factory.getTableSetAsColumnTitlesAction());
        this.tableUseAsColumnNamesCheckBoxMenuItem.setText(this.resourceBundle.getString("useAsColumnNames"));
        this.tableUseAsColumnNamesCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tableUseAsColumnNamesAction(evt);
            }
        });
        this.popupMenu.add(this.tableUseAsColumnNamesCheckBoxMenuItem);
        this.setDefaultCloseOperation(0);
        this.setTitle("CsvEditor");
        this.setIconImage(this.createIconImage("libs/duke.gif"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CsvEditor.this.windowClosingEvent(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                CsvEditor.this.frameMoved(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                CsvEditor.this.frameResized(evt);
            }
        });
        this.centerPanel.setLayout(new BorderLayout());
        this.table.setAutoResizeMode(0);
        this.centerPanelScrollPane.setViewportView(this.table);
        this.centerPanelScrollPane.setRowHeaderView(this.createRowHeader(this.table));
        this.centerPanel.add((Component)this.centerPanelScrollPane, "Center");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.fileMenu.setMnemonic(this.resourceBundle.getString("Menu_File_Mnemonic").charAt(0));
        this.fileMenu.setText(this.resourceBundle.getString("Menu_File"));
        this.fileNewMenuItem.setAction(this.factory.getFileNewAction());
        this.fileNewMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.fileNewMenuItem.setMnemonic(this.resourceBundle.getString("Btn_New_Mnemonic").charAt(0));
        this.fileNewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.fileNewAction(evt);
            }
        });
        this.fileMenu.add(this.fileNewMenuItem);
        this.fileMenu.add(this.fileMenuSeparator2);
        this.fileOpenMenuItem.setAction(this.factory.getFileOpenAction());
        this.fileOpenMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.fileOpenMenuItem.setMnemonic(this.resourceBundle.getString("Btn_Open_Mnemonic").charAt(0));
        this.fileOpenMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.fileOpenAction(evt);
            }
        });
        this.fileMenu.add(this.fileOpenMenuItem);
        this.fileOpenRecentMenuItem.setMnemonic(this.resourceBundle.getString("Btn_Recent_Mnemonic").charAt(0));
        this.fileOpenRecentMenuItem.setText(this.resourceBundle.getString("Btn_Recent"));
        this.fileOpenRecentMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.fileOpenRecentAction(evt);
            }
        });
        this.fileMenu.add(this.fileOpenRecentMenuItem);
        this.fileSaveMenuItem.setAction(this.factory.getFileSaveAction());
        this.fileSaveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileSaveMenuItem.setMnemonic(this.resourceBundle.getString("Btn_Save_Mnemonic").charAt(0));
        this.fileSaveMenuItem.setEnabled(false);
        this.fileSaveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.fileSaveAction(evt);
            }
        });
        this.fileMenu.add(this.fileSaveMenuItem);
        this.fileSaveAsMenuItem.setAction(this.factory.getFileSaveAsAction());
        this.fileSaveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.fileSaveAsMenuItem.setMnemonic(this.resourceBundle.getString("Btn_SaveAs_Mnemonic").charAt(0));
        this.fileSaveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.fileSaveAsAction(evt);
            }
        });
        this.fileMenu.add(this.fileSaveAsMenuItem);
        this.filePrintMenuItem.setAction(this.factory.getFilePrintAction());
        this.filePrintMenuItem.setMnemonic(this.resourceBundle.getString("Btn_Print_Mnemonic").charAt(0));
        this.filePrintMenuItem.setText(this.resourceBundle.getString("Btn_Print"));
        this.filePrintMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.filePrintAction(evt);
            }
        });
        this.fileMenu.add(this.filePrintMenuItem);
        this.fileMenu.add(this.fileMenuSeparator1);
        this.fileExitMenuItem.setAction(this.factory.getFileExitAction());
        this.fileExitMenuItem.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.fileExitMenuItem.setMnemonic(this.resourceBundle.getString("Btn_Exit_Mnemonic").charAt(0));
        this.fileExitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.fileExitAction(evt);
            }
        });
        this.fileMenu.add(this.fileExitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.tableMenu.setMnemonic(this.resourceBundle.getString("Menu_Table_Mnemonic").charAt(0));
        this.tableMenu.setText(this.resourceBundle.getString("Menu_Table"));
        this.tableUnsortTableMenuItem.setMnemonic(this.resourceBundle.getString("Btn_UnsortTable_Mnemonic").charAt(0));
        this.tableUnsortTableMenuItem.setText(this.resourceBundle.getString("Btn_UnsortTable"));
        this.tableUnsortTableMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tableUnsortTableAction(evt);
            }
        });
        this.tableMenu.add(this.tableUnsortTableMenuItem);
        this.tablePackTableMenuItem.setAction(this.factory.getTablePackTableAction());
        this.tablePackTableMenuItem.setMnemonic(this.resourceBundle.getString("Btn_PackTable_Mnemonic").charAt(0));
        this.tablePackTableMenuItem.setText(this.resourceBundle.getString("Btn_PackTable"));
        this.tablePackTableMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tablePackTableAction(evt);
            }
        });
        this.tableMenu.add(this.tablePackTableMenuItem);
        this.tablePackRowsMenuItem.setAction(this.factory.getTablePackRowsAction());
        this.tablePackRowsMenuItem.setMnemonic(this.resourceBundle.getString("Btn_PackRows_Mnemonic").charAt(0));
        this.tablePackRowsMenuItem.setText(this.resourceBundle.getString("Btn_PackRows"));
        this.tablePackRowsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tablePackRowsAction(evt);
            }
        });
        this.tableMenu.add(this.tablePackRowsMenuItem);
        this.tablePackColumnsMenuItem.setAction(this.factory.getTablePackColumnsAction());
        this.tablePackColumnsMenuItem.setMnemonic(this.resourceBundle.getString("Btn_PackColumns_Mnemonic").charAt(0));
        this.tablePackColumnsMenuItem.setText(this.resourceBundle.getString("Btn_PackColumns"));
        this.tablePackColumnsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tablePackColumnsAction(evt);
            }
        });
        this.tableMenu.add(this.tablePackColumnsMenuItem);
        this.tableMenu.add(this.tableMenuSeparator2);
        this.tableInsertRowBeforeMenuItem.setAction(this.factory.getTableInsertRowBeforeAction());
        this.tableInsertRowBeforeMenuItem.setMnemonic(this.resourceBundle.getString("Btn_InsertRow_Before_Mnemonic").charAt(0));
        this.tableInsertRowBeforeMenuItem.setText(this.resourceBundle.getString("Btn_InsertRow_Before"));
        this.tableInsertRowBeforeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tableInsertRowBeforeAction(evt);
            }
        });
        this.tableMenu.add(this.tableInsertRowBeforeMenuItem);
        this.tableInsertRowAfterMenuItem.setAction(this.factory.getTableInsertRowAfterAction());
        this.tableInsertRowAfterMenuItem.setMnemonic(this.resourceBundle.getString("Btn_InsertRow_After_Mnemonic").charAt(0));
        this.tableInsertRowAfterMenuItem.setText(this.resourceBundle.getString("Btn_InsertRow_After"));
        this.tableInsertRowAfterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tableInsertRowAfterAction(evt);
            }
        });
        this.tableMenu.add(this.tableInsertRowAfterMenuItem);
        this.tableDeleteRowMenuItem.setAction(this.factory.getTableDeleteRowAction());
        this.tableDeleteRowMenuItem.setMnemonic(this.resourceBundle.getString("Btn_DeleteRow_Mnemonic").charAt(0));
        this.tableDeleteRowMenuItem.setText(this.resourceBundle.getString("Btn_DeleteRow"));
        this.tableDeleteRowMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tableDeleteRowAction(evt);
            }
        });
        this.tableMenu.add(this.tableDeleteRowMenuItem);
        this.tableMenu.add(this.tableMenuSeparator1);
        this.tableInsertColumnBeforeMenuItem.setAction(this.factory.getTableInsertColumnBeforeAction());
        this.tableInsertColumnBeforeMenuItem.setMnemonic(this.resourceBundle.getString("Btn_InsertColumn_Before_Mnemonic").charAt(0));
        this.tableInsertColumnBeforeMenuItem.setText(this.resourceBundle.getString("Btn_InsertColumn_Before"));
        this.tableInsertColumnBeforeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tableInsertColumnBeforeAction(evt);
            }
        });
        this.tableMenu.add(this.tableInsertColumnBeforeMenuItem);
        this.tableInsertColumnAfterMenuItem.setAction(this.factory.getTableInsertColumnAfterAction());
        this.tableInsertColumnAfterMenuItem.setMnemonic(this.resourceBundle.getString("Btn_InsertColumn_After_Mnemonic").charAt(0));
        this.tableInsertColumnAfterMenuItem.setText(this.resourceBundle.getString("Btn_InsertColumn_After"));
        this.tableInsertColumnAfterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tableInsertColumnAfterAction(evt);
            }
        });
        this.tableMenu.add(this.tableInsertColumnAfterMenuItem);
        this.tableDeleteColumnMenuItem.setAction(this.factory.getTableDeleteColumnAction());
        this.tableDeleteColumnMenuItem.setMnemonic(this.resourceBundle.getString("Btn_DeleteColumn_Mnemonic").charAt(0));
        this.tableDeleteColumnMenuItem.setText(this.resourceBundle.getString("Btn_DeleteColumn"));
        this.tableDeleteColumnMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.tableDeleteColumnAction(evt);
            }
        });
        this.tableMenu.add(this.tableDeleteColumnMenuItem);
        this.menuBar.add(this.tableMenu);
        this.formatMenu.setMnemonic(this.resourceBundle.getString("Menu_Format_Mnemonic").charAt(0));
        this.formatMenu.setText(this.resourceBundle.getString("Menu_Format"));
        this.formatDelimiterMenuItem.setMnemonic(this.resourceBundle.getString("Btn_Delimiter_Mnemonic").charAt(0));
        this.formatDelimiterMenuItem.setText(this.resourceBundle.getString("Btn_Delimiter"));
        this.formatDelimiterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.formatDelimiterAction(evt);
            }
        });
        this.formatMenu.add(this.formatDelimiterMenuItem);
        this.formatFontMenuItem.setMnemonic(this.resourceBundle.getString("Btn_Font_Mnemonic").charAt(0));
        this.formatFontMenuItem.setText(this.resourceBundle.getString("Btn_Font"));
        this.formatFontMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.formatFontAction(evt);
            }
        });
        this.formatMenu.add(this.formatFontMenuItem);
        this.menuBar.add(this.formatMenu);
        this.helpMenu.setMnemonic(this.resourceBundle.getString("Menu_Help_Mnemonic").charAt(0));
        this.helpMenu.setText(this.resourceBundle.getString("Menu_Help"));
        this.helpAboutMenuItem.setAction(this.factory.getHelpAboutAction());
        this.helpAboutMenuItem.setMnemonic(this.resourceBundle.getString("Btn_About_Mnemonic").charAt(0));
        this.helpAboutMenuItem.setText(this.resourceBundle.getString("Btn_About"));
        this.helpAboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.helpAboutAction(evt);
            }
        });
        this.helpMenu.add(this.helpAboutMenuItem);
        this.helpHelpMenuItem.setAction(this.factory.getHelpHelpAction());
        this.helpHelpMenuItem.setMnemonic(this.resourceBundle.getString("Btn_Help_Mnemonic").charAt(0));
        this.helpHelpMenuItem.setText(this.resourceBundle.getString("Btn_Help"));
        this.helpHelpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvEditor.this.helpHelpAction(evt);
            }
        });
        this.helpMenu.add(this.helpHelpMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void fileOpenAction(ActionEvent evt) {
        this.fileOpenEventHandler(null);
    }

    private void fileExitAction(ActionEvent evt) {
        this.windowClosingEventHandler();
    }

    private void windowClosingEvent(WindowEvent evt) {
        this.windowClosingEventHandler();
    }

    private void fileSaveAsAction(ActionEvent evt) {
        File saveAsPath = null;
        try {
            if (this.currentOpenFile != null) {
                saveAsPath = this.currentOpenFile.getCanonicalFile();
            }
        }
        catch (NullPointerException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.saveFileAs(saveAsPath)) {
            this.hasChanged = false;
            this.setTitle(String.format("%s - %s", this.currentOpenFile.getName(), "CsvEditor"));
            this.fileSaveMenuItem.setEnabled(true);
        }
    }

    private void frameMoved(ComponentEvent evt) {
        this.frameLocation = this.getLocation();
    }

    private void frameResized(ComponentEvent evt) {
        this.frameSize = this.getSize();
    }

    private void formatDelimiterAction(ActionEvent evt) {
        DelimiterDialog dlg = new DelimiterDialog(this, true, this.colDelimiter, this.textDelimiter);
        this.colDelimiter = dlg.getColDelimiterSelection();
        this.textDelimiter = dlg.getTextDelimiterSelection();
        dlg = null;
    }

    private void formatFontAction(ActionEvent evt) {
        JTable newTable = null;
        FontDialog dlg = new FontDialog(this, true, this.currentFont, this.currentEncoding);
        if (dlg.getOption() == 0) {
            if (dlg.getSelectedFont() != null) {
                this.currentFont = dlg.getSelectedFont();
                this.table.setFont(this.currentFont);
                newTable = this.recreateTable(this.writeTableToMem(this.table));
                if (newTable != null) {
                    this.centerPanelScrollPane.setVisible(false);
                    this.table = newTable;
                    this.table.setTransferHandler(new CsvTableTransferHandler());
                    this.table.setDragEnabled(true);
                    this.centerPanelScrollPane.setViewportView(this.table);
                    this.centerPanelScrollPane.setRowHeaderView(this.createRowHeader(this.table));
                    this.centerPanelScrollPane.setVisible(true);
                }
            }
            if (dlg.getSelectedEncoding() != null) {
                this.currentEncoding = dlg.getSelectedEncoding();
            }
        }
    }

    private void fileSaveAction(ActionEvent evt) {
        if (this.fileSave(this.table, this.currentOpenFile)) {
            this.setTitle(String.format("%s - %s", this.currentOpenFile.getName(), "CsvEditor"));
            this.hasChanged = false;
        }
    }

    private void fileOpenRecentAction(ActionEvent evt) {
        this.fileOpenRecentEventHandler();
    }

    private void tableInsertRowBeforeAction(ActionEvent evt) {
        int pos = this.table.getSelectedRow();
        if (pos > -1) {
            this.tableInsertRowAction(evt, pos);
        }
    }

    private void tableInsertRowAfterAction(ActionEvent evt) {
        int pos = this.table.getSelectedRow();
        if (pos > -1) {
            this.tableInsertRowAction(evt, pos + 1);
        }
    }

    private void tableInsertRowAction(ActionEvent evt, int pos) {
        this.insertRow(pos);
        this.centerPanelScrollPane.setRowHeaderView(this.createRowHeader(this.table));
        ((DefaultTableModel)this.table.getModel()).fireTableStructureChanged();
    }

    private void tableDeleteRowAction(ActionEvent evt) {
        int[] rows = this.table.getSelectedRows();
        if (rows.length > 0) {
            this.deleteRows(rows);
            this.centerPanelScrollPane.setRowHeaderView(this.createRowHeader(this.table));
            ((DefaultTableModel)this.table.getModel()).fireTableStructureChanged();
        }
    }

    private void tableInsertColumnBeforeAction(ActionEvent evt) {
        int pos = this.table.getSelectedColumn();
        if (pos > -1) {
            this.tableInsertColumnAction(evt, pos);
        }
    }

    private void tableInsertColumnAfterAction(ActionEvent evt) {
        int pos = this.table.getSelectedColumn();
        if (pos > -1) {
            this.tableInsertColumnAction(evt, pos + 1);
        }
    }

    private void tableInsertColumnAction(ActionEvent evt, int pos) {
        this.insertColumn(pos);
        HelperClass.fitRowHeight(this.table);
        this.centerPanelScrollPane.setRowHeaderView(this.createRowHeader(this.table));
        ((DefaultTableModel)this.table.getModel()).fireTableStructureChanged();
    }

    private void tableDeleteColumnAction(ActionEvent evt) {
        int pos = this.table.getSelectedColumn();
        if (pos > -1) {
            this.deleteColumn(pos);
            HelperClass.fitRowHeight(this.table);
            this.centerPanelScrollPane.setRowHeaderView(this.createRowHeader(this.table));
            ((DefaultTableModel)this.table.getModel()).fireTableStructureChanged();
        }
    }

    private void fileNewAction(ActionEvent evt) {
        this.fileNewEventHandler();
    }

    private void tablePackRowsAction(ActionEvent evt) {
        HelperClass.fitRowHeight(this.table);
        this.centerPanelScrollPane.setRowHeaderView(this.createRowHeader(this.table));
    }

    private void tablePackColumnsAction(ActionEvent evt) {
        HelperClass.fitColumnWidth(this.table, 80);
    }

    private void tablePackTableAction(ActionEvent evt) {
        this.tablePackRowsAction(evt);
        this.tablePackColumnsAction(evt);
    }

    private void helpAboutAction(ActionEvent evt) {
        new AboutDialog(this, false);
    }

    private void helpHelpAction(ActionEvent evt) {
        new HelpDialog(this, false);
    }

    private void tableUnsortTableAction(ActionEvent evt) {
        this.table.getRowSorter().setSortKeys(null);
    }

    private void filePrintAction(ActionEvent evt) {
        PrintFormatDialog dialog = new PrintFormatDialog(this, true);
        JTable.PrintMode printMode = dialog.getOption();
        dialog = null;
        String footer = this.resourceBundle.getString("Page") + " {0}";
        PrinterJob pj = PrinterJob.getPrinterJob();
        PageFormat pf = pj.pageDialog(pj.defaultPage());
        Printable p = this.table.getPrintable(printMode, null, new MessageFormat(footer));
        pj.setPrintable(p, pf);
        try {
            if (pj.printDialog()) {
                pj.print();
            }
        }
        catch (PrinterException e) {
            // empty catch block
        }
    }

    private void tableUseAsColumnNamesAction(ActionEvent evt) {
        Object source = evt.getSource();
        if (this.tableUseAsColumnNamesCheckBoxMenuItem.isSelected()) {
            int row = this.table.convertRowIndexToModel(this.table.getSelectedRow());
            if (row > -1) {
                int cols = this.table.getColumnCount();
                ArrayList<String> colNames = new ArrayList<String>(cols);
                for (int i = 0; i < cols; ++i) {
                    Object colName = this.table.getModel().getValueAt(row, i);
                    if (colName == null || colName.toString().equals("")) {
                        String newTitle = String.format("%1$s %2$d", this.resourceBundle.getString("ColumnHeader"), i + 1);
                        colName = newTitle;
                    }
                    colNames.add(colName.toString());
                }
                ((DefaultTableModel)this.table.getModel()).setColumnIdentifiers(colNames.toArray(new String[0]));
                ((DefaultTableModel)this.table.getModel()).removeRow(this.table.convertRowIndexToModel(row));
                this.centerPanelScrollPane.setRowHeaderView(this.createRowHeader(this.table));
                ((DefaultTableModel)this.table.getModel()).fireTableStructureChanged();
                this.useColumnNames = true;
                if (source == this.tableUseAsColumnNamesCheckBoxMenuItem) {
                    this.tableUseAsColumnNamesCheckBoxMenuItem.setText(this.resourceBundle.getString("removeColumnNames"));
                }
            }
        } else {
            this.insertRow(0);
            int cols = this.table.getColumnCount();
            ArrayList colNames = new ArrayList(cols);
            for (int i = 0; i < cols; ++i) {
                Object colName = this.table.getColumnModel().getColumn(i).getHeaderValue();
                ((DefaultTableModel)this.table.getModel()).setValueAt(colName, 0, i);
                colNames.add(null);
            }
            ((DefaultTableModel)this.table.getModel()).setColumnIdentifiers(colNames.toArray(new String[0]));
            this.useColumnNames = false;
            if (source == this.tableUseAsColumnNamesCheckBoxMenuItem) {
                this.tableUseAsColumnNamesCheckBoxMenuItem.setText(this.resourceBundle.getString("useAsColumnNames"));
            }
        }
    }

    private int changesSaved(boolean changed) {
        int result;
        block3: {
            block4: {
                int answer = 0;
                result = 0;
                if (!changed) break block3;
                while (true) {
                    if ((answer = JOptionPane.showConfirmDialog(this, this.resourceBundle.getString("Save_Changes"), "CsvEditor", 1, 3)) == 1) {
                        result = 0;
                        break block3;
                    }
                    if (answer != 0) break block4;
                    if (this.currentOpenFile == null) {
                        if (!this.saveFileAs(this.currentOpenFile)) continue;
                        result = 0;
                        break block3;
                    }
                    if (this.fileSave(this.table, this.currentOpenFile)) break;
                }
                result = 0;
                break block3;
            }
            result = 2;
        }
        return result;
    }

    private void fileNewEventHandler() {
        JTable newTable = null;
        if (this.changesSaved(this.hasChanged) == 0) {
            this.hasChanged = false;
        }
        if (!this.hasChanged && (newTable = this.createEmptyTable(null)) != null) {
            this.currentOpenFile = null;
            this.currentOpenFileString = "";
            this.setTitle(String.format("%s", "CsvEditor"));
            this.centerPanelScrollPane.setVisible(false);
            this.table = newTable;
            this.table.setTransferHandler(new CsvTableTransferHandler());
            this.table.setDragEnabled(true);
            this.centerPanelScrollPane.setViewportView(this.table);
            this.centerPanelScrollPane.setRowHeaderView(this.createRowHeader(this.table));
            this.centerPanelScrollPane.setVisible(true);
        }
    }

    private void fileOpenEventHandler(String path) {
        JTable newTable = null;
        File fileToOpen = null;
        if (this.changesSaved(this.hasChanged) == 0) {
            this.hasChanged = false;
        }
        if (!this.hasChanged) {
            if (path == null) {
                fileToOpen = this.fileOpen();
            } else {
                File f = new File(path);
                if (f.exists() && f.isFile() && f.canRead()) {
                    fileToOpen = f;
                }
            }
            if (fileToOpen != null && (newTable = this.createTable(fileToOpen)) != null) {
                try {
                    String filePath = fileToOpen.getCanonicalPath();
                    this.setTitle(String.format("%s - %s", fileToOpen.getName(), "CsvEditor"));
                    if (!this.recentListModel.contains(filePath)) {
                        this.recentListModel.add(0, filePath);
                    } else {
                        int i = this.recentListModel.indexOf(filePath);
                        if (i != 0) {
                            this.recentListModel.remove(i);
                            this.recentListModel.add(0, filePath);
                        }
                    }
                    while (this.recentListModel.getSize() > 4) {
                        this.recentListModel.remove(4);
                    }
                }
                catch (IOException ioe) {
                    String msg = String.format(this.resourceBundle.getString("IOExceptionMsg"), fileToOpen);
                    JOptionPane.showMessageDialog(this, msg, ioe.getClass().getName(), 0);
                }
                this.centerPanelScrollPane.setVisible(false);
                this.table = newTable;
                this.table.setTransferHandler(new CsvTableTransferHandler());
                this.table.setDragEnabled(true);
                this.currentOpenFile = fileToOpen;
                this.centerPanelScrollPane.setViewportView(this.table);
                this.centerPanelScrollPane.setRowHeaderView(this.createRowHeader(this.table));
                this.centerPanelScrollPane.setVisible(true);
            }
        }
    }

    private void fileOpenRecentEventHandler() {
        RecentDialog dlg;
        JTable newTable = null;
        File fileToOpen = null;
        if (this.changesSaved(this.hasChanged) == 0) {
            this.hasChanged = false;
        }
        if (!this.hasChanged && (fileToOpen = this.recentFileSelected((dlg = new RecentDialog(this, this.recent)).getSelectedIndex())) != null && (newTable = this.createTable(fileToOpen)) != null) {
            this.currentOpenFile = fileToOpen;
            try {
                this.currentOpenFileString = fileToOpen.getCanonicalPath();
                this.setTitle(String.format("%s - %s", this.currentOpenFile.getName(), "CsvEditor"));
            }
            catch (IOException ioe) {
                String msg = String.format(this.resourceBundle.getString("IOExceptionMsg"), fileToOpen);
                JOptionPane.showMessageDialog(this, msg, ioe.getClass().getName(), 0);
            }
            this.centerPanelScrollPane.setVisible(false);
            this.table = newTable;
            this.table.setTransferHandler(new CsvTableTransferHandler());
            this.table.setDragEnabled(true);
            this.currentOpenFile = fileToOpen;
            this.centerPanelScrollPane.setViewportView(this.table);
            this.centerPanelScrollPane.setRowHeaderView(this.createRowHeader(this.table));
            this.centerPanelScrollPane.setVisible(true);
        }
    }

    private void windowClosingEventHandler() {
        if (this.changesSaved(this.hasChanged) == 0) {
            this.hasChanged = false;
        }
        if (!this.hasChanged) {
            this.finalize();
            System.exit(0);
        }
    }

    private File fileOpen() {
        File result = null;
        FileDialog dlg = new FileDialog(this, Enums.FileDialogMethod.OPEN, this.currentOpenFile);
        result = dlg.getPath();
        return result;
    }

    private File recentFileSelected(int selectedIndex) {
        String fileString = null;
        File file = null;
        int answer = 0;
        while (this.hasChanged) {
            answer = JOptionPane.showConfirmDialog(this, this.resourceBundle.getString("Save_Changes"), this.getTitle(), 1, 3);
            if (answer == 1) {
                this.hasChanged = false;
                continue;
            }
            if (answer == 0) {
                if (!this.fileSave(this.table, this.currentOpenFile)) continue;
                this.hasChanged = false;
                continue;
            }
            return null;
        }
        if (selectedIndex > -1) {
            try {
                fileString = (String)this.recentListModel.getElementAt(selectedIndex);
                file = new File(fileString);
                if (file != null && file.canRead()) {
                    Object openedFile = this.recentListModel.remove(selectedIndex);
                    this.recentListModel.add(0, openedFile);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            AccessibleContext ac = this.menuBar.getAccessibleContext();
            if (ac != null) {
                ac.getAccessibleSelection().clearAccessibleSelection();
                this.recent.clearSelection();
            }
        }
        return file;
    }

    private boolean fileSave(JTable table, File file) {
        boolean result = false;
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.currentEncoding));
            CsvWriter csvWriter = new CsvWriter(writer, this.colDelimiter);
            csvWriter.setTextQualifier(this.textDelimiter);
            JTable tbl = table;
            DefaultTableModel model = (DefaultTableModel)tbl.getModel();
            String[] rowData = new String[model.getColumnCount()];
            if (this.useColumnNames) {
                for (int c = 0; c < model.getColumnCount(); ++c) {
                    rowData[c] = model.getColumnName(c);
                }
                csvWriter.writeRecord(rowData);
            }
            for (int r = 0; r < model.getRowCount(); ++r) {
                for (int c = 0; c < model.getColumnCount(); ++c) {
                    Object o = model.getValueAt(r, c);
                    rowData[c] = o == null ? "" : model.getValueAt(r, c).toString();
                }
                csvWriter.writeRecord(rowData);
            }
            csvWriter.flush();
            csvWriter.close();
            writer.close();
            result = true;
            String filePath = file.getCanonicalPath();
            if (!this.recentListModel.contains(filePath)) {
                this.recentListModel.add(0, filePath);
            } else {
                int i = this.recentListModel.indexOf(filePath);
                if (i != 0) {
                    this.recentListModel.remove(i);
                    this.recentListModel.add(0, filePath);
                }
            }
            while (this.recentListModel.getSize() > 4) {
                this.recentListModel.remove(4);
            }
        }
        catch (UnsupportedEncodingException uee) {
            String msg = String.format(this.resourceBundle.getString("UnsupportedEncodingExceptionMsg"), this.currentEncoding);
            JOptionPane.showMessageDialog(this, msg, uee.getClass().getName(), 0);
        }
        catch (FileNotFoundException fnfe) {
            String msg = String.format(this.resourceBundle.getString("FileNotFoundExceptionMsg"), file);
            JOptionPane.showMessageDialog(this, msg, fnfe.getClass().getName(), 0);
        }
        catch (IOException ioe) {
            String msg = String.format(this.resourceBundle.getString("IOExceptionMsg"), file);
            JOptionPane.showMessageDialog(this, msg, ioe.getClass().getName(), 0);
        }
        return result;
    }

    private boolean saveFileAs(File saveFilePath) {
        boolean result = false;
        File path = saveFilePath;
        try {
            FileDialog dlg = new FileDialog(this, Enums.FileDialogMethod.SAVEAS, saveFilePath);
            path = dlg.getPath();
            result = this.fileSave(this.table, path);
        }
        catch (NullPointerException e) {
            result = false;
        }
        if (result) {
            this.currentOpenFile = path;
        }
        return result;
    }

    private byte[] writeTableToMem(JTable table) {
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)os, this.currentEncoding));
            CsvWriter csvWriter = new CsvWriter(writer, this.colDelimiter);
            csvWriter.setTextQualifier(this.textDelimiter);
            JTable tbl = table;
            String[] rowData = new String[tbl.getColumnCount()];
            if (this.useColumnNames) {
                for (int c = 0; c < tbl.getColumnCount(); ++c) {
                    rowData[c] = tbl.getColumnName(c);
                }
                csvWriter.writeRecord(rowData);
            }
            for (int r = 0; r < tbl.getRowCount(); ++r) {
                for (int c = 0; c < tbl.getColumnCount(); ++c) {
                    Object o = tbl.getValueAt(r, c);
                    rowData[c] = o == null ? null : tbl.getValueAt(r, c).toString();
                }
                csvWriter.writeRecord(rowData);
            }
            csvWriter.flush();
            csvWriter.close();
            writer.close();
        }
        catch (UnsupportedEncodingException uee) {
            String msg = String.format(this.resourceBundle.getString("UnsupportedEncodingExceptionMsg"), this.currentEncoding);
            JOptionPane.showMessageDialog(this, msg, uee.getClass().getName(), 0);
        }
        catch (IOException ioe) {
            String msg = String.format(this.resourceBundle.getString("IOExceptionMsg"), "");
            JOptionPane.showMessageDialog(this, msg, ioe.getClass().getName(), 0);
        }
        return os.toByteArray();
    }

    private JTable createTable(File file) {
        JTable tbl = null;
        DefaultTableModel model = null;
        CsvReader csvReader = null;
        BufferedReader reader = null;
        int cols = 0;
        int currentCols = 0;
        int rows = 0;
        try {
            Object[] currentRecord;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.currentEncoding));
            csvReader = new CsvReader(reader, this.colDelimiter);
            csvReader.setTextQualifier(this.textDelimiter);
            while (csvReader.readRecord()) {
                ++rows;
                currentCols = csvReader.getColumnCount();
                cols = Math.max(currentCols, cols);
            }
            csvReader.close();
            reader.close();
            model = new DefaultTableModel(0, cols);
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.currentEncoding));
            csvReader = new CsvReader(reader, this.colDelimiter);
            csvReader.setTextQualifier(this.textDelimiter);
            if (this.useColumnNames && csvReader.readRecord()) {
                currentRecord = csvReader.getValues();
                if (cols > currentRecord.length) {
                    currentRecord = this.fillColumnNames((String[])currentRecord, rows);
                }
                model.setColumnIdentifiers(currentRecord);
            }
            while (csvReader.readRecord()) {
                currentRecord = csvReader.getValues();
                model.addRow(currentRecord);
            }
            csvReader.close();
            reader.close();
            csvReader = null;
            reader = null;
            tbl = new JTable(model);
            tbl.setAutoCreateRowSorter(true);
            tbl.setAutoResizeMode(0);
            tbl.setFont(this.currentFont);
            tbl.setCellSelectionEnabled(true);
            HelperClass.fitRowHeight(tbl);
            HelperClass.fitColumnWidth(tbl, 80);
            tbl.getModel().addTableModelListener(new TableModelListenerClass(this));
            tbl.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    CsvEditor.this.mouseEventHandler(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    CsvEditor.this.mouseEventHandler(e);
                }
            });
        }
        catch (UnsupportedEncodingException uee) {
            String msg = String.format(this.resourceBundle.getString("UnsupportedEncodingExceptionMsg"), this.currentEncoding);
            JOptionPane.showMessageDialog(this, msg, uee.getClass().getName(), 0);
        }
        catch (FileNotFoundException fnfe) {
            String msg = String.format(this.resourceBundle.getString("FileNotFoundExceptionMsg"), file);
            JOptionPane.showMessageDialog(this, msg, fnfe.getClass().getName(), 0);
        }
        catch (IOException ioe) {
            String msg = String.format(this.resourceBundle.getString("IOExceptionMsg"), file);
            JOptionPane.showMessageDialog(this, msg, ioe.getClass().getName(), 0);
        }
        return tbl;
    }

    private DefaultTableModel createModel(int columns, int rows) {
        DefaultTableModel model = new DefaultTableModel(rows, columns);
        return model;
    }

    private JTable createEmptyTable(String fileToOpen) {
        if (fileToOpen == null || fileToOpen.equals("")) {
            DefaultTableSizeDialog dlg = new DefaultTableSizeDialog(this, true, this.defaultColumns, this.defaultRows, this.useColumnNames);
            this.defaultColumns = dlg.getSelectedColumns();
            this.defaultRows = dlg.getSelectedRows();
            this.useColumnNames = dlg.getUseColumnNames();
        }
        DefaultTableModel model = this.createModel(this.defaultColumns, this.defaultRows);
        model.addTableModelListener(new TableModelListenerClass(this));
        model.addTableModelListener(new TableModelListenerClass(this));
        JTable tbl = new JTable();
        tbl.setModel(model);
        tbl.setAutoCreateRowSorter(true);
        tbl.setFont(this.currentFont);
        tbl.setAutoResizeMode(0);
        tbl.setCellSelectionEnabled(true);
        tbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CsvEditor.this.mouseEventHandler(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CsvEditor.this.mouseEventHandler(e);
            }
        });
        return tbl;
    }

    private JTable recreateTable(byte[] a) {
        JTable tbl = null;
        DefaultTableModel model = null;
        CsvReader csvReader = null;
        Object rdr = null;
        int cols = 0;
        int currentCols = 0;
        int rows = 0;
        try {
            Object[] currentRecord;
            rdr = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(a), this.currentEncoding));
            csvReader = new CsvReader((Reader)rdr, this.colDelimiter);
            csvReader.setTextQualifier(this.textDelimiter);
            while (csvReader.readRecord()) {
                ++rows;
                currentCols = csvReader.getColumnCount();
                cols = Math.max(currentCols, cols);
            }
            csvReader.close();
            ((BufferedReader)rdr).close();
            model = new DefaultTableModel(0, cols);
            rdr = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(a), this.currentEncoding));
            csvReader = new CsvReader((Reader)rdr, this.colDelimiter);
            csvReader.setTextQualifier(this.textDelimiter);
            if (this.useColumnNames && csvReader.readRecord()) {
                currentRecord = csvReader.getValues();
                if (cols > currentRecord.length) {
                    currentRecord = this.fillColumnNames((String[])currentRecord, rows);
                }
                model.setColumnIdentifiers(currentRecord);
            }
            while (csvReader.readRecord()) {
                currentRecord = csvReader.getValues();
                model.addRow(currentRecord);
            }
            csvReader.close();
            ((BufferedReader)rdr).close();
            tbl = new JTable(model);
            tbl.setAutoCreateRowSorter(true);
            tbl.setAutoResizeMode(0);
            tbl.setFont(this.currentFont);
            tbl.setCellSelectionEnabled(true);
            tbl.getModel().addTableModelListener(new TableModelListenerClass(this));
            tbl.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    CsvEditor.this.mouseEventHandler(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    CsvEditor.this.mouseEventHandler(e);
                }
            });
        }
        catch (UnsupportedEncodingException uee) {
            String msg = String.format(this.resourceBundle.getString("UnsupportedEncodingExceptionMsg"), this.currentEncoding);
            JOptionPane.showMessageDialog(this, msg, uee.getClass().getName(), 0);
        }
        catch (IOException ioe) {
            String msg = String.format(this.resourceBundle.getString("IOExceptionMsg"), rdr.toString());
            JOptionPane.showMessageDialog(this, msg, ioe.getClass().getName(), 0);
        }
        return tbl;
    }

    private void insertRow(int position) {
        Object[] s = new String[this.table.getRowCount()];
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.insertRow(position, s);
        this.centerPanelScrollPane.setRowHeaderView(this.createRowHeader(this.table));
    }

    private void deleteRows(int[] rows) {
        int deletedRows = 0;
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        for (int i = 0; i < rows.length; ++i) {
            model.removeRow(this.table.convertRowIndexToModel(rows[i] - deletedRows));
            ++deletedRows;
        }
        this.centerPanelScrollPane.setRowHeaderView(this.createRowHeader(this.table));
    }

    private void insertColumn(int position) {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.addColumn("newColumn");
        this.table.moveColumn(this.table.getColumnCount() - 1, position);
        JTable tbl = this.recreateTable(this.writeTableToMem(this.table));
        if (tbl != null) {
            this.centerPanelScrollPane.setVisible(false);
            this.table = tbl;
            this.table.setTransferHandler(new CsvTableTransferHandler());
            this.table.setDragEnabled(true);
            this.centerPanelScrollPane.setViewportView(this.table);
            this.centerPanelScrollPane.setRowHeaderView(this.createRowHeader(this.table));
            this.centerPanelScrollPane.setVisible(true);
        }
    }

    private void deleteColumn(int position) {
        this.table.removeColumn(this.table.getColumnModel().getColumn(position));
        JTable tbl = this.recreateTable(this.writeTableToMem(this.table));
        if (tbl != null) {
            this.centerPanelScrollPane.setVisible(false);
            this.table = tbl;
            this.table.setTransferHandler(new CsvTableTransferHandler());
            this.table.setDragEnabled(true);
            this.centerPanelScrollPane.setViewportView(this.table);
            this.centerPanelScrollPane.setRowHeaderView(this.createRowHeader(this.table));
            this.centerPanelScrollPane.setVisible(true);
        }
    }

    private Image createIconImage(String imageName) {
        Image img = null;
        try {
            String imgName = imageName;
            URL imgURL = this.getClass().getClassLoader().getResource(imgName);
            Toolkit tk = Toolkit.getDefaultToolkit();
            MediaTracker m = new MediaTracker(this);
            img = tk.getImage(imgURL);
            m.addImage(img, 0);
            m.waitForAll();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img;
    }

    public String getAppname() {
        return "CsvEditor";
    }

    public void setHasChanged(boolean set) {
        this.hasChanged = set;
        if (this.hasChanged) {
            if (this.currentOpenFile != null) {
                this.setTitle(String.format("%s [%s] - %s", this.currentOpenFile.getName(), this.resourceBundle.getString("ChangedMsg"), "CsvEditor"));
                this.fileSaveMenuItem.setEnabled(true);
            } else {
                this.setTitle(String.format("%s [%s] - %s", this.resourceBundle.getString("UnnamedMsg"), this.resourceBundle.getString("ChangedMsg"), "CsvEditor"));
                this.fileSaveMenuItem.setEnabled(false);
            }
        }
    }

    private void tableSelectRowAction(ListSelectionEvent evt) {
        if (evt.getSource() instanceof JList) {
            JList list = (JList)evt.getSource();
            int minSelectionIndex = list.getMinSelectionIndex();
            int[] selectedIndices = list.getSelectedIndices();
            int columnCount = this.table.getColumnCount() - 1;
            if (minSelectionIndex > -1) {
                this.table.setRowSelectionInterval(minSelectionIndex, minSelectionIndex);
                this.table.setColumnSelectionInterval(0, columnCount);
                for (int i = 0; i < selectedIndices.length; ++i) {
                    this.table.addRowSelectionInterval(selectedIndices[i], selectedIndices[i]);
                    this.table.addColumnSelectionInterval(0, columnCount);
                }
            }
            this.table.requestFocusInWindow();
        }
    }

    private void mouseEventHandler(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CsvEditor().setVisible(true);
            }
        });
    }

    private class CsvTableTransferHandler
    extends TableCellTransferHandler {
        private CsvTableTransferHandler() {
        }

        @Override
        protected void importString(JComponent c, String str) {
            super.importString(c, str);
            CsvEditor.this.centerPanelScrollPane.setRowHeaderView(CsvEditor.this.createRowHeader(CsvEditor.this.table));
        }
    }
}

