// mfcht.cpp
// (c) Petr Mikulik, mikulik@physics.muni.cz

#include <stdlib.h>
#include <iostream.h>
#include <string.h>
#include <iomanip.h>
#include "ansicpp.h"
#include "mfcht.h"

// ---- lattice parameters ----

// diamant structure

const double lpGaAs = 5.65325;
const double lpAlAs = 5.6620;
const double lpAlAsonGaAs = 5.6664; // as grown on GaAs
const double lpSi   = 5.4309;
const double lpGe   = 5.6575;
const double lpC    = 3.567;   // diamant
const double lpGa5Al5As = ( lpGaAs + lpAlAs ) /2;
const double lpZnTe = 6.09;

// cubic - bcc

const double lpFe = 2.8664;
const double lpW  = 3.1648;
const double lpNb = 3.3066;

//  hexagonal
const double lpY_a  = 3.64713,     lpY_c  = 5.72856;
const double lpGd_a = 3.629,       lpGd_c = 5.760;
const double lpTb_a = 3.592,       lpTb_c = 5.675;
const double lpSapphire_a = 4.759, lpSapphire_c = 12.991;
const double lpSm_a = 3.6291,      lpSm_c = 26.203;
const double lpY2Co17_a = 8.341,   lpY2Co17_c = 8.125;

// other structures:
//   Diamond a=3.567
//   Be      a=2.286 c=3.583


double XrayLambda [] = {
    2.748510, // TiKa1
    2.289620, // CrKa1
    1.935970, // FeKa1
    1.788965, // CoKa1
    1.544390, // CuKa2
    1.541838, // CuKa = ( 2 * CuKa1 + CuKa2 ) / 3
    1.540562, // CuKa1
    1.392218, // CuKb1
    0.713590, // MoKa2
    0.711445, // MoKa  approx  ( MoKa1 + MoKa2 ) / 2
    0.709300, // MoKa1
    0.632288, // MoKb1
    0.563798, // AgKa2
    0.561603, // AgKa  approx  ( AgKa1 + AgKa2 ) / 2
    0.559408, // AgKa1
    0.497069, // AgKb2
    0.215947, // TaKa1
    0.209010, // WKa1
    0.180195  // AuKa1
    };

char *( XrayLambdaStr[] ) = { // their names
    "Ti-Kalfa1",
    "Cr-Kalfa1",
    "Fe-Kalfa1",
    "Co-Kalfa1",
    "Cu-Kalfa2",
    "Cu-Kalfa",
    "Cu-Kalfa1",
    "Cu-Kbeta1",
    "Mo-Kalfa2",
    "Mo-Kalfa",
    "Mo-Kalfa1",
    "Mo-Kbeta1",
    "Ag-Kalfa2",
    "Ag-Kalfa",
    "Ag-Kalfa1",
    "Ag-Kbeta2",
    "Ta-Kalfa1",
    "W-Kalfa1",
    "Au-Kalfa1"
    };


double ReadWaveLength ( char opt )
{
double Lambda;
if (!opt) { cin >> Lambda; return Lambda; }
char *s,S[41],L[21]; int i;
cout <<"Known wavelengths [A]:";
#ifndef __hppa
cout.setf(ios::left);
#endif
for (i=0; i<=XrayLambdaLast; i++) {
  if (!(i%4)) cout <<'\n';
  cout <<setw(9) <<XrayLambdaStr[i] <<"=";
  if (i%4!=3) cout <<setw(10) <<XrayLambda[i];
    else cout <<XrayLambda[i];
  }
if (i%4) cout <<'\n';
do {
  cout <<"Choose wavelength (string from the above list or positive value [A]) or\n"
	 "       energy (negative value [eV]): ";
  cin >> S;
  Lambda = strtod(S,&s);
  if (!*s) // it is number
    return (Lambda >= 0) ? Lambda : -A2M/Lambda;
  // find in the list
  strlwr(S);
  for (i=0; i<=XrayLambdaLast; i++) {
    strcpy(L,XrayLambdaStr[i]);
    if (!strcmp(S,strlwr(L))) return XrayLambda[i];
    }
  cout <<"Unknown. Try again.\n"; }
while (1);
}

// eof mfcht.cpp
