/* LINDEF3.H
History:
  o February 1999: taken away function "abs"
  o November, June 1994: enlarged by Petr Mikulik
  o April 1994: original version o_lindf2, unknown author
*/

// Pozn: matice jsou usporadany jako sloupcove vektory

#ifdef		__O_LINDF2
#error Cannot use both lindef3 and o_lindf2
#endif

#ifndef		LINDEF3_H
#define		LINDEF3_H

#include <iostream.h>
#if !defined(__DECCXX) && !defined(__EMX__) && !defined(__WATCOMC__)
  #include <values.h>
#endif

typedef unsigned long int uli;

const int  mtxdim  =  50;
const int  mtx1dim =  mtxdim * (mtxdim + 1) / 2;
const int  mtxdim1 =  200;
const int  mtxdim2 =  5;
#ifndef MAXINT
#define MAXINT 32767
#endif
const long int  lngvec  =  MAXINT / sizeof (double);


// definition of the characters used in Vector's  operator >>
extern char outVecleft[];   // = "[ ";
extern char outVecmiddle[]; // = ",";
extern char outVecright[];  // = " ]";
extern char outVecformat[]; // = "%g";
extern char outMatchar;     // usually '\n' or ' '
// operator << reads the vector formed by a sequence of reals,
// which are separated by any non-digit character. The sequence
// must be terminated by any non-space character or return.
// E.g, these 3dim vectors are accepted:
//       [1,2,3]  1 2 3;  =1 2*3=  ;1=2x3y   -6 -7 -8
// In the help of your programs you can write that the recommended
// syntax is [1,2,3] or [1 2 3] or the same with ( and ).


/*
 *	Vector
 *
 *    Indexovani se provadi od 1 .. N !!!
 */


class Vector {
  private:
    double *vektor;
    int n;
  public:
    Vector (int d = mtxdim)	{ init (d); }
    Vector ( double, double );
    Vector ( double, double, double );
    Vector (Vector&);
    ~Vector (void);
    Vector&  operator= (Vector&); // g++/ar nema rado const v operator= ??
    void dim (int& d) { d = n; };
    int dim () { return n; };
    inline double& operator[] (int);
    friend Vector operator+ (const Vector&, const Vector&);
    friend Vector operator- (const Vector&, const Vector&);
    Vector operator+= (const Vector &);
    Vector operator-= (const Vector &);
    friend double operator* (const Vector&, const Vector&);
    friend Vector operator* (const double, const Vector &);
    friend Vector operator* (const Vector &, const double);
    friend Vector operator/ (const Vector &, const double);
    Vector operator*= (const double);
    Vector operator/= (const double);
    friend Vector vectproduct(Vector &a, Vector &b);
      // vector product for vector of dim 3
  friend ostream & operator << (ostream &, const Vector &);
  friend istream & operator >> (istream &, Vector &);
//ostream _FAR & _Cdecl _FARFUNC operator<<(ostream _FAR &, complex _FAR &);
//istream _FAR & _Cdecl _FARFUNC operator>>(istream _FAR &, complex _FAR &);
    double norm ();
    double length (); // length == sqrt( norm() )
  private:
    void init (int);
  };

inline double& Vector::operator[] (int _p) {
#if DEBUG == 1
if (_p < 1 || _p > n) {
  perror ("Index out of dimension");
  exit (1); }
#endif
return vektor [_p - 1];
}


Vector topolar ( Vector& );
  // conversion to polar coordinates
  // returns Vector with [1]=length, [2]=angle in  (-pi..pi>


/*
 *	Matrix
 *
 *		A zase indexovani 1 .. N !!!
 */

class  Matrix {
	  Vector**    matice;
	  int         m;
	private:
	  void	init	(int, int);
	public:
	  Matrix  (int d = mtxdim)  {init (d, d);};
	  Matrix  (int dn,int dm)   {init (dn, dm);};
	  Matrix  (Matrix&);
	  ~Matrix (void);
	  void    dim (int&, int&) const;
	  int dim () const { return m; }
	  int dimvec () const {return (matice!=0)?(*matice)->dim():0; }
	    // declar. is then M(a.dimvec(),a.dim());
	  inline Vector& operator[] (int);
	  Matrix& operator=	(Matrix&);
	  Matrix  operator*	(Matrix&);
	  // Matrix  operator*	(double&);

        friend Matrix operator+ (const Matrix&, const Matrix&);
        friend Matrix operator- (const Matrix&, const Matrix&);
        Matrix operator+= (Matrix &);
        Matrix operator-= (Matrix &);
        friend Matrix operator* (const double, const Matrix &);
        friend Matrix operator* (const Matrix &, const double);
        friend Matrix operator/ (const Matrix &, const double);
        Matrix operator*= (const double);
        Matrix operator/= (const double);
        friend ostream & operator << (ostream &, const Matrix&);
        friend istream & operator >> (istream &, Matrix&);
	};

Matrix transp3 ( Matrix& a );
double minor3 (Matrix& a, int j, int k);
  // signed minor wrt a[i,j] for matrix 3x3
  // return transponed matrix 3x3
double deter3 (Matrix& a);
  // determinant of matrix 3x3
Matrix invmat3 (Matrix& A);
  // inverse matrix to matrix 3x3
void neglect_small ( Matrix& a, double Limit );
  // set to zero all elements of the matrix with absolute value
  // less than Limit. It is usually used after  invmat3


inline void	Matrix::dim (int& d1, int& d2) const 
{ d1 = m;
  if (matice != 0) { (*matice) -> dim (d2); }
    else { d2 = 0; }
}

inline Vector&	Matrix::operator[]	(int p)
{
#if DEBUG == 1
	if (p < 1 || p > m)
	{ perror ("Index out of dimension");
	  exit (1); }
#endif
	return *matice [p - 1];
}


class  VecMatrix : public Vector {
	 public:
	   VecMatrix	(int n = mtx1dim) : Vector (n) {};
	 };


#endif

// eof lindef3.h
