"""
Proxy/Cache a remote XML document.
"""
# $Id: XMLProxy.py,v 1.1.1.1 2002/02/03 17:07:16 root Exp $
#
# $Log: XMLProxy.py,v $
# Revision 1.1.1.1  2002/02/03 17:07:16  root
#
#
# Revision 1.7  2001/11/14 17:08:49  adrian
# Corrected Auto Update bug where changing properties failed to
# cause a data-reload.
# Changed XMLODBCClient to return brains instead of XML
# (DOM(self) returns the DOM for clients if required)
#
# Revision 1.6  2001/10/31 01:25:46  adrian
# Fixed several problems with creation and editing of XMLFiles
# Fixed pretty-printing of XML (Indentation)
#
# Revision 1.5  2001/10/24 15:34:12  adrian
# Completed factoring out common code into 3 base classes
# (XMLClientBase, XMLServerBase, and XMLReloadBase)
#
# Completed XMLProxy.
#
# Revision 1.4  2001/10/22 15:40:00  adrian
# Started moving common functions to base classes
#
# Revision 1.3  2001/10/22 11:55:36  adrian
# Added XMLProxy class. XMLProxy combines the download/cache
# ability of XMLDocument with the Method interface of XMLFile, to
# provide a simple way to cache remote XML source locally within Zope.
#
# Revision 1.2  2001/10/21 15:10:16  adrian
# no message
#
#
__version__ = '$Revision: 1.1.1.1 $'[11:-2]

import Globals
import AccessControl.Role
import OFS.SimpleItem
import OFS.PropertyManager
import Persistence
import Acquisition
import XML
import OFS.History
import DateTime
import urllib
import XMLKitBase

manage_addXMLProxyForm = Globals.HTMLFile('www/addXMLProxy', globals())
def manage_addXMLProxy(self, id='', source='', submit=None, REQUEST=None):
    """ """
    obj = XMLProxy(str(id), str(source))
    self._setObject(obj.getId(), obj)
    if REQUEST is not None:
        try: u=self.DestinationURL()
        except: u=REQUEST['URL1']
        if submit==" Add and Edit ": u="%s/%s" % (u, urllib.quote(obj.getId()))
        REQUEST.RESPONSE.redirect(u+'/manage_workspace')
    return ''

class XMLProxy(
        XMLKitBase.XMLReloadBase,
        XMLKitBase.XMLClientBase,
        XMLKitBase.XMLServerBase,
        OFS.PropertyManager.PropertyManager,
        OFS.SimpleItem.SimpleItem,
        Persistence.Persistent,
        Acquisition.Implicit,
        AccessControl.Role.RoleManager,
        OFS.History.Historical,
    ):
    """ """
    id = "XMLProxy"
    title = "XML Proxy"
    meta_type = "XML Proxy"
    index_html = None

    # Masquerade as function:
    class func_code: pass
    func_code=func_code()
    func_code.co_varnames='self','REQUEST','RESPONSE'
    func_code.co_argcount=3

    manage_options = (
        OFS.PropertyManager.PropertyManager.manage_options +
        XMLKitBase.XMLClientBase.manage_options +
        XMLKitBase.XMLServerBase.manage_options +
        XMLKitBase.XMLReloadBase.manage_options +
        OFS.History.Historical.manage_options +
        OFS.SimpleItem.SimpleItem.manage_options
    )
    _properties=(
        XMLKitBase.XMLClientBase._properties +
        XMLKitBase.XMLServerBase._properties +
        XMLKitBase.XMLReloadBase._properties
    )

    def __init__(self, id, source):
        """ """
        self.id = id
        self.source = source
        self.xp = XML.XMLParser.XMLParser()

    def _internal_initEmpty(self):
        """ Clear the DOM """
        self.xp.reset()

    def _internal_reload(self):
        """ Reload the XML data """
        try:
            source = self.unrestrictedTraverse(self.source).absolute_url()
        except:
            source = self.source
        self.xp.runURL(source)

    def _internal_getDOMref(self):
        """ Return a reference to the DOM """
        return self.xp.DOM

    def _internal_setDOMref(self, newDOM):
        """ replace the DOM with a new one """
        self.xp.DOM = newDOM

Globals.default__class_init__(XMLProxy)
