/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import java.io.Serializable;

public class VectorInt
implements Cloneable,
Serializable {
    protected int[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767609914048989439L;

    public VectorInt() {
        this(10);
    }

    public VectorInt(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public VectorInt(int initialCapacity, int capacityIncrement) {
        this.elementData = new int[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public void addElement(int i) {
        int newcount = this.elementCount + 1;
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        this.elementData[this.elementCount++] = i;
    }

    public Object clone() {
        try {
            VectorInt v = (VectorInt)super.clone();
            v.elementData = new int[this.elementCount];
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.elementCount);
            return v;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void copyInto(int[] anArray) {
        int i = this.elementCount;
        while (i-- > 0) {
            anArray[i] = this.elementData[i];
        }
    }

    public int elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        try {
            return this.elementData[index];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    private void ensureCapacityHelper(int minCapacity) {
        int newCapacity;
        int oldCapacity = this.elementData.length;
        int[] oldData = this.elementData;
        int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.elementData = new int[newCapacity];
        System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
    }

    public int indexOf(int elem) {
        int i = 0;
        while (i < this.elementCount) {
            if (elem == this.elementData[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void insertElementAt(int obj, int index) {
        int newcount = this.elementCount + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public int lastIndexOf(int elem) {
        int i = this.elementCount - 1;
        while (i >= 0) {
            if (elem == this.elementData[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public void removeAllElements() {
        int i = 0;
        while (i < this.elementCount) {
            this.elementData[i] = 0;
            ++i;
        }
        this.elementCount = 0;
    }

    public void removeElementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
    }

    public void setElementAt(int obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    public int size() {
        return this.elementCount;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int i = 0;
        while (i < this.size()) {
            buf.append(this.elementData[i]);
            if (i < this.size()) {
                buf.append(",");
            }
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }

    public void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            int[] oldData = this.elementData;
            this.elementData = new int[this.elementCount];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }
}

