/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import java.io.Serializable;
import java.util.StringTokenizer;

public class IP_Network
implements Serializable {
    private long lngNetwork = -1L;
    private long lngNetmask = -1L;

    private IP_Network() {
    }

    public IP_Network(String str) {
        int pp = str.indexOf(",");
        if (pp == -1) {
            throw new IllegalArgumentException("'" + str + "' is not a valid network,netmask combination");
        }
        this.lngNetwork = IP_Network.stringToLong(str.substring(0, pp).trim());
        this.lngNetmask = IP_Network.stringToLong(str.substring(pp + 1).trim());
    }

    public IP_Network(String strNetwork, String strNetmask) {
        this.lngNetwork = IP_Network.stringToLong(strNetwork.trim());
        this.lngNetmask = IP_Network.stringToLong(strNetmask.trim());
    }

    public static final long arrayToLong(long[] lngAddress) {
        long ll = 0L;
        ll += (lngAddress[0] & 0xFFL) << 24;
        ll += (lngAddress[1] & 0xFFL) << 16;
        ll += (lngAddress[2] & 0xFFL) << 8;
        return ll += lngAddress[3] & 0xFFL;
    }

    public static final String arrayToString(long[] lngValue) {
        StringBuffer strb = new StringBuffer();
        int i = 0;
        while (i < 4) {
            strb.append(String.valueOf(lngValue[i]));
            strb.append(".");
            ++i;
        }
        strb.setLength(strb.length() - 1);
        return strb.toString();
    }

    public boolean equals(IP_Network ip) {
        return ip.lngNetmask == this.lngNetmask && ip.lngNetwork == this.lngNetwork;
    }

    public static final long[] longToArray(long lngAddress) {
        long[] ll;
        ll = new long[]{ll[0] + (lngAddress >>> 24 & 0xFFL), ll[1] + (lngAddress >>> 16 & 0xFFL), ll[2] + (lngAddress >>> 8 & 0xFFL), ll[3] + (lngAddress & 0xFFL)};
        return ll;
    }

    public static final String longToString(long lngValue) {
        long[] lng = IP_Network.longToArray(lngValue);
        return IP_Network.arrayToString(lng);
    }

    public static void main(String[] args) {
        System.out.println(0xFFFF0000L);
        System.out.println(IP_Network.stringToLong("/16"));
    }

    public final boolean match(String strProbeIP) {
        long lngN = this.lngNetwork;
        long lngM = this.lngNetmask;
        long lngT = IP_Network.stringToLong(strProbeIP.trim());
        return (lngN & lngM) - (lngT & lngM) == 0L;
    }

    public static final boolean match(String strNetworkNetmask, String strProbeIP) {
        long lngT;
        long lngM;
        int pp = strNetworkNetmask.indexOf(",");
        if (pp == -1) {
            return true;
        }
        long lngN = IP_Network.stringToLong(strNetworkNetmask.substring(0, pp).trim());
        return (lngN & (lngM = IP_Network.stringToLong(strNetworkNetmask.substring(pp + 1).trim()))) - ((lngT = IP_Network.stringToLong(strProbeIP)) & lngM) == 0L;
    }

    public static final boolean match(String strNetwork, String strNetmask, String strProbeIP) {
        long lngT;
        long lngM;
        long lngN = IP_Network.stringToLong(strNetwork.trim());
        return (lngN & (lngM = IP_Network.stringToLong(strNetmask.trim()))) - ((lngT = IP_Network.stringToLong(strProbeIP.trim())) & lngM) == 0L;
    }

    public static final long[] stringToArray(String s) {
        if (s.startsWith("/")) {
            return IP_Network.longToArray(IP_Network.stringToLong(s));
        }
        StringTokenizer strt = new StringTokenizer(s, ".");
        long[] l = new long[4];
        int i = 0;
        while (i < 4) {
            l[i] = Long.parseLong(strt.nextToken());
            ++i;
        }
        return l;
    }

    public static final long stringToLong(String string) {
        String s;
        if (string.startsWith("/")) {
            s = string.substring(1);
            return -1L << (int)(32L - Long.parseLong(s)) & 0xFFFFFFFFL;
        }
        return IP_Network.arrayToLong(IP_Network.stringToArray(s));
    }

    public String toString() {
        if (this.lngNetwork == -1L && this.lngNetmask == -1L) {
            return "";
        }
        return String.valueOf(IP_Network.longToString(this.lngNetwork)) + "," + IP_Network.longToString(this.lngNetmask);
    }
}

