/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.StringTokenizer;

public class HelperFormat {
    private static final int CASEDIFF = 32;
    private static final Object objLock = new Object();

    private HelperFormat() {
    }

    public static final String buildID(int intNb, int intMaxNb) {
        int fillChar = 48;
        String strLeft = String.valueOf(intNb);
        String strRight = String.valueOf(intMaxNb);
        int length = strRight.length();
        int copyLen = strLeft.length();
        if (copyLen > length) {
            copyLen = length;
        }
        byte[] buffer = new byte[length];
        int i = 0;
        while (i < length - copyLen) {
            buffer[i] = fillChar;
            ++i;
        }
        i = 0;
        while (i < copyLen) {
            buffer[i + length - copyLen] = (byte)strLeft.charAt(i);
            ++i;
        }
        return "[" + new String(buffer) + "/" + strRight + "]";
    }

    public static final String formatMemoryString(long lngSize) {
        double result = lngSize;
        String tail = " Bt";
        if (lngSize > 0x10000000000L) {
            result = (double)lngSize / 1.099511627776E12;
            tail = " TB";
        } else if (lngSize > 0x40000000L) {
            result = (double)lngSize / 1.073741824E9;
            tail = " GB";
        } else if (lngSize >= 0x100000L) {
            result = (double)lngSize / 1048576.0;
            tail = " MB";
        } else if (lngSize >= 1024L) {
            result = (double)lngSize / 1024.0;
            tail = " KB";
        }
        if (!tail.equals(" Bt")) {
            result = (double)Math.round(result * 100.0) / 100.0;
            return String.valueOf(HelperFormat.number(result, 2)) + tail;
        }
        return lngSize + tail;
    }

    public static final String hexDigit(byte x) {
        String s = "";
        char c = (char)(x >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        s = String.valueOf(s) + c;
        c = (char)(x & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        s = String.valueOf(s) + c;
        return s;
    }

    public static final String hexDigit(byte[] digest) {
        return HelperFormat.hexDigit(digest, 0, digest.length);
    }

    public static final String hexDigit(byte[] digest, int i1, int i2) {
        StringBuffer strb = new StringBuffer();
        int i = i1;
        while (i < i2) {
            strb.append(HelperFormat.hexDigit(digest[i + i1]));
            ++i;
        }
        return strb.toString();
    }

    public static final String limit(String str, int intLength) {
        return str.length() > intLength ? str.substring(0, intLength) : str;
    }

    public static String lset(long value, int length, char filler) {
        return HelperFormat.lset(Long.toString(value), length, filler);
    }

    public static final String lset(String copyStr, int length, char filler) {
        byte fillChar = (byte)filler;
        int copyLen = copyStr.length();
        if (copyLen > length) {
            copyLen = length;
        }
        byte[] buffer = new byte[length];
        int i = 0;
        while (i < copyLen) {
            buffer[i] = (byte)copyStr.charAt(i);
            ++i;
        }
        i = copyLen++;
        while (i < length) {
            buffer[i] = fillChar;
            ++i;
        }
        return new String(buffer);
    }

    public static void main(String[] args) {
        StringBuffer strb = new StringBuffer();
        strb.append("Dear [%sender%],\r\n");
        strb.append("\r\n");
        strb.append("We cannot send your message to test@asdqoqjajcladasdasd.de because no mailserver ");
        strb.append("was found for domain asdqoqjajcladasdasd.de or domain asdqoqjajcladasdasd.de cannot be resolved.\r\n");
        strb.append("\r\n");
        strb.append("Please verify the email address and resend the mail.\r\n");
        strb.append("\r\n");
        strb.append("Please verify the email address and resend the mail.\r\n");
        System.out.println(String.valueOf(HelperFormat.rewrap(strb.toString(), 70)) + "[end]");
    }

    public static final String makeIndex(String string, boolean blnKeepSpace) {
        String str = string.trim();
        int strLen = str.length();
        StringBuffer strb = new StringBuffer(strLen);
        int i = 0;
        while (i < strLen) {
            char ch = str.charAt(i);
            if (ch == ' ') {
                if (blnKeepSpace) {
                    strb.append(ch);
                }
            } else if (ch >= 'A' && ch <= 'Z') {
                strb.append(ch);
            } else if (ch >= 'a' && ch <= 'z') {
                strb.append((char)(ch - 32));
            } else if (ch >= '0' && ch <= '9') {
                strb.append(ch);
            } else if (ch == '%') {
                strb.append(ch);
            } else if (ch == '_') {
                strb.append(ch);
            } else if (ch == '\u00df') {
                strb.append("S");
            } else if (ch >= '\u00c0' && ch <= '\u00c6' || ch >= '\u00e0' && ch <= '\u00e6') {
                strb.append('A');
            } else if (ch == '\u00c7' || ch == '\u00e7') {
                strb.append('C');
            } else if (ch >= '\u00c8' && ch <= '\u00cb' || ch >= '\u00e8' && ch <= '\u00eb') {
                strb.append('A');
            } else if (ch >= '\u00cc' && ch <= '\u00cf' || ch >= '\u00ec' && ch <= '\u00ef') {
                strb.append('A');
            } else if (ch == '\u00d0' || ch == '\u00d0') {
                strb.append('D');
            } else if (ch == '\u00d1' || ch == '\u00f1') {
                strb.append('N');
            } else if (ch >= '\u00d2' && ch <= '\u00d6' || ch >= '\u00f2' && ch <= '\u00f6') {
                strb.append('O');
            } else if (ch == '\u00d8' || ch == '\u00f8') {
                strb.append('O');
            } else if (ch >= '\u00d9' && ch <= '\u00dc' || ch >= '\u00f9' && ch <= '\u00fc') {
                strb.append('O');
            } else if (ch >= '\u00dd' && ch <= '\u00de' || ch >= '\u00fd' && ch <= '\u00ff') {
                strb.append('O');
            }
            ++i;
        }
        if (strb.length() > str.length()) {
            strb.setLength(str.length());
        }
        return strb.toString();
    }

    public static final String number(double dbl, int intNKS) {
        DecimalFormatSymbols decfs = new DecimalFormatSymbols();
        decfs.setDecimalSeparator('.');
        decfs.setGroupingSeparator(',');
        DecimalFormat decf = new DecimalFormat("0", decfs);
        ((NumberFormat)decf).setMinimumIntegerDigits(1);
        ((NumberFormat)decf).setMinimumFractionDigits(intNKS);
        return decf.format(dbl);
    }

    public static final String number_rset(double dbl, int intVKS, int intNKS) {
        if (intVKS == 0) {
            return HelperFormat.number(dbl, intNKS);
        }
        return HelperFormat.rset(HelperFormat.number(dbl, intNKS), intVKS + (intNKS == 0 ? 0 : 1) + intNKS, ' ');
    }

    public static final String number_rset_signum(double dbl, int intVKS, int intNKS) {
        String s = HelperFormat.number_rset(Math.abs(dbl), intVKS, intNKS);
        if (dbl < 0.0) {
            return String.valueOf(s) + "-";
        }
        if (dbl > 0.0) {
            return String.valueOf(s) + "+";
        }
        return String.valueOf(s) + " ";
    }

    public static final String rewrap(String strIN, int intLimit) {
        StringTokenizer strt = new StringTokenizer(strIN, " \t\r\n", true);
        StringBuffer strb = new StringBuffer();
        StringBuffer strbLine = new StringBuffer();
        String CRLF = "\r\n";
        while (strt.hasMoreTokens()) {
            String s = strt.nextToken();
            if (s.endsWith("\r") || s.endsWith("\n")) {
                strb.append(strbLine.toString().trim());
                strb.append(s);
                strbLine.setLength(0);
                continue;
            }
            if (strbLine.length() + s.length() > intLimit) {
                strb.append(strbLine.toString().trim());
                strb.append(CRLF);
                strbLine.setLength(0);
            }
            strbLine.append(s);
        }
        strb.append(strbLine.toString().trim());
        return strb.toString();
    }

    public static final StringBuffer rewrap(StringBuffer strbIN, int intLimit) {
        return new StringBuffer(HelperFormat.rewrap(strbIN.toString(), intLimit));
    }

    public static final String rset(long value, int length, char filler) {
        return HelperFormat.rset(Long.toString(value), length, filler);
    }

    public static final String rset(String string, int length, char filler) {
        String copyStr;
        byte fillChar = (byte)filler;
        int copyLen = string.length();
        if (copyLen > length) {
            copyStr = "%%%%%%%%%%%%%%%%";
            copyLen = length;
        }
        byte[] buffer = new byte[length];
        int i = 0;
        while (i < length - copyLen) {
            buffer[i] = fillChar;
            ++i;
        }
        i = 0;
        while (i < copyLen) {
            buffer[i + length - copyLen] = (byte)copyStr.charAt(i);
            ++i;
        }
        return new String(buffer);
    }

    public static final String tab2space(String strIn, int intTabSize) {
        int intLength = strIn.length();
        int intCol = 0;
        StringBuffer strb = new StringBuffer(intLength * 2);
        int i = 0;
        while (i < intLength) {
            switch (strIn.charAt(i)) {
                case '\t': {
                    int intTabs = intTabSize - intCol % intTabSize;
                    int t = 0;
                    while (t < intTabs) {
                        strb.append(' ');
                        ++intCol;
                        ++t;
                    }
                    break;
                }
                default: {
                    strb.append(strIn.charAt(i));
                    ++intCol;
                }
            }
            ++i;
        }
        return strb.toString();
    }

    public static final String toLowerCase(String str) {
        char[] ch = str.toCharArray();
        HelperFormat.toLowerCase(ch);
        return new String(ch);
    }

    public static final void toLowerCase(char[] chars) {
        int len = chars.length;
        int i = 0;
        while (i < len) {
            char ch = chars[i];
            if (ch >= 'A' && ch <= 'Z') {
                int n = i;
                chars[n] = (char)(chars[n] + 32);
            }
            ++i;
        }
    }
}

