/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.randomaccessdb;

import de.zwanzigeins.randomaccessdb.DatabaseDefinition;
import de.zwanzigeins.randomaccessdb.Field;
import de.zwanzigeins.randomaccessdb.SearchRecord;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;

public class DataRecord
extends SearchRecord {
    protected static final byte REC_FREE = 70;
    protected static final byte REC_BUSY = 66;

    public DataRecord(DatabaseDefinition ddf) {
        super(ddf);
        this.buffer = new byte[ddf.getPagesize() - 1];
    }

    public DataRecord cloneRecord() {
        DataRecord dr = new DataRecord(this.ddf);
        dr.buffer = new byte[this.buffer.length];
        int i = 0;
        while (i < this.buffer.length) {
            dr.buffer[i] = this.buffer[i];
            ++i;
        }
        return dr;
    }

    public boolean equals(Object objSearch) {
        if (!(objSearch instanceof SearchRecord)) {
            return false;
        }
        SearchRecord sr = (SearchRecord)objSearch;
        if (sr.ddf.getPagesize() != this.ddf.getPagesize()) {
            return false;
        }
        boolean blnResult = true;
        Enumeration e = sr.ddf.fieldEnumerator();
        while (e.hasMoreElements()) {
            Field fldSearch = (Field)e.nextElement();
            Field fldData = this.ddf.getFieldByName(fldSearch.strName);
            if (!fldSearch.blnKeyField) continue;
            if (fldSearch.bytType != fldData.bytType) {
                blnResult = false;
                break;
            }
            switch (fldSearch.bytType) {
                case 1: {
                    break;
                }
                case 2: {
                    String strSearch = sr.getString(fldSearch);
                    String strData = this.getString(fldData);
                    int pp = strSearch.indexOf("*");
                    if (pp == -1) {
                        blnResult = strSearch.equals(strData);
                        break;
                    }
                    if (strData.length() < pp) {
                        blnResult = false;
                        break;
                    }
                    strSearch = strSearch.substring(0, pp);
                    strData = strData.substring(0, pp);
                    blnResult &= strSearch.equals(strData);
                    break;
                }
                case 3: {
                    blnResult &= this.getLong(fldData) == sr.getLong(fldSearch);
                    break;
                }
                case 4: {
                    blnResult &= this.getInt(fldData) == sr.getInt(fldSearch);
                    break;
                }
                case 5: {
                    blnResult &= this.getChar(fldData) == sr.getChar(fldSearch);
                    break;
                }
                case 6: {
                    blnResult &= this.getByte(fldData) == sr.getByte(fldSearch);
                    break;
                }
                case 7: {
                    blnResult &= this.getLong(fldData) == sr.getLong(fldSearch);
                    break;
                }
                case 8: {
                    blnResult &= this.getLong(fldData) == sr.getLong(fldSearch);
                    break;
                }
                case 9: {
                    blnResult &= this.getInt(fldData) == sr.getInt(fldSearch);
                }
            }
            if (!blnResult) break;
        }
        return blnResult;
    }

    public InputStream getBlob(int idx) throws FileNotFoundException {
        Field fld = this.ddf.getFieldByIdx(idx);
        this.sanitycheck(fld, (byte)1);
        return this.getBlob(fld);
    }

    public InputStream getBlob(String idx) throws FileNotFoundException {
        Field fld = this.ddf.getFieldByName(idx);
        this.sanitycheck(fld, (byte)1);
        return this.getBlob(fld);
    }

    public String getBlobFileName(int idx) throws FileNotFoundException {
        Field fld = this.ddf.getFieldByIdx(idx);
        this.sanitycheck(fld, (byte)1);
        return this.getBlobFileName(fld);
    }

    public String getBlobFileName(String idx) throws FileNotFoundException {
        Field fld = this.ddf.getFieldByName(idx);
        this.sanitycheck(fld, (byte)1);
        return this.getBlobFileName(fld);
    }

    public long getBlobLength(int idx) throws FileNotFoundException {
        Field fld = this.ddf.getFieldByIdx(idx);
        this.sanitycheck(fld, (byte)1);
        return this.getBlobLength(fld);
    }

    public long getBlobLength(String idx) throws FileNotFoundException {
        Field fld = this.ddf.getFieldByName(idx);
        this.sanitycheck(fld, (byte)1);
        return this.getBlobLength(fld);
    }

    public byte getByte(int idx) {
        Field fld = this.ddf.getFieldByIdx(idx);
        this.sanitycheck(fld, (byte)6);
        return this.getByte(fld);
    }

    public byte getByte(String idx) {
        Field fld = this.ddf.getFieldByName(idx);
        this.sanitycheck(fld, (byte)6);
        return this.getByte(fld);
    }

    public char getChar(int idx) {
        Field fld = this.ddf.getFieldByIdx(idx);
        this.sanitycheck(fld, (byte)5);
        return this.getChar(fld);
    }

    public char getChar(String idx) {
        Field fld = this.ddf.getFieldByName(idx);
        this.sanitycheck(fld, (byte)5);
        return this.getChar(fld);
    }

    public Date getDate(int idx) {
        Field fld = this.ddf.getFieldByIdx(idx);
        this.sanitycheck(fld, (byte)7);
        return this.getDate(fld);
    }

    public Date getDate(String idx) {
        Field fld = this.ddf.getFieldByName(idx);
        this.sanitycheck(fld, (byte)7);
        return this.getDate(fld);
    }

    public double getDouble(int idx) {
        Field fld = this.ddf.getFieldByIdx(idx);
        this.sanitycheck(fld, (byte)8);
        return this.getDouble(fld);
    }

    public double getDouble(String idx) {
        Field fld = this.ddf.getFieldByName(idx);
        this.sanitycheck(fld, (byte)8);
        return this.getDouble(fld);
    }

    public float getFloat(int idx) {
        Field fld = this.ddf.getFieldByIdx(idx);
        this.sanitycheck(fld, (byte)9);
        return this.getFloat(fld);
    }

    public float getFloat(String idx) {
        Field fld = this.ddf.getFieldByName(idx);
        this.sanitycheck(fld, (byte)9);
        return this.getFloat(fld);
    }

    public int getInt(int idx) {
        Field fld = this.ddf.getFieldByIdx(idx);
        this.sanitycheck(fld, (byte)4);
        return this.getInt(fld);
    }

    public int getInt(String idx) {
        Field fld = this.ddf.getFieldByName(idx);
        this.sanitycheck(fld, (byte)4);
        return this.getInt(fld);
    }

    public long getLong(int idx) {
        Field fld = this.ddf.getFieldByIdx(idx);
        this.sanitycheck(fld, (byte)3);
        return this.getLong(fld);
    }

    public long getLong(String idx) {
        Field fld = this.ddf.getFieldByName(idx);
        this.sanitycheck(fld, (byte)3);
        return this.getLong(fld);
    }

    public String getString(int idx) {
        Field fld = this.ddf.getFieldByIdx(idx);
        this.sanitycheck(fld, (byte)2);
        return this.getString(fld);
    }

    public String getString(String idx) {
        Field fld = this.ddf.getFieldByName(idx);
        this.sanitycheck(fld, (byte)2);
        return this.getString(fld);
    }
}

