/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class DataByteOutputStream
extends ByteArrayOutputStream {
    public DataByteOutputStream() {
    }

    public DataByteOutputStream(int size) {
        super(size);
    }

    public int getPos() {
        return this.count;
    }

    public void writeBigInteger(BigInteger i) {
        byte[] b = i.toByteArray();
        try {
            if (b[0] == 0) {
                this.write(b, 1, b.length - 1);
            } else {
                this.write(b);
            }
        }
        catch (IOException iOException) {}
    }

    public void writeByte(int i) {
        this.write(i);
    }

    public void writeInt(int i) {
        this.write(i >>> 24 & 0xFF);
        this.write(i >>> 16 & 0xFF);
        this.write(i >>> 8 & 0xFF);
        this.write(i & 0xFF);
    }

    public void writeLong(long l) {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)l & 0xFF);
    }

    public void writeShort(int i) {
        this.write(i >>> 8 & 0xFF);
        this.write(i & 0xFF);
    }

    public void writeShortAt(int i, int pos) throws IllegalArgumentException {
        if (pos < 0 || pos > this.count) {
            throw new IllegalArgumentException(pos + " out of range");
        }
        int oldcount = this.count;
        this.count = pos;
        this.writeShort(i);
        this.count = oldcount;
    }

    public void writeString(String s) {
        try {
            byte[] b = s.getBytes();
            this.write(b.length);
            this.write(b);
        }
        catch (IOException iOException) {}
    }

    public void writeString(byte[] s) {
        try {
            this.write(s.length);
            this.write(s);
        }
        catch (IOException iOException) {}
    }

    public void writeStringCanonical(String s) {
        try {
            byte[] b = s.toLowerCase().getBytes();
            this.write(b.length);
            this.write(b);
        }
        catch (IOException iOException) {}
    }
}

