/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Enumeration;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Master;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameSet;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TypeMap;

public class Zone
extends NameSet {
    public static final int PRIMARY = 1;
    public static final int SECONDARY = 2;
    private int type;
    private Name origin;
    private short dclass = 1;
    private RRset NS;
    private SOARecord SOA;

    public Zone(String file, Cache cache) throws IOException {
        this(file, cache, null);
    }

    /*
     * WARNING - void declaration
     */
    public Zone(String file, Cache cache, Name initialOrigin) throws IOException {
        super(false);
        Record record;
        Master m = new Master(file, initialOrigin);
        this.origin = initialOrigin;
        while ((record = m.nextRecord()) != null) {
            void var5_5;
            this.maybeAddRecord((Record)var5_5, cache, file);
        }
        this.validate();
    }

    public Zone(Name zone, short _dclass, String remote, Cache cache) throws IOException {
        super(false);
        this.origin = zone;
        this.dclass = _dclass;
        this.type = 2;
        SimpleResolver res = new SimpleResolver(remote);
        Record rec = Record.newRecord(zone, (short)252, this.dclass);
        Message query = Message.newQuery(rec);
        Message response = res.send(query);
        Record[] recs = response.getSectionArray(1);
        int i = 0;
        while (i < recs.length) {
            if (!recs[i].getName().subdomain(this.origin)) {
                if (Options.check("verbose")) {
                    System.err.println(recs[i].getName() + "is not in zone " + this.origin);
                }
            } else {
                this.addRecord(recs[i]);
            }
            ++i;
        }
        if (cache != null) {
            recs = response.getSectionArray(3);
            i = 0;
            while (i < recs.length) {
                cache.addRecord(recs[i], (byte)3, recs);
                ++i;
            }
        }
        this.validate();
    }

    public Zone(Record[] records, Cache cache, Name initialOrigin) throws IOException {
        super(false);
        this.origin = initialOrigin;
        int i = 0;
        while (i < records.length) {
            this.maybeAddRecord(records[i], cache, records);
            ++i;
        }
        this.validate();
    }

    public void addRecord(Record r) {
        short type;
        Name name = r.getName();
        RRset rrset = (RRset)this.findExactSet(name, type = r.getRRsetType());
        if (rrset == null) {
            rrset = new RRset();
            this.addSet(name, type, rrset);
        }
        rrset.addRR(r);
    }

    public Enumeration AXFR() {
        return new AXFREnumeration(this);
    }

    public RRset findExactMatch(Name name, short type) {
        return (RRset)this.findExactSet(name, type);
    }

    public SetResponse findRecords(Name name, short type) {
        RRset rrset;
        Object[] objects;
        SetResponse zr = null;
        Object o = this.findSets(name, type);
        if (o == null) {
            SetResponse sr;
            if (name.isWild()) {
                return new SetResponse(1);
            }
            int labels = name.labels() - this.origin.labels();
            if (labels == 0) {
                return new SetResponse(1);
            }
            Name tname = name;
            do {
                if ((sr = this.findRecords(tname.wild(1), type)).isSuccessful()) {
                    return sr;
                }
                tname = new Name(tname, 1);
            } while (labels-- >= 1);
            return sr;
        }
        if (o instanceof TypeMap) {
            return new SetResponse(2);
        }
        if (o instanceof RRset) {
            objects = null;
            rrset = (RRset)o;
        } else {
            objects = (Object[])o;
            rrset = (RRset)objects[0];
        }
        if (name.equals(rrset.getName())) {
            if (type != 5 && type != 255 && rrset.getType() == 5) {
                zr = new SetResponse(4);
                zr.addCNAME((CNAMERecord)rrset.first());
            } else if (rrset.getType() == 2 && !name.equals(this.origin)) {
                zr = new SetResponse(3);
                zr.addNS(rrset);
            } else {
                zr = new SetResponse(6);
                zr.addRRset(rrset);
                if (objects != null) {
                    int i = 1;
                    while (i < objects.length) {
                        zr.addRRset((RRset)objects[i]);
                        ++i;
                    }
                }
            }
        } else {
            if (rrset.getType() == 5) {
                return new SetResponse(1);
            }
            if (rrset.getType() == 39) {
                zr = new SetResponse(5);
                zr.addDNAME((DNAMERecord)rrset.first());
            } else if (rrset.getType() == 2) {
                zr = new SetResponse(3);
                zr.addNS(rrset);
            }
        }
        return zr;
    }

    public short getDClass() {
        return this.dclass;
    }

    public RRset getNS() {
        return this.NS;
    }

    public Name getOrigin() {
        return this.origin;
    }

    public SOARecord getSOA() {
        return this.SOA;
    }

    private final void maybeAddRecord(Record record, Cache cache, Object source) throws IOException {
        short type = record.getType();
        Name name = record.getName();
        if (type == 6) {
            if (!name.equals(this.origin)) {
                throw new IOException("SOA owner " + name + " does not match zone origin " + this.origin);
            }
            this.setOrigin(this.origin);
            this.dclass = record.getDClass();
        }
        if (this.origin == null && type != 6) {
            throw new IOException("non-SOA record seen at " + name + " with no origin set");
        }
        if (name.subdomain(this.origin)) {
            this.addRecord(record);
        } else if (cache != null) {
            cache.addRecord(record, (byte)3, source);
        }
    }

    private void validate() throws IOException {
        RRset rrset = (RRset)this.findExactSet(this.origin, (short)6);
        if (rrset == null || rrset.size() != 1) {
            throw new IOException(this.origin + ": exactly 1 SOA must be specified");
        }
        Enumeration e = rrset.rrs();
        this.SOA = (SOARecord)e.nextElement();
        this.NS = (RRset)this.findExactSet(this.origin, (short)2);
        if (this.NS == null) {
            throw new IOException(this.origin + ": no NS set specified");
        }
    }

    static Name access$origin(Zone zone) {
        return zone.origin;
    }

    class AXFREnumeration
    implements Enumeration {
        /* synthetic */ Zone this$0;
        private Enumeration znames;
        private Name currentName;
        private Object[] current;
        int count;
        boolean sentFirstSOA;
        boolean sentNS;
        boolean sentOrigin;
        boolean sentLastSOA;

        AXFREnumeration(Zone this$0) {
            this.this$0 = this$0;
            this.znames = this$0.names();
        }

        public boolean hasMoreElements() {
            return !this.sentLastSOA;
        }

        /*
         * Unable to fully structure code
         */
        public Object nextElement() {
            if (this.sentLastSOA) {
                return null;
            }
            if (!this.sentFirstSOA) {
                this.sentFirstSOA = true;
                return (RRset)this.this$0.findExactSet(Zone.access$origin(this.this$0), (short)6);
            }
            if (!this.sentNS) {
                this.sentNS = true;
                return this.this$0.getNS();
            }
            if (!this.sentOrigin) {
                if (this.currentName == null) {
                    this.currentName = this.this$0.getOrigin();
                    tm = this.this$0.findName(this.currentName);
                    this.current = tm.getAll();
                    this.count = 0;
                }
                while (this.count < this.current.length) {
                    rrset = (RRset)this.current[this.count];
                    if (rrset.getType() != 6 && rrset.getType() != 2) {
                        return this.current[this.count++];
                    }
                    ++this.count;
                }
                this.current = null;
                this.sentOrigin = true;
            }
            if (this.current == null || this.count >= this.current.length) ** GOTO lbl32
            return this.current[this.count++];
lbl-1000:
            // 1 sources

            {
                currentName = (Name)this.znames.nextElement();
                if (currentName.equals(this.this$0.getOrigin())) continue;
                tm = this.this$0.findName(currentName);
                this.current = tm.getAll();
                this.count = 0;
                if (this.count >= this.current.length) continue;
                return this.current[this.count++];
lbl32:
                // 3 sources

                ** while (this.znames.hasMoreElements())
            }
lbl33:
            // 1 sources

            this.sentLastSOA = true;
            rrset = new RRset();
            rrset.addRR(this.this$0.getSOA());
            return rrset;
        }
    }
}

