/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class TypeClassMap {
    private Hashtable data = new Hashtable();

    TypeClassMap() {
    }

    private int fill(Object[] array, int start, Enumeration e, short dclass) {
        while (e.hasMoreElements()) {
            Wrapper w = (Wrapper)e.nextElement();
            if (dclass != 255 && w.dclass != dclass) continue;
            array[start++] = w.object;
        }
        return start;
    }

    Object get(short type, short dclass) {
        Object[] out = this.getMultiple(type, dclass);
        if (out == null || out.length == 0) {
            return null;
        }
        if (out.length == 1) {
            return out[0];
        }
        throw new RuntimeException("TypeClassMap error: " + out.length);
    }

    Object[] getMultiple(short type, short dclass) {
        int n;
        Object[] out;
        Cloneable cloneable;
        if (type != 255) {
            Vector v = (Vector)this.data.get(new Short(type));
            if (v == null) {
                return null;
            }
            cloneable = v;
            synchronized (cloneable) {
                out = new Object[v.size()];
                n = this.fill(out, 0, v.elements(), dclass);
            }
        }
        cloneable = this.data;
        synchronized (cloneable) {
            int size = this.data.size();
            while (true) {
                try {
                    out = new Object[size];
                    Enumeration e = this.data.elements();
                    n = 0;
                    while (e.hasMoreElements()) {
                        Vector v = (Vector)e.nextElement();
                        n = this.fill(out, n, v.elements(), dclass);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    size *= 2;
                    continue;
                }
                break;
            }
        }
        if (n != out.length) {
            Object[] out2 = out;
            out = new Object[n];
            System.arraycopy(out2, 0, out, 0, n);
        }
        return out;
    }

    boolean isEmpty() {
        return this.data.isEmpty();
    }

    void put(short type, short dclass, Object value) {
        Short T = new Short(type);
        Vector<Wrapper> v = (Vector<Wrapper>)this.data.get(T);
        if (v == null) {
            Hashtable hashtable = this.data;
            synchronized (hashtable) {
                v = new Vector<Wrapper>();
                this.data.put(T, v);
            }
        }
        Wrapper w = new Wrapper(this, dclass, value);
        Vector<Wrapper> vector = v;
        synchronized (vector) {
            v.removeElement(w);
            v.addElement(w);
        }
    }

    void remove(short type, short dclass) {
        Short T = new Short(type);
        Vector v = (Vector)this.data.get(T);
        if (v == null) {
            return;
        }
        Wrapper w = new Wrapper(this, dclass, null);
        Vector vector = v;
        synchronized (vector) {
            v.removeElement(w);
            if (v.size() == 0) {
                this.data.remove(T);
            }
        }
    }

    class Wrapper {
        /* synthetic */ TypeClassMap this$0;
        short dclass;
        Object object;

        Wrapper(TypeClassMap this$0, short _dclass, Object _object) {
            this.this$0 = this$0;
            this.dclass = _dclass;
            this.object = _object;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Wrapper)) {
                return false;
            }
            Wrapper w = (Wrapper)o;
            return this.dclass == w.dclass;
        }
    }
}

